f = 18;  % focal length in mm
t = [-10:0.1:10]; % 10 second scan time,sampled 100ms
t = t(2:200);
t2 = t-.047;
scanangle=2*atan(0.65/17.805); %full scan span in radians during the time t
omega = scanangle/20; % mirror rotation freq. omega in radians/sec
angles = t*omega; % sequence of mirror angles corresponding to time t
v = f*omega*sec(angles).^2; % linear velocity profile in mm/sec
px=2048/1.3;  % 1mm to pixels

y=(load('off-y-data.txt','-ascii'))'; % load the expmedian mpiv velocities

fig7=figure(7)

set(fig7, 'units','normalized','Position', [.1 .1 .6 .2]);
% subplot(2,1,1)
% plot(rad2deg(t2*omega),v*px*.1,'-','linewidth',2); % velocity in pixels vs time
% xlabel('mirror angle deviation [deg]');
% ylabel('[px/100 ms]')
% axis([-2.2 2.2 10.345 10.365]);
% title('theoretical velocity');


%subplot(2,1,2)
plot(rad2deg(angles),v.*t2*px,'b','linewidth',2); % distance in pixels vs time from analytical calculation
xlabel('mirror angle deviation [deg]');
ylabel('position along flow direction (y) [px]')
axis([-2.2 2.2 -1050 1050]);
title('theoretical position of image centre');

fig9=figure(9);

set(fig9, 'units','normalized','Position', [.1 .1 .6 .2]);

a=ones(1,numel(t))*70;
%plot(rad2deg(t*omega),v.*t2*px,'b','linewidth',10); % distance in pixels vs time from analytical calculation
hold on
plot(rad2deg(t*omega),-y,'r.','MarkerSize',70); % distance in pixels vs time from expt data
hold off
%expt data t-time, Y - expt distance vs time values
Y= -y;
Ymodel = fitlm(rad2deg(t*omega)',Y','linear');

modelCoeffs = Ymodel.Coefficients.Estimate;

Yfitted = predict(Ymodel, rad2deg(t*omega)');

hold on
plot(rad2deg(t*omega), Yfitted, 'g','linewidth',10);
title('Experimental position of image centre along flow direction (y) in [px]');
xlabel('mirror angle deviation [deg]');
ylabel(poly2str(flipud(modelCoeffs), '* angle'));
axis([-2.2 2.2 -1050 1050]);
hold off

fig10=figure(10)
set(fig10, 'units','normalized','Position', [.1 .1 .6 .2]);

plot(rad2deg(t*omega), (((v.*t2*px)'- Yfitted)),'r-o','linewidth',1)
title('Least suqares fit line - theoretical position');
xlabel('mirror angle deviation [deg]');
ylabel('position error [px]');
axis([-2.2 2.2 -.6 .6]);

fig11=figure(11);
set(fig11, 'units','normalized','Position', [.1 .1 .6 .2]);

plot(rad2deg(t*omega), (Ymodel.Residuals.Raw),'r-o','linewidth',1)
title('Residuals from linear fit');
xlabel('mirror angle deviation [deg]');
ylabel('error in px');
axis([-2.2 2.2 -6 6]);

fig12=figure(12);
set(fig12, 'units','normalized','Position', [.1 .1 .6 .2]);

yoffdiff=abs(load('yoff-diff.txt','-ascii'));
plot(yoffdiff,'r-o','linewidth',1)
axis([0 200 0 12]);
title('Shift between paires of frames');
xlabel('frame pair [#]');
ylabel('[pixels/100 ms]');

Ymodel.Rsquared
