function xCorrPairs_Callback(hObject, eventdata)
% hObject    handle to crosscor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=guidata(hObject);
progressBar(hObject, eventdata,0);

handles.xoffset = 0;
handles.yoffset = 0;
handles.yoffsetdiff = 0;

if isequal(handles.filename_im,0) ||  isequal(size(handles.filename_im ,2),1) || isequal(handles.pathname_im,0)
    msgbox(sprintf('Insufficient number of images to process \n Load two or more images'),'Error', 'Error');  
    disp('Insufficient number of images to process');
else

    progressBar(hObject, eventdata, 0);

    for i=1:size((handles.filename_im),2) - 1

        im1=imread(char(handles.imfile2(i)));
        im2=imread(char(handles.imfile2(i+1)));
        
        axes(handles.axes1);
        imshow(imadjust(im1));
        axes(handles.axes2);
        imshow(imadjust(im2));
        
        pause(0.1);
        c = normxcorr2((im1), (im2));
        counter=i/(size((handles.filename_im),2) - 1);
        progressBar(hObject, eventdata, counter);
        pause(0.1);
        
        centre=round(size(c)./2);
        
        %find the coordinates for the shift of the correlation matrix
        [y,x]=find(c==max(c(:)));
        
        handles.xoffset(i) = x-centre(2);
        handles.yoffset(i) = y-centre(1);

%prepare empty space for displaying original image
% image=uint16(zeros(2*size(im1,1)+size(im2,1),2*size(im1,2)+size(im2,2)));
% 
% xbegin_im = size(im1,2);
% xend_im = xbegin_im+size(im2,2)-1;
% ybegin_im = size(im1,1);
% yend_im = ybegin_im+size(im2,1)-1;

%prepare template to overlap the original image
% im_TP=uint16(zeros(2*size(im1,1)+size(im2,1),2*size(im1,2)+size(im2,2)));
% 
% xbegin_TP = x;
% xend_TP = x+size(im1,2)-1;
% ybegin_TP = y;
% yend_TP = y+size(im1,1)-1;
% 
% image(ybegin_im:yend_im,xbegin_im:xend_im) = im2;
% im_TP(ybegin_TP:yend_TP,xbegin_TP:xend_TP) = im1;
%         
%         figure(4)
%         pause(4);
%         imshowpair(image,im_TP,'falsecolor');
%         pause(4);
        


end

set(handles.savemydata,'Enable','on')
      figure(2)
      plot(handles.yoffset,'r *');
      title('y-axis travel between two consecutive images (velocity data)','fontsize',14)
      xlabel('image#','fontsize',14);
      ylabel('[pixels]','fontsize',14);
      grid on
      
      figure(3)
      Fs = 100; % sampling frequency or fps
      N = length(handles.yoffset) % number of samples
      freq=linspace(-Fs/2,Fs/2,N);
      
      spectrum = fftshift(fft(handles.yoffset));
      spectrum2=fft(handles.yoffset);
      spectrum2(1)
      handles.freq = freq;
      handles.spectrum = abs(spectrum);
      handles.angle = angle(spectrum);
      plot(freq,log10(abs(spectrum)),'r');
      title('fft magnitude spectrum of the velocity data','fontsize',14)
      xlabel('frequency [Hz]','fontsize',14);
      ylabel('magnitude','fontsize',14);
      grid on
      
      %get the difference shift between two consecutive images for yoffset
for i=1:length(handles.yoffset)-1
    handles.yoffsetdiff(i)=handles.yoffset(i+1)-handles.yoffset(i);
end
      figure(5)
      plot(handles.yoffsetdiff,'r o');
      title('y-axis acceleration data','fontsize',14)
      xlabel('image#','fontsize',14);
      ylabel('[pixels]','fontsize',14);
      grid on

end

guidata(hObject, handles);

end
