//% Encoder function for a terminated unity-rate recursive convolutional code
//% having 3 memory elements, a generator polynomial of [1,1,0,1] and a feedback
//% polynomial of [1,0,1,1]. This is as used in the LTE turbo code, as specified in ETSI TS 136 212.
//% Copyright (C) 2014  Hoang-Anh Ngo

//% uncoded_bits is a 1xN vector of uncoded bits
//% encoded_bits is a 1x(N+3) vector of encoded bits
//% termination_bits is a 1x3 vector of termination bits

#ifndef CONVOLUTIONAL_ENCODER_H
#define CONVOLUTIONAL_ENCODER_H

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

using namespace std;
using namespace itpp;

class Convolutional_Encoder
{
public:
    Convolutional_Encoder();

    void encode(vec uncoded_bits, vec &encoded_bits, vec &termination_bits);
    ivec get_interleaver_sequence(int frame_length);
};

#endif // CONVOLUTIONAL_ENCODER_H
