/*
% Fully-parallel algorithm for a unity-rate recursive convolutional code
% having 3 memory elements, a generator polynomial of [1,1,0,1] and a feedback
% polynomial of [1,0,1,1]. This is as used in the LTE turbo code, as specified in ETSI TS 136 212.
% Copyright (C) 2014  Hoang-Anh Ngo.

% apriori_uncoded is an a priori uncoded LLR
% apriori_encoded is an a priori encoded LLR
% apriori_alphas is a vector of 8 a priori forward state log-probabilities
% apriori_betas is a vector of 8 a priori backward state log-probabilities
% extrinsic_uncoded is an extrinsic encoded LLR
% extrinsic_betas is a vector of 8 extrinsic backward state log-probabilities
% extrinsic_alphas is a vector of 8 extrinsic forward state log-probabilities
***************************************************************************************************************/

#ifndef FP_BLOCK_DECODER_H
#define FP_BLOCK_DECODER_H

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

#include <maxstar.h>

using namespace std;
using namespace itpp;

class FP_block_decoder
{
public:
    FP_block_decoder();
    int state_count;
    maxstar max_star;

    void block_decoder(double &apriori_uncoded, vec apriori_alphas, vec apriori_betas, double &apriori_encoded, double &extrinsic_uncoded, vec &extrinsic_betas, vec &extrinsic_alphas);
    void block_decoder(double &apriori_uncoded, vec apriori_alphas, vec apriori_betas, double &apriori_encoded, double &extrinsic_uncoded, double &entrinsic_encoded, vec &extrinsic_betas, vec &extrinsic_alphas);
};

#endif // FP_BLOCK_DECODER_H
