#ifndef EQ_INTERLEAVER_H
#define EQ_INTERLEAVER_H

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

using namespace std;
using namespace itpp;


class EQ_Interleaver
{
public:
    EQ_Interleaver();
    EQ_Interleaver(int frame_length, bool tail);

    vec interleave(vec a, vec b, vec c, bool tail);
    vec interleave(vec d, bool tail);
    //vec deinterleave(vec d);
    void deinterleave(vec d, vec &a, vec &b, vec &c);
    vec deinterleave(vec d);
    ivec get_interleaver();
    void set_interleaver_length(int length, bool tail);
    void generate_interleaver();

public:
    ivec interleaver_index;
    Sequence_Interleaver<double> frame_interleaver;
    int frame_length;
    int uncoded_bits_length;
};

#endif // EQ_INTERLEAVER_H
