#ifndef MAXSTAR_H
#define MAXSTAR_H

#include <itpp/itbase.h>
#include <itpp/itcomm.h>
#include <limits>

#ifndef INFINITY
#define INFINITY std::numeric_limits<double>::infinity()
#endif

#ifndef MAX_DOUBLE
#define MAX_DOUBLE std::numeric_limits<double>::max()
#endif

using namespace std;
using namespace itpp;

class maxstar
{
public:
    maxstar();
    maxstar(int approx_maxstar_method);

    int approx_maxstar_method;  // approx_maxstar_method=0: Log-MAP approximation
                                // approx_maxstar_method=1: Max-Log-MAP approximation

    void initialize(int approx_maxstar_method);
    vec approximation(mat input);
    double approximation(vec input);
};

#endif // MAXSTAR_H
