%**************************************************************************
% --- Problem definition & input parameters ---
%**************************************************************************
Tend=100;               % [min] Time span

Vtot=30e-3;             % total volume of placental cotolydon perfused in experiment [dm^3]

% --- Flow rates ---
Fmrate=2;               % maternal [dm^3/kg/min]
Ffrate=0.2;             % fetal [dm^3/kg/min]
Fm=Fmrate*Vtot;         % [dm^3/min]
Ff=Ffrate*Vtot;         % [dm^3/min]

% --- Relative volume fractions compartments --- 
mfrac=0.34;             % [-] intervillous space          
sfrac=0.15;             % [-] syncytiotrophoblast
ffrac=0.074;            % [-] fetal capillaries

Vm=mfrac*Vtot;          % [dm^3] maternal volume
Vs=sfrac*Vtot;          % [dm^3] syncytiotrophoblast volume
Vf=ffrac*Vtot;          % [dm^3] fetal volume


% --- Amino acids to include ---
aa(1).name='AcEx';
aa(1).c0maternal=826;     % [micro molar] initial maternal amino acid concentration
aa(1).c0syncitio=4423;    % [micro molar] initial syncytiotrophoblast amino acid concentration
aa(1).c0fetal=1369;       % fetal inlet concentration [micro mol/l]  
aa(1).cinmaternal=826;    % maternal inlet concentration [micro mol/l]    
aa(1).cinfetal=1369;      % fetal inlet concentration [micro mol/l]
aa(1).linestyle='b-';     % line style for plotting
 
aa(2).name='Ex';
aa(2).c0maternal=170;     % [micro molar] initial maternal amino acid concentration
aa(2).c0syncitio=786;     % [micro molar] initial syncytiotrophoblast amino acid concentration
aa(2).c0fetal=258;        % [micro molar] initial fetal amino acid concentration
aa(2).cinmaternal=170;    % maternal inlet concentration [micro mol/l]   
aa(2).cinfetal=258;       % fetal inlet concentration [micro mol/l] 
aa(2).linestyle='g-';     % line style for plotting
 
aa(3).name='ExF';
aa(3).c0maternal=338;     % [micro molar] initial maternal amino acid concentration
aa(3).c0syncitio=1145;    % [micro molar] initial syncytiotrophoblast amino acid concentration
aa(3).c0fetal=483;        % [micro molar] initial fetal amino acid concentration
aa(3).cinmaternal=338;    % maternal inlet concentration [micro mol/l]   
aa(3).cinfetal=483;       % fetal inlet concentration [micro mol/l] 
aa(3).linestyle='r-';     % line style for plotting
 
aa(4).name='AcExF';
aa(4).c0maternal=215;     % [micro molar] initial maternal amino acid concentration
aa(4).c0syncitio=1987;    % [micro molar] initial syncytiotrophoblast amino acid concentration
aa(4).c0fetal=238;        % [micro molar] initial fetal amino acid concentration
aa(4).cinmaternal=215;    % maternal inlet concentration [micro mol/l]   
aa(4).cinfetal=238;       % fetal inlet concentration [micro mol/l] 
aa(4).linestyle='k-';     % line style for plotting


% -------------------------------------------------------------------------
%     Transporter parameters, see kineticodefile.m 
% -------------------------------------------------------------------------

% --- Maternal - Syncytiotrophoblast --------------------------------------

%------Accumulative MVM
param.MVM_accum_aaindx=[1 4];% substrate specificity
param.MVM_accum_xt=1e3;
param.MVM_accum_beta=0.33;
param.MVM_accum_pot=-21;     % mV
param.MVM_accum_k1=0.01;
param.MVM_accum_k1b=0.01;
param.MVM_accum_k2=0.01;
param.MVM_accum_k2b=0.01;

param.MVM_accum_Ko=2263;
param.MVM_accum_KNao=25073;
param.MVM_accum_Ki=2263;
param.MVM_accum_KNai=25073;

param.MVM_accum_CNa1=134*1000;
param.MVM_accum_CNa2=15*1000;

%------Exchange MVM
param.MVM_exchange_aaindx=[1 2 3 4]; % substrate specificity 
param.MVM_exchange_Dxt=0.01e3; % [micro mol/(min dm^2)] transporter rate 
param.MVM_exchange_Ko(param.MVM_exchange_aaindx)=[200 200 200 200];% [micro molar] 
param.MVM_exchange_Ki(param.MVM_exchange_aaindx)=[200 200 200 200];% [micro molar] 


% --- Syncytiotrophoblast - Fetal -----------------------------------------

%------Exchange BM
param.BM_exchange_aaindx=[1 2 3 4]; 
param.BM_exchange_Dxt=0.01e3; % [micro mol/(min dm^2)] transporter rate 
param.BM_exchange_Ko(param.BM_exchange_aaindx)=[200 200 200 200];% [micro molar] 
param.BM_exchange_Ki(param.BM_exchange_aaindx)=[200 200 200 200];% [micro molar]

%------Facilitative (efflux) BM 
param.BM_efflux_aaindx=[3 4];
param.BM_efflux_Dxt=0.01e3;% [micro mol/(min dm^2)] transport rate efflux transporter 
param.BM_efflux_Ko(param.BM_efflux_aaindx)=[1000 1000];% [micro molar]
param.BM_efflux_Ki(param.BM_efflux_aaindx)=[1000 1000];


% --- Maternal - Fetal ----------------------------------------------------
%param.Paracellflux_Rd = 0; % [dm/min] passive diffusion rate from maternal to fetal, bypassing syncytiotrophoblast



