clear all
load('Data.mat');

% Create a new plot
fig=figure;
axes('YScale','log');
xlim([0, 1.6]);
ylim([1e-6, 1]);
title('BCJR-I=7 vs. FPTD-N=6144 (Max-Log)');
set(fig,'Position',[100,100,800,640]);
set(gca,'FontSize',18);
xlhand = get(gca,'xlabel');
set(xlhand,'string','E_b/N_0 (dB)','fontsize',18);
ylhand = get(gca,'ylabel');
set(gca,'YTick',[1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
set(gca,'XTick',[0:0.2:1.6]);
set(ylhand,'string','BER','fontsize',18);
grid;
hold on

%% 6144-bit Frames
% Plot PIVI Log-BCJR with different window sizes
for iteration_index = 7
    semilogy(N6144_P32(:,1),N6144_P32(:,iteration_index+2)./N6144_P32(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N6144_P64(:,1),N6144_P64(:,iteration_index+2)./N6144_P64(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N6144_P96(:,1),N6144_P96(:,iteration_index+2)./N6144_P96(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N6144_P128(:,1),N6144_P128(:,iteration_index+2)./N6144_P128(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    h2=semilogy(N6144_P192(:,1),N6144_P192(:,iteration_index+2)./N6144_P192(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
end
% Plot SIMD FPTD with different iterations
for idx=[36 39 42 46 49]
    h1=semilogy(N6144_FPTD(:,1),N6144_FPTD(:,idx+2)./N6144_FPTD(:,2),'-b','LineWidth',1.2,'MarkerSize',10);
end

%% 768-bit Frames
% Plot PIVI Log-BCJR with different window sizes
for iteration_index = 7
    h2=semilogy(N768_P4(:,1),N768_P4(:,iteration_index+2)./N768_P4(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N768_P8(:,1),N768_P8(:,iteration_index+2)./N768_P8(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N768_P12(:,1),N768_P12(:,iteration_index+2)./N768_P12(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N768_P16(:,1),N768_P16(:,iteration_index+2)./N768_P16(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
    semilogy(N768_P24(:,1),N768_P24(:,iteration_index+2)./N768_P24(:,2),'-.k','LineWidth',1.2,'MarkerSize',10);
end
% Plot SIMD FPTD with different iterations
for idx=[36 39 42 46 49]
    h1=semilogy(N768_FPTD(:,1),N768_FPTD(:,idx+2)./N768_FPTD(:,2),'-b','LineWidth',1.2,'MarkerSize',10);
end


%% Plot a zoomed in subplot
hAxS = axes('Position',[0.205 0.174 0.2 0.3]);
set(hAxS,'YScale','log')
set(hAxS ,'Box','on','FontSize',16,'LineWidth',1.2);
ylim([0.99*1e-5, 1e-4])
xlim([0.8 1])
grid
hold on
x_plot=[9:11];
semilogy(hAxS, N6144_P32(x_plot,1),N6144_P32(x_plot,iteration_index+2)./N6144_P32(x_plot,2),'-.k','LineWidth',1.2,'MarkerSize',10);
semilogy(hAxS, N6144_P64(x_plot,1),N6144_P64(x_plot,iteration_index+2)./N6144_P64(x_plot,2),'-.k','LineWidth',1.2,'MarkerSize',10);
semilogy(hAxS, N6144_P96(x_plot,1),N6144_P96(x_plot,iteration_index+2)./N6144_P96(x_plot,2),'-.k','LineWidth',1.2,'MarkerSize',10);
semilogy(hAxS, N6144_P128(x_plot,1),N6144_P128(x_plot,iteration_index+2)./N6144_P128(x_plot,2),'-.k','LineWidth',1.2,'MarkerSize',10);
semilogy(hAxS, N6144_P192(x_plot,1),N6144_P192(x_plot,iteration_index+2)./N6144_P192(x_plot,2),'-.k','LineWidth',1.2,'MarkerSize',10);
for idx=[36 39 42 46 49]
   semilogy(N6144_FPTD(x_plot,1),N6144_FPTD(x_plot,idx+2)./N6144_FPTD(x_plot,2),'-b','LineWidth',1.2,'MarkerSize',10);
end

%%
% Legend
legend([h1 h2],'FPTD','BCJR','interpreter','latex','FontSize',18);

% Annotation
annotation(fig,'textarrow',[0.412 0.448],...
    [0.56 0.594],'TextEdgeColor','none', 'TextLineWidth',2,'FontSize',18,...
    'FontName','Arial','String',{'$N=6144$'},'interpreter','latex');
annotation(fig,'textarrow',[0.661 0.615],...
    [0.704 0.6634],'TextEdgeColor','none', 'TextLineWidth',2,'FontSize',18,...
    'FontName','Arial','String',{'$N=768$'},'interpreter','latex');
annotation(fig,'textarrow',[0.744 0.675],...
    [0.529 0.457],'TextEdgeColor','none', 'TextLineWidth',2,'FontSize',18,...
    'FontName','Arial','String',sprintf('$I$ (FPTD)\n$W$ (BCJR)'),'interpreter','latex');
annotation(fig,'rectangle',[0.518 0.251 0.0955 0.1357],'LineWidth',1,'LineStyle','--');
annotation(fig,'line',[0.403 0.512],[0.473 0.392],'LineWidth',1,'LineStyle','--');
annotation(fig,'line',[0.408 0.519],[0.178 0.253],'LineWidth',1,'LineStyle','--');