clear all

%% Parameters
I_BCJR = 6;
I_FPTD = 39;

%% Compare float FPTD approximate max* with 0.75 scaling, fixed-point FPTD with various bit widths

fig=figure;
axes('YScale','log');
xlim([0, 2]);
ylim([1e-8, 1]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',18);
xlabel('$E_b/N_0$ (dB)','fontsize',18,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
ylabel('BER','fontsize',18,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
hold on

% Plot floating-point FPTD
load('Data_FPTD.mat');
fig_FPTD_FP(1)=semilogy(FPTD_ApproxMaxstar(:,1),FPTD_ApproxMaxstar(:,I_FPTD(end)+2)./FPTD_ApproxMaxstar(:,2),'-xr','LineWidth',2,'MarkerSize',10);
fig_FPTD_FP(2)=semilogy(FPTD_ApproxMaxstar_scaling(:,1),FPTD_ApproxMaxstar_scaling(:,I_FPTD(end)+2)./FPTD_ApproxMaxstar_scaling(:,2),'-+r','LineWidth',2,'MarkerSize',10);

%Plot fixed-point FPTD
load('Data_IFPTD.mat');
fig_FPTD_Int(1)=semilogy(IFPTD_BW357_S0(:,1),IFPTD_BW357_S0(:,I_FPTD+2)./IFPTD_BW357_S0(:,2),'-ob','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(2)=semilogy(IFPTD_BW468_S0(:,1),IFPTD_BW468_S0(:,I_FPTD+2)./IFPTD_BW468_S0(:,2),'-sb','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(3)=semilogy(IFPTD_BW579_S0(:,1),IFPTD_BW579_S0(:,I_FPTD+2)./IFPTD_BW579_S0(:,2),'-*b','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(4)=semilogy(IFPTD_BW6810_S0(:,1),IFPTD_BW6810_S0(:,I_FPTD+2)./IFPTD_BW6810_S0(:,2),'-db','LineWidth',2,'MarkerSize',10);

% Legend
leg=legend([fig_FPTD_FP([1 2]) fig_FPTD_Int],sprintf('FPTD, float\napprox max*'),sprintf('FPTD, float\napprox max*\nscaling ($f_2=0.7$)'),'FPTD, fixed (3,5)','FPTD, fixed (4,6)','FPTD, fixed (5,7)','FPTD, fixed (6,8)');
set(legend,'Location','NorthEast','color','none','Box','off','interpreter','latex','FontSize',18);
leg.Position(4) = leg.Position(4)+0.05; 
leg.Position(2) = leg.Position(2)-0.05; 
