clear all

%% Parameters
I_BCJR = 6;
I_FPTD = 39;

%% Compare float FPTD and float Log-BCJR

fig=figure;
axes('YScale','log');
xlim([0, 2]);
ylim([1e-8, 1]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',18);
xlabel('$E_b/N_0$ (dB)','fontsize',18,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
ylabel('BER','fontsize',18,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
hold on

% Plot float BCJR_FP (P=64)
load('Data_BCJR.mat');
fig_BCJR_FP(1)=semilogy(BCJR_P64_ApproxMaxstar(:,1),BCJR_P64_ApproxMaxstar(:,I_BCJR+2)./BCJR_P64_ApproxMaxstar(:,2),'-.xr','LineWidth',2,'MarkerSize',10);
fig_BCJR_FP(2)=semilogy(BCJR_P64_ExactMaxstar(:,1),BCJR_P64_ExactMaxstar(:,I_BCJR+2)./BCJR_P64_ExactMaxstar(:,2),'-.^r','LineWidth',2,'MarkerSize',10);
fig_BCJR_FP(3)=semilogy(BCJR_P64_ApproxMaxstar_scaling(:,1),BCJR_P64_ApproxMaxstar_scaling(:,I_BCJR+2)./BCJR_P64_ApproxMaxstar_scaling(:,2),'-.+r','LineWidth',2,'MarkerSize',10);

% Plot float FPTD_FP
load('Data_FPTD.mat');
fig_FPTD_FP(1)=semilogy(FPTD_ApproxMaxstar(:,1),FPTD_ApproxMaxstar(:,I_FPTD(end)+2)./FPTD_ApproxMaxstar(:,2),'-xb','LineWidth',2,'MarkerSize',10);
fig_FPTD_FP(2)=semilogy(FPTD_ExactMaxstar(:,1),FPTD_ExactMaxstar(:,I_FPTD(end)+2)./FPTD_ExactMaxstar(:,2),'-^b','LineWidth',2,'MarkerSize',10);
fig_FPTD_FP(3)=semilogy(FPTD_ApproxMaxstar_scaling(:,1),FPTD_ApproxMaxstar_scaling(:,I_FPTD(end)+2)./FPTD_ApproxMaxstar_scaling(:,2),'-+b','LineWidth',2,'MarkerSize',10);

% Legend
leg=legend([fig_FPTD_FP fig_BCJR_FP],...
    sprintf('FPTD, float\napprox max*, $I=39$'),...
    sprintf('FPTD, float\nexact max*, $I=39$'),...
    sprintf('FPTD, float\napprox max*, $I=39$\nscaling ($f_2=0.7$)'),...
    sprintf('Log-BCJR, float\napprox max*, $I=6$'),...
    sprintf('Log-BCJR, float\nexact max*, $I=6$'),...
    sprintf('Log-BCJR, float\napprox max*, $I=6$\nscaling ($f_2=0.7$)'));
set(legend,'Location','NorthEast','color','none','Box','off','interpreter','latex','FontSize',17);
leg.Position(4) = leg.Position(4)+0.1; 
leg.Position(2) = leg.Position(2)-0.1; 

% Annotation
annotation(fig,'textbox',[0.383017543859649 0.509315811853569 0.202830420166091 0.100947535935403],...
    'String',sprintf('Improved by\n scaling'),'LineStyle','none','FontSize',17,'FitBoxToText','on','interpreter','latex');
annotation(fig,'arrow',[0.461333333333333 0.402666666666667],...
    [0.508333333333334 0.506666666666667]); 

