clear all

%% Parameters
I_FPTD= 39;

%% Plot
fig=figure;
axes('YScale','log');
xlim([0, 2]);
ylim([1e-8, 1]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',18);
xlabel('$E_b/N_0$ (dB)','fontsize',18,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
ylabel('BER','fontsize',18,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
hold on

load('Data_IFPTD.mat');

fig_FPTD_Int(1)=semilogy(IFPTD_BW457_Max(:,1),IFPTD_BW457_Max(:,I_FPTD+2)./IFPTD_BW457_Max(:,2),'-.or','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(2)=semilogy(IFPTD_BW457_Min(:,1),IFPTD_BW457_Min(:,I_FPTD+2)./IFPTD_BW457_Min(:,2),'-.+r','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(3)=semilogy(IFPTD_BW457_S0(:,1),IFPTD_BW457_S0(:,I_FPTD+2)./IFPTD_BW457_S0(:,2),'-.sr','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(4)=semilogy(IFPTD_BW468_Max(:,1),IFPTD_BW468_Max(:,I_FPTD+2)./IFPTD_BW468_Max(:,2),'-ob','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(5)=semilogy(IFPTD_BW468_Min(:,1),IFPTD_BW468_Min(:,I_FPTD+2)./IFPTD_BW468_Min(:,2),'-+b','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(6)=semilogy(IFPTD_BW468_S0(:,1),IFPTD_BW468_S0(:,I_FPTD+2)./IFPTD_BW468_S0(:,2),'-sb','LineWidth',2,'MarkerSize',10);

% Legend
legend(fig_FPTD_Int,'FPTD, fixed (4,5), \it{max}','FPTD, fixed (4,5), \it{min}','FPTD, fixed (4,5), \it{state-zero}','FPTD, fixed (4,6), \it{max}','FPTD, fixed (4,6), \it{min}','FPTD, fixed (4,6), \it{state-zero}');
set(legend,'Location','NorthEast','color','none','Box','off','interpreter','latex','FontSize',18);
