clear all
close all

% QPSK, 35dB, Lpi=50 
Eth50=[5 6 7 8 9 10].';

k50=[1 2 3 4 5 6 7 8 9 10].';

Numb50=[12467 3196 689 101 14 1 0 0 0 0;...
      7404  969  78  2   0  0 0 0 0 0;...
      3605  206  6   0   0  0 0 0 0 0;...
      1738  42   0   0   0  0 0 0 0 0;...
      735   7    1   0   0  0 0 0 0 0;...
      289   0    0   0   0  0 0 0 0 0];
%Numb50=10*log10(Numb50/64e7);
%Numb50=Numb50/64e7;
% QPSK, 35dB, Lpi=10
Eth10=[5 6 7 8 9 10].';

k10=[1 2 3 4 5 6 7 8 9 10].';

Numb10=[2912 2059 1515 1034 640 353 194 82 34 17;...
        3381 1644 748  284  99  30  11  0  0  0;...
        2575 662  148  35   9   3   0   0  0  0;...
        1458 179  15   2    0   0   0   0  0  0;...
        597  32   2    0    0   0   0   0  0  0;...
        240  6    1    0    0   0   0   0  0  0];
% QPSK, 35dB, Lpi=25
Eth25=[5 6 7 8 9 10].';
%Numb10=10*log10(Numb10/64e7);
%Numb10=Numb10/64e7;
k25=[1 2 3 4 5 6 7 8 9 10].';

Numb25=[8239 3844 1531 557 174 34 5 1 0 0;...
        6290 1688 345  60  6   1  1 0 0 0;...
        3695 453  46   4   0   0  0 0 0 0;...
        1614 75   2    0   0   0  0 0 0 0;...
        749  17   0    0   0   0  0 0 0 0;...
        276  6    0    0   0   0  0 0 0 0];

% QPSK, 35dB, Lpi=5
Eth5=[5 6 7 8 9 10].';
%Numb25=10*log10(Numb25/64e7);
%Numb25=Numb25/64e7;
k5=[1 2 3 4 5 6 7 8 9 10].';

Numb5=[1201 985  775 654 538 385 272 226 137 124;...
       1626 1030 664 400 213 90  61  24  10  2;...
       1564 650  266 85  32  5   1   0   0   0;...
       1107 245  32  3   0   0   0   0   0   0;...
       566  47   6   0   0   0   0   0   0   0;...
       271  7    1   0   0   0   0   0   0   0];    
    
X=cell(1,4);
X{1}=Numb5;
X{2}=Numb10;
X{3}=Numb25;
X{4}=Numb50;
%Numb5=10*log10(Numb5/64e7);
%Numb5=Numb5/64e7;
dlmwrite('P2F53.dat',X);

figure(1)

%h1 = tight_subplot(2, 2, 0.5, 0, 0)
ax1=subtightplot(2,2,1,0.15,[],[]);
h5=bar3(Numb5);
%h5=imagesc(Numb5);

%h35 = get(h5(3),'parent');
%h25 = get(h5(2),'parent');
%h15 = get(h5(1),'parent');
set(gca,'yticklabel',Eth5,'FontSize',9,'FontWeight','bold');
set(gca,'xticklabel',k5,'FontSize',9,'FontWeight','bold');
%set(h15,'zticklabel',[0:1e3:1e4],'FontSize',9,'FontWeight','bold');
%set(gca, 'XTickLabel', [],'XTick',[])
title('\it L_{\rm \Pi}=5\times M','FontSize',10,'FontWeight','bold')
xlabel('Sparsity Level \it k(l)','FontSize',10,'FontWeight','bold')
ylabel('Threshold \it E_{\rm TH}','FontSize',10,'FontWeight','bold')
view([45 45])
axis tight


ax2=subtightplot(2,2,2,0.15,[],[]);
h10=bar3(Numb10);
%h10=imagesc(Numb10);
%h310 = get(h10(3),'parent');
%h210 = get(h10(2),'parent');
set(gca,'yticklabel',Eth10,'FontSize',9,'FontWeight','bold');
set(gca,'xticklabel',k10,'FontSize',9,'FontWeight','bold');
%set(gca, 'XTickLabel', [],'XTick',[])
xlim([5 10])
title('\it L_{\rm \Pi}=10\times M','FontSize',10,'FontWeight','bold')
xlabel('Sparsity Level \it k(l)','FontSize',10,'FontWeight','bold')
ylabel('Threshold \it E_{\rm TH}','FontSize',10,'FontWeight','bold')
view([45 45])
axis tight

ax3=subtightplot(2,2,3,0.15,[],[]);
h25=bar3(Numb25);
%h25=imagesc(Numb25);
%h325 = get(h25(3),'parent');
%h225 = get(h25(2),'parent');
set(gca,'yticklabel',Eth25,'FontSize',9,'FontWeight','bold');
set(gca,'xticklabel',k25,'FontSize',9,'FontWeight','bold');
%set(gca, 'XTickLabel', [],'XTick',[])
%zlim([0 10000])
title('\it L_{\rm \Pi}=25\times M','FontSize',10,'FontWeight','bold')
xlabel('Sparsity Level \it k(l)','FontSize',10,'FontWeight','bold')
ylabel('Threshold \it E_{\rm TH}','FontSize',10,'FontWeight','bold')
view([45 45])
axis tight


ax4=subtightplot(2,2,4,0.15,[],[]);
h50=bar3(Numb50);
%h50=imagesc(Numb50);
%h350 = get(h50(3),'parent');
%h250 = get(h50(2),'parent');
set(gca,'yticklabel',Eth50,'FontSize',9,'FontWeight','bold');
set(gca,'xticklabel',k50,'FontSize',9,'FontWeight','bold');
%set(gca, 'XTickLabel', [],'XTick',[])
%zlim([0 10000])
title('\it L_{\rm \Pi}=50\times M','FontSize',10,'FontWeight','bold')
xlabel('Sparsity Level \it k(l)','FontSize',10,'FontWeight','bold')
ylabel('Threshold \it E_{\rm TH}','FontSize',10,'FontWeight','bold')
view([45 45])
axis tight

%linkdata on
%linkprop([ax1,ax2,ax3,ax4])
%linkprop(ax,{'CameraPosition','CameraUpVector'})