/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Iterator;
import java.util.Vector;

public abstract class ConditionalMutualInfoMultiVariateCommon
implements ConditionalMutualInfoCalculatorMultiVariate {
    protected int dimensionsVar1 = 1;
    protected int dimensionsVar2 = 1;
    protected int dimensionsCond = 1;
    protected double[][] var1Observations;
    protected double[][] var2Observations;
    protected double[][] condObservations;
    protected int totalObservations = 0;
    protected double lastAverage;
    protected boolean condMiComputed;
    protected boolean debug;
    protected Vector<double[][]> vectorOfVar1Observations;
    protected Vector<double[][]> vectorOfVar2Observations;
    protected Vector<double[][]> vectorOfCondObservations;
    protected boolean addedMoreThanOneObservationSet;
    public static final String PROP_NORMALISE = "NORMALISE";
    protected boolean normalise = true;

    @Override
    public void initialise(int n, int n2, int n3) {
        this.dimensionsVar1 = n;
        this.dimensionsVar2 = n2;
        this.dimensionsCond = n3;
        this.lastAverage = 0.0;
        this.totalObservations = 0;
        this.condMiComputed = false;
        this.var1Observations = null;
        this.var2Observations = null;
        this.condObservations = null;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase(PROP_NORMALISE)) {
            this.normalise = Boolean.parseBoolean(string2);
        }
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2, dArray3);
        this.finaliseAddObservations();
        this.addedMoreThanOneObservationSet = false;
    }

    @Override
    public void startAddObservations() {
        this.vectorOfVar1Observations = new Vector();
        this.vectorOfVar2Observations = new Vector();
        this.vectorOfCondObservations = new Vector();
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        if (this.vectorOfVar1Observations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new Exception(String.format("Observation vector lengths (%d, %d and %d) must match!", dArray.length, dArray2.length, dArray3.length));
        }
        if (dArray[0].length != this.dimensionsVar1) {
            throw new Exception("Number of joint variables in var1 data does not match the initialised value");
        }
        if (dArray2[0].length != this.dimensionsVar2) {
            throw new Exception("Number of joint variables in var2 data does not match the initialised value");
        }
        if (dArray3[0].length != this.dimensionsCond) {
            throw new Exception("Number of joint variables in cond data does not match the initialised value");
        }
        this.vectorOfVar1Observations.add(dArray);
        this.vectorOfVar2Observations.add(dArray2);
        this.vectorOfCondObservations.add(dArray3);
        if (this.vectorOfVar1Observations.size() > 1) {
            this.addedMoreThanOneObservationSet = true;
        }
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2, double[][] dArray3, int n, int n2) throws Exception {
        if (this.vectorOfVar1Observations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        double[][] dArrayArray = new double[n2][];
        System.arraycopy(dArray, n, dArrayArray, 0, n2);
        double[][] dArrayArray2 = new double[n2][];
        System.arraycopy(dArray2, n, dArrayArray2, 0, n2);
        double[][] dArrayArray3 = new double[n2][];
        System.arraycopy(dArray3, n, dArrayArray3, 0, n2);
        this.addObservations(dArrayArray, dArrayArray2, dArrayArray3);
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, double[][] dArray3, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2, blArray3);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, dArray3, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, double[][] dArray3, boolean[][] blArray, boolean[][] blArray2, boolean[][] blArray3) throws Exception {
        boolean[] blArray4 = MatrixUtils.andRows(blArray);
        boolean[] blArray5 = MatrixUtils.andRows(blArray2);
        boolean[] blArray6 = MatrixUtils.andRows(blArray3);
        this.setObservations(dArray, dArray2, dArray3, blArray4, blArray5, blArray6);
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.totalObservations = 0;
        for (double[][] object2 : this.vectorOfVar2Observations) {
            this.totalObservations += object2.length;
        }
        this.var1Observations = new double[this.totalObservations][this.dimensionsVar1];
        this.var2Observations = new double[this.totalObservations][this.dimensionsVar2];
        this.condObservations = new double[this.totalObservations][this.dimensionsCond];
        int n = 0;
        Iterator<double[][]> iterator = this.vectorOfVar2Observations.iterator();
        Iterator<double[][]> iterator2 = this.vectorOfCondObservations.iterator();
        for (double[][] dArray : this.vectorOfVar1Observations) {
            double[][] dArray2 = iterator.next();
            double[][] dArray3 = iterator2.next();
            MatrixUtils.arrayCopy(dArray, 0, 0, this.var1Observations, n, 0, dArray.length, this.dimensionsVar1);
            MatrixUtils.arrayCopy(dArray2, 0, 0, this.var2Observations, n, 0, dArray2.length, this.dimensionsVar2);
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.condObservations, n, 0, dArray3.length, this.dimensionsCond);
            n += dArray2.length;
        }
        if (this.normalise) {
            MatrixUtils.normalise(this.var1Observations);
            MatrixUtils.normalise(this.var2Observations);
            MatrixUtils.normalise(this.condObservations);
        }
        this.vectorOfVar1Observations = null;
        this.vectorOfVar2Observations = null;
        this.vectorOfCondObservations = null;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n, int n2) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.var1Observations.length, n2);
        return this.computeSignificance(n, nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n, int[][] nArray) throws Exception {
        int n2 = nArray.length;
        if (!this.condMiComputed) {
            this.computeAverageLocalOfObservations();
        }
        ConditionalMutualInfoMultiVariateCommon conditionalMutualInfoMultiVariateCommon = (ConditionalMutualInfoMultiVariateCommon)this.clone();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double[][] dArray2 = MatrixUtils.extractSelectedTimePointsReusingArrays(n == 1 ? this.var1Observations : this.var2Observations, nArray[i]);
            conditionalMutualInfoMultiVariateCommon.initialise(this.dimensionsVar1, this.dimensionsVar2, this.dimensionsCond);
            if (n == 1) {
                conditionalMutualInfoMultiVariateCommon.setObservations(dArray2, this.var2Observations, this.condObservations);
            } else {
                conditionalMutualInfoMultiVariateCommon.setObservations(this.var1Observations, dArray2, this.condObservations);
            }
            dArray[i] = conditionalMutualInfoMultiVariateCommon.computeAverageLocalOfObservations();
            if (!this.debug) continue;
            System.out.println("New MI was " + dArray[i]);
        }
        return new EmpiricalMeasurementDistribution(dArray, this.lastAverage);
    }

    @Override
    public double computeAverageLocalOfObservations(int n, int[] nArray) throws Exception {
        ConditionalMutualInfoMultiVariateCommon conditionalMutualInfoMultiVariateCommon = (ConditionalMutualInfoMultiVariateCommon)this.clone();
        double[][] dArray = MatrixUtils.extractSelectedTimePointsReusingArrays(n == 1 ? this.var1Observations : this.var2Observations, nArray);
        conditionalMutualInfoMultiVariateCommon.initialise(this.dimensionsVar1, this.dimensionsVar2, this.dimensionsCond);
        if (n == 1) {
            conditionalMutualInfoMultiVariateCommon.setObservations(dArray, this.var2Observations, this.condObservations);
        } else {
            conditionalMutualInfoMultiVariateCommon.setObservations(this.var1Observations, dArray, this.condObservations);
        }
        return conditionalMutualInfoMultiVariateCommon.computeAverageLocalOfObservations();
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.totalObservations;
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < blArray2.length; ++i) {
            if (bl) {
                if (blArray[i] && blArray2[i] && blArray3[i]) {
                    n2 = i;
                    bl = false;
                    if (i != blArray.length - 1) continue;
                    int[] nArray = new int[]{n, n2};
                    vector.add(nArray);
                    continue;
                }
                ++n;
                continue;
            }
            boolean bl2 = false;
            if (blArray[i] && blArray2[i] && blArray3[i]) {
                n2 = i;
            } else {
                bl2 = true;
            }
            if (i == blArray2.length - 1) {
                bl2 = true;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{n, n2};
            vector.add(nArray);
            bl = true;
            n = i + 1;
        }
        return vector;
    }

    @Override
    public boolean getAddedMoreThanOneObservationSet() {
        return this.addedMoreThanOneObservationSet;
    }
}

