/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;

public class TransferEntropyCalculatorViaCondMutualInfo
implements TransferEntropyCalculator {
    protected ConditionalMutualInfoCalculatorMultiVariate condMiCalc;
    protected int k = 1;
    protected int k_tau = 1;
    protected int l = 1;
    protected int l_tau = 1;
    protected int delay = 1;
    protected int startTimeForFirstDestEmbedding;
    protected boolean debug = false;

    public TransferEntropyCalculatorViaCondMutualInfo(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = (ConditionalMutualInfoCalculatorMultiVariate)clazz.newInstance();
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    public TransferEntropyCalculatorViaCondMutualInfo(Class<ConditionalMutualInfoCalculatorMultiVariate> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = clazz.newInstance();
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    public TransferEntropyCalculatorViaCondMutualInfo(ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate) throws Exception {
        if (conditionalMutualInfoCalculatorMultiVariate == null) {
            throw new Exception("Conditional MI calculator used to construct ConditionalTransferEntropyCalculatorViaCondMutualInfo  must have already been instantiated.");
        }
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    protected void construct(ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate) {
        this.condMiCalc = conditionalMutualInfoCalculatorMultiVariate;
    }

    @Override
    public void initialise() throws Exception {
        this.initialise(this.k, this.k_tau, this.l, this.l_tau, this.delay);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.k_tau, this.l, this.l_tau, this.delay);
    }

    public void initialise(int n, int n2, int n3, int n4, int n5) throws Exception {
        if (n5 < 0) {
            throw new Exception("Cannot compute TE with source-destination delay < 0");
        }
        this.k = n;
        this.k_tau = n2;
        this.l = n3;
        this.l_tau = n4;
        this.delay = n5;
        int n6 = (n - 1) * n2;
        int n7 = (n3 - 1) * n4 + n5 - 1;
        this.startTimeForFirstDestEmbedding = Math.max(n6, n7);
        this.condMiCalc.initialise(n3, 1, n);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("k_HISTORY")) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("k_TAU")) {
            this.k_tau = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("l_HISTORY")) {
            this.l = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("l_TAU")) {
            this.l_tau = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("DELAY")) {
            this.delay = Integer.parseInt(string2);
        } else {
            this.condMiCalc.setProperty(string, string2);
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < this.startTimeForFirstDestEmbedding + 2) {
            throw new Exception("Not enough observations to set here given k, k_tau, l, l_tau and delay parameters");
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        this.condMiCalc.setObservations(dArray5, dArray4, dArray3);
    }

    @Override
    public void startAddObservations() {
        this.condMiCalc.startAddObservations();
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < this.startTimeForFirstDestEmbedding + 2) {
            return;
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        this.condMiCalc.addObservations(dArray5, dArray4, dArray3);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, int n, int n2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < n + n2) {
            throw new Exception("Not enough observations to set here given startTime and numTimeSteps parameters");
        }
        this.addObservations(MatrixUtils.select(dArray, n, n2), MatrixUtils.select(dArray2, n, n2));
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.condMiCalc.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray, boolean[] blArray2) throws Exception {
        if (blArray.length != blArray2.length) {
            throw new Exception("Validity arrays must be of same length");
        }
        int n = (this.k - 1) * this.k_tau + 1;
        int n2 = (this.l - 1) * this.l_tau + 1;
        int n3 = 0;
        Vector<int[]> vector = new Vector<int[]>();
        boolean bl = false;
        for (int i = this.startTimeForFirstDestEmbedding; i < blArray2.length - 1; ++i) {
            int n4;
            if (bl) {
                if (blArray2[i + 1] && blArray[i + 1 - this.delay]) continue;
                bl = false;
                int[] nArray = new int[]{n3, i};
                vector.add(nArray);
                continue;
            }
            if (!blArray2[i + 1]) continue;
            boolean bl2 = true;
            for (n4 = 0; n4 < n; ++n4) {
                if (blArray2[i - n4]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            bl2 = true;
            for (n4 = this.delay - 1; n4 < this.delay - 1 + n2; ++n4) {
                if (blArray[i - n4]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            n3 = i - this.startTimeForFirstDestEmbedding;
            bl = true;
        }
        if (bl) {
            bl = false;
            int[] nArray = new int[]{n3, blArray2.length - 1};
            vector.add(nArray);
        }
        return vector;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        return this.condMiCalc.computeAverageLocalOfObservations();
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        double[] dArray = this.condMiCalc.computeLocalOfPreviousObservations();
        if (!this.condMiCalc.getAddedMoreThanOneObservationSet()) {
            double[] dArray2 = new double[dArray.length + this.startTimeForFirstDestEmbedding + 1];
            System.arraycopy(dArray, 0, dArray2, this.startTimeForFirstDestEmbedding + 1, dArray.length);
            return dArray2;
        }
        return dArray;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray2.length < this.startTimeForFirstDestEmbedding + 2) {
            return new double[dArray2.length];
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        double[] dArray6 = this.condMiCalc.computeLocalUsingPreviousObservations(dArray5, dArray4, dArray3);
        double[] dArray7 = new double[dArray6.length + this.startTimeForFirstDestEmbedding + 1];
        System.arraycopy(dArray6, 0, dArray7, this.startTimeForFirstDestEmbedding + 1, dArray6.length);
        return dArray7;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        return this.condMiCalc.computeSignificance(1, n);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        return this.condMiCalc.computeSignificance(1, nArray);
    }

    @Override
    public double getLastAverage() {
        return this.condMiCalc.getLastAverage();
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.condMiCalc.getNumObservations();
    }

    @Override
    public boolean getAddedMoreThanOneObservationSet() {
        return this.condMiCalc.getAddedMoreThanOneObservationSet();
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
        this.condMiCalc.setDebug(bl);
    }
}

