/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;

public abstract class TransferEntropyCommon
implements TransferEntropyCalculator {
    protected static final double log2 = Math.log(2.0);
    protected int k;
    protected int totalObservations = 0;
    protected boolean debug = false;
    protected double lastAverage;
    protected Vector<double[]> vectorOfSourceObservations;
    protected Vector<double[]> vectorOfDestinationObservations;
    protected boolean addedMoreThanOneObservationSet;

    @Override
    public void initialise(int n) throws Exception {
        this.k = n;
        this.addedMoreThanOneObservationSet = false;
        this.initialise();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2);
        this.finaliseAddObservations();
    }

    @Override
    public void startAddObservations() {
        this.vectorOfSourceObservations = new Vector();
        this.vectorOfDestinationObservations = new Vector();
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.vectorOfSourceObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length <= this.k) {
            return;
        }
        this.vectorOfSourceObservations.add(dArray);
        this.vectorOfDestinationObservations.add(dArray2);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, int n, int n2) throws Exception {
        if (this.vectorOfSourceObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        if (n2 <= this.k) {
            return;
        }
        double[] dArray3 = new double[n2];
        System.arraycopy(dArray, n, dArray3, 0, n2);
        this.vectorOfSourceObservations.add(dArray3);
        double[] dArray4 = new double[n2];
        System.arraycopy(dArray2, n, dArray4, 0, n2);
        this.vectorOfDestinationObservations.add(dArray4);
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray, boolean[] blArray2) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < blArray2.length; ++i) {
            if (bl) {
                if (blArray2[i]) {
                    if (i - n < this.k) continue;
                    if (blArray[i - 1]) {
                        n2 = i;
                        bl = false;
                        if (i != blArray2.length - 1) continue;
                        int[] nArray = new int[]{n, n2};
                        vector.add(nArray);
                        continue;
                    }
                    ++n;
                    continue;
                }
                n = i + 1;
                continue;
            }
            boolean bl2 = false;
            if (blArray2[i] && blArray[i - 1]) {
                n2 = i;
            } else {
                bl2 = true;
            }
            if (i == blArray2.length - 1) {
                bl2 = true;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{n, n2};
            vector.add(nArray);
            bl = true;
            n = !blArray2[i] ? i + 1 : i - this.k + 1;
        }
        return vector;
    }

    protected double[][] makeJointVectorForPast(double[] dArray) {
        try {
            return MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.k - 1, dArray.length - this.k);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected double[][] makeJointVectorForNextPast(double[] dArray) {
        return MatrixUtils.makeDelayEmbeddingVector(dArray, this.k + 1);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("k_HISTORY")) {
            this.k = Integer.parseInt(string2);
        } else {
            if (string.equalsIgnoreCase("k_TAU")) {
                throw new Exception("Unsupported property");
            }
            if (string.equalsIgnoreCase("l_HISTORY")) {
                throw new Exception("Unsupported property");
            }
            if (string.equalsIgnoreCase("l_TAU")) {
                throw new Exception("Unsupported property");
            }
            if (string.equalsIgnoreCase("DELAY")) {
                throw new Exception("Unsupported property");
            }
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public int getNumObservations() {
        return this.totalObservations;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getAddedMoreThanOneObservationSet() {
        return this.addedMoreThanOneObservationSet;
    }
}

