/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.continuous.kernel.KernelCount;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import java.util.Iterator;

public class TransferEntropyCalculatorKernelPlainIterators
extends TransferEntropyCommon
implements TransferEntropyCalculator {
    protected int[] timeSeriesIndex;
    protected int[] timeStepIndex;
    private static final int NEXT_PAST_SOURCE = 0;
    private static final int PAST_SOURCE = 1;
    private static final int NEXT_PAST = 2;
    private static final int PAST = 3;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 100;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    public static final double DEFAULT_EPSILON = 0.25;
    private double epsilon = 0.25;
    private double epsDest;
    private double epsSource;
    public static final String EPSILON_PROP_NAME = "EPSILON";

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.epsilon);
    }

    public void initialise(int n, double d) throws Exception {
        this.epsilon = d;
        super.initialise(n);
    }

    @Override
    public void initialise() {
        this.timeSeriesIndex = null;
        this.timeStepIndex = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        super.setProperty(string, string2);
        if (string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.epsilon = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl = this.dynCorrExcl = this.dynCorrExclTime > 0;
        }
        if (this.debug) {
            System.out.println("Set property " + string + " to " + string2);
        }
    }

    @Override
    public void finaliseAddObservations() {
        this.totalObservations = 0;
        for (double[] dArray : this.vectorOfDestinationObservations) {
            this.totalObservations += dArray.length - this.k;
        }
        this.timeSeriesIndex = new int[this.totalObservations];
        this.timeStepIndex = new int[this.totalObservations];
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Iterator iterator = this.vectorOfSourceObservations.iterator();
        for (double[] dArray : this.vectorOfDestinationObservations) {
            int n3;
            int n4 = this.k;
            while (n4 < dArray.length) {
                this.timeSeriesIndex[n] = n2;
                this.timeStepIndex[n++] = n4++;
            }
            ++n2;
            if (!this.normalise) continue;
            double[] dArray2 = (double[])iterator.next();
            for (n3 = 0; n3 < this.k - 1; ++n3) {
                d += dArray[n3];
                d2 += dArray[n3] * dArray[n3];
            }
            for (n3 = this.k - 1; n3 < dArray.length - 1; ++n3) {
                d += dArray[n3];
                d2 += dArray[n3] * dArray[n3];
                d3 += dArray2[n3];
                d4 += dArray2[n3] * dArray2[n3];
            }
            d += dArray[dArray.length - 1];
            d2 += dArray[dArray.length - 1] * dArray[dArray.length - 1];
        }
        if (this.normalise) {
            double d5 = d / (double)this.totalObservations;
            double d6 = d3 / (double)this.totalObservations;
            double d7 = d2 / (double)this.totalObservations;
            double d8 = d4 / (double)this.totalObservations;
            double d9 = Math.sqrt(d7 - d5 * d5);
            double d10 = Math.sqrt(d8 - d6 * d6);
            this.epsDest = this.epsilon * d9;
            this.epsSource = this.epsilon * d10;
        } else {
            this.epsDest = this.epsilon;
            this.epsSource = this.epsilon;
        }
        boolean bl = this.addedMoreThanOneObservationSet = this.vectorOfDestinationObservations.size() > 1;
        if (!this.addedMoreThanOneObservationSet || this.dynCorrExcl) {
            // empty if block
        }
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            int n = this.timeSeriesIndex[i];
            double[] dArray = (double[])this.vectorOfSourceObservations.elementAt(n);
            double[] dArray2 = (double[])this.vectorOfDestinationObservations.elementAt(n);
            int[] nArray = this.getCounts(dArray, dArray2, this.timeStepIndex[i], n);
            double d2 = 0.0;
            double d3 = 0.0;
            if (nArray[0] > 0) {
                d2 = (double)nArray[0] / (double)nArray[1] / ((double)nArray[2] / (double)nArray[3]);
                d3 = Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + dArray2[this.timeStepIndex[i]] + " (" + nArray[0] + " / " + nArray[1] + ") / (" + nArray[2] + " / " + nArray[3] + ") = " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWithCorrection() throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            int n = this.timeSeriesIndex[i];
            double[] dArray = (double[])this.vectorOfSourceObservations.elementAt(n);
            double[] dArray2 = (double[])this.vectorOfDestinationObservations.elementAt(n);
            int[] nArray = this.getCounts(dArray, dArray2, this.timeStepIndex[i], n);
            double d2 = 0.0;
            if (nArray[0] > 0) {
                d2 = MathsUtils.digamma(nArray[0]) - MathsUtils.digamma(nArray[1]) - MathsUtils.digamma(nArray[2]) + MathsUtils.digamma(nArray[3]);
            }
            d += d2;
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(null, null, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    private double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, boolean bl) throws Exception {
        double[] dArray3;
        int n = bl ? this.totalObservations : dArray2.length - this.k;
        double d = 0.0;
        int n2 = 0;
        if (bl && this.addedMoreThanOneObservationSet) {
            dArray3 = new double[n];
            n2 = 0;
        } else {
            dArray3 = new double[n + this.k];
            n2 = this.k;
        }
        for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = i;
            if (bl) {
                n3 = this.timeSeriesIndex[i];
                n4 = this.timeStepIndex[i];
                dArray = (double[])this.vectorOfSourceObservations.elementAt(n3);
                dArray2 = (double[])this.vectorOfDestinationObservations.elementAt(n3);
            }
            int[] nArray = this.getCounts(dArray, dArray2, n4, n3);
            double d2 = 0.0;
            double d3 = 0.0;
            if (nArray[0] > 0) {
                d2 = (double)nArray[0] / (double)nArray[1] / ((double)nArray[2] / (double)nArray[3]);
                d3 = Math.log(d2);
            }
            dArray3[n2 + i] = d3;
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)n / Math.log(2.0);
        return dArray3;
    }

    protected int[] getCounts(double[] dArray, double[] dArray2, int n, int n2) {
        int[] nArray = new int[4];
        for (int i = 0; i < this.totalObservations; ++i) {
            double[] dArray3 = (double[])this.vectorOfSourceObservations.elementAt(this.timeSeriesIndex[i]);
            double[] dArray4 = (double[])this.vectorOfDestinationObservations.elementAt(this.timeSeriesIndex[i]);
            int n3 = this.timeStepIndex[i];
            if (n2 >= 0 && this.dynCorrExcl && this.timeSeriesIndex[i] == n2 && Math.abs(n3 - n) < this.dynCorrExclTime || !this.compareHistory(dArray2, n, dArray4, n3)) continue;
            nArray[3] = nArray[3] + 1;
            boolean bl = Math.abs(dArray2[n] - dArray4[n3]) <= this.epsDest;
            boolean bl2 = Math.abs(dArray[n - 1] - dArray3[n3 - 1]) <= this.epsSource;
            nArray[2] = nArray[2] + (bl ? 1 : 0);
            nArray[1] = nArray[1] + (bl2 ? 1 : 0);
            nArray[0] = nArray[0] + (bl && bl2 ? 1 : 0);
        }
        return nArray;
    }

    protected boolean compareHistory(double[] dArray, int n, double[] dArray2, int n2) {
        for (int i = 1; i <= this.k; ++i) {
            if (!(Math.abs(dArray[n - i] - dArray2[n2 - i]) > this.epsDest)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        throw new RuntimeException("Not implemented in this calculator");
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        throw new RuntimeException("Not implemented in this calculator");
    }

    public KernelCount[][] computeMatchesForEachObservations(boolean bl) throws Exception {
        KernelCount[][] kernelCountArray = new KernelCount[this.totalObservations][4];
        for (int i = 0; i < this.totalObservations; ++i) {
            int n = this.timeSeriesIndex[i];
            double[] dArray = (double[])this.vectorOfSourceObservations.elementAt(n);
            double[] dArray2 = (double[])this.vectorOfDestinationObservations.elementAt(n);
            int[] nArray = this.getCounts(dArray, dArray2, this.timeStepIndex[i], n);
            kernelCountArray[i] = new KernelCount[4];
            for (int j = 0; j < 4; ++j) {
                int n2 = 0;
                if (this.dynCorrExcl) {
                    int n3 = dArray2.length;
                    int n4 = this.timeStepIndex[i] - this.k;
                    int n5 = n4 >= this.dynCorrExclTime ? this.dynCorrExclTime - 1 : n4;
                    n5 += n3 - n4 >= this.dynCorrExclTime ? this.dynCorrExclTime - 1 : n3 - n4 - 1;
                    n2 = this.totalObservations - ++n5;
                } else {
                    n2 = this.totalObservations;
                }
                kernelCountArray[i][j] = new KernelCount(nArray[j], n2);
            }
        }
        return kernelCountArray;
    }
}

