/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.kernel.TransferEntropyCalculatorMultiVariateKernel;
import infodynamics.utils.MatrixUtils;
import java.util.Iterator;
import java.util.Vector;

public class TransferEntropyCalculatorMultiVariateSingleObservationsKernel
extends TransferEntropyCalculatorMultiVariateKernel {
    protected Vector<double[][]> vectorOfJointDestinationPastObservations;
    protected int destPastDimensions = 1;

    public void initialise(double d) throws Exception {
        this.kernelWidth = d;
        this.initialise(1, 1);
    }

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.destDimensions = n2;
        this.sourceDimensions = n;
        this.destPastDimensions = n2;
        super.initialise(1);
    }

    public void initialiseAllDimensions(int n, int n2, int n3) throws Exception {
        this.destDimensions = n2;
        this.sourceDimensions = n;
        this.destPastDimensions = n3;
        this.addedMoreThanOneObservationSet = false;
        this.k = 1;
        this.teKernelEstimator.initialise(n3, n, this.kernelWidth, this.kernelWidth);
        this.nextStateKernelEstimator.initialise(n2, this.kernelWidth);
        this.destPastVectors = null;
        this.destNextVectors = null;
        this.sourceVectors = null;
        this.localProbNextCondPast = null;
    }

    public void setObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2, dArray3);
        this.finaliseAddObservations();
    }

    @Override
    public void startAddObservations() {
        this.vectorOfJointDestinationPastObservations = new Vector();
        super.startAddObservations();
    }

    public void addObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        if (dArray3.length != dArray2.length) {
            throw new Exception(String.format("Destination past and destination lengths (%d and %d) must match!", dArray3.length, dArray2.length));
        }
        int n = dArray3[0].length;
        if (n != this.destPastDimensions) {
            throw new Exception("Cannot add observsations for destination past variables  of " + n + " dimensions for TE calculator set up for " + this.destPastDimensions + " destination past dimensions");
        }
        if (this.vectorOfJointDestinationPastObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        this.vectorOfJointDestinationPastObservations.add(dArray3);
        super.addObservations(dArray, dArray2);
    }

    public void addSingleObservation(double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray3.length;
        if (n2 != this.destDimensions || n != this.sourceDimensions || n3 != this.destPastDimensions) {
            throw new Exception("Cannot add observsations for source, destination and destPast variables  of " + n + " and " + n2 + " and " + n3 + " dimensions respectively for TE calculator set up for " + this.sourceDimensions + ", " + this.destDimensions + " and " + this.destPastDimensions + " source, destination and destPast dimensions respectively");
        }
        if (this.vectorOfJointDestinationPastObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        double[][] dArrayArray = new double[1][];
        double[][] dArrayArray2 = new double[1][];
        double[][] dArrayArray3 = new double[1][];
        dArrayArray[0] = dArray;
        dArrayArray2[0] = dArray2;
        dArrayArray3[0] = dArray3;
        this.vectorOfJointDestinationPastObservations.add(dArrayArray3);
        super.addObservations(dArrayArray, dArrayArray2);
    }

    @Override
    public void finaliseAddObservations() {
        Object object2;
        this.totalObservations = 0;
        for (Object object2 : this.vectorOfJointDestinationObservations) {
            this.totalObservations += ((double[][])object2).length;
        }
        this.destPastVectors = new double[this.totalObservations][this.destPastDimensions];
        this.destNextVectors = new double[this.totalObservations][this.destDimensions];
        this.sourceVectors = new double[this.totalObservations][this.sourceDimensions];
        int n = 0;
        object2 = this.vectorOfJointDestinationObservations.iterator();
        Iterator<double[][]> iterator = this.vectorOfJointDestinationPastObservations.iterator();
        for (double[][] dArray : this.vectorOfJointSourceObservations) {
            double[][] dArray2 = (double[][])object2.next();
            double[][] dArray3 = iterator.next();
            MatrixUtils.arrayCopy(dArray3, 0, 0, this.destPastVectors, n, 0, dArray3.length, this.destPastDimensions);
            MatrixUtils.arrayCopy(dArray2, 0, 0, this.destNextVectors, n, 0, dArray2.length, this.destDimensions);
            MatrixUtils.arrayCopy(dArray, 0, 0, this.sourceVectors, n, 0, dArray.length, this.sourceDimensions);
            n += dArray2.length;
        }
        this.teKernelEstimator.setObservations(this.destPastVectors, this.destNextVectors, this.sourceVectors);
        this.addedMoreThanOneObservationSet = this.vectorOfJointDestinationObservations.size() > 1;
        this.vectorOfJointSourceObservations = null;
        this.vectorOfJointDestinationObservations = null;
        this.vectorOfJointDestinationPastObservations = null;
    }
}

