/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Arrays;

public class ConditionalMutualInfoCalculatorMultiVariateKraskov1
extends ConditionalMutualInfoCalculatorMultiVariateKraskov {
    protected static final double CUTOFF_MULTIPLIER = 1.5;

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        return this.computeAverageLocalOfObservations(1, null);
    }

    @Override
    public double computeAverageLocalOfObservations(int n, int[] nArray) throws Exception {
        if (!tryKeepAllPairsNorms || this.var1Observations.length > MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM) {
            double[][] dArray = n == 1 ? this.var1Observations : this.var2Observations;
            if (nArray != null) {
                if (n == 1) {
                    this.var1Observations = MatrixUtils.extractSelectedTimePointsReusingArrays(dArray, nArray);
                } else {
                    this.var2Observations = MatrixUtils.extractSelectedTimePointsReusingArrays(dArray, nArray);
                }
            }
            double d = this.computeAverageLocalOfObservationsWhileComputingDistances();
            if (n == 1) {
                this.var1Observations = dArray;
            } else {
                this.var2Observations = dArray;
            }
            return d;
        }
        if (this.xNorms == null) {
            this.computeNorms();
        }
        int n2 = this.var1Observations.length;
        int n3 = (int)(1.5 * Math.log(n2) / Math.log(2.0));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray == null ? i : nArray[i];
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                int n5 = nArray == null ? j : nArray[j];
                dArray[j] = n == 1 ? Math.max(this.xNorms[n4][n5], Math.max(this.yNorms[i][j], this.zNorms[i][j])) : Math.max(this.xNorms[i][j], Math.max(this.yNorms[n4][n5], this.zNorms[i][j]));
            }
            double d5 = 0.0;
            if (this.k <= n3) {
                d5 = MatrixUtils.kthMin(dArray, this.k);
            } else {
                Arrays.sort(dArray);
                d5 = dArray[this.k - 1];
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int j = 0; j < n2; ++j) {
                int n9;
                if (!(this.zNorms[i][j] < d5)) continue;
                ++n8;
                int n10 = n9 = nArray == null ? j : nArray[j];
                if (n == 1) {
                    if (this.xNorms[n4][n9] < d5) {
                        ++n6;
                    }
                    if (!(this.yNorms[i][j] < d5)) continue;
                    ++n7;
                    continue;
                }
                if (this.xNorms[i][j] < d5) {
                    ++n6;
                }
                if (!(this.yNorms[n4][n9] < d5)) continue;
                ++n7;
            }
            d += MathsUtils.digamma(n8 + 1) - MathsUtils.digamma(n6 + 1) - MathsUtils.digamma(n7 + 1);
            if (!this.debug) continue;
            d2 += (double)n6;
            d3 += (double)n7;
            d4 += (double)n8;
            double d6 = MathsUtils.digamma(this.k) + MathsUtils.digamma(n8 + 1) - MathsUtils.digamma(n6 + 1) - MathsUtils.digamma(n7 + 1);
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f\n", i, n6, n7, n8, d6);
        }
        this.lastAverage = MathsUtils.digamma(this.k) + (d /= (double)n2);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d2 /= (double)n2, d3 /= (double)n2, d4 /= (double)n2);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f = %.3f \n", MathsUtils.digamma(this.k), d, this.lastAverage);
        }
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWhileComputingDistances() throws Exception {
        int n = this.var1Observations.length;
        int n2 = (int)(1.5 * Math.log(n) / Math.log(2.0));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double[][] dArray = this.normCalculator.computeNorms(this.var1Observations, this.var2Observations, this.condObservations, i);
            double[] dArray2 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray2[j] = Math.max(dArray[j][0], Math.max(dArray[j][1], dArray[j][2]));
            }
            double d5 = 0.0;
            if (this.k <= n2) {
                d5 = MatrixUtils.kthMin(dArray2, this.k);
            } else {
                Arrays.sort(dArray2);
                d5 = dArray2[this.k - 1];
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (!(dArray[j][2] < d5)) continue;
                ++n5;
                if (dArray[j][0] < d5) {
                    ++n3;
                }
                if (!(dArray[j][1] < d5)) continue;
                ++n4;
            }
            d += MathsUtils.digamma(n5 + 1) - MathsUtils.digamma(n3 + 1) - MathsUtils.digamma(n4 + 1);
            if (!this.debug) continue;
            d2 += (double)n3;
            d3 += (double)n4;
            d4 += (double)n5;
            double d6 = MathsUtils.digamma(this.k) + MathsUtils.digamma(n5 + 1) - MathsUtils.digamma(n3 + 1) - MathsUtils.digamma(n4 + 1);
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f\n", i, n3, n4, n5, d6);
        }
        this.lastAverage = MathsUtils.digamma(this.k) + (d /= (double)n);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d2 /= (double)n, d3 /= (double)n, d4 /= (double)n);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f = %.3f \n", MathsUtils.digamma(this.k), d, this.lastAverage);
        }
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        int n = this.var1Observations.length;
        int n2 = (int)(1.5 * Math.log(n) / Math.log(2.0));
        double[] dArray = new double[n];
        double d = MathsUtils.digamma(this.k);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double[][] dArray2 = this.normCalculator.computeNorms(this.var1Observations, this.var2Observations, this.condObservations, i);
            double[] dArray3 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray3[j] = Math.max(dArray2[j][0], Math.max(dArray2[j][1], dArray2[j][2]));
            }
            double d6 = 0.0;
            if (this.k <= n2) {
                d6 = MatrixUtils.kthMin(dArray3, this.k);
            } else {
                Arrays.sort(dArray3);
                d6 = dArray3[this.k - 1];
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (!(dArray2[j][2] < d6)) continue;
                ++n5;
                if (dArray2[j][0] < d6) {
                    ++n3;
                }
                if (!(dArray2[j][1] < d6)) continue;
                ++n4;
            }
            double d7 = MathsUtils.digamma(n3 + 1);
            double d8 = MathsUtils.digamma(n4 + 1);
            double d9 = MathsUtils.digamma(n5 + 1);
            dArray[i] = d - d7 - d8 + d9;
            d2 += d9 - d7 - d8;
            if (!this.debug) continue;
            d3 += (double)n3;
            d4 += (double)n4;
            d5 += (double)n5;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, local=%.4f\n", i, n3, n4, n5, dArray[i]);
        }
        this.lastAverage = d + (d2 /= (double)n);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d3 /= (double)n, d4 /= (double)n, d5 /= (double)n);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f = %.3f \n", d, d2, this.lastAverage);
        }
        return dArray;
    }

    @Override
    public String printConstants(int n) throws Exception {
        String string = String.format("digamma(k=%d)=%.3e", this.k, MathsUtils.digamma(this.k));
        return string;
    }
}

