/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Arrays;

public class ConditionalMutualInfoCalculatorMultiVariateKraskov2
extends ConditionalMutualInfoCalculatorMultiVariateKraskov {
    protected static final int JOINT_NORM_VAL_COLUMN = 0;
    protected static final int JOINT_NORM_TIMESTEP_COLUMN = 1;
    protected static final double CUTOFF_MULTIPLIER = 1.5;

    @Override
    public double computeAverageLocalOfObservations(int n, int[] nArray) throws Exception {
        if (!tryKeepAllPairsNorms || this.var1Observations.length > MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM) {
            double[][] dArray = n == 1 ? this.var1Observations : this.var2Observations;
            if (n == 1) {
                this.var1Observations = MatrixUtils.extractSelectedTimePointsReusingArrays(dArray, nArray);
            } else {
                this.var2Observations = MatrixUtils.extractSelectedTimePointsReusingArrays(dArray, nArray);
            }
            double d = this.computeAverageLocalOfObservationsWhileComputingDistances();
            if (n == 1) {
                this.var1Observations = dArray;
            } else {
                this.var2Observations = dArray;
            }
            return d;
        }
        if (this.xNorms == null) {
            this.computeNorms();
        }
        int n2 = this.var1Observations.length;
        int n3 = (int)(1.5 * Math.log(n2) / Math.log(2.0));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            int n6 = nArray[i];
            double[][] dArray = new double[n2][2];
            for (int j = 0; j < n2; ++j) {
                int n7 = nArray[j];
                dArray[j][0] = n == 1 ? Math.max(this.xNorms[n6][n7], Math.max(this.yNorms[i][j], this.zNorms[i][j])) : Math.max(this.xNorms[i][j], Math.max(this.yNorms[n6][n7], this.zNorms[i][j]));
                dArray[j][1] = j;
            }
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            int[] nArray2 = null;
            if (this.k <= n3) {
                nArray2 = MatrixUtils.kMinIndices(dArray, 0, this.k);
            } else {
                Arrays.sort(dArray, FirstIndexComparatorDouble.getInstance());
                nArray2 = new int[this.k];
                for (n5 = 0; n5 < this.k; ++n5) {
                    nArray2[n5] = (int)dArray[n5][1];
                }
            }
            for (n5 = 0; n5 < this.k; ++n5) {
                n4 = nArray2[n5];
                if (n == 1) {
                    if (this.xNorms[n6][nArray[n4]] > d7) {
                        d7 = this.xNorms[n6][nArray[n4]];
                    }
                    if (this.yNorms[i][n4] > d8) {
                        d8 = this.yNorms[i][n4];
                    }
                } else {
                    if (this.xNorms[i][n4] > d7) {
                        d7 = this.xNorms[i][n4];
                    }
                    if (this.yNorms[n6][nArray[n4]] > d8) {
                        d8 = this.yNorms[n6][nArray[n4]];
                    }
                }
                if (!(this.zNorms[i][n4] > d9)) continue;
                d9 = this.zNorms[i][n4];
            }
            n5 = 0;
            n4 = 0;
            int n8 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!(this.zNorms[i][j] <= d9)) continue;
                ++n8;
                if (n == 1) {
                    if (this.xNorms[n6][nArray[j]] <= d7) {
                        ++n5;
                    }
                    if (!(this.yNorms[i][j] <= d8)) continue;
                    ++n4;
                    continue;
                }
                if (this.xNorms[i][j] <= d7) {
                    ++n5;
                }
                if (!(this.yNorms[n6][nArray[j]] <= d8)) continue;
                ++n4;
            }
            d4 += (double)n5;
            d5 += (double)n4;
            d6 += (double)n8;
            d += MathsUtils.digamma(n8) - MathsUtils.digamma(n5) - MathsUtils.digamma(n4);
            double d10 = 1.0 / (double)n5;
            d3 += d10;
            double d11 = 1.0 / (double)n4;
            d2 += d11;
            if (!this.debug) continue;
            double d12 = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + MathsUtils.digamma(n8) - MathsUtils.digamma(n5) + d10 - MathsUtils.digamma(n4) + d11;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, 1/n_yz=%.3f, 1/n_xz=%.3f, local=%.4f\n", i, n5, n4, n8, d11, d10, d12);
        }
        this.lastAverage = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + (d /= (double)n2) + (d3 /= (double)n2) + (d2 /= (double)n2);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d4 /= (double)n2, d5 /= (double)n2, d6 /= (double)n2);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f +<inverses>=%.3f - 2/k=%.3f = %.3f (<1/n_yz>=%.3f, <1/n_xz>=%.3f)\n", MathsUtils.digamma(this.k), d, d3 + d2, 2.0 / (double)this.k, this.lastAverage, d2, d3);
        }
        return this.lastAverage;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        if (!tryKeepAllPairsNorms || this.var1Observations.length > MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM) {
            return this.computeAverageLocalOfObservationsWhileComputingDistances();
        }
        if (this.xNorms == null) {
            this.computeNorms();
        }
        int n = this.var1Observations.length;
        int n2 = (int)(1.5 * Math.log(n) / Math.log(2.0));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            double[][] dArray = new double[n][2];
            for (int j = 0; j < n; ++j) {
                dArray[j][0] = Math.max(this.xNorms[i][j], Math.max(this.yNorms[i][j], this.zNorms[i][j]));
                dArray[j][1] = j;
            }
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            int[] nArray = null;
            if (this.k <= n2) {
                nArray = MatrixUtils.kMinIndices(dArray, 0, this.k);
            } else {
                Arrays.sort(dArray, FirstIndexComparatorDouble.getInstance());
                nArray = new int[this.k];
                for (n4 = 0; n4 < this.k; ++n4) {
                    nArray[n4] = (int)dArray[n4][1];
                }
            }
            for (n4 = 0; n4 < this.k; ++n4) {
                n3 = nArray[n4];
                if (this.xNorms[i][n3] > d7) {
                    d7 = this.xNorms[i][n3];
                }
                if (this.yNorms[i][n3] > d8) {
                    d8 = this.yNorms[i][n3];
                }
                if (!(this.zNorms[i][n3] > d9)) continue;
                d9 = this.zNorms[i][n3];
            }
            n4 = 0;
            n3 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (!(this.zNorms[i][j] <= d9)) continue;
                ++n5;
                if (this.xNorms[i][j] <= d7) {
                    ++n4;
                }
                if (!(this.yNorms[i][j] <= d8)) continue;
                ++n3;
            }
            d4 += (double)n4;
            d5 += (double)n3;
            d6 += (double)n5;
            d += MathsUtils.digamma(n5) - MathsUtils.digamma(n4) - MathsUtils.digamma(n3);
            double d10 = 1.0 / (double)n4;
            d3 += d10;
            double d11 = 1.0 / (double)n3;
            d2 += d11;
            if (!this.debug) continue;
            double d12 = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + MathsUtils.digamma(n5) - MathsUtils.digamma(n4) + d10 - MathsUtils.digamma(n3) + d11;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, 1/n_yz=%.3f, 1/n_xz=%.3f, local=%.4f\n", i, n4, n3, n5, d11, d10, d12);
        }
        this.lastAverage = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + (d /= (double)n) + (d2 /= (double)n) + (d3 /= (double)n);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d4 /= (double)n, d5 /= (double)n, d6 /= (double)n);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f + <avInverses>=%.3f - 2/k=%.3f = %.3f (<1/n_yz>=%.3f, <1/n_xz>=%.3f)\n", MathsUtils.digamma(this.k), d, d2 + d3, 2.0 / (double)this.k, this.lastAverage, d2, d3);
        }
        return this.lastAverage;
    }

    public double computeAverageLocalOfObservationsWhileComputingDistances() throws Exception {
        int n = this.var1Observations.length;
        int n2 = (int)(1.5 * Math.log(n) / Math.log(2.0));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            double[][] dArray = this.normCalculator.computeNorms(this.var1Observations, this.var2Observations, this.condObservations, i);
            double[][] dArray2 = new double[n][2];
            for (int j = 0; j < n; ++j) {
                dArray2[j][0] = Math.max(dArray[j][0], Math.max(dArray[j][1], dArray[j][2]));
                dArray2[j][1] = j;
            }
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            int[] nArray = null;
            if (this.k <= n2) {
                nArray = MatrixUtils.kMinIndices(dArray2, 0, this.k);
            } else {
                Arrays.sort(dArray2, FirstIndexComparatorDouble.getInstance());
                nArray = new int[this.k];
                for (n4 = 0; n4 < this.k; ++n4) {
                    nArray[n4] = (int)dArray2[n4][1];
                }
            }
            for (n4 = 0; n4 < this.k; ++n4) {
                n3 = nArray[n4];
                if (dArray[n3][0] > d7) {
                    d7 = dArray[n3][0];
                }
                if (dArray[n3][1] > d8) {
                    d8 = dArray[n3][1];
                }
                if (!(dArray[n3][2] > d9)) continue;
                d9 = dArray[n3][2];
            }
            n4 = 0;
            n3 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (!(dArray[j][2] <= d9)) continue;
                ++n5;
                if (dArray[j][0] <= d7) {
                    ++n4;
                }
                if (!(dArray[j][1] <= d8)) continue;
                ++n3;
            }
            d4 += (double)n4;
            d5 += (double)n3;
            d6 += (double)n5;
            d += MathsUtils.digamma(n5) - MathsUtils.digamma(n4) - MathsUtils.digamma(n3);
            double d10 = 1.0 / (double)n4;
            d3 += d10;
            double d11 = 1.0 / (double)n3;
            d2 += d11;
            if (!this.debug) continue;
            double d12 = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + MathsUtils.digamma(n5) - MathsUtils.digamma(n4) + d10 - MathsUtils.digamma(n3) + d11;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, 1/n_yz=%.3f, 1/n_xz=%.3f, local=%.4f\n", i, n4, n3, n5, d11, d10, d12);
        }
        this.lastAverage = MathsUtils.digamma(this.k) - 2.0 / (double)this.k + (d /= (double)n) + (d2 /= (double)n) + (d3 /= (double)n);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d4 /= (double)n, d5 /= (double)n, d6 /= (double)n);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f + <inverses>=%.3f - 2/k=%.3f = %.3f (<1/n_yz>=%.3f, <1/n_xz>=%.3f)\n", MathsUtils.digamma(this.k), d, d2 + d3, 2.0 / (double)this.k, this.lastAverage, d2, d3);
        }
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        int n = this.var1Observations.length;
        int n2 = (int)(1.5 * Math.log(n) / Math.log(2.0));
        double[] dArray = new double[n];
        double d = MathsUtils.digamma(this.k);
        double d2 = 2.0 / (double)this.k;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            double[][] dArray2 = this.normCalculator.computeNorms(this.var1Observations, this.var2Observations, this.condObservations, i);
            double[][] dArray3 = new double[n][2];
            for (int j = 0; j < n; ++j) {
                dArray3[j][0] = Math.max(dArray2[j][0], Math.max(dArray2[j][1], dArray2[j][2]));
                dArray3[j][1] = j;
            }
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            int[] nArray = null;
            if (this.k <= n2) {
                nArray = MatrixUtils.kMinIndices(dArray3, 0, this.k);
            } else {
                Arrays.sort(dArray3, FirstIndexComparatorDouble.getInstance());
                nArray = new int[this.k];
                for (n4 = 0; n4 < this.k; ++n4) {
                    nArray[n4] = (int)dArray3[n4][1];
                }
            }
            for (n4 = 0; n4 < this.k; ++n4) {
                n3 = nArray[n4];
                if (dArray2[n3][0] > d9) {
                    d9 = dArray2[n3][0];
                }
                if (dArray2[n3][1] > d10) {
                    d10 = dArray2[n3][1];
                }
                if (!(dArray2[n3][2] > d11)) continue;
                d11 = dArray2[n3][2];
            }
            n4 = 0;
            n3 = 0;
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (!(dArray2[j][2] <= d11)) continue;
                ++n5;
                if (dArray2[j][0] <= d9) {
                    ++n4;
                }
                if (!(dArray2[j][1] <= d10)) continue;
                ++n3;
            }
            d6 += (double)n4;
            d7 += (double)n3;
            d8 += (double)n5;
            double d12 = MathsUtils.digamma(n4);
            double d13 = MathsUtils.digamma(n3);
            double d14 = MathsUtils.digamma(n5);
            double d15 = 1.0 / (double)n3;
            double d16 = 1.0 / (double)n4;
            d4 += d15;
            d5 += d16;
            dArray[i] = d - d12 + d16 - d13 + d15 + d14 - d2;
            d3 += d14 - d12 - d13;
            if (!this.debug) continue;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, 1/n_yz=%.3f, 1/n_xz=%.3f, local=%.4f\n", i, n4, n3, n5, d15, d16, dArray[i]);
        }
        this.lastAverage = d - d2 + (d3 /= (double)n) + (d5 /= (double)n) + (d4 /= (double)n);
        this.condMiComputed = true;
        if (this.debug) {
            System.out.printf("<n_xz>=%.3f, <n_yz>=%.3f, <n_z>=%.3f\n", d6 /= (double)n, d7 /= (double)n, d8 /= (double)n);
            System.out.printf("Av = digamma(k)=%.3f + <digammas>=%.3f +<inverses>=%.3f - 2/k=%.3f  = %.3f (<1/n_yz>=%.3f, <1/n_xz>=%.3f)\n", d, d3, d5 + d4, d2, this.lastAverage, d4, d5);
        }
        return dArray;
    }

    @Override
    public String printConstants(int n) throws Exception {
        String string = String.format("digamma(k=%d)=%.3e", this.k, MathsUtils.digamma(this.k));
        return string;
    }
}

