/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.MutualInfoMultiVariateCommon;
import infodynamics.utils.EuclideanUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Random;

public abstract class MutualInfoCalculatorMultiVariateKraskov
extends MutualInfoMultiVariateCommon
implements MutualInfoCalculatorMultiVariate {
    protected int k = 4;
    protected EuclideanUtils normCalculator = new EuclideanUtils(2);
    protected double[][] xNorms;
    protected double[][] yNorms;
    public static boolean tryKeepAllPairsNorms = true;
    public static int MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM = 2000;
    public static final String PROP_K = "k";
    public static final String PROP_NORM_TYPE = "NORM_TYPE";
    public static final String PROP_NORMALISE = "NORMALISE";
    public static final String PROP_ADD_NOISE = "NOISE_LEVEL_TO_ADD";
    protected boolean normalise = true;
    protected boolean addNoise = false;
    protected double noiseLevel = 0.0;

    @Override
    public void initialise(int n, int n2) {
        super.initialise(n, n2);
        this.xNorms = null;
        this.yNorms = null;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(PROP_K)) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_NORM_TYPE)) {
            this.normCalculator.setNormToUse(string2);
        } else if (string.equalsIgnoreCase(PROP_NORMALISE)) {
            this.normalise = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase(PROP_ADD_NOISE)) {
            this.addNoise = true;
            this.noiseLevel = Double.parseDouble(string2);
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        if (this.addNoise) {
            Random random = new Random();
            for (int i = 0; i < this.sourceObservations.length; ++i) {
                int n = 0;
                while (n < this.dimensionsSource) {
                    double[] dArray = this.sourceObservations[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] + random.nextGaussian() * this.noiseLevel;
                }
                n = 0;
                while (n < this.dimensionsDest) {
                    double[] dArray = this.destObservations[i];
                    int n3 = n++;
                    dArray[n3] = dArray[n3] + random.nextGaussian() * this.noiseLevel;
                }
            }
        }
        if (this.normalise) {
            this.sourceObservations = MatrixUtils.normaliseIntoNewArray(this.sourceObservations);
            this.destObservations = MatrixUtils.normaliseIntoNewArray(this.destObservations);
        }
    }

    protected void computeNorms() {
        int n = this.sourceObservations.length;
        this.xNorms = new double[n][n];
        this.yNorms = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double[][] dArray = this.normCalculator.computeNorms(this.sourceObservations, this.destObservations, i);
            for (int j = 0; j < n; ++j) {
                this.xNorms[i][j] = dArray[j][0];
                this.yNorms[i][j] = dArray[j][1];
            }
        }
    }

    @Override
    public abstract double computeAverageLocalOfObservations() throws Exception;

    @Override
    public abstract double computeAverageLocalOfObservations(int[] var1) throws Exception;

    @Override
    public abstract double[] computeLocalOfPreviousObservations() throws Exception;

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) throws Exception {
        throw new Exception("Local method not implemented yet");
    }

    public abstract String printConstants(int var1) throws Exception;
}

