/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculatorViaCondMutualInfo;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov2;
import java.util.Hashtable;

public class TransferEntropyCalculatorKraskov
extends TransferEntropyCalculatorViaCondMutualInfo {
    public static final String COND_MI_CALCULATOR_KRASKOV1 = ConditionalMutualInfoCalculatorMultiVariateKraskov1.class.getName();
    public static final String COND_MI_CALCULATOR_KRASKOV2 = ConditionalMutualInfoCalculatorMultiVariateKraskov2.class.getName();
    public static final String PROP_KRASKOV_ALG_NUM = "ALG_NUM";
    protected int kraskovAlgorithmNumber = 1;
    protected boolean algChanged = false;
    protected Hashtable<String, String> props;

    public TransferEntropyCalculatorKraskov() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(COND_MI_CALCULATOR_KRASKOV1);
        this.kraskovAlgorithmNumber = 1;
        this.props = new Hashtable();
    }

    public TransferEntropyCalculatorKraskov(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
        if (string.equalsIgnoreCase(COND_MI_CALCULATOR_KRASKOV1)) {
            this.kraskovAlgorithmNumber = 1;
        } else if (string.equalsIgnoreCase(COND_MI_CALCULATOR_KRASKOV2)) {
            this.kraskovAlgorithmNumber = 2;
        } else {
            throw new ClassNotFoundException("Must be an underlying Kraskov-Grassberger conditional MI calculator");
        }
        this.props = new Hashtable();
    }

    @Override
    public void initialise(int n, int n2, int n3, int n4, int n5) throws Exception {
        if (this.algChanged) {
            String string = COND_MI_CALCULATOR_KRASKOV1;
            if (this.kraskovAlgorithmNumber == 2) {
                string = COND_MI_CALCULATOR_KRASKOV2;
            }
            Class<?> clazz = Class.forName(string);
            ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = (ConditionalMutualInfoCalculatorMultiVariate)clazz.newInstance();
            this.construct(conditionalMutualInfoCalculatorMultiVariate);
            for (String string2 : this.props.keySet()) {
                conditionalMutualInfoCalculatorMultiVariate.setProperty(string2, this.props.get(string2));
            }
            this.algChanged = false;
        }
        super.initialise(n, n2, n3, n4, n5);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        if (string.equalsIgnoreCase(PROP_KRASKOV_ALG_NUM)) {
            int n = this.kraskovAlgorithmNumber;
            this.kraskovAlgorithmNumber = Integer.parseInt(string2);
            if (this.kraskovAlgorithmNumber != 1 && this.kraskovAlgorithmNumber != 2) {
                throw new Exception("Kraskov algorithm number (" + this.kraskovAlgorithmNumber + ") must be either 1 or 2");
            }
            if (this.kraskovAlgorithmNumber != n) {
                this.algChanged = true;
            }
            if (this.debug) {
                System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
            }
        } else {
            super.setProperty(string, string2);
            this.props.put(string, string2);
        }
    }
}

