/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class ConditionalTransferEntropyCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete {
    protected int k = 0;
    protected int base_power_k = 0;
    protected int base_power_num_others = 0;
    protected int numOtherInfoContributors = 0;
    protected int[][][][] sourceDestPastOthersCount = null;
    protected int[][][] sourcePastOthersCount = null;
    protected int[][][] destPastOthersCount = null;
    protected int[][] pastOthersCount = null;
    protected int[] maxShiftedValue = null;
    protected int startObservationTime = 1;

    public static ConditionalTransferEntropyCalculatorDiscrete newInstance(int n, int n2, int n3) {
        return new ConditionalTransferEntropyCalculatorDiscrete(n, n2, n3);
    }

    public ConditionalTransferEntropyCalculatorDiscrete(int n, int n2, int n3) {
        super(n);
        this.k = n2;
        this.numOtherInfoContributors = n3;
        this.base_power_k = MathsUtils.power(n, this.k);
        this.base_power_num_others = MathsUtils.power(n, n3);
        this.startObservationTime = Math.max(this.k, 1);
        if ((double)this.k > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and history combination too large");
        }
        if (n3 < 1) {
            throw new RuntimeException("Number of other info contributors < 1 for CompleteTECalculator");
        }
        this.sourceDestPastOthersCount = new int[n][n][this.base_power_k][this.base_power_num_others];
        this.sourcePastOthersCount = new int[n][this.base_power_k][this.base_power_num_others];
        this.destPastOthersCount = new int[n][this.base_power_k][this.base_power_num_others];
        this.pastOthersCount = new int[this.base_power_k][this.base_power_num_others];
        this.maxShiftedValue = new int[n];
        for (int i = 0; i < n; ++i) {
            this.maxShiftedValue[i] = i * MathsUtils.power(n, this.k - 1);
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        MatrixUtils.fill(this.sourceDestPastOthersCount, 0);
        MatrixUtils.fill(this.sourcePastOthersCount, 0);
        MatrixUtils.fill(this.destPastOthersCount, 0);
        MatrixUtils.fill(this.pastOthersCount, 0);
    }

    public void addObservations(int[] nArray, int[] nArray2, int[][] nArray3) throws Exception {
        int n;
        int n2 = nArray2.length;
        if (nArray.length != n2 || nArray3.length != n2) {
            throw new Exception("Number of observations must match for dest, source and conditionals");
        }
        if (n2 - this.startObservationTime <= 0) {
            return;
        }
        this.observations += n2 - this.startObservationTime;
        if (this.numOtherInfoContributors != nArray3[0].length) {
            throw new Exception(String.format("conditionals does not have the expected number of variables (%d)", this.numOtherInfoContributors));
        }
        int n3 = 0;
        for (n = 0; n < this.k; ++n) {
            n3 *= this.base;
            n3 += nArray2[n];
        }
        for (int i = this.startObservationTime; i < n2; ++i) {
            n = nArray2[i];
            int n4 = nArray[i - 1];
            int n5 = 0;
            for (int j = 0; j < this.numOtherInfoContributors; ++j) {
                n5 *= this.base;
                n5 += nArray3[i - 1][j];
            }
            int[] nArray4 = this.sourceDestPastOthersCount[n4][n][n3];
            int n6 = n5;
            nArray4[n6] = nArray4[n6] + 1;
            int[] nArray5 = this.sourcePastOthersCount[n4][n3];
            int n7 = n5;
            nArray5[n7] = nArray5[n7] + 1;
            int[] nArray6 = this.destPastOthersCount[n][n3];
            int n8 = n5;
            nArray6[n8] = nArray6[n8] + 1;
            int[] nArray7 = this.pastOthersCount[n3];
            int n9 = n5;
            nArray7[n9] = nArray7[n9] + 1;
            if (this.k <= 0) continue;
            n3 -= this.maxShiftedValue[nArray2[i - this.k]];
            n3 *= this.base;
            n3 += nArray2[i];
        }
    }

    public void addObservations(int[] nArray, int[] nArray2, int[] nArray3) throws Exception {
        int n;
        int n2 = nArray2.length;
        if (nArray.length != n2 || nArray3.length != n2) {
            throw new Exception("Number of observations must match for dest, source and conditionals");
        }
        if (n2 - this.startObservationTime <= 0) {
            return;
        }
        this.observations += n2 - this.startObservationTime;
        int n3 = 0;
        for (n = 0; n < this.k; ++n) {
            n3 *= this.base;
            n3 += nArray2[n];
        }
        for (int i = this.startObservationTime; i < n2; ++i) {
            n = nArray2[i];
            int n4 = nArray[i - 1];
            int n5 = nArray3[i - 1];
            int[] nArray4 = this.sourceDestPastOthersCount[n4][n][n3];
            int n6 = n5;
            nArray4[n6] = nArray4[n6] + 1;
            int[] nArray5 = this.sourcePastOthersCount[n4][n3];
            int n7 = n5;
            nArray5[n7] = nArray5[n7] + 1;
            int[] nArray6 = this.destPastOthersCount[n][n3];
            int n8 = n5;
            nArray6[n8] = nArray6[n8] + 1;
            int[] nArray7 = this.pastOthersCount[n3];
            int n9 = n5;
            nArray7[n9] = nArray7[n9] + 1;
            if (this.k <= 0) continue;
            n3 -= this.maxShiftedValue[nArray2[i - this.k]];
            n3 *= this.base;
            n3 += nArray2[i];
        }
    }

    public void addObservations(int[][] nArray, int n, int[] nArray2) {
        this.addObservations(nArray, n, nArray2, false);
    }

    private void addObservations(int[][] nArray, int n, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        int[] nArray3 = bl ? nArray2 : this.cleanOffsetOthers(nArray2, n, this.k > 0);
        int n4 = nArray.length;
        int n5 = nArray[0].length;
        this.observations += (n4 - this.startObservationTime) * n5;
        int[] nArray4 = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray4[n3] = 0;
            for (n2 = 0; n2 < this.k; ++n2) {
                int n6 = n3;
                nArray4[n6] = nArray4[n6] * this.base;
                int n7 = n3;
                nArray4[n7] = nArray4[n7] + nArray[n2][n3];
            }
        }
        for (int i = this.startObservationTime; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                n3 = nArray[i][j];
                n2 = nArray[i - 1][(j - n + n5) % n5];
                int n8 = 0;
                for (int k = 0; k < nArray3.length; ++k) {
                    n8 *= this.base;
                    n8 += nArray[i - 1][(j - nArray3[k] + n5) % n5];
                }
                int[] nArray5 = this.sourceDestPastOthersCount[n2][n3][nArray4[j]];
                int n9 = n8;
                nArray5[n9] = nArray5[n9] + 1;
                int[] nArray6 = this.sourcePastOthersCount[n2][nArray4[j]];
                int n10 = n8;
                nArray6[n10] = nArray6[n10] + 1;
                int[] nArray7 = this.destPastOthersCount[n3][nArray4[j]];
                int n11 = n8;
                nArray7[n11] = nArray7[n11] + 1;
                int[] nArray8 = this.pastOthersCount[nArray4[j]];
                int n12 = n8;
                nArray8[n12] = nArray8[n12] + 1;
                if (this.k <= 0) continue;
                int n13 = j;
                nArray4[n13] = nArray4[n13] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n14 = j;
                nArray4[n14] = nArray4[n14] * this.base;
                int n15 = j;
                nArray4[n15] = nArray4[n15] + nArray[i][j];
            }
        }
    }

    public void addObservations(int[][] nArray, int n, int n2, int[] nArray2) {
        this.addObservations(nArray, n, n2, nArray2, false);
    }

    private void addObservations(int[][] nArray, int n, int n2, int[] nArray2, boolean bl) {
        int n3;
        int[] nArray3 = bl ? nArray2 : this.cleanAbsoluteOthers(nArray2, n, n2, this.k > 0);
        int n4 = nArray.length;
        this.observations += n4 - this.startObservationTime;
        int n5 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.base;
            n5 += nArray[n3][n2];
        }
        for (int i = this.startObservationTime; i < n4; ++i) {
            n3 = nArray[i][n2];
            int n6 = nArray[i - 1][n];
            int n7 = 0;
            for (int j = 0; j < nArray3.length; ++j) {
                n7 *= this.base;
                n7 += nArray[i - 1][nArray3[j]];
            }
            int[] nArray4 = this.sourceDestPastOthersCount[n6][n3][n5];
            int n8 = n7;
            nArray4[n8] = nArray4[n8] + 1;
            int[] nArray5 = this.sourcePastOthersCount[n6][n5];
            int n9 = n7;
            nArray5[n9] = nArray5[n9] + 1;
            int[] nArray6 = this.destPastOthersCount[n3][n5];
            int n10 = n7;
            nArray6[n10] = nArray6[n10] + 1;
            int[] nArray7 = this.pastOthersCount[n5];
            int n11 = n7;
            nArray7[n11] = nArray7[n11] + 1;
            if (this.k <= 0) continue;
            n5 -= this.maxShiftedValue[nArray[i - this.k][n2]];
            n5 *= this.base;
            n5 += nArray[i][n2];
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.base_power_num_others; ++i) {
            for (int j = 0; j < this.base_power_k; ++j) {
                for (int k = 0; k < this.base; ++k) {
                    for (int i2 = 0; i2 < this.base; ++i2) {
                        if (this.sourceDestPastOthersCount[i2][k][j][i] != 0) {
                            double d4 = (double)this.sourceDestPastOthersCount[i2][k][j][i] / (double)this.observations;
                            double d5 = (double)this.sourceDestPastOthersCount[i2][k][j][i] / (double)this.sourcePastOthersCount[i2][j][i] / ((double)this.destPastOthersCount[k][j][i] / (double)this.pastOthersCount[j][i]);
                            double d6 = Math.log(d5) / this.log_2;
                            d2 = d4 * d6;
                            if (d6 > this.max) {
                                this.max = d6;
                            } else if (d6 < this.min) {
                                this.min = d6;
                            }
                            d3 += d2 * d6;
                        } else {
                            d2 = 0.0;
                        }
                        d += d2;
                    }
                }
            }
        }
        this.average = d;
        this.std = Math.sqrt(d3 - this.average * this.average);
        return d;
    }

    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        int n2;
        double d = this.computeAverageLocalOfObservations();
        int[] nArray = new int[this.observations];
        int n3 = 0;
        for (int i = 0; i < this.base; ++i) {
            int n4 = 0;
            for (int j = 0; j < this.base_power_k; ++j) {
                for (n2 = 0; n2 < this.base_power_num_others; ++n2) {
                    n4 += this.sourcePastOthersCount[i][j][n2];
                }
            }
            MatrixUtils.fill(nArray, i, n3, n4);
            n3 += n4;
        }
        int[] nArray2 = new int[this.observations];
        int[] nArray3 = new int[this.observations];
        int[] nArray4 = new int[this.observations];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.base_power_k; ++i) {
            for (int j = 0; j < this.base_power_num_others; ++j) {
                MatrixUtils.fill(nArray3, i, n5, this.pastOthersCount[i][j]);
                n5 += this.pastOthersCount[i][j];
                MatrixUtils.fill(nArray4, j, n6, this.pastOthersCount[i][j]);
                n6 += this.pastOthersCount[i][j];
                for (int k = 0; k < this.base; ++k) {
                    MatrixUtils.fill(nArray2, k, n2, this.destPastOthersCount[k][i][j]);
                    n2 += this.destPastOthersCount[k][i][j];
                }
            }
        }
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray5 = randomGenerator.generateRandomPerturbations(this.observations, n);
        ConditionalTransferEntropyCalculatorDiscrete conditionalTransferEntropyCalculatorDiscrete = ConditionalTransferEntropyCalculatorDiscrete.newInstance(this.base, this.k, this.numOtherInfoContributors);
        conditionalTransferEntropyCalculatorDiscrete.initialise();
        conditionalTransferEntropyCalculatorDiscrete.observations = this.observations;
        conditionalTransferEntropyCalculatorDiscrete.pastOthersCount = this.pastOthersCount;
        conditionalTransferEntropyCalculatorDiscrete.destPastOthersCount = this.destPastOthersCount;
        int n7 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        for (int i = 0; i < n; ++i) {
            double d2;
            int[] nArray6 = MatrixUtils.extractSelectedTimePoints(nArray, nArray5[i]);
            MatrixUtils.fill(conditionalTransferEntropyCalculatorDiscrete.sourceDestPastOthersCount, 0);
            MatrixUtils.fill(conditionalTransferEntropyCalculatorDiscrete.sourcePastOthersCount, 0);
            for (int j = 0; j < this.observations; ++j) {
                int[] nArray7 = conditionalTransferEntropyCalculatorDiscrete.sourcePastOthersCount[nArray6[j]][nArray3[j]];
                int n8 = nArray4[j];
                nArray7[n8] = nArray7[n8] + 1;
                int[] nArray8 = conditionalTransferEntropyCalculatorDiscrete.sourceDestPastOthersCount[nArray6[j]][nArray2[j]][nArray3[j]];
                int n9 = nArray4[j];
                nArray8[n9] = nArray8[n9] + 1;
            }
            empiricalMeasurementDistribution.distribution[i] = d2 = conditionalTransferEntropyCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n7;
        }
        empiricalMeasurementDistribution.pValue = (double)n7 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    public double[][] computeLocalFromPreviousObservations(int[][] nArray, int n, int[] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, n, nArray2, false);
    }

    private double[][] computeLocalFromPreviousObservations(int[][] nArray, int n, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        int[] nArray3 = bl ? nArray2 : this.cleanOffsetOthers(nArray2, n, this.k > 0);
        int n4 = nArray.length;
        int n5 = nArray[0].length;
        double[][] dArray = new double[n4][n5];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray4 = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray4[n3] = 0;
            for (n2 = 0; n2 < this.k; ++n2) {
                int n6 = n3;
                nArray4[n6] = nArray4[n6] * this.base;
                int n7 = n3;
                nArray4[n7] = nArray4[n7] + nArray[n2][n3];
            }
        }
        for (int i = this.startObservationTime; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                n3 = nArray[i][j];
                n2 = nArray[i - 1][(j - n + n5) % n5];
                int n8 = 0;
                for (int k = 0; k < nArray3.length; ++k) {
                    n8 *= this.base;
                    n8 += nArray[i - 1][(j - nArray3[k] + n5) % n5];
                }
                double d = (double)this.sourceDestPastOthersCount[n2][n3][nArray4[j]][n8] / (double)this.sourcePastOthersCount[n2][nArray4[j]][n8] / ((double)this.destPastOthersCount[n3][nArray4[j]][n8] / (double)this.pastOthersCount[nArray4[j]][n8]);
                dArray[i][j] = Math.log(d) / this.log_2;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                if (this.k <= 0) continue;
                int n9 = j;
                nArray4[n9] = nArray4[n9] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n10 = j;
                nArray4[n10] = nArray4[n10] * this.base;
                int n11 = j;
                nArray4[n11] = nArray4[n11] + nArray[i][j];
            }
        }
        this.average /= (double)(n5 * (n4 - this.startObservationTime));
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int n2, int[] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, n, n2, nArray2, false);
    }

    private double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int n2, int[] nArray2, boolean bl) {
        int n3;
        int[] nArray3 = bl ? nArray2 : this.cleanAbsoluteOthers(nArray2, n, n2, this.k > 0);
        int n4 = nArray.length;
        double[] dArray = new double[n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n5 = 0;
        n5 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.base;
            n5 += nArray[n3][n2];
        }
        for (int i = this.startObservationTime; i < n4; ++i) {
            n3 = nArray[i][n2];
            int n6 = nArray[i - 1][n];
            int n7 = 0;
            for (int j = 0; j < nArray3.length; ++j) {
                n7 *= this.base;
                n7 += nArray[i - 1][nArray3[j]];
            }
            double d = (double)this.sourceDestPastOthersCount[n6][n3][n5][n7] / (double)this.sourcePastOthersCount[n6][n5][n7] / ((double)this.destPastOthersCount[n3][n5][n7] / (double)this.pastOthersCount[n5][n7]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k <= 0) continue;
            n5 -= this.maxShiftedValue[nArray[i - this.k][n2]];
            n5 *= this.base;
            n5 += nArray[i][n2];
        }
        this.average /= (double)(n4 - this.startObservationTime);
        return dArray;
    }

    public double[][] computeLocal(int[][] nArray, int n, int[] nArray2) {
        this.initialise();
        int[] nArray3 = this.cleanOffsetOthers(nArray2, n, this.k > 0);
        this.addObservations(nArray, n, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, n, nArray3, true);
    }

    public double computeAverageLocal(int[][] nArray, int n, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, n, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public double[] computeLocal(int[][] nArray, int n, int n2, int[] nArray2) {
        this.initialise();
        int[] nArray3 = this.cleanAbsoluteOthers(nArray2, n, n2, this.k > 0);
        this.addObservations(nArray, n, n2, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, n, n2, nArray3, true);
    }

    public double computeAverageLocal(int[][] nArray, int n, int n2, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, n, n2, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public static int countOfOffsetOthers(int[] nArray, int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n || nArray[i] == 0 && bl) continue;
            ++n2;
        }
        return n2;
    }

    public static int countOfAbsoluteOthers(int[] nArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n || nArray[i] == n2 && bl) continue;
            ++n3;
        }
        return n3;
    }

    public boolean confirmEnoughOffsetOthers(int[] nArray, int n, boolean bl) {
        if (ConditionalTransferEntropyCalculatorDiscrete.countOfOffsetOthers(nArray, n, bl) != this.numOtherInfoContributors) {
            throw new RuntimeException("Incorrect number of others in offsets");
        }
        return true;
    }

    public boolean confirmEnoughAbsoluteOthers(int[] nArray, int n, int n2, boolean bl) {
        if (ConditionalTransferEntropyCalculatorDiscrete.countOfAbsoluteOthers(nArray, n, n2, bl) != this.numOtherInfoContributors) {
            throw new RuntimeException("Incorrect number of others in absolutes");
        }
        return true;
    }

    public int[] cleanOffsetOthers(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[this.numOtherInfoContributors];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n || nArray[i] == 0 && bl) continue;
            if (n2 == this.numOtherInfoContributors) {
                ++n2;
                break;
            }
            nArray2[n2] = nArray[i];
            ++n2;
        }
        if (n2 < this.numOtherInfoContributors) {
            throw new RuntimeException("Too few others in offsets");
        }
        if (n2 > this.numOtherInfoContributors) {
            throw new RuntimeException("Too many others in offsets");
        }
        return nArray2;
    }

    public int[] cleanAbsoluteOthers(int[] nArray, int n, int n2, boolean bl) {
        int[] nArray2 = new int[this.numOtherInfoContributors];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n || nArray[i] == n2 && bl) continue;
            if (n3 == this.numOtherInfoContributors) {
                ++n3;
                break;
            }
            nArray2[n3] = nArray[i];
            ++n3;
        }
        if (n3 < this.numOtherInfoContributors) {
            throw new RuntimeException("Too few others in absolutes");
        }
        if (n3 > this.numOtherInfoContributors) {
            throw new RuntimeException("Too many others in absolutes");
        }
        return nArray2;
    }
}

