/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class MultiInformationCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete {
    private int[] jointCount = null;
    private int[][] marginalCounts = null;
    private int numVars;
    private int jointStates;
    private boolean checkedFirst = false;

    public MultiInformationCalculatorDiscrete(int n, int n2) {
        super(n);
        this.numVars = n2;
        this.jointStates = MathsUtils.power(n, n2);
        this.jointCount = new int[this.jointStates];
        this.marginalCounts = new int[n2][n];
    }

    @Override
    public void initialise() {
        super.initialise();
        MatrixUtils.fill(this.jointCount, 0);
        MatrixUtils.fill(this.marginalCounts, 0);
    }

    public void addObservations(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < this.numVars; ++j) {
                int n2 = nArray[(i + nArray2[j] + nArray.length) % nArray.length];
                int[] nArray3 = this.marginalCounts[j];
                int n3 = n2;
                nArray3[n3] = nArray3[n3] + 1;
                n *= this.base;
                n += n2;
            }
            int n4 = n;
            this.jointCount[n4] = this.jointCount[n4] + 1;
            ++this.observations;
        }
    }

    public void addObservations(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        for (int i = 0; i < this.numVars; ++i) {
            int n3 = nArray[(n + nArray2[i] + nArray.length) % nArray.length];
            int[] nArray3 = this.marginalCounts[i];
            int n4 = n3;
            nArray3[n4] = nArray3[n4] + 1;
            n2 *= this.base;
            n2 += n3;
        }
        int n5 = n2;
        this.jointCount[n5] = this.jointCount[n5] + 1;
        ++this.observations;
    }

    public void addObservations(int[][] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = 0;
                for (int k = 0; k < this.numVars; ++k) {
                    int n2 = nArray[i][(j + nArray2[k] + nArray.length) % nArray.length];
                    int[] nArray3 = this.marginalCounts[k];
                    int n3 = n2;
                    nArray3[n3] = nArray3[n3] + 1;
                    n *= this.base;
                    n += n2;
                }
                int n4 = n;
                this.jointCount[n4] = this.jointCount[n4] + 1;
                ++this.observations;
            }
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        int[] nArray = new int[this.numVars];
        this.checkedFirst = false;
        this.average = this.computeMiOfGivenTupleFromVarIndex(nArray, 0);
        return this.average;
    }

    public double computeMiOfGivenTupleFromVarIndex(int[] nArray, int n) {
        double d = 0.0;
        if (n == this.numVars) {
            double d2 = 1.0;
            int n2 = 0;
            for (int i = 0; i < this.numVars; ++i) {
                d2 *= (double)this.marginalCounts[i][nArray[i]] / (double)this.observations;
                n2 *= this.base;
                n2 += nArray[i];
            }
            if (this.jointCount[n2] == 0) {
                return 0.0;
            }
            double d3 = (double)this.jointCount[n2] / (double)this.observations;
            double d4 = d3 / d2;
            double d5 = Math.log(d4) / this.log_2;
            if (d3 > 0.0) {
                if (!this.checkedFirst) {
                    this.max = d5;
                    this.min = d5;
                    this.checkedFirst = true;
                } else {
                    if (d5 > this.max) {
                        this.max = d5;
                    }
                    if (d5 < this.min) {
                        this.min = d5;
                    }
                }
            }
            d = d3 * d5;
        } else {
            int n3 = 0;
            while (n3 < this.base) {
                nArray[n] = n3++;
                d += this.computeMiOfGivenTupleFromVarIndex(nArray, n + 1);
            }
        }
        return d;
    }
}

