/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class PredictiveInformationCalculatorDiscrete {
    private double average = 0.0;
    private double max = 0.0;
    private double min = 0.0;
    private int observations = 0;
    private int k = 0;
    private int numDiscreteValues = 0;
    private int[][] jointCount = null;
    private int[] prevCount = null;
    private int[] nextCount = null;
    private int[] maxShiftedValue = null;
    private int base_power_k = 0;
    private double log_base = 0.0;

    public static PredictiveInformationCalculatorDiscrete newInstance(int n, int n2) {
        return new PredictiveInformationCalculatorDiscrete(n, n2);
    }

    public PredictiveInformationCalculatorDiscrete(int n, int n2) {
        this.numDiscreteValues = n;
        this.k = n2;
        this.base_power_k = MathsUtils.power(n, this.k);
        this.log_base = Math.log(n);
        if (n2 < 1) {
            throw new RuntimeException("History k " + n2 + " is not >= 1 for Predictive information calculator");
        }
        if ((double)this.k > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and history combination too large");
        }
        this.jointCount = new int[this.base_power_k][this.base_power_k];
        this.prevCount = new int[this.base_power_k];
        this.nextCount = new int[this.base_power_k];
        this.maxShiftedValue = new int[n];
        for (int i = 0; i < n; ++i) {
            this.maxShiftedValue[i] = i * MathsUtils.power(n, this.k - 1);
        }
    }

    public void initialise() {
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        this.observations = 0;
        MatrixUtils.fill(this.jointCount, 0);
        MatrixUtils.fill(this.prevCount, 0);
        MatrixUtils.fill(this.nextCount, 0);
    }

    public void addObservations(int[] nArray) {
        int n;
        int n2 = nArray.length;
        if (n2 - this.k - (this.k - 1) <= 0) {
            return;
        }
        this.observations += n2 - this.k - (this.k - 1);
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.k; ++n) {
            n3 *= this.numDiscreteValues;
            n3 += nArray[n];
            n4 *= this.numDiscreteValues;
            n4 += nArray[this.k - 1 + n];
        }
        for (n = this.k; n < n2 - (this.k - 1); ++n) {
            n4 -= this.maxShiftedValue[nArray[n - 1]];
            n4 *= this.numDiscreteValues;
            int[] nArray2 = this.jointCount[n4 += nArray[this.k - 1 + n]];
            int n5 = n3;
            nArray2[n5] = nArray2[n5] + 1;
            int n6 = n3;
            this.prevCount[n6] = this.prevCount[n6] + 1;
            int n7 = n4;
            this.nextCount[n7] = this.nextCount[n7] + 1;
            n3 -= this.maxShiftedValue[nArray[n - this.k]];
            n3 *= this.numDiscreteValues;
            n3 += nArray[n];
        }
    }

    public void addObservations(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        if (n3 - this.k - (this.k - 1) <= 0) {
            return;
        }
        this.observations += (n3 - this.k - (this.k - 1)) * n4;
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = 0;
            nArray3[n2] = 0;
            for (n = 0; n < this.k; ++n) {
                int n5 = n2;
                nArray2[n5] = nArray2[n5] * this.numDiscreteValues;
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + nArray[n][n2];
                int n7 = n2;
                nArray3[n7] = nArray3[n7] * this.numDiscreteValues;
                int n8 = n2;
                nArray3[n8] = nArray3[n8] + nArray[this.k - 1 + n][n2];
            }
        }
        for (n2 = this.k; n2 < n3 - (this.k - 1); ++n2) {
            for (n = 0; n < n4; ++n) {
                int n9 = n;
                nArray3[n9] = nArray3[n9] - this.maxShiftedValue[nArray[n2 - 1][n]];
                int n10 = n;
                nArray3[n10] = nArray3[n10] * this.numDiscreteValues;
                int n11 = n;
                nArray3[n11] = nArray3[n11] + nArray[this.k - 1 + n2][n];
                int[] nArray4 = this.jointCount[nArray3[n]];
                int n12 = nArray2[n];
                nArray4[n12] = nArray4[n12] + 1;
                int n13 = nArray2[n];
                this.prevCount[n13] = this.prevCount[n13] + 1;
                int n14 = nArray3[n];
                this.nextCount[n14] = this.nextCount[n14] + 1;
                int n15 = n;
                nArray2[n15] = nArray2[n15] - this.maxShiftedValue[nArray[n2 - this.k][n]];
                int n16 = n;
                nArray2[n16] = nArray2[n16] * this.numDiscreteValues;
                int n17 = n;
                nArray2[n17] = nArray2[n17] + nArray[n2][n];
            }
        }
    }

    public void addObservations(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        if (n4 - this.k - (this.k - 1) <= 0) {
            return;
        }
        int n5 = nArray[0].length;
        if (n5 == 0) {
            return;
        }
        int n6 = nArray[0][0].length;
        this.observations += (n4 - this.k - (this.k - 1)) * n5 * n6;
        int[][] nArray2 = new int[n5][n6];
        int[][] nArray3 = new int[n5][n6];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                nArray2[n3][n2] = 0;
                nArray3[n3][n2] = 0;
                for (n = 0; n < this.k; ++n) {
                    int[] nArray4 = nArray2[n3];
                    int n7 = n2;
                    nArray4[n7] = nArray4[n7] * this.numDiscreteValues;
                    int[] nArray5 = nArray2[n3];
                    int n8 = n2;
                    nArray5[n8] = nArray5[n8] + nArray[n][n3][n2];
                    int[] nArray6 = nArray3[n3];
                    int n9 = n2;
                    nArray6[n9] = nArray6[n9] * this.numDiscreteValues;
                    int[] nArray7 = nArray3[n3];
                    int n10 = n2;
                    nArray7[n10] = nArray7[n10] + nArray[this.k - 1 + n][n3][n2];
                }
            }
        }
        for (n3 = this.k; n3 < n4 - (this.k - 1); ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    int[] nArray8 = nArray3[n2];
                    int n11 = n;
                    nArray8[n11] = nArray8[n11] - this.maxShiftedValue[nArray[n3 - 1][n2][n]];
                    int[] nArray9 = nArray3[n2];
                    int n12 = n;
                    nArray9[n12] = nArray9[n12] * this.numDiscreteValues;
                    int[] nArray10 = nArray3[n2];
                    int n13 = n;
                    nArray10[n13] = nArray10[n13] + nArray[this.k - 1 + n3][n2][n];
                    int[] nArray11 = this.jointCount[nArray3[n2][n]];
                    int n14 = nArray2[n2][n];
                    nArray11[n14] = nArray11[n14] + 1;
                    int n15 = nArray2[n2][n];
                    this.prevCount[n15] = this.prevCount[n15] + 1;
                    int n16 = nArray3[n2][n];
                    this.nextCount[n16] = this.nextCount[n16] + 1;
                    int[] nArray12 = nArray2[n2];
                    int n17 = n;
                    nArray12[n17] = nArray12[n17] - this.maxShiftedValue[nArray[n3 - this.k][n2][n]];
                    int[] nArray13 = nArray2[n2];
                    int n18 = n;
                    nArray13[n18] = nArray13[n18] * this.numDiscreteValues;
                    int[] nArray14 = nArray2[n2];
                    int n19 = n;
                    nArray14[n19] = nArray14[n19] + nArray[n3][n2][n];
                }
            }
        }
    }

    public void addObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        if (n3 - this.k - (this.k - 1) <= 0) {
            return;
        }
        this.observations += n3 - this.k - (this.k - 1);
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.numDiscreteValues;
            n4 += nArray[n2][n];
            n5 *= this.numDiscreteValues;
            n5 += nArray[this.k - 1 + n2][n];
        }
        for (n2 = this.k; n2 < n3 - (this.k - 1); ++n2) {
            n5 -= this.maxShiftedValue[nArray[n2 - 1][n]];
            n5 *= this.numDiscreteValues;
            int[] nArray2 = this.jointCount[n5 += nArray[this.k - 1 + n2][n]];
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n4;
            this.prevCount[n7] = this.prevCount[n7] + 1;
            int n8 = n5;
            this.nextCount[n8] = this.nextCount[n8] + 1;
            n4 -= this.maxShiftedValue[nArray[n2 - this.k][n]];
            n4 *= this.numDiscreteValues;
            n4 += nArray[n2][n];
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        if (n4 - this.k - (this.k - 1) <= 0) {
            return;
        }
        this.observations += n4 - this.k - (this.k - 1);
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.numDiscreteValues;
            n5 += nArray[n3][n][n2];
            n6 *= this.numDiscreteValues;
            n6 += nArray[this.k - 1 + n3][n][n2];
        }
        for (n3 = this.k; n3 < n4 - (this.k - 1); ++n3) {
            n6 -= this.maxShiftedValue[nArray[n3 - 1][n][n2]];
            n6 *= this.numDiscreteValues;
            int[] nArray2 = this.jointCount[n6 += nArray[this.k - 1 + n3][n][n2]];
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
            int n8 = n5;
            this.prevCount[n8] = this.prevCount[n8] + 1;
            int n9 = n6;
            this.nextCount[n9] = this.nextCount[n9] + 1;
            n5 -= this.maxShiftedValue[nArray[n3 - this.k][n][n2]];
            n5 *= this.numDiscreteValues;
            n5 += nArray[n3][n][n2];
        }
    }

    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < this.base_power_k; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                double d4 = (double)this.prevCount[j] / (double)this.observations;
                double d5 = (double)this.jointCount[i][j] / (double)this.observations;
                if (d5 > 0.0) {
                    double d6 = d5 / (d3 * d4);
                    double d7 = Math.log(d6) / this.log_base;
                    d2 = d5 * d7;
                    if (d7 > this.max) {
                        this.max = d7;
                    } else if (d7 < this.min) {
                        this.min = d7;
                    }
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        this.average = d;
        return d;
    }

    public double computeLocalFromPreviousObservations(int n, int n2) {
        double d = (double)this.jointCount[n][n2] / ((double)this.nextCount[n] * (double)this.prevCount[n2]);
        return Math.log(d *= (double)this.observations) / this.log_base;
    }

    public double[] computeLocalFromPreviousObservations(int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        if (n < this.k + (this.k - 1)) {
            return dArray;
        }
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.k; ++i) {
            n2 *= this.numDiscreteValues;
            n2 += nArray[i];
            n3 *= this.numDiscreteValues;
            n3 += nArray[this.k - 1 + i];
        }
        double d = 0.0;
        for (int i = this.k; i < n - (this.k - 1); ++i) {
            n3 -= this.maxShiftedValue[nArray[i - 1]];
            n3 *= this.numDiscreteValues;
            d = (double)this.jointCount[n3 += nArray[this.k - 1 + i]][n2] / ((double)this.nextCount[n3] * (double)this.prevCount[n2]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n2 -= this.maxShiftedValue[nArray[i - this.k]];
            n2 *= this.numDiscreteValues;
            n2 += nArray[i];
        }
        this.average /= (double)(n - this.k - (this.k - 1));
        return dArray;
    }

    public double[][] computeLocalFromPreviousObservations(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        double[][] dArray = new double[n][n2];
        if (n < this.k + (this.k - 1)) {
            return dArray;
        }
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = 0;
            nArray3[i] = 0;
            for (int j = 0; j < this.k; ++j) {
                int n3 = i;
                nArray2[n3] = nArray2[n3] * this.numDiscreteValues;
                int n4 = i;
                nArray2[n4] = nArray2[n4] + nArray[j][i];
                int n5 = i;
                nArray3[n5] = nArray3[n5] * this.numDiscreteValues;
                int n6 = i;
                nArray3[n6] = nArray3[n6] + nArray[this.k - 1 + j][i];
            }
        }
        double d = 0.0;
        for (int i = this.k; i < n - (this.k - 1); ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7 = j;
                nArray3[n7] = nArray3[n7] - this.maxShiftedValue[nArray[i - 1][j]];
                int n8 = j;
                nArray3[n8] = nArray3[n8] * this.numDiscreteValues;
                int n9 = j;
                nArray3[n9] = nArray3[n9] + nArray[this.k - 1 + i][j];
                d = (double)this.jointCount[nArray3[j]][nArray2[j]] / ((double)this.nextCount[nArray3[j]] * (double)this.prevCount[nArray2[j]]);
                dArray[i][j] = Math.log(d *= (double)this.observations) / this.log_base;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                int n10 = j;
                nArray2[n10] = nArray2[n10] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n11 = j;
                nArray2[n11] = nArray2[n11] * this.numDiscreteValues;
                int n12 = j;
                nArray2[n12] = nArray2[n12] + nArray[i][j];
            }
        }
        this.average /= (double)(n2 * (n - this.k - (this.k - 1)));
        return dArray;
    }

    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = nArray[0][0].length;
        double[][][] dArray = new double[n2][n3][n4];
        if (n2 < this.k + (this.k - 1)) {
            return dArray;
        }
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][] nArray2 = new int[n3][n4];
        int[][] nArray3 = new int[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray2[i][j] = 0;
                nArray3[i][j] = 0;
                for (n = 0; n < this.k; ++n) {
                    int[] nArray4 = nArray2[i];
                    int n5 = j;
                    nArray4[n5] = nArray4[n5] * this.numDiscreteValues;
                    int[] nArray5 = nArray2[i];
                    int n6 = j;
                    nArray5[n6] = nArray5[n6] + nArray[n][i][j];
                    int[] nArray6 = nArray3[i];
                    int n7 = j;
                    nArray6[n7] = nArray6[n7] * this.numDiscreteValues;
                    int[] nArray7 = nArray3[i];
                    int n8 = j;
                    nArray7[n8] = nArray7[n8] + nArray[this.k - 1 + n][i][j];
                }
            }
        }
        double d = 0.0;
        for (n = this.k; n < n2 - (this.k - 1); ++n) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int[] nArray8 = nArray3[i];
                    int n9 = j;
                    nArray8[n9] = nArray8[n9] - this.maxShiftedValue[nArray[n - 1][i][j]];
                    int[] nArray9 = nArray3[i];
                    int n10 = j;
                    nArray9[n10] = nArray9[n10] * this.numDiscreteValues;
                    int[] nArray10 = nArray3[i];
                    int n11 = j;
                    nArray10[n11] = nArray10[n11] + nArray[this.k - 1 + n][i][j];
                    d = (double)this.jointCount[nArray3[i][j]][nArray2[i][j]] / ((double)this.nextCount[nArray3[i][j]] * (double)this.prevCount[nArray2[i][j]]);
                    dArray[n][i][j] = Math.log(d *= (double)this.observations) / this.log_base;
                    this.average += dArray[n][i][j];
                    if (dArray[n][i][j] > this.max) {
                        this.max = dArray[n][i][j];
                    } else if (dArray[n][i][j] < this.min) {
                        this.min = dArray[n][i][j];
                    }
                    int[] nArray11 = nArray2[i];
                    int n12 = j;
                    nArray11[n12] = nArray11[n12] - this.maxShiftedValue[nArray[n - this.k][i][j]];
                    int[] nArray12 = nArray2[i];
                    int n13 = j;
                    nArray12[n13] = nArray12[n13] * this.numDiscreteValues;
                    int[] nArray13 = nArray2[i];
                    int n14 = j;
                    nArray13[n14] = nArray13[n14] + nArray[n][i][j];
                }
            }
        }
        this.average /= (double)(n3 * n4 * (n2 - this.k - (this.k - 1)));
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        if (n2 < this.k + (this.k - 1)) {
            return dArray;
        }
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.k; ++i) {
            n3 *= this.numDiscreteValues;
            n3 += nArray[i][n];
            n4 *= this.numDiscreteValues;
            n4 += nArray[this.k - 1 + i][n];
        }
        double d = 0.0;
        for (int i = this.k; i < n2 - (this.k - 1); ++i) {
            n4 -= this.maxShiftedValue[nArray[i - 1][n]];
            n4 *= this.numDiscreteValues;
            d = (double)this.jointCount[n4 += nArray[this.k - 1 + i][n]][n3] / ((double)this.nextCount[n4] * (double)this.prevCount[n3]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n3 -= this.maxShiftedValue[nArray[i - this.k][n]];
            n3 *= this.numDiscreteValues;
            n3 += nArray[i][n];
        }
        this.average /= (double)(n2 - this.k - (this.k - 1));
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        if (n3 < this.k + (this.k - 1)) {
            return dArray;
        }
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.k; ++i) {
            n4 *= this.numDiscreteValues;
            n4 += nArray[i][n][n2];
            n5 *= this.numDiscreteValues;
            n5 += nArray[this.k - 1 + i][n][n2];
        }
        double d = 0.0;
        for (int i = this.k; i < n3 - (this.k - 1); ++i) {
            n5 -= this.maxShiftedValue[nArray[i - 1][n][n2]];
            n5 *= this.numDiscreteValues;
            d = (double)this.jointCount[n5 += nArray[this.k - 1 + i][n][n2]][n4] / ((double)this.nextCount[n5] * (double)this.prevCount[n4]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n4 -= this.maxShiftedValue[nArray[i - this.k][n][n2]];
            n4 *= this.numDiscreteValues;
            n4 += nArray[i][n][n2];
        }
        this.average /= (double)(n3 - this.k - (this.k - 1));
        return dArray;
    }

    public double[] computeLocal(int[] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    public double[][] computeLocal(int[][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    public double[][][] computeLocal(int[][][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    public double computeAverageLocal(int[] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    public double[] computeLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeLocalFromPreviousObservations(nArray, n);
    }

    public double[] computeLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    public double computeAverageLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }

    public double getLastAverage() {
        return this.average;
    }

    public double getLastMax() {
        return this.max;
    }

    public double getLastMin() {
        return this.min;
    }

    public void writePdfs() {
        double d = 0.0;
        double d2 = 0.0;
        System.out.println("nextVal p(next) prevVal p(prev) p(joint) logTerm localVal");
        for (int i = 0; i < this.base_power_k; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                double d4 = (double)this.prevCount[j] / (double)this.observations;
                double d5 = (double)this.jointCount[i][j] / (double)this.observations;
                if (d5 > 0.0) {
                    double d6 = d5 / (d3 * d4);
                    double d7 = Math.log(d6) / this.log_base;
                    d2 = d5 * d7;
                    System.out.println(String.format("%7d    %.2f %7d    %.2f     %.2f    %.2f     %.2f", i, d3, j, d4, d5, d6, d7));
                } else {
                    d2 = 0.0;
                    System.out.println(String.format("%7d    %.2f %7d    %.2f     %.2f    %.2f     %.2f", i, d3, j, d4, d5, 0.0, 0.0));
                }
                d += d2;
            }
        }
        System.out.println("Average is " + d);
    }

    public int computePastValue(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < this.k; ++i) {
            n2 *= this.numDiscreteValues;
            n2 += nArray[n - this.k + 1 + i];
        }
        return n2;
    }

    public int computePastValue(int[][] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.k; ++i) {
            n3 *= this.numDiscreteValues;
            n3 += nArray[n2 - this.k + 1 + i][n];
        }
        return n3;
    }

    public int computePastValue(int[][][] nArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.k; ++i) {
            n4 *= this.numDiscreteValues;
            n4 += nArray[n3 - this.k + 1 + i][n][n2];
        }
        return n4;
    }
}

