/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.mixed.symbolic;

import infodynamics.measures.discrete.MutualInformationCalculatorDiscrete;
import infodynamics.measures.mixed.MutualInfoCalculatorMultiVariateWithDiscrete;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Arrays;

public class MutualInfoCalculatorMultiVariateWithDiscreteSymbolic
implements MutualInfoCalculatorMultiVariateWithDiscrete {
    protected MutualInformationCalculatorDiscrete miCalc;
    protected int dimensions;
    protected int[][] permutations;
    protected int[] permutationIds;
    protected int[] idToPermutationIndex;
    protected static final int VAL_COLUMN = 0;
    protected static final int VAR_NUM_COLUMN = 1;
    public static final String PROP_NORMALISE = "NORMALISE";
    private boolean normalise = true;

    @Override
    public void initialise(int n, int n2) throws Exception {
        int n3;
        this.dimensions = n;
        RandomGenerator randomGenerator = new RandomGenerator();
        this.permutations = randomGenerator.generateAllDistinctPerturbations(n);
        this.permutationIds = new int[this.permutations.length];
        for (n3 = 0; n3 < this.permutations.length; ++n3) {
            this.permutationIds[n3] = this.generatePermutationId(this.permutations[n3]);
        }
        this.idToPermutationIndex = new int[MathsUtils.power(n, n)];
        for (n3 = 0; n3 < this.idToPermutationIndex.length; ++n3) {
            this.idToPermutationIndex[n3] = -1;
        }
        for (n3 = 0; n3 < this.permutationIds.length; ++n3) {
            this.idToPermutationIndex[this.permutationIds[n3]] = n3;
        }
        n3 = Math.max(this.permutationIds.length, n2);
        this.miCalc = new MutualInformationCalculatorDiscrete(n3, 0);
        this.miCalc.initialise();
    }

    private int generatePermutationId(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            n *= this.dimensions;
            n += nArray[i];
        }
        return n;
    }

    private int generatePermutationId(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            n *= this.dimensions;
            n += (int)dArray[i];
        }
        return n;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals(PROP_NORMALISE)) {
            this.normalise = Boolean.parseBoolean(string2);
        }
    }

    @Override
    public void setObservations(double[][] dArray, int[] nArray) throws Exception {
        if (this.normalise) {
            dArray = MatrixUtils.normaliseIntoNewArray(dArray);
        }
        int[] nArray2 = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[][] dArray2 = new double[this.dimensions][2];
            for (int j = 0; j < this.dimensions; ++j) {
                dArray2[j][0] = dArray[i][j];
                dArray2[j][1] = j;
            }
            Arrays.sort(dArray2, FirstIndexComparatorDouble.getInstance());
            double[] dArray3 = MatrixUtils.selectColumn(dArray2, 1);
            int n = this.generatePermutationId(dArray3);
            nArray2[i] = this.idToPermutationIndex[n];
        }
        this.miCalc.addObservations(nArray2, nArray);
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        return this.miCalc.computeAverageLocalOfObservations();
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, int[] nArray) throws Exception {
        throw new Exception("Local method not implemented yet");
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        return this.miCalc.computeSignificance(n);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        return this.miCalc.computeSignificance(nArray);
    }

    @Override
    public void setDebug(boolean bl) {
    }

    @Override
    public double getLastAverage() {
        return this.miCalc.getLastAverage();
    }

    @Override
    public int getNumObservations() {
        return this.miCalc.getNumObservations();
    }
}

