/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public class ParsedProperties {
    private Properties properties;

    public ParsedProperties() {
        this.properties = new Properties();
    }

    public ParsedProperties(Properties properties) {
        this.properties = properties;
    }

    public ParsedProperties(String string) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(string));
        this.properties = properties;
    }

    public int getIntProperty(String string) throws Exception {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Property " + string + " not found");
        }
        return Integer.parseInt(string2);
    }

    public long getLongProperty(String string) throws Exception {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Property " + string + " not found");
        }
        return Long.parseLong(string2);
    }

    public double getDoubleProperty(String string) throws Exception {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Property " + string + " not found");
        }
        return Double.parseDouble(string2);
    }

    public boolean getBooleanProperty(String string) throws Exception {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Property " + string + " not found");
        }
        return Boolean.parseBoolean(string2);
    }

    public int[] getIntArrayProperty(String string) {
        String string2 = this.properties.getProperty(string);
        return ParsedProperties.parseStringArrayOfInts(string2);
    }

    public static int[] parseStringArrayOfInts(String string) {
        int[] nArray;
        if (string.indexOf(58) >= 0) {
            String[] stringArray = string.split(":");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n + i;
            }
        } else {
            String[] stringArray = string.split(",");
            nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        return nArray;
    }

    public String getStringProperty(String string) throws Exception {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new Exception("Property " + string + " not found");
        }
        return string2;
    }

    public String[] getStringArrayProperty(String string) {
        String string2 = this.properties.getProperty(string);
        String[] stringArray = string2.split(",");
        return stringArray;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public Set<Object> keySet() {
        return this.properties.keySet();
    }

    public void writeToFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.properties.store(fileOutputStream, string2);
    }

    public boolean containsProperty(String string) {
        return this.properties.containsKey(string);
    }
}

