function usage() {
    echo ""
    echo "########### Build Script for ARGOS #########"
    echo
    echo "Author: Lenka Pitonakova - contact@lenkaspace.net"
    echo " "
    echo "Usage: ./build.sh -c"
    echo "  Compiles the whole set of files"
    echo "  The output files will be placed in the "$BUILD" directory."
    echo " "
    echo "Additionally, you can use these options: "
    echo "  -r path: Run the experiment with ARGoS 3 simulator"
    echo "  -e: Build into 'buildExec' folder instead of 'build' folder"
    echo " "
    echo "Examples:"
    echo "  ./build.sh -c"
    echo "  ./build.sh -r experiments/test.argos"
    echo
    echo "###########################################"
    echo ""
}

function runCmake() {
    echo ""
    echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Running cmake.."
    if [ -d $BUILD ]; then
        rm -rf $BUILD
    fi
    mkdir $BUILD
    cd $BUILD
    cmake ..
    cd ../
}

function compile() {
    echo ""
    echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Compiling ..."


    #-- compile and build
    cd $BUILD
    make
    cd ../

}

function run() {
    echo $EXPERIMENT_PATH
    argos3 -c $EXPERIMENT_PATH
}

function performDeploy() {
    echo
    echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Deploying to ${REMOTE_LOCATION}"
    scp -r cmake $REMOTE_LOCATION
    scp -r controllers $REMOTE_LOCATION
    scp -r entities $REMOTE_LOCATION
    scp -r embedding $REMOTE_LOCATION
    scp experiments/*.argos $REMOTE_LOCATION/experiments
    scp -r loop_functions $REMOTE_LOCATION
    scp build.sh $REMOTE_LOCATION
    scp CMakeLists.txt $REMOTE_LOCATION
    scp *.sh $REMOTE_LOCATION
    scp *.pbs $REMOTE_LOCATION
}

function deploy() {
    performDeploy;
    REMOTE_LOCATION="lp2g12@iridis4_a.soton.ac.uk:/scratch/lp2g12/beeForaging";
    performDeploy;
}





declare COMPILE RUN HELP BUILD EXPERIMENT_PATH RUN_CMAKE DEPLOY REMOTE_LOCATION
declare -a files

REMOTE_LOCATION="lp2g12@iridis4_a.soton.ac.uk:beeForaging"

RUN=0
HELP=1
COMPILE=0
BUILD="build"
RUN_CMAKE=0
DEPLOY=0
RUN_PATH=""

#-- check if help should be displayed
while getopts "hr:cmed" name
do
    case $name in
        e)
        BUILD="buildExec"
        HELP=0;;
        h)
        HELP=1;;
        c)
        COMPILE=1
        HELP=0;;
        m)
        RUN_CMAKE=1
        HELP=0;;
        r)
        RUN=1
        HELP=0;
        RUN_PATH="$OPTARG";;
        d)
        DEPLOY=1
        HELP=0;;

        \?) echo "!!! Invalid option: -"$OPTARG"" >&2
        exit 1;;
        : ) echo "!!! Option -"$OPTARG" requires an argument." >&2
        exit 1;;

    esac
done

#echo $RUN_PATH;

if [ $HELP -eq 1 ]; then
    usage;
    exit 1;
fi

#-- compile
if [ $RUN_CMAKE -eq 1 ]; then
    runCmake
fi
if [ $COMPILE -eq 1 ]; then
    compile
fi

#-- deploy
if [ $DEPLOY -eq 1 ]; then
    deploy
fi

#-- exit if not running
if [ $RUN -eq 0 ]; then
    exit 1;
fi

EXPERIMENT_PATH="${RUN_PATH}"
run
