function prepareDirectory() {
    if [ -d $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY ]; then
        echo ""
    else
        mkdir $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY;
    fi
}

function prepareArgosFile() {
    OUTPUT_FILE_NAME_PREFIX="$MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/Run$RUN_NO";

    sed -e "s^\[OUTPUT_FILE_NAME_PREFIX\]^$OUTPUT_FILE_NAME_PREFIX^g;\
    s^\[MAX_INTERACTION_TIME\]^$MAX_INTERACTION_TIME^g;\
    s^\[SCOUT_PROB\]^$SCOUT_PROB^g;\
    s^\[RESTING_PROB\]^$RESTING_PROB^g;\
    s^\[WAKING_PROB\]^$WAKING_PROB^g;\
    s^\[DEPOSIT_MIN_DISTANCE_FROM_BASE\]^$DEPOSIT_MIN_DISTANCE_FROM_BASE^g;\
    s^\[PELLET_DISAPPEAR_RATE\]^$PELLET_DISAPPEAR_RATE^g;\
    s^\[NUM_OF_ROBOTS\]^$NUM_OF_ROBOTS^g;\
    s^\[RUN_LENGTH\]^$RUN_LENGTH^g;\
    s^\[NUM_OF_DEPOSITS\]^$NUM_OF_DEPOSITS^g;\
    s^\[DEPOSIT_HEIGHT\]^$DEPOSIT_HEIGHT^g;\
    s^\[DEPOSIT_MASS\]^$DEPOSIT_MASS^g;\
    s^\[MAX_SCOUT_TIME\]^$MAX_SCOUT_TIME^g;\
    s^\[WHEELS_NOIZE\]^$WHEELS_NOIZE^g;\
    s^\[STEERING_SENSOR_NOIZE\]^$STEERING_SENSOR_NOIZE^g;\
    s^\[DEPOSIT_MAX_DISTANCE_FROM_BASE\]^$DEPOSIT_MAX_DISTANCE_FROM_BASE^g;\
    s^\[NUM_OF_GROUPS\]^$NUM_OF_GROUPS^g;\
    s^\[GROUP_1_QUALITY\]^$GROUP_1_QUALITY^g;\
    s^\[GROUP_2_QUALITY\]^$GROUP_2_QUALITY^g;\
    s^\[GROUP_3_QUALITY\]^$GROUP_3_QUALITY^g;\
    s^\[GROUP_4_QUALITY\]^$GROUP_4_QUALITY^g;\
    s^\[DEPOSIT_DISAPPEAR_RATE\]^$DEPOSIT_DISAPPEAR_RATE^g;\
    s^\[DEPOSIT_RENEWABILITY_THRESHOLD\]^$DEPOSIT_RENEWABILITY_THRESHOLD^g;\
    s^\[EXECUTABLE_EXTENSION\]^$EXECUTABLE_EXTENSION^g;\
    s^\[IS_ON_IRIDIS\]^$IS_ON_IRIDIS^g;\
    s^\[USE_MODEL_B\]^$USE_MODEL_B^g;\
    s^\[MAX_UNLOAD_TIME\]^$MAX_UNLOAD_TIME^g;\
    s^\[STOP_SIGNAL_PROB_TD\]^$STOP_SIGNAL_PROB_TD^g;\
    s^\[STOP_SIGNAL_PROB_NON_TD\]^$STOP_SIGNAL_PROB_NON_TD^g;\
    s^\[UNLOAD_TIME_THRESHOLD\]^$UNLOAD_TIME_THRESHOLD^g;\
    s^\[TREMBLE_SIGNAL_DISTANCE\]^$TREMBLE_SIGNAL_DISTANCE^g;\
    s^\[EVENLY_SPACED_DEPOSITS\]^$EVENLY_SPACED_DEPOSITS^g;\
    s^\[USE_MODEL_C\]^$USE_MODEL_C^g;\
    s^\[SAMPLING_ENCOUTERS_TIME\]^$SAMPLING_ENCOUTERS_TIME^g;\
    s^\[MAX_ENCOUNTERS\]^$MAX_ENCOUNTERS^g;\
    s^\[ENCOUNTER_SIGNAL_DISTANCE\]^$ENCOUNTER_SIGNAL_DISTANCE^g;\
    s^\[RANGE_AND_BEARING_SENSOR_NOIZE\]^$RANGE_AND_BEARING_SENSOR_NOIZE^g;\
    s^\[DEPOSIT_APPEAR_RATE\]^$DEPOSIT_APPEAR_RATE^g;\
    s^\[RANDOM_SEED\]^$RANDOM_SEED^g;\
    s^\[USE_MODEL_D\]^$USE_MODEL_D^g;\
    s^\[BEGGING_SIGNAL_DISTANCE\]^$BEGGING_SIGNAL_DISTANCE^g;\
    s^\[DEPOSIT_GRADIENT_RADIUS\]^$DEPOSIT_GRADIENT_RADIUS^g;\
    s^\[DEPOSIT_RADIUS\]^$DEPOSIT_RADIUS^g;\
    s^\[WAKE_SIGNAL_TIME_MULTIPLIER\]^$WAKE_SIGNAL_TIME_MULTIPLIER^g;\
    s^\[DOES_REL_EE\]^$DOES_REL_EE^g;\
    s^\[QUALITY_CHANGE_RATE\]^$QUALITY_CHANGE_RATE^g;\
    s^\[SEARCH_RADIUS\]^$SEARCH_RADIUS^g;\
    s^\[SEARCH_TIME\]^$SEARCH_TIME^g;\
    s^\[CART_CAPACITY\]^$CART_CAPACITY^g;\
    s^\[UNLOAD_PER_PELLET\]^$UNLOAD_PER_PELLET^g;\
    s^\[MIN_REACTIVATION_PROB\]^$MIN_REACTIVATION_PROB^g;\
    s^\[MAX_REACTIVATION_PROB\]^$MAX_REACTIVATION_PROB^g;\
    s^\[MIN_OBSERVER_TIME\]^$MIN_OBSERVER_TIME^g;\
    s^\[WAGGLE_SIGNAL_DISTANCE\]^$WAGGLE_SIGNAL_DISTANCE^g;\
    s^\[BEGGING_PROB\]^$BEGGING_PROB^g;\
    s^\[RESTING_BAY_RADIUS\]^$RESTING_BAY_RADIUS^g;\
    s^\[DANCE_FLOOR_MIDDLE_RADIUS\]^$DANCE_FLOOR_MIDDLE_RADIUS^g;\

s^\[INFINITE_DEPOSITS\]^$INFINITE_DEPOSITS^g;\
s^\[USE_MODEL_B_NON_SOCIAL\]^$USE_MODEL_B_NON_SOCIAL^g;\
    " \
    experiments/$ARGOS_FILE_NAME > $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos
}


function runExperiment20() {
    prepareDirectory;
    for RUN_NO in `seq 0 19`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute 10 at a time
            if [ $RUN_NO -eq 9 ] || [ $RUN_NO -eq 19 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 3 ] || [ $RUN_NO -eq 7 ] || [ $RUN_NO -eq 11 ] || [ $RUN_NO -eq 15 ] || [ $RUN_NO -eq 19 ] ; then
                wait
            fi

        fi
    done
}

function runExperiment50() {
    prepareDirectory;
    for RUN_NO in `seq 0 49`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute up to 16 at a time
            if [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 49 ] ; then
#if [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 49 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 5 at a time
            if [ $RUN_NO -eq 4 ] || [ $RUN_NO -eq 9 ] || [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 19 ] || [ $RUN_NO -eq 24 ] || [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 34 ] || [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 44 ] || [ $RUN_NO -eq 49 ]; then
                wait
            fi

        fi
    done
}

function runExperiment50b() {
    prepareDirectory;
    for RUN_NO in `seq 50 99`;
    do
        prepareArgosFile;
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- run the experiment in the background
            echo "----- $OUTPUT_FILE_NAME_PREFIX";
            argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

            #-- iridis can execute up to 16 at a time, but execute slightly more for balance
            if [ $RUN_NO -eq 66 ] || [ $RUN_NO -eq 82 ] || [ $RUN_NO -eq 99 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment100() {
    prepareDirectory;
    for RUN_NO in `seq 0 99`;
    do
        prepareArgosFile;
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- run the experiment in the background
            echo "----- $OUTPUT_FILE_NAME_PREFIX";
            argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

            #-- iridis can execute up to 16 at a time, but execute slightly more for balance
            if [ $RUN_NO -eq 16 ] || [ $RUN_NO -eq 33 ] || [ $RUN_NO -eq 48 ] || [ $RUN_NO -eq 66 ] || [ $RUN_NO -eq 82 ] || [ $RUN_NO -eq 99 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment100nonRand() {
    prepareDirectory;
    for RUN_NO in `seq 0 99`;
    do
        RANDOM_SEED=1${RUN_NO}00
        prepareArgosFile;
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- run the experiment in the background
            echo "----- $OUTPUT_FILE_NAME_PREFIX";
            argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

            #-- iridis can execute up to 16 at a time, but execute slightly more for balance
            if [ $RUN_NO -eq 16 ] || [ $RUN_NO -eq 33 ] || [ $RUN_NO -eq 48 ] || [ $RUN_NO -eq 66 ] || [ $RUN_NO -eq 82 ] || [ $RUN_NO -eq 99 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment30() {
    prepareDirectory;

    for RUN_NO in `seq 0 29`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute up to 16 at a time
            if [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 29 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 29 ] ; then
                wait
            fi

        fi
    done
}

function runExperiment30b() {
    prepareDirectory;

    for RUN_NO in `seq 30 49`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute up to 16 at a time
            if [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 49 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 49 ] ; then
                wait
            fi

        fi
    done
}

function runExperiment10() {
    prepareDirectory;

    for RUN_NO in `seq 0 9`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute 10 at a time
            if [ $RUN_NO -eq 9 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 5 at a time
            if [ $RUN_NO -eq 5 ] || [ $RUN_NO -eq 9 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment10b() {
    prepareDirectory;

    for RUN_NO in `seq 10 19`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute 10 at a time
            if [ $RUN_NO -eq 19 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 12 ] || [ $RUN_NO -eq 15 ] || [ $RUN_NO -eq 19 ] ; then
                wait
            fi
        fi
    done
}

function setupEnvironment() {
#--------- group 2: normal
    if [ $ENVIRONMENT_ID -eq 1 ]; then
        ENVIRONMENT_NAME="group2-8E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 2 ]; then
        ENVIRONMENT_NAME="group2-10E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 3 ]; then
        ENVIRONMENT_NAME="group2-12E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 4 ]; then
        ENVIRONMENT_NAME="group2-14E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 5 ]; then
        ENVIRONMENT_NAME="group2-16E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";

#--------- group 4: normal
    elif [ $ENVIRONMENT_ID -eq 6 ]; then
        ENVIRONMENT_NAME="group4-8E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 7 ]; then
        ENVIRONMENT_NAME="group4-10E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 8 ]; then
        ENVIRONMENT_NAME="group4-12E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 9 ]; then
        ENVIRONMENT_NAME="group4-14E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 10 ]; then
        ENVIRONMENT_NAME="group4-16E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";

#--------- group 2: qualities 0.5, 1.5
    elif [ $ENVIRONMENT_ID -eq 11 ]; then
        ENVIRONMENT_NAME="group2_05|15-8E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
    elif [ $ENVIRONMENT_ID -eq 12 ]; then
        ENVIRONMENT_NAME="group2_05|15-10E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
    elif [ $ENVIRONMENT_ID -eq 13 ]; then
        ENVIRONMENT_NAME="group2_05|15-12E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
    elif [ $ENVIRONMENT_ID -eq 14 ]; then
        ENVIRONMENT_NAME="group2_05|15-14E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
    elif [ $ENVIRONMENT_ID -eq 15 ]; then
        ENVIRONMENT_NAME="group2_05|15-16E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;

#--------- group 2: qualities 0.1, 1.9
    elif [ $ENVIRONMENT_ID -eq 16 ]; then
        ENVIRONMENT_NAME="group2_01|19-8E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.1;
        GROUP_2_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 17 ]; then
        ENVIRONMENT_NAME="group2_01|19-10E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.1;
        GROUP_2_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 18 ]; then
        ENVIRONMENT_NAME="group2_01|19-12E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.1;
        GROUP_2_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 19 ]; then
        ENVIRONMENT_NAME="group2_01|19-14E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.1;
        GROUP_2_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 20 ]; then
        ENVIRONMENT_NAME="group2_01|19-16E";
        NUM_OF_DEPOSITS=2;
        DEPOSIT_HEIGHT=50;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.1;
        GROUP_2_QUALITY=1.9;

#--------- group 4: qualities 0.5, 1.5, 0.1, 1.9
    elif [ $ENVIRONMENT_ID -eq 21 ]; then
        ENVIRONMENT_NAME="group4_05|15|01|19-8E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
        GROUP_3_QUALITY=0.1;
        GROUP_4_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 22 ]; then
        ENVIRONMENT_NAME="group4_05|15|01|19-10E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
        GROUP_3_QUALITY=0.1;
        GROUP_4_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 23 ]; then
        ENVIRONMENT_NAME="group4_05|15|01|19-12E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
        GROUP_3_QUALITY=0.1;
        GROUP_4_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 24 ]; then
        ENVIRONMENT_NAME="group4_05|15|01|19-14E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
        GROUP_3_QUALITY=0.1;
        GROUP_4_QUALITY=1.9;
    elif [ $ENVIRONMENT_ID -eq 25 ]; then
        ENVIRONMENT_NAME="group4_05|15|01|19-16E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.5;
        GROUP_2_QUALITY=1.5;
        GROUP_3_QUALITY=0.1;
        GROUP_4_QUALITY=1.9;

#--------- group 4: qualities 0.5, 0.5, 0.5, 2.5
    elif [ $ENVIRONMENT_ID -eq 26 ]; then
        ENVIRONMENT_NAME="group4_05|05|05|25-8E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.500001;
        GROUP_2_QUALITY=0.499999;
        GROUP_3_QUALITY=0.5;
        GROUP_4_QUALITY=2.5;
    elif [ $ENVIRONMENT_ID -eq 27 ]; then
        ENVIRONMENT_NAME="group4_05|05|05|25-10E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.500001;
        GROUP_2_QUALITY=0.499999;
        GROUP_3_QUALITY=0.5;
        GROUP_4_QUALITY=2.5;
    elif [ $ENVIRONMENT_ID -eq 28 ]; then
        ENVIRONMENT_NAME="group4_05|05|05|25-12E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.500001;
        GROUP_2_QUALITY=0.499999;
        GROUP_3_QUALITY=0.5;
        GROUP_4_QUALITY=2.5;
    elif [ $ENVIRONMENT_ID -eq 29 ]; then
        ENVIRONMENT_NAME="group4_05|05|05|25-14E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.500001;
        GROUP_2_QUALITY=0.499999;
        GROUP_3_QUALITY=0.5;
        GROUP_4_QUALITY=2.5;
    elif [ $ENVIRONMENT_ID -eq 30 ]; then
        ENVIRONMENT_NAME="group4_05|05|05|25-16E";
        NUM_OF_DEPOSITS=4;
        DEPOSIT_HEIGHT=25;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";
        GROUP_1_QUALITY=0.500001;
        GROUP_2_QUALITY=0.499999;
        GROUP_3_QUALITY=0.5;
        GROUP_4_QUALITY=2.5;

#--------- group 1: normal
    elif [ $ENVIRONMENT_ID -eq 31 ]; then
        ENVIRONMENT_NAME="group1-8E";
        NUM_OF_DEPOSITS=1;
        DEPOSIT_HEIGHT=100;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=8;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 32 ]; then
        ENVIRONMENT_NAME="group1-10E";
        NUM_OF_DEPOSITS=1;
        DEPOSIT_HEIGHT=100;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=10;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 33 ]; then
        ENVIRONMENT_NAME="group1-12E";
        NUM_OF_DEPOSITS=1;
        DEPOSIT_HEIGHT=100;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=12;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 34 ]; then
        ENVIRONMENT_NAME="group1-14E";
        NUM_OF_DEPOSITS=1;
        DEPOSIT_HEIGHT=100;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=14;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_DEPOSITS="true";
    elif [ $ENVIRONMENT_ID -eq 35 ]; then
        ENVIRONMENT_NAME="group1-16E";
        NUM_OF_DEPOSITS=1;
        DEPOSIT_HEIGHT=100;
        DEPOSIT_GRADIENT_RADIUS=3.0;
        DEPOSIT_RADIUS=0.5;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=16;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_DEPOSITS="true";


#--------- rand 25: normal
    elif [ $ENVIRONMENT_ID -eq 36 ]; then
        ENVIRONMENT_NAME="rand25-8";
        NUM_OF_DEPOSITS=25;
        DEPOSIT_HEIGHT=4;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=3;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=13;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 37 ]; then
        ENVIRONMENT_NAME="rand25-10";
        NUM_OF_DEPOSITS=25;
        DEPOSIT_HEIGHT=4;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=5;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=15;
        EVENLY_SPACED_DEPOSITS="false";
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
    elif [ $ENVIRONMENT_ID -eq 38 ]; then
        ENVIRONMENT_NAME="rand25-12";
        NUM_OF_DEPOSITS=25;
        DEPOSIT_HEIGHT=4;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=7;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=17;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 39 ]; then
        ENVIRONMENT_NAME="rand25-14";
        NUM_OF_DEPOSITS=25;
        DEPOSIT_HEIGHT=4;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=9;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=19;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 40 ]; then
        ENVIRONMENT_NAME="rand25-16";
        NUM_OF_DEPOSITS=25;
        DEPOSIT_HEIGHT=4;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=11;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=21;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";

#--------- rand 100: normal
    elif [ $ENVIRONMENT_ID -eq 41 ]; then
        ENVIRONMENT_NAME="rand100-8";
        NUM_OF_DEPOSITS=100;
        DEPOSIT_HEIGHT=1;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=3;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=13;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 42 ]; then
        ENVIRONMENT_NAME="rand100-10";
        NUM_OF_DEPOSITS=100;
        DEPOSIT_HEIGHT=1;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=5;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=15;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 43 ]; then
        ENVIRONMENT_NAME="rand100-12";
        NUM_OF_DEPOSITS=100;
        DEPOSIT_HEIGHT=1;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=7;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=17;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 44 ]; then
        ENVIRONMENT_NAME="rand100-14";
        NUM_OF_DEPOSITS=100;
        DEPOSIT_HEIGHT=1;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=9;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=19;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 45 ]; then
        ENVIRONMENT_NAME="rand100-16";
        NUM_OF_DEPOSITS=100;
        DEPOSIT_HEIGHT=1;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=11;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=21;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";

#--------- rand 10: normal
    elif [ $ENVIRONMENT_ID -eq 46 ]; then
        ENVIRONMENT_NAME="rand10-8";
        NUM_OF_DEPOSITS=10;
        DEPOSIT_HEIGHT=10;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=3;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=13;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 47 ]; then
        ENVIRONMENT_NAME="rand10-10";
        NUM_OF_DEPOSITS=10;
        DEPOSIT_HEIGHT=10;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=5;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=15;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 48 ]; then
        ENVIRONMENT_NAME="rand10-12";
        NUM_OF_DEPOSITS=10;
        DEPOSIT_HEIGHT=10;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=7;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=17;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 49 ]; then
        ENVIRONMENT_NAME="rand10-14";
        NUM_OF_DEPOSITS=10;
        DEPOSIT_HEIGHT=10;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=9;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=19;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    elif [ $ENVIRONMENT_ID -eq 50 ]; then
        ENVIRONMENT_NAME="rand10-16";
        NUM_OF_DEPOSITS=10;
        DEPOSIT_HEIGHT=10;
        DEPOSIT_MIN_DISTANCE_FROM_BASE=11;
        DEPOSIT_MAX_DISTANCE_FROM_BASE=21;
        DEPOSIT_GRADIENT_RADIUS=1.0;
        DEPOSIT_RADIUS=0.1;
        EVENLY_SPACED_DEPOSITS="false";
    fi
}

#==========================================================

declare OUTPUT_FILE_NAME_PREFIX MAIN_DIRECTORY EXPERIMENT_DIRECTORY RUN_NO MAX_INTERACTION_TIME SCOUT_PROB RESTING_PROB WAKING_PROB DEPOSIT_MIN_DISTANCE_FROM_BASE PELLET_DISAPPEAR_RATE NUM_OF_ROBOTS RUN_LENGTH NUM_OF_DEPOSITS DEPOSIT_HEIGHT DEPOSIT_MASS RUN_NO WHEELS_NOIZE STEERING_SENSOR_NOIZE DEPOSIT_MAX_DISTANCE_FROM_BASE NUM_OF_GROUPS GROUP_1_QUALITY GROUP_2_QUALITY GROUP_3_QUALITY GROUP_4_QUALITY ARGOS_FILE_NAME MAX_SCOUT_TIME EXECUTABLE_EXTENSION IS_ON_IRIDIS ENVIRONMENTS GROUP_SIZE DEPOSIT_RENEWABILITY_THRESHOLD DEPOSIT_DISAPPEAR_RATE MAX_UNLOAD_TIME STOP_SIGNAL_PROB_TD STOP_SIGNAL_PROB_NON_TD UNLOAD_TIME_THRESHOLD TREMBLE_SIGNAL_DISTANCE USE_MODEL_B EVENLY_SPACED_DEPOSITS USE_MODEL_C SAMPLING_ENCOUTERS_TIME MAX_ENCOUNTERS ENCOUNTER_SIGNAL_DISTANCE RANGE_AND_BEARING_SENSOR_NOIZE DEPOSIT_APPEAR_RATE RANDOM_SEED BEGGING_SIGNAL_DISTANCE USE_MODEL_D DEPOSIT_GRADIENT_RADIUS DEPOSIT_RADIUS WAKE_SIGNAL_TIME_MULTIPLIER DOES_REL_EE QUALITY_CHANGE_RATE SEARCH_RADIUS SEARCH_TIME UNLOAD_PER_PELLET CART_CAPACITY MIN_REACTIVATION_PROB MIN_OBSERVER_TIME MAX_REACTIVATION_PROB WAGGLE_SIGNAL_DISTANCE BEGGING_PROB RESTING_BAY_RADIUS DANCE_FLOOR_MIDDLE_RADIUS INFINITE_DEPOSITS USE_MODEL_B_NON_SOCIAL;

MAIN_DIRECTORY="experiments/test";
ARGOS_FILE_NAME="experiment.argos";
EXECUTABLE_EXTENSION="dylib";
RANDOM_SEED=0;

#-- default values
RESTING_BAY_RADIUS=0.85;
DANCE_FLOOR_MIDDLE_RADIUS=1.02;
#RESTING_BAY_RADIUS=0.0;
#DANCE_FLOOR_MIDDLE_RADIUS=0.51;

INFINITE_DEPOSITS="false";


DOES_REL_EE="false";
RUN_LENGTH=3600;
PELLET_DISAPPEAR_RATE=1;
NUM_OF_ROBOTS=25;
NUM_OF_GROUPS=0;
GROUP_SIZE=0;
GROUP_1_QUALITY=1.0;
GROUP_2_QUALITY=1.0;
GROUP_3_QUALITY=1.0;
GROUP_4_QUALITY=1.0;
DEPOSIT_MAX_DISTANCE_FROM_BASE=0;
DEPOSIT_RENEWABILITY_THRESHOLD=-1;
DEPOSIT_DISAPPEAR_RATE=0;
DEPOSIT_APPEAR_RATE=0;
QUALITY_CHANGE_RATE=0;
EVENLY_SPACED_DEPOSITS="false"
DEPOSIT_GRADIENT_RADIUS=1.0;
DEPOSIT_RADIUS=0.1;
DEPOSIT_MASS=100001.0;
SEARCH_TIME=1800;
SEARCH_RADIUS=2;
CART_CAPACITY=1;
UNLOAD_PER_PELLET=0.25;

WAGGLE_SIGNAL_DISTANCE=60;

SCOUT_PROB=0.001;
MAX_SCOUT_TIME=6000;

MAX_INTERACTION_TIME=1200
MIN_OBSERVER_TIME=0

RESTING_PROB=0
WAKING_PROB=0

MIN_REACTIVATION_PROB=0.0
MAX_REACTIVATION_PROB=1.0

WHEELS_NOIZE=0.4;
STEERING_SENSOR_NOIZE=0;
RANGE_AND_BEARING_SENSOR_NOIZE=0;

ENVIRONMENTS=();
IS_ON_IRIDIS=0;

#-- model B
USE_MODEL_B="false";
TREMBLE_SIGNAL_DISTANCE=90;
MAX_UNLOAD_TIME=800;
UNLOAD_TIME_THRESHOLD=0.5;
STOP_SIGNAL_PROB_TD=0.0;
STOP_SIGNAL_PROB_NON_TD=0.0;

#-- model B non social
USE_MODEL_B_NON_SOCIAL="false";

#-- model C
USE_MODEL_C="false";
ENCOUNTER_SIGNAL_DISTANCE=100;
SAMPLING_ENCOUTERS_TIME=100;
MAX_ENCOUNTERS=0;
WAKE_SIGNAL_TIME_MULTIPLIER=0.5;

#-- model D
USE_MODEL_D="false";
BEGGING_SIGNAL_DISTANCE=60;
BEGGING_PROB=1.0;

#-- check the parameters
eval set -- $(getopt -n $0 -o "-i:" -- "$@")
while [ $# -gt 0 ] ; do
    case "$1" in
        -i) IS_ON_IRIDIS=1 ; shift ;;
        --) shift ;;
        -*) echo "bad option '$1'" ; exit 1 ;;
        *) ENVIRONMENTS=("${ENVIRONMENTS[@]}" "$1") ; shift ;;
    esac
done


#-- decide on extension, linux compiles .so files, but mac does .dylib
if [ $IS_ON_IRIDIS -eq 1 ]; then
    EXECUTABLE_EXTENSION='so';
fi


