#ifndef FORAGING_LOOP_FUNCTIONS_H
#define FORAGING_LOOP_FUNCTIONS_H

#include <argos3/core/simulator/loop_functions.h>
#include <argos3/core/simulator/entity/floor_entity.h>
#include <argos3/core/utility/math/range.h>
#include <argos3/core/utility/math/rng.h>
#include <argos3/plugins/simulator/entities/cylinder_entity.h>
#include <controllers/footbot_foraging/footbot_foraging.h>
#include <argos3/plugins/simulator/entities/box_entity.h>

using namespace argos;

class CForagingLoopFunctions : public CLoopFunctions {

#define PREDEFINED_DEPOSIT_POSITIONS_MULTIPLIER 1.5
#define GROUP_SIZE 5

public:

   CForagingLoopFunctions();
   virtual ~CForagingLoopFunctions() {}

   virtual void Init(TConfigurationNode& t_tree);
   virtual void Reset();
   virtual void Destroy();
   virtual CColor GetFloorColor(const CVector2& c_position_on_plane);
   virtual void PreStep();

   void OnNewRun();
   CCylinderEntity* GetDepositByPosition(CVector3 position_);
   int GetDepositIdByPosition(CVector3 position_, Real maxDistance_);
   int GetDepositIdByPosition(CVector3 position_);
   CCylinderEntity* GetDepositById(const int& id_);
   CFootBotForaging& GetRobotById(const int& id_);

   CVector2 generateDepositPosition(CCylinderEntity& deposit_,uint groupId_);
   CVector2 generateDepositPositionAroundGroupMiddle(CCylinderEntity& deposit_, CVector2 groupMiddlePosition_);
   Real generateGroupMass(uint groupId_);

private:

   struct DepositInfo {
	   DepositInfo(CVector2 position_, uint groupId_) {
		   position = CVector2(position_);
		   groupId = groupId_;
		   isActive = true;
	   }
	   CVector2 position;
	   uint groupId;
	   bool isActive;
   };

   Real depositGradientRadius; //size of gradient around the food item
   Real depositRadius;
   Real arenaSize;
   Real depositMinDistanceFromBase;
   Real resourceCollected;
   uint pelletDisappearRate;
   uint depositDisappearRate; //rate at which a random deposit / group disappears and appears somewhere else fully replenished
   Real depositRenewabilityThreshold; //% of deposit volume at which it disappears and renews somewhere else
   uint depositAppearRate; //rate at which a new deposit/group is added into the environment on top of the existing ones
   uint qualityChangeRate; // rate and which deposit volumes are replenished and quality is reassigned

   int timeTillNextPelletDissapears;
   int timeTillNextDepositDisappears;
   int timeTillNextDepositAppears;
   int timeTillQualityReassigned;

   //UInt32 numOfDeposits;

   CRange<Real> m_cForagingArenaSideX, m_cForagingArenaSideY;
   std::vector<CVector2> preSpecifiedDepositPositions;
   std::vector<DepositInfo> depositData;


   CFloorEntity* floor;
   CRandom::CRNG* randNumGenerator;

   std::string outputFileNamePrefix;
   std::ofstream outputFileGlobal;
   std::ofstream outputFileRobots;
   std::ofstream outputFileLoadEvents;
   std::ofstream outputFileScoutingEvents;
   std::ofstream outputFileWaggleDanceEvents;
   std::ofstream outputFileUnloadEvents;
   std::ofstream outputFileNeighbSearchEvents;
   std::ofstream outputFileDepositRenewEvents;

   std::vector<CBoxEntity*> pellets;
   std::vector<UInt8> pelletIdsInUnloadingBay;

   Real numOfRobots;
   uint numOfScouts;
   uint numOfForagers;
   uint numOfWaggleDancers;
   uint numOfObservers;
   uint numOfResters;
   uint numOfUnloaders;
   uint numOfTrembleDancers;
   uint numOfEncounterSamplers;
   uint numOfShakers;
   uint numOfDepositSamplers;
   uint numOfLadenForagers;
   uint numOfLoaders;
   uint numOfScoutLoaders;
   uint numOfLadenScouts;
   uint numOfUnsuccessfulForagers;

   uint numOfGroups;
   uint numOfDeposits;
   uint numOfPredefinedLocations;
   Real group1Quality;
   Real group2Quality;
   Real group3Quality;
   Real group4Quality;
   Real depositMaxDistanceFromBase;
   Real originalDepositHeight;
   bool evenlySpacedDeposits;
   bool infiniteDeposits;

   Real restingBayRadius;
   Real danceFloorMiddleRadius;




};

#endif
