#include "foraging_qt_user_functions.h"
#include <controllers/footbot_foraging/footbot_foraging.h>
#include <argos3/core/simulator/entity/controllable_entity.h>

using namespace argos;

/****************************************/
/****************************************/

CForagingQTUserFunctions::CForagingQTUserFunctions() {
   RegisterUserFunction<CForagingQTUserFunctions,CFootBotEntity>(&CForagingQTUserFunctions::Draw);
}

/****************************************/
/****************************************/

void CForagingQTUserFunctions::Draw(CFootBotEntity& c_entity) {
	CFootBotForaging& footBot = dynamic_cast<CFootBotForaging&>(c_entity.GetControllableEntity().GetController());
	//-- draw base odomerty location
	DrawCylinder(0.05f, 0.05f, CVector3(-footBot.GetRelativeBaseLocation().GetX(), -footBot.GetRelativeBaseLocation().GetY(), 0.1f), CColor::CYAN);
	DrawSegment(CVector3(-footBot.GetRelativeBaseLocation().GetX(), -footBot.GetRelativeBaseLocation().GetY(), 0.1f),
	    		CVector3::ZERO,
	    		CColor::CYAN);
	//LOGERR << -footBot.GetRelativeBaseLocation().GetX() << " | " << -footBot.GetRelativeBaseLocation().GetY() << std::endl;
	//-- draw target deposit odometry location
	CFootBotForaging::Deposit dep = footBot.GetTargetDeposit();
    if (!dep.isNull) {
    	DrawCylinder(0.05f, 0.05f, CVector3(-dep.relLocation.GetX(), -dep.relLocation.GetY(), 0.1f), CColor::RED);
    	DrawSegment(CVector3(-dep.relLocation.GetX(), -dep.relLocation.GetY(), 0.1f),
    	    		CVector3::ZERO,
    	    		CColor::RED);
    }



}

/****************************************/
/****************************************/

REGISTER_QTOPENGL_USER_FUNCTIONS(CForagingQTUserFunctions, "foraging_qt_user_functions")
