import helpers;
import numpy;
import constants;
import crGraphs;
import crData;
import matplotlib.colors as mcolors;
import scipy.stats;
from math import ceil;

import matplotlib.pyplot as plt;
import math;

def compareWithA(chosenParamString_, scenarios, scenarioLabels_, NR_, fP_, fD_, 
                 chosenParamStringModelA_, modelADir_, chosenParamStringModelB_, modelBDir_,
                 EXPERIMENT_DIR, IMAGE_OUTPUT_DIR,
            DO_RES_COLLECTED,DO_RES_COLLECTED_OVER_TIME,DO_RES_COLLECTED_PER_ROBOT,DO_RES_COLLECTED_DIFF,DO_RES_COLLECTED_PER_LOAD,
            DO_LOAD_EVENTS_RECRUITMENT,DO_SCOUT_EVENTS_SUCCESS,
            DO_NEIGHB_SEARCH_SUCESS,DO_ROBOT_STATES,DO_PELLETS, DO_LOAD_EVENT_GROUPS, DO_UNLOAD_TIME, DO_ENERGY_SPENT, DO_RES_ENERGY_COST,
            DO_LOAD_EVENTS,DO_LOAD_EVENT_GROUPS_OVER_TIME,DO_TIME_OF_FIRST_LOADS,DO_UNLOAD_TIME_OVER_TIME,DO_TIME_BETWEEN_LOAD_UNLOAD,DO_RES_COLLECTED_ENERGY_CAPPED,
            DO_INFO_TRANSFER,
            DO_COMPARISON_WITH_B,
            maxResCollected_, maxResEnergyCost_=-999999, energyCapPerRobot_=5000, scenarioTypes_=['group5','group10','group20','group50'],distances_=[8,10,12,14],xLabel_="",size_=(12,6),
            resValueMultipliers_=[], examinedModelLabel_ = "examined model", modelALabel_="basic model", modelBLabel_="tremble dancing", timeInterval_=3600, startTime_=1,
            afterParamNameStr_="",afterParamNameStrModelA_="",afterParamNameStrModelB_=""):
    
    FD_FILENAME_STR="fP" + str(fP_) + "_fD" + str(fD_) + "_";
    if (fD_ == "-"):
        if (fP_ == "-"):
            FD_FILENAME_STR = "";
        else:
            FD_FILENAME_STR="fP" + str(fP_) + "_";
        fD_=0;
        
    IMAGE_OUTPUT_DIR += "_NR" + str(NR_);
    
    if (len(chosenParamString_) > 0):
        chosenParamString_ = "_" + chosenParamString_;
        
    if (DO_COMPARISON_WITH_B):
        legendLabels = [examinedModelLabel_,modelBLabel_,modelALabel_];
        markers = ['gs-','bs-','rs-'];
        plainMarkers = ['g-','b-','r-'];
        scatterMarkers = ['g.','b.','r.'];
        boxPlotMarkers = ['gs','bs','rs'];
    else:
        legendLabels = [examinedModelLabel_,modelALabel_];
        markers = ['gs-','rs-'];
        plainMarkers = ['g-','r-'];
        scatterMarkers = ['g.','r.'];
        boxPlotMarkers = ['gs','rs'];
        
    resComparisonData = [];
    energyComparisonData = [];
    loadEvNcomparisonData = [];
    if (DO_RES_ENERGY_COST or DO_RES_COLLECTED_PER_LOAD):
        DO_RES_COLLECTED = True;
    if (DO_RES_ENERGY_COST): 
        DO_ENERGY_SPENT = True;
    if (DO_RES_COLLECTED_DIFF):
        DO_RES_COLLECTED = True;
    
    time = range(constants.MAX_TIME);  
    if (DO_PELLETS):
        #-- specific pellets over time graph
        for sc in range(len(scenarios)):
            #-- comparison in 1 scenario, over time
            data = helpers.getPelletsForParameter("", [FD_FILENAME_STR +"NR" + str(NR_) + chosenParamString_], [scenarios[sc]], EXPERIMENT_DIR);    
            dataNoTD = helpers.getPelletsForParameter(chosenParamStringModelA_, [""], [scenarios[sc]], modelADir_);
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonPelOverTime_" + chosenParamString_ + "_" + scenarios[sc] + ".png";
            crGraphs.createPlot(time, [data[0][0],dataNoTD[0][0]], "Time", "Pellets",markers_=plainMarkers, legendLabels_=legendLabels, fileName_=fileName,size_=size_);
            
        
    #=======================================================================
    #     pelComparisonData = [[],[]];
    #     pel = helpers.getPelletsForParameter(FD_FILENAME_STR+"NR" + str(NR_) + "_muO" + str(CHOSEN_MU) + "_O", [CHOSEN_O], scenarios, EXPERIMENT_DIR);
    #     #pelNoTD = helpers.getPelletsForParameter("NR" + str(NR_) + "_FP", [FP], scenarios, "A3"); 
    #     pelNoTD = pel;
    #     for sc in range(len(pel)):
    #         pelComparisonData[0].append(pel[sc][0]);
    #         pelComparisonData[1].append(pelNoTD[sc][0]);
    #     
    #     #print(len(pel));
    #     fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonPel_muO" + str(CHOSEN_MU) + "_O" + str(CHOSEN_O) + ".png";
    #     crGraphs.createPlot(range(len(scenarios)), pelComparisonData, "", "Pellets", legendLabels, xTickLabels_=scenarios, boxPlots_=True, fileName_=fileName);
    # 
    #=======================================================================
    if (DO_RES_COLLECTED_OVER_TIME):
        for sc in range(len(scenarios)):
            #-- comparison in 1 scenario, over time
            data = helpers.getResourceCollectedForParameter(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], [scenarios[sc]], EXPERIMENT_DIR,valueMultipliers_=resValueMultipliers_);
            dataNoTD = helpers.getResourceCollectedForParameter(chosenParamStringModelA_, [""], [scenarios[sc]], modelADir_,valueMultipliers_=resValueMultipliers_); 
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonResOverTime_" + chosenParamString_ + "_" + scenarios[sc] + ".png";
            crGraphs.createPlot(time, [data[1][0][0],dataNoTD[1][0][0]], "Time", "% Resource collected",markers_=plainMarkers, legendLabels_=legendLabels, fileName_=fileName,size_=size_,yLimMin_=0, yLimMax_=100);
    
    #============= DO_RES_COLLECTED       
    if (DO_RES_COLLECTED):
        for x in range(startTime_,constants.MAX_TIME,timeInterval_):
            startTime = x;
            endTime = x+timeInterval_;
            #-- comparison accross scenarios
            data = helpers.getResourceCollectedForParameter(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,valueMultipliers_=resValueMultipliers_, endRow_=endTime, startTime_=startTime,afterParamNameStr_=afterParamNameStr_);
            dataNoTD = helpers.getResourceCollectedForParameter(chosenParamStringModelA_, [""], scenarios, modelADir_,valueMultipliers_=resValueMultipliers_,endRow_=endTime,startTime_=startTime,afterParamNameStr_=afterParamNameStrModelA_);

            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_resVS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_T" + str(startTime) + "-" + str(endTime) +  ".png";
            if (DO_COMPARISON_WITH_B):
                comparisonData = [[],[],[]];
                dataTD = helpers.getResourceCollectedForParameter(chosenParamStringModelB_, [""], scenarios, modelBDir_,valueMultipliers_=resValueMultipliers_);
                for sc in range(len(data[0])):
                    comparisonData[0].append(data[0][sc][0]);
                    comparisonData[1].append(dataTD[0][sc][0]);
                    comparisonData[2].append(dataNoTD[0][sc][0]);
            else:
                comparisonData = [[],[]];
                for sc in range(len(data[0])):
                    comparisonData[0].append(data[0][sc][0]);
                    comparisonData[1].append(dataNoTD[0][sc][0]);
            resComparisonData = comparisonData;
            crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "% Resource collected", legendLabels, markers_=markers, xTickLabels_=scenarioLabels_, boxPlots_=True, fileName_=fileName,yLimMin_=0, yLimMax_=maxResCollected_,size_=size_,doWilcoxon_=True);

            #============= DO_RES_COLLECTED_DIFF
            if (DO_RES_COLLECTED_DIFF):
                #-- get data of by how much percentage is examined model better than Model A (diff = Model C / Model A)
                #   any number > 1 means more resource was collected by examined model

                matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
                annodationData = [["" for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];

                for d in range(len(distances_)):
                    for sc in range(len(scenarioTypes_)):
                        comparisonDataIndex = d*len(scenarioTypes_) + sc;
                        #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                        print("Calculating res collected diff for " + scenarios[comparisonDataIndex]);
                        matrixData[d][sc] = (crData.getMedian(resComparisonData[0][comparisonDataIndex]) / crData.getMedian(resComparisonData[len(resComparisonData)-1][comparisonDataIndex]) - 1 )*100;
                        #annodationData[d][sc] = str(ceil(matrixData[d][sc] * 100) / 100.0) + "%";
                        annodationData[d][sc] = str(int(round(matrixData[d][sc]))) + "%";
                        #-- perform wilcoxon test
                        pVal = scipy.stats.wilcoxon(resComparisonData[0][comparisonDataIndex],resComparisonData[len(resComparisonData)-1][comparisonDataIndex])[1];
                        print("  p=" + str(pVal));
                        if (pVal < 0.01):
                            annodationData[d][sc] += "**";
                        elif (pVal < 0.05):
                            annodationData[d][sc] += "*";



                        #print(str(crData.getMedian(resComparisonData[0][comparisonDataIndex])) + "  / " + str(crData.getMedian(resComparisonData[len(resComparisonData)-1][comparisonDataIndex])) + "   = " + str(matrixData[d][sc]));

                #-- create custom color map
                levs = range(100)
                cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                    colors =[(0.45, 0.45, 1),
                        (0.7, 1, 0.9),
                        (1, 1, 1),
                        (1, 0.9, 0.7),
                        (1, 0.45, 0.45),],
                    N=len(levs)-1,
                )
                valRangeMin=-50;
                valRangeMax=50;

                levs = range(100)
                cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                      colors =[
                          (1, 1., 1),
                          (1, 0.9, 0.7),
                          (1, 0.45, 0.45),],
                      N=len(levs)-1,
                )
                valRangeMin=0;
                valRangeMax=100;



                fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_resDiff_" + chosenParamString_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ +  "_T" + str(startTime) + "-" + str(endTime) + ".png";
                crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,annotationFontSize_='21',colorMap_=cmap,vmin_=valRangeMin,vmax_=valRangeMax,fileName_=fileName,annotationValues_=annodationData,annotateValues_=True);

    #============= DO_LOAD_EVENTS_RECRUITMENT   
    if (DO_LOAD_EVENTS_RECRUITMENT):
        data = helpers.getLoadEventsRecruitment(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,afterParamNameStr_=afterParamNameStr_);
        dataNoTD = helpers.getLoadEventsRecruitment(chosenParamStringModelA_, [""], scenarios, modelADir_,afterParamNameStr_=afterParamNameStrModelA_);
        
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonRec_" + chosenParamString_ + afterParamNameStr_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + ".png";
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getLoadEventsRecruitment(chosenParamStringModelB_, [""], scenarios, modelBDir_);
            for sc in range(len(dataNoTD)):
               comparisonData[0].append(data[sc][0]);
               comparisonData[1].append(dataTD[sc][0]);
               comparisonData[2].append(dataNoTD[sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(dataNoTD)):
                comparisonData[0].append(data[sc][0]);
                comparisonData[1].append(dataNoTD[sc][0]);
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "% due to recruitment", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=1,size_=size_,doWilcoxon_=True);

        #-- get data of by how much percentage is examined model better than Model A (diff = Model C / Model A)
        #   any number > 1 means more resource was collected by examined model

        matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        for d in range(len(distances_)):
            for sc in range(len(scenarioTypes_)):
                comparisonDataIndex = d*len(scenarioTypes_) + sc;
                #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                print("Calculating recruitment diff for " + scenarios[comparisonDataIndex]);
                if (crData.getMedian(comparisonData[len(comparisonData)-1][comparisonDataIndex]) != 0):
                    matrixData[d][sc] = (crData.getMedian(comparisonData[0][comparisonDataIndex]) / crData.getMedian(comparisonData[len(comparisonData)-1][comparisonDataIndex]) - 1 )*100;
                else:
                    matrixData[d][sc] = 0;
                #print(str(crData.getMedian(resComparisonData[0][comparisonDataIndex])) + "  / " + str(crData.getMedian(resComparisonData[len(resComparisonData)-1][comparisonDataIndex])) + "   = " + str(matrixData[d][sc]));
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_ler_" + chosenParamString_ + afterParamNameStr_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + ".png";
        crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=plt.cm.get_cmap("bwr"),vmin_=-50,vmax_=50,fileName_=fileName,annotateValues_=True,annotationStringAfter_="%");


    #============= DO_SCOUT_EVENTS_SUCCESS
    if (DO_SCOUT_EVENTS_SUCCESS):
        data = helpers.getScoutingEvents(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR);
        dataNoTD = helpers.getScoutingEvents(chosenParamStringModelA_, [""], scenarios, modelADir_); 
        
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_ses_" + chosenParamString_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ +  ".png";
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getScoutingEvents(chosenParamStringModelB_, [""], scenarios, modelBDir_);
            for sc in range(len(dataNoTD)):
                comparisonData[0].append(data[sc][0]);
                comparisonData[1].append(dataTD[sc][0]);
                comparisonData[2].append(dataNoTD[sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(dataNoTD)):
                comparisonData[0].append(data[sc][0]);
                comparisonData[1].append(dataNoTD[sc][0]);
                
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "% successful scouts", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=1,size_=size_,doWilcoxon_=True);
    
    #============= DO_UNLOAD_TIME 
    if (DO_UNLOAD_TIME or DO_UNLOAD_TIME_OVER_TIME):
        data = helpers.getUnloadTime(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,onlyAboveValue_=200,afterParamNameStr_=afterParamNameStr_);
        dataNoTD = helpers.getUnloadTime(chosenParamStringModelA_, [""], scenarios, modelADir_,onlyAboveValue_=200,afterParamNameStr_=afterParamNameStrModelA_);
        
        if (DO_UNLOAD_TIME):
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_unlT_" + chosenParamString_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ +  ".png";
            if (DO_COMPARISON_WITH_B):
                comparisonData = [[],[],[]];
                dataTD = helpers.getUnloadTime(chosenParamStringModelB_, [""], scenarios, modelBDir_,onlyAboveValue_=200);
                for sc in range(len(dataNoTD[0])):
                    comparisonData[0].append((data[0][sc][0]));
                    comparisonData[1].append((dataTD[0][sc][0]));
                    comparisonData[2].append((dataNoTD[0][sc][0]));
            else:
                comparisonData = [[],[]];
                for sc in range(len(dataNoTD[0])):
                    comparisonData[0].append((data[0][sc][0]));
                    comparisonData[1].append((dataNoTD[0][sc][0]));
            
            crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "Unload time", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_);
        
        if (DO_UNLOAD_TIME_OVER_TIME):
            for sc in range(len(scenarios)):
                fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_unlToverT_" + chosenParamString_ + afterParamNameStr_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ +  "_" + scenarios[sc] + ".png";
                crGraphs.createPlot(time, [data[1][sc][0],dataNoTD[1][sc][0]], "Time", "Unload time",markers_=scatterMarkers,lineStyle_ = "", legendLabels_=legendLabels, fileName_=fileName,size_=size_,doWilcoxon_=True);
        
    
    #============= DO_ENERGY_SPENT
    if (DO_ENERGY_SPENT):
        data = helpers.getEnergySpent(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_, [''], scenarios, EXPERIMENT_DIR,NR_);
        dataNoTD = helpers.getEnergySpent(chosenParamStringModelA_ + afterParamNameStrModelA_, [""], scenarios, modelADir_,NR_);
        
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getEnergySpent(chosenParamStringModelB_, [""], scenarios, modelBDir_,NR_);
            for sc in range(len(dataNoTD)):
                comparisonData[0].append(data[sc][0]);
                comparisonData[1].append(dataTD[sc][0]);
                comparisonData[2].append(dataNoTD[sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(dataNoTD)):
                comparisonData[0].append(data[sc][0]);
                comparisonData[1].append(dataNoTD[sc][0]);
        energyComparisonData = comparisonData;
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_EVS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_T" + str(startTime) + "-" + str(endTime) +  ".png";

        maxE = 4000;
        if (constants.MAX_TIME > 3600):
            maxE = 8000;
        if (constants.MAX_TIME > 7200):
            maxE = 16000;
            
        #maxE = 40000;
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "Energy spent per robot", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=maxE,size_=size_,doWilcoxon_=True);
    
    #============= DO_RES_ENERGY_COST
    if (DO_RES_ENERGY_COST):
        #-- divide each energy spent data point by how much resource was collected 
        for i in range(len(resComparisonData)):
            for sc in range(len(resComparisonData[i])):
                for run in range(len(resComparisonData[i][sc])):
                    if (resComparisonData[i][sc][run] == 0):
                        energyComparisonData[i][sc][run] = 0;
                    else:
                        #energyComparisonData[i][sc][run] /= resComparisonData[i][sc][run]; # resource energy cost , i.e. C=E/R
                        energyComparisonData[i][sc][run] = resComparisonData[i][sc][run] / energyComparisonData[i][sc][run]; #energy efficiency, i.e. C=R/E

        #-- create custom color map
        levs = range(100)
        cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
            colors =[(0.45, 0.45, 1),
                (0.7, 1, 0.9),
                (1, 1, 1),
                (1, 0.9, 0.7),
                (1, 0.45, 0.45),],
            N=len(levs)-1,
        )


        #-- plot models separately by color
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonResECostVS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_T" + str(startTime) + "-" + str(endTime) +  ".png";
        crGraphs.createPlot(range(len(scenarios)), energyComparisonData, xLabel_, "per robot energy / resource", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=maxResEnergyCost_,size_=size_,doWilcoxon_=True);
        
                    
        #-- create data that compares model A and examined model     
        matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        for d in range(len(distances_)):
            for sc in range(len(scenarioTypes_)):
                comparisonDataIndex = d*len(scenarioTypes_) + sc;
                #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                print("Calculating energy cost diff for " + scenarios[comparisonDataIndex]);

                matrixData[d][sc] =  crData.getMedian(energyComparisonData[0][comparisonDataIndex]) / crData.getMedian(energyComparisonData[len(energyComparisonData)-1][comparisonDataIndex]);
                #-- for resource energy cost, make a percentage of how much better
                #matrixData[d][sc] = round((1-matrixData[d][sc]) * 100,2);
                #-- for energy efficiency, positive values already mean better, translate to percentages
                matrixData[d][sc] = round((matrixData[d][sc] - 1)*100,2);
                print(str(crData.getMedian(energyComparisonData[0][comparisonDataIndex])) + "  / " + str(crData.getMedian(energyComparisonData[len(energyComparisonData)-1][comparisonDataIndex])) + "   = " + str(matrixData[d][sc]));

        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_EcostDiffVS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_T" + str(startTime) + "-" + str(endTime) +  ".png";
        crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-60,vmax_=60,fileName_=fileName,annotateValues_=True,addPlusSigns_=True, annotationStringAfter_="%", annotationFontSize_='17');
         
    
    #============= DO_LOAD_EVENTS
    if (DO_LOAD_EVENTS or DO_TIME_OF_FIRST_LOADS) or DO_RES_COLLECTED_PER_LOAD:
        data = helpers.getLoadEvents(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_, [''], scenarios, EXPERIMENT_DIR,NR_,fD_,afterParamNameStr_=afterParamNameStr_);
        dataNoTD = helpers.getLoadEvents(chosenParamStringModelA_, [""], scenarios, modelADir_,NR_,fD_,afterParamNameStr_=afterParamNameStrModelA_);
        
        if (DO_LOAD_EVENTS or DO_RES_COLLECTED_PER_LOAD):
            if (DO_COMPARISON_WITH_B):
                comparisonDataSubseqTimes = [[],[],[]];
                comparisonDataSubseqNums = [[],[],[]];
                comparisonDataReactivateTimes = [[],[],[]];
                comparisonDataReactivateNums = [[],[],[]];
                dataTD = helpers.getLoadEvents(chosenParamStringModelB_, [""], scenarios, modelBDir_,NR_,fD_);
                for sc in range(len(dataNoTD[0])):
                    comparisonDataSubseqTimes[0].append(data[0][sc][0]);
                    comparisonDataSubseqTimes[1].append(dataTD[0][sc][0]);
                    comparisonDataSubseqTimes[2].append(dataNoTD[0][sc][0]);
                    comparisonDataSubseqNums[0].append(data[1][sc][0]);
                    comparisonDataSubseqNums[1].append(dataTD[1][sc][0]);
                    comparisonDataSubseqNums[2].append(dataNoTD[1][sc][0]);
                    
                    comparisonDataReactivateTimes[0].append(data[2][sc][0]);
                    comparisonDataReactivateTimes[1].append(dataTD[2][sc][0]);
                    comparisonDataReactivateTimes[2].append(dataNoTD[2][sc][0]);
                    comparisonDataReactivateNums[0].append(data[3][sc][0]);
                    comparisonDataReactivateNums[1].append(dataTD[3][sc][0]);
                    comparisonDataReactivateNums[2].append(dataNoTD[3][sc][0]);
            else:
                comparisonDataSubseqTimes = [[],[]];
                comparisonDataSubseqNums = [[],[]];
                comparisonDataReactivateTimes = [[],[]];
                comparisonDataReactivateNums = [[],[]];
                comparisonDataLoadNums = [[],[]];
                comparisonDataLoadNumsByRobot = [[],[]];
                for sc in range(len(dataNoTD[0])):
                    comparisonDataSubseqTimes[0].append(data[0][sc][0]);
                    comparisonDataSubseqTimes[1].append(dataNoTD[0][sc][0]);
                    comparisonDataSubseqNums[0].append(crData.getListDivision(data[1][sc][0],data[5][sc][0]));
                    comparisonDataSubseqNums[1].append(crData.getListDivision(dataNoTD[1][sc][0],dataNoTD[5][sc][0]));
                    
                    comparisonDataReactivateTimes[0].append(data[2][sc][0]);
                    comparisonDataReactivateTimes[1].append(dataNoTD[2][sc][0]);
                    comparisonDataReactivateNums[0].append(crData.getListDivision(data[3][sc][0],data[5][sc][0]));
                    comparisonDataReactivateNums[1].append(crData.getListDivision(dataNoTD[3][sc][0],dataNoTD[5][sc][0]));
                    
                    comparisonDataLoadNums[0].append(data[5][sc][0]);
                    comparisonDataLoadNums[1].append(dataNoTD[5][sc][0]);
                    
                    comparisonDataLoadNumsByRobot[0].append(crData.getAverage(data[6][sc][0]));
                    comparisonDataLoadNumsByRobot[1].append(crData.getAverage(dataNoTD[6][sc][0]));
            
            loadEvNcomparisonData = comparisonDataLoadNums;
        
        if (DO_LOAD_EVENTS):
            #fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadSubseqT_" + chosenParamString_ + ".png";
            #crGraphs.createPlot(range(len(scenarios)), comparisonDataSubseqTimes, xLabel_, "t between loadings from the same depo", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_);
            # fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadSubseqN_" + chosenParamString_ + ".png";
            # crGraphs.createPlot(range(len(scenarios)), comparisonDataSubseqNums, xLabel_, "% loadings from the same depo", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=0.7,size_=size_,doWilcoxon_=True);
            #
            # fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadReactT_" + chosenParamString_ + ".png";
            # crGraphs.createPlot(range(len(scenarios)), comparisonDataReactivateTimes, "", "t between loadings from different depos", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_);
            # fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadReactN_" + chosenParamString_ + ".png";
            # crGraphs.createPlot(range(len(scenarios)), comparisonDataReactivateNums, xLabel_, "% loadings from a new depo", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=0.2,size_=size_,doWilcoxon_=True);
            #
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadN_" + chosenParamString_ + ".png";
            crGraphs.createPlot(range(len(scenarios)), comparisonDataLoadNums, xLabel_, "Number of loadings", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_,doWilcoxon_=True);
            
            # fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonLoadNrob_" + chosenParamString_ + ".png";
            # crGraphs.createPlot(range(len(scenarios)), [comparisonDataLoadNumsByRobot[0]], xLabel_, "# loadings by a single robot", legendLabels, boxPlots_=False, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_,doWilcoxon_=False);
            #
        
        if (DO_TIME_OF_FIRST_LOADS):
            #-- graphs of first loads after fD perios
            intervals = [];
            if (fD_ > 0):
                for i in range(int(constants.MAX_TIME/(fD_/10))):
                    intervals.append(i*fD_/10);
            else:
                intervals.append(0);
            for sc in range(len(scenarios)):
                comparisonData = [[],[]];
                for i in range(len(data[4][sc][0])):
                    comparisonData[0].append(data[4][sc][0][i]);
                    comparisonData[1].append(dataNoTD[4][sc][0][i]);
                                    
                fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonFirstLoad_" + chosenParamString_ + "_" + scenarios[sc] + ".png";
                crGraphs.createPlot(range(len(intervals)),comparisonData, xLabel_, "t of first load after change", legendLabels, boxPlots_=True, xTickLabels_=intervals, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_,doWilcoxon_=True);
    
    #===================== DO_RES_COLLECTED_PER_LOAD
    if (DO_RES_COLLECTED_PER_LOAD):
        for i in range(len(resComparisonData)):
            for sc in range(len(resComparisonData[i])):
                for run in range(len(resComparisonData[i][sc])):
                    if (resComparisonData[i][sc][run] == 0):
                        resComparisonData[i][sc][run] = 0;
                    else:
                        print(resComparisonData[i][sc][run]);
                        print(loadEvNcomparisonData[i][sc][run]);
                        resComparisonData[i][sc][run] /= loadEvNcomparisonData[i][sc][run];
        
        #-- plot models separately by color
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonResPerLoad_" + chosenParamString_ + ".png";
        crGraphs.createPlot(range(len(scenarios)), resComparisonData, xLabel_, "resource % per 1 load", legendLabels, boxPlots_=True, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,size_=size_,doWilcoxon_=True);  
        
        #-- create data that compares model A and examined model
        matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        for d in range(len(distances_)):
            for sc in range(len(scenarioTypes_)):
                comparisonDataIndex = d*len(scenarioTypes_) + sc;
                #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                print("Calculating resource per load diff for " + scenarios[comparisonDataIndex]);
                matrixData[d][sc] = crData.getMedian(resComparisonData[0][comparisonDataIndex]) / crData.getMedian(resComparisonData[len(resComparisonData)-1][comparisonDataIndex]);
                #print(str(crData.getMedian(resComparisonData[0][comparisonDataIndex])) + "  / " + str(crData.getMedian(resComparisonData[len(resComparisonData)-1][comparisonDataIndex])) + "   = " + str(matrixData[d][sc]));
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonResPerLoadDiff_" + chosenParamString_ + ".png";
        crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=plt.cm.get_cmap("bwr"),vmin_=0.75,vmax_=1.25,fileName_=fileName,annotateValues_=True);
         
        
    #===================== DO_NEIGHB_SEARCH_SUCESS
    if (DO_NEIGHB_SEARCH_SUCESS):
        data = helpers.getNeighbSearchEvents(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR);
        dataNoTD = helpers.getNeighbSearchEvents(chosenParamStringModelA_, [""], scenarios, modelADir_); 
        
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_neighbS_" + chosenParamString_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ +  ".png";
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getNeighbSearchEvents(chosenParamStringModelB_, [""], scenarios, modelBDir_);
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataTD[0][sc][0]);
                comparisonData[2].append(dataNoTD[0][sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataNoTD[0][sc][0]); 
        resComparisonData = comparisonData;
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "% successful neighbourhood searches", legendLabels, markers_=markers, xTickLabels_=scenarioLabels_, boxPlots_=True, fileName_=fileName,yLimMin_=0,yLimMax_=1,size_=size_,doWilcoxon_=True);
    
    #===================== DO_TIME_BETWEEN_LOAD_UNLOAD
    if (DO_TIME_BETWEEN_LOAD_UNLOAD):
        data = helpers.getInfoBetweenLoadUnload(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,afterParamNameStr_=afterParamNameStr_);
        dataNoTD = helpers.getInfoBetweenLoadUnload(chosenParamStringModelA_, [""], scenarios, modelADir_,afterParamNameStr_=afterParamNameStrModelA_);
        
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonUnlT-LT_" + chosenParamString_ + afterParamNameStr_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + ".png";
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getInfoBetweenLoadUnload(chosenParamStringModelB_, [""], scenarios, modelBDir_);
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataTD[0][sc][0]);
                comparisonData[2].append(dataNoTD[0][sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataNoTD[0][sc][0]);
        resComparisonData = comparisonData;
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "t(unload) - t(load)", legendLabels, markers_=markers, xTickLabels_=scenarioLabels_, boxPlots_=True, fileName_=fileName,yLimMin_=0,size_=size_);
    
    #===================== DO_RES_COLLECTED_ENERGY_CAPPED
    if (DO_RES_COLLECTED_ENERGY_CAPPED):
        data = helpers.getResourceCollectedForEnergy(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,energyCapPerRobot_);
        dataNoTD = helpers.getResourceCollectedForEnergy(chosenParamStringModelA_, [""], scenarios, modelADir_,energyCapPerRobot_); 
        
        fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_res_eCap" + str(energyCapPerRobot_) + "_" + chosenParamString_ + "_VS_" + modelADir_ + "_" + chosenParamStringModelA_ + ".png";
        if (DO_COMPARISON_WITH_B):
            comparisonData = [[],[],[]];
            dataTD = helpers.getResourceCollectedForEnergy(chosenParamStringModelB_, [""], scenarios, modelBDir_,energyCapPerRobot_);
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataTD[0][sc][0]);
                comparisonData[2].append(dataNoTD[0][sc][0]);
        else:
            comparisonData = [[],[]];
            for sc in range(len(data[0])):
                comparisonData[0].append(data[0][sc][0]);
                comparisonData[1].append(dataNoTD[0][sc][0]);
        crGraphs.createPlot(range(len(scenarios)), comparisonData, xLabel_, "% Resource collected", legendLabels, markers_=markers, xTickLabels_=scenarioLabels_, boxPlots_=True, fileName_=fileName,yLimMin_=0,yLimMax_=maxResCollected_,size_=size_,doWilcoxon_=True);
    
    #===================== DO_LOAD_EVENT_GROUPS_OVER_TIME
    if (DO_LOAD_EVENT_GROUPS_OVER_TIME):
        doWilcoxon = True;
        if (timeInterval_==300):
            doWilcoxon = False;
        YLIMMAX = 20;
        if (timeInterval_ == 3600):
            YLIMMAX = 80;
        elif (timeInterval_ == 7200):
            YLIMMAX = 160;

        for sc in range(len(scenarios)):
            data = [];
            dataModA = []
            graphLegendLabels = [];
            graphLegendLabelsModA = [];
            timeLabels = [];
            for x in range(startTime_,constants.MAX_TIME,timeInterval_):
                startTime = x;
                endTime = x+timeInterval_;
                if (endTime % 3600 == 0):
                    timeLabels.append(str(endTime/3600));
                else:
                    timeLabels.append('');
                rawData = helpers.getLoadEventsGroups(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], [scenarios[sc]], EXPERIMENT_DIR, startTime_=startTime,endTime_=endTime,sortByQuality_=True);
                rawDataModA = helpers.getLoadEventsGroups(chosenParamStringModelA_, [""], [scenarios[sc]], modelADir_, startTime_=startTime,endTime_=endTime,sortByQuality_=True);

                #-- add the raw data into a structure that has length of the big time steps. examined model.
                numOfGroups = len(rawData[3][0][0]);
                #-- determine graph markers based on how many groups
                if (numOfGroups == 2):
                    graphMarkers = ['bs','rs'];
                else:
                    graphMarkers = ['cx','yd','ro','ks'];

                outputStr = "";
                #-- basic model
                NA = 0;
                for group in range(numOfGroups):
                    if (len(dataModA) <= group):
                        dataModA.append([]);
                        graphLegendLabelsModA.append("Basic G" + str(group+1));
                    dataModA[group].append(rawDataModA[3][0][0][group]);
                    NA += crData.getAverage(rawDataModA[3][0][0][group]);
                outputStr += "  NA=" + str(NA);

                #-- examined model
                for group in range(numOfGroups):
                    if (len(data) <= group):
                        #-- not enough space in data structure based on the examined model groups - add empty list and a legend label for this group
                        data.append([]);
                        graphLegendLabels.append("Examined G" + str(group+1));

                    data[group].append(rawData[3][0][0][group]);
                    outputStr += " NG" + str(group) + "=" + str(crData.getAverage(rawData[3][0][0][group])) + " ";
                print(outputStr);



            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonGroupsOverTime_" + chosenParamString_ + "_ITVL" + str(timeInterval_) + "_" + scenarios[sc] + "_exam.png";
            crGraphs.createPlot(range(len(data[0])), data, "Time [hours]", "Group resource collections",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,size_=size_,yLimMin_=0,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon);

            #fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonGroupsOverTime_" + chosenParamString_ + "_ITVL" + str(timeInterval_) + "_" + scenarios[sc] + "_basic.png";
            #crGraphs.createPlot(range(len(dataModA[0])), dataModA, "Time", "Group resource collections",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabelsModA, fileName_=fileName,size_=size_,yLimMin_=0,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon);







    #===================== DO_ROBOT_STATES
    if (DO_ROBOT_STATES):
        data = helpers.getRobotStatesForParameter(FD_FILENAME_STR+"NR" + str(NR_) + chosenParamString_,[""], scenarios, EXPERIMENT_DIR,afterParamNameStr_=afterParamNameStr_);
        dataNoTD = helpers.getRobotStatesForParameter(chosenParamStringModelA_, [""], scenarios, modelADir_,afterParamNameStr_=afterParamNameStrModelA_);
        if (DO_COMPARISON_WITH_B):
            dataNoTD = helpers.getRobotStatesForParameter(chosenParamStringModelB_, [""], scenarios, modelBDir_); 

        xLabel = "Time";
        yLabel = "States";
        #robotStateLabels = ['Scouts','Foragers','Waggle D.','Observers','Resters','Unloaders','Trembe D','ES','Wakers','Beggrs','Inspectors','For load','For return','Sc load','Sc return',"Unsucs"];
        robotStateLabels = ['Scout','Forag','Wagg D.','Obser','Rest','Unload','Trem. D','Beg','For load','For ret','Sc load','Sc ret',"Unsucs"];

        timeLabels = [];
        for t in range(len(time)):
            if (t%3600 == 0):
                timeLabels.append(t);
            else:
                timeLabels.append("");

        for sc in range(len(scenarios)):
            
            #--individual graphs over time 
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_rob_" + "_"+ scenarios[sc] + ".png";
            crGraphs.createStackedPlot(time, data[0][sc][0], xLabel, yLabel, robotStateLabels, constants.ROB_STATES_COLORS, timeLabels, 0,  constants.MAX_TIME, 0, 1, legendCols_= 7, fileName_=fileName, size_=(15,6));
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_rob_" + modelADir_ + "_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_"+ scenarios[sc]  + ".png";
            crGraphs.createStackedPlot(time, dataNoTD[0][sc][0], xLabel, yLabel, robotStateLabels, constants.ROB_STATES_COLORS, timeLabels, 0, constants.MAX_TIME, 0, 1, legendCols_= 7, fileName_=fileName,size_=(15,6));
            #-- comparison of numbers
            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_robVS_" + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_"+ scenarios[sc] + "_exam.png";
            crGraphs.createPlot(range(len(robotStateLabels)), [data[1][sc][0],dataNoTD[1][sc][0]], '', "total % in state", legendLabels, markers_=boxPlotMarkers, xTickLabels_=robotStateLabels, boxPlots_=True, fileName_=fileName,yLimMin_=0,size_=size_,doWilcoxon_=True);

    #===================== DO_INFO_VALUE
    if (DO_INFO_TRANSFER):
        doWilcoxon = True;
        if (timeInterval_==300):
            doWilcoxon = False;

        YLIMMAX = 20;
        if (timeInterval_ == 3600):
            YLIMMAX = 100;
        elif (timeInterval_ == 7200):
            YLIMMAX = 250;



        #-- create time labels
        timeLabels = [];
        for x in range(startTime_,constants.MAX_TIME,timeInterval_):
            startTime = x;
            endTime = x+timeInterval_;
            if (endTime % 3600 == 0):
                timeLabels.append(str(endTime/3600));
            else:
                timeLabels.append('');

        for sc in range(len(scenarios)):

            data = helpers.getInfoTransferForScenario(EXPERIMENT_DIR+"/" + scenarios[sc] + "_" + FD_FILENAME_STR+"NR" + str(NR_) +  chosenParamString_ + afterParamNameStr_,timeInterval_);
            dataA = helpers.getInfoTransferForScenario(modelADir_+"/" + scenarios[sc] + "_"  +  chosenParamStringModelA_ + afterParamNameStrModelA_,timeInterval_);

            if (DO_COMPARISON_WITH_B):
                dataB = helpers.getInfoTransferForScenario(modelBDir_+"/" + scenarios[sc] + "_" +  chosenParamStringModelB_ + afterParamNameStrModelB_,timeInterval_);

            #-- do info transfer events and their cost in separate graphs
            graphMarkers = ['bs-', 'rs-' , 'gs-'];
            graphLegendLabels = [examinedModelLabel_, modelALabel_, modelBLabel_];


            # fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonITE" + str(timeInterval_) + afterParamNameStr_ + "_VS_" + modelADir_ + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_" + scenarios[sc] +  ".png";
            # size = getGraphSize(timeInterval_);
            # if (DO_COMPARISON_WITH_B):
            #     crGraphs.createPlot(range(len(data[0])), [data[0],dataA[0],dataB[0]], "Time [hours]", "Information transfer",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=0,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);
            # else:
            #     crGraphs.createPlot(range(len(data[0])), [data[0],dataA[0]], "Time [hours]", "Information transfer",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=-YLIMMAX,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);

            fileName = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + "_comparisonITEV" + str(timeInterval_) + afterParamNameStr_ + "_VS_" + modelADir_ + chosenParamStringModelA_ + afterParamNameStrModelA_ + "_" + scenarios[sc] +  ".png";
            size = getGraphSize(timeInterval_,True);
            if (DO_COMPARISON_WITH_B):
                crGraphs.createPlot(range(len(data[0])), [data[2],dataA[2],dataB[2]], "Time [hours]", "Information transfer value",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=-15,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);
            else:
                crGraphs.createPlot(range(len(data[0])), [data[2],dataA[2]], "Time [hours]", "Information transfer value",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=-15,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);





#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================

def analyse(paramName_, paramVals_, paramLegendLabels_, scenarios_, scenarioLabels_, NRVals_, experimentDir_, imageOutputDir_,
            DO_RES_COLLECTED,DO_RES_COLLECTED_PER_ROBOT,DO_LOAD_EVENTS_RECRUITMENT,DO_SCOUT_EVENTS_SUCCESS,
            DO_NEIGHB_SEARCH_SUCESS,DO_ROBOT_STATES,DO_PELLETS, DO_LOAD_EVENT_GROUPS, DO_UNLOAD_TIME, DO_ENERGY_SPENT, DO_RES_ENERGY_COST,
            DO_WAGGLE_DANCE_GROUPS,DO_LOAD_EVENT_GROUPS_OVER_TIME,
            DO_TRANSFER_ENTROPY,DO_INFO_TRANSFER_REGIONS_GRID, DO_LOAD_EVENT_GROUPS_ABSOLUTE_VALS,
            maxResCollected_=100, scenarioPostFix_="",xLabel_="",resValueMultipliers_=[],size_=(12,6),timeInterval_=3600,startTime_=0,
            afterParamNameStr_="",
            scenarioTypes_=['group5','group10','group20','group50'],distances_=[8,10,12,14]):

    markers = ['gs-','bs-','rs-'];
    plainMarkers = ['g-','b-','r-'];
    scatterMarkers = ['g.','b.','r.'];
    boxPlotMarkers = ['gs','bs','rs'];

    if (DO_RES_ENERGY_COST ):
        DO_RES_COLLECTED = True;
        DO_ENERGY_SPENT = True;
        
    scenarios = [];
    if (not constants.SHOW_LEGEND):
        paramLegendLabels_ = [];
    
    for nr in range(len(NRVals_)):
        if (len(str(NRVals_[nr])) > 0):
            scenarios.append([x + scenarioPostFix_+"_NR"+str(NRVals_[nr]) for x in scenarios_]);
        else:
            scenarios.append([x + scenarioPostFix_ for x in scenarios_]);
   
        
    if (DO_RES_COLLECTED):
        resData = [];
        for nr in range(len(NRVals_)):
            resData.append(helpers.getResourceCollectedForParameter(paramName_,paramVals_,scenarios[nr],experimentDir_,valueMultipliers_=resValueMultipliers_,afterParamNameStr_=afterParamNameStr_));
            #-- graph
            helpers.plotScenarioByParam(resData[nr][0],"Resource collected",maxResCollected_,paramVals_,paramLegendLabels_,scenarioLabels_,"res"+afterParamNameStr_,imageOutputDir_ + "_NR" + str(NRVals_[nr]),boxPlots_=True,xLabel_=xLabel_,size_=size_,doWilcoxon_=True);


            #-- matrix plot
            levs = range(100)
            cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                colors =[(0.45, 0.45, 1),
                    (0.7, 1, 0.9),
                    (1, 1, 1),
                    (1, 0.9, 0.7),
                    (1, 0.45, 0.45),],
                N=len(levs)-1,
            )

            cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                colors =[(0.45, 0.45, 1),
                    (0.7, 1, 0.9),
                    (1, 1, 1)
                   ],
                N=len(levs)-1,
            )

            print("Param vals: " + str(paramVals_))
            pBase = paramVals_[0]
            for p in range(len(paramVals_)-1):
                paramVal = paramVals_[p+1]
                print(str(paramVal) + " vs " + str(pBase))

                #-- create data that compares model A and examined model
                matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
                for d in range(len(distances_)):
                    for sc in range(len(scenarioTypes_)):
                        comparisonDataIndex = d*len(scenarioTypes_) + sc;
                        #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                        scenario = scenarios[nr][comparisonDataIndex]
                        print("Calculating energy cost diff for " + scenario);
                        matrixData[d][sc] =  crData.getMedian(resData[nr][0][comparisonDataIndex][p+1]) / crData.getMedian(resData[nr][0][comparisonDataIndex][0])
                        #-- now make this a percentage
                        matrixData[d][sc] = round((matrixData[d][sc]-1) * 100,2);

                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_ResDiff_fP" + str(paramVal) + "_VS_" + str(pBase) + afterParamNameStr_ + ".png";
                crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-100,vmax_=0,fileName_=fileName,annotateValues_=True,annotationStringAfter_="%", annotationFontSize_='13');
    
    if (DO_RES_COLLECTED_PER_ROBOT):
        #for nr in range(len(NRVals_)):
        valueMultipliers = [1.0/paramVals_[x] for x in range(len(paramVals_))];
        print(valueMultipliers);
        res = helpers.getResourceCollectedForParameter(paramName_,paramVals_,scenarios_,experimentDir_,valueMultipliers_=valueMultipliers,afterParamNameStr_=afterParamNameStr_);
        #-- graph
        helpers.plotScenarioByParam(res[0],"% Resource collected per robot",5,paramVals_,paramLegendLabels_,scenarioLabels_,"resPerRobot"+afterParamNameStr_,imageOutputDir_,boxPlots_=True,xLabel_=xLabel_,size_=size_);
    
    if (DO_ROBOT_STATES):
        for nr in range(len(NRVals_)):
            rob = helpers.getRobotStatesForParameter(paramName_,paramVals_,scenarios[nr],experimentDir_);
            #-- graph
            xLabel = "Time";
            yLabel = "States";
            time = numpy.linspace(0,constants.MAX_TIME,constants.MAX_TIME);
            for sc in range(len(scenarios[nr])):
                for val in range(len(paramVals_)):
                    fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_rob_" + scenarios[nr][sc] + "_"+ str(paramLegendLabels_[val]) + ".png";
                    crGraphs.createStackedPlot(time, rob[0][sc][val], xLabel, yLabel, [], constants.ROB_STATES_COLORS, 0, constants.MAX_TIME, 0, 1,fileName_=fileName);
            
            
    if (DO_PELLETS):
        time = numpy.linspace(0, constants.MAX_TIME, constants.MAX_TIME);
        for nr in range(len(NRVals_)):
            for sc in range(len(scenarios[nr])):
                #-- pellets in 1 scenario, over time
                data = helpers.getPelletsForParameter(paramName_,paramVals_,[scenarios[nr][sc]], experimentDir_);
                fileName = constants.BASE_FILE_PATH+"/"+imageOutputDir_+"_pelOverTime_" + scenarios[nr][sc] + ".png";
                crGraphs.createPlot(time, [data[0][0]], "Time", "Pellets",markers_=plainMarkers, fileName_=fileName,size_=size_);

        
    if (DO_LOAD_EVENTS_RECRUITMENT):
        for nr in range(len(NRVals_)):
            ler = helpers.getLoadEventsRecruitment(paramName_,paramVals_,scenarios[nr],experimentDir_,afterParamNameStr_=afterParamNameStr_);
            #-- graph
            helpers.plotScenarioByParam(ler,"% found by recruitment",1,paramVals_,paramLegendLabels_,scenarioLabels_,"ler"+afterParamNameStr_,imageOutputDir_ + "_NR" + str(NRVals_[nr]),size_=size_);
        
    if (DO_SCOUT_EVENTS_SUCCESS):
        for nr in range(len(NRVals_)):
            ses = helpers.getScoutingEvents(paramName_,paramVals_,scenarios[nr],experimentDir_,afterParamNameStr_=afterParamNameStr_);
            #-- graph
            helpers.plotScenarioByParam(ses,"% successfull scouts",1,paramVals_,paramLegendLabels_,scenarioLabels_,"ses"+afterParamNameStr_,imageOutputDir_ + "_NR" + str(NRVals_[nr]),size_=size_);

    if (DO_ENERGY_SPENT):
        energyData = [];
        for nr in range(len(NRVals_)):
            energyData.append(helpers.getEnergySpent(paramName_,paramVals_,scenarios[nr],experimentDir_,nr,afterParamNameStr_=afterParamNameStr_));
            #-- graph
            helpers.plotScenarioByParam(energyData[nr],"Energy spent per robot",20000,paramVals_,paramLegendLabels_,scenarioLabels_,"ener"+afterParamNameStr_,imageOutputDir_ + "_NR" + str(NRVals_[nr]),size_=size_);

    if (DO_RES_ENERGY_COST):
        #-- divide each energy spent data point by how much resource was collected
        for nr in range(len(NRVals_)):
            for sc in range(len(energyData[nr])):
                for paramVal in range(len(energyData[nr][sc])):
                    for run in range(len(energyData[nr][sc][paramVal])):
                        if (resData[nr][0][sc][paramVal][run] == 0):
                            energyData[nr][sc][paramVal][run] = 0;
                        else:
                            energyData[nr][sc][paramVal][run] /= resData[nr][0][sc][paramVal][run];

            #-- plot
            helpers.plotScenarioByParam(energyData[nr],"Resource energy cost",80,paramVals_,paramLegendLabels_,scenarioLabels_,"resEnergyCost"+afterParamNameStr_,imageOutputDir_ + "_NR" + str(NRVals_[nr]),size_=size_,yMin_=15);


            #-- matrix plot
            levs = range(100)
            cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                colors =[(0.45, 0.45, 1),
                    (0.7, 1, 0.9),
                    (1, 1, 1),
                    (1, 0.9, 0.7),
                    (1, 0.45, 0.45),],
                N=len(levs)-1,
            )

            print("Param vals: " + str(paramVals_))
            pBase = paramVals_[0]
            for p in range(len(paramVals_)-1):
                paramVal = paramVals_[p+1]
                print(str(paramVal) + " vs " + str(pBase))

                #-- create data that compares model A and examined model
                matrixData = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
                for d in range(len(distances_)):
                    for sc in range(len(scenarioTypes_)):
                        comparisonDataIndex = d*len(scenarioTypes_) + sc;
                        #print(str(d) + "   " + str(sc) + "  -> " + str(comparisonDataIndex));
                        scenario = scenarios[nr][comparisonDataIndex]
                        print("Calculating energy cost diff for " + scenario);
                        matrixData[d][sc] =  crData.getMedian(energyData[nr][comparisonDataIndex][p+1]) / crData.getMedian(energyData[nr][comparisonDataIndex][0])
                        #-- now make this a percentage
                        matrixData[d][sc] = round((1-matrixData[d][sc]) * 100,2);

                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_EcostDiff_fP" + str(paramVal) + "_VS_" + str(pBase) + afterParamNameStr_ + ".png";
                crGraphs.createMatrixPlot(matrixData,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-40,vmax_=40,fileName_=fileName,annotateValues_=True,annotationStringAfter_="%", annotationFontSize_='13');



    if (DO_NEIGHB_SEARCH_SUCESS):
        for nr in range(len(NRVals_)):
            overalGraphData = [[0 for i in range(len(scenarios[nr]))] for j in range(len(paramVals_))];
            overalGraphLegendLabels = [];
            #overalGraphData = [];
            
            #-- stacked graphs of numbers
            nss = helpers.getNeighbSearchEvents(paramName_, paramVals_, scenarios[nr], experimentDir_,afterParamNameStr_=afterParamNameStr_);
            for val in range(len(paramVals_)):
                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_NR" + str(NRVals_[nr]) + "_nss_" + str(paramVals_[val]) + afterParamNameStr_ + ".png";
                crGraphs.createStackedBar(nss[1][val], groupLabels_=['success','not success'], barLabels_=scenarioLabels_, fileName_=fileName);      
                overalGraphLegendLabels.append("NR=" + str(NRVals_[nr]) + ", " + str(paramVals_[val]));
               
            #-- graph of percentages
            fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_  + "_NR" + str(NRVals_[nr]) + "_nss" + afterParamNameStr_ + ".png";
            crGraphs.createPlot(range(len(scenarios[nr])), crData.columnsToRows(nss[0]), xLabel_, "% successfull neighbourhood searches", overalGraphLegendLabels, boxPlots_=False, xTickLabels_=scenarioLabels_, markers_=markers, fileName_=fileName,yLimMin_=0,yLimMax_=1,size_=size_);
            
       
    if (DO_LOAD_EVENT_GROUPS):
        for nr in range(len(NRVals_)):
            print(scenarios_)
            rawData = helpers.getLoadEventsGroups(paramName_, paramVals_, scenarios_, experimentDir_,sortByQuality_=True,afterParamNameStr_=afterParamNameStr_);
            #-- graph of number of collections per group
            #groups = [1,2,3,4]; 
            #helpers.plotScenarioByParam(data[0],"% load events",1,groups,groups,scenarioLabels_,"leg",imageOutputDir_ + "_NR" + str(NRVals_[nr]));
            for val in range(len(paramVals_)):
                #-- create stacked graphs per param val
                #data = [[] for j in range(len(rawData[0][sc][0]))];
                data = [];
                for sc in range(len(scenarios_)):
                    for g in range(len(rawData[0][sc][val])):
                        if (len(data) <= g):
                            data.append([[] for i in range(len(scenarios_))]);
                        data[g][sc] = (rawData[0][sc][val][g]);
                    #-- fill in remaining groups as having 0 collects (for scenarios with < 4 groups)
                    while (len(data) < 4):
                        data.append([0 for i in range(len(scenarios_))])
                        
                #data = [[1,2,3],[4,5,6]];
                #print(len(data));
                #print(len(data[0]));
                #print(data[0]);

                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_leg_" + str(paramLegendLabels_[val]) + ".png";     
                crGraphs.createStackedBar(data, barLabels_=scenarioLabels_,yLabel_="Proportion of loadings", fileName_=fileName,xLabel_=xLabel_,yLimMin_=0,yLimMax_=1.0);

    if (DO_LOAD_EVENT_GROUPS_ABSOLUTE_VALS):
        for nr in range(len(NRVals_)):

            rawData = helpers.getLoadEventsGroups(paramName_, paramVals_, scenarios_, experimentDir_,sortByQuality_=True,afterParamNameStr_=afterParamNameStr_);

            #-- graph of number of collections per group
            #groups = [1,2,3,4];
            #helpers.plotScenarioByParam(data[0],"% load events",1,groups,groups,scenarioLabels_,"leg",imageOutputDir_ + "_NR" + str(NRVals_[nr]));
            for val in range(len(paramVals_)):
                #-- create stacked graphs per param val
                #data = [[] for j in range(len(rawData[0][sc][0]))];
                data = [];
                for sc in range(len(scenarios_)):
                    for g in range(len(rawData[3][sc][val])):
                        if (len(data) <= g):
                            data.append([[] for i in range(len(scenarios_))]);
                        data[g][sc] = (rawData[3][sc][val][g]);
                    #-- fill in remaining groups as having 0 collects (for scenarios with < 4 groups)
                    while (len(data) < 4):
                        data.append([0 for i in range(len(scenarios_))])

                #data = [[1,2,3],[4,5,6]];
                #print(len(data));
                #print(len(data[0]));
                #print(data[0]);

                groupColors = ['r','m','g','b']
                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_legAbs_" + str(paramLegendLabels_[val]) + ".png";
                crGraphs.createStackedBar(data, barLabels_=scenarioLabels_,yLabel_="Total number of loadings", fileName_=fileName,xLabel_=xLabel_, size_=(20,5), barWidth_=0.6, groupColors_=groupColors);


    if (DO_WAGGLE_DANCE_GROUPS):
        for nr in range(len(NRVals_)):
            for x in range(600,constants.MAX_TIME,600):
                startTime = x;
                endTime = x+600;

                rawData = helpers.getWaggleDanceGroups(paramName_, paramVals_, scenarios_, experimentDir_, startTime_=startTime,endTime_=endTime,sortByQuality_=True);
                #-- graph of number of collections per group
                for val in range(len(paramVals_)):
                    #-- create stacked graphs per param val
                    data = [];
                    for sc in range(len(scenarios_)):
                        for g in range(len(rawData[0][sc][val])):
                            if (len(data) <= g):
                                data.append([[] for i in range(len(scenarios_))]);
                            data[g][sc] = (rawData[0][sc][val][g]);
                        #-- fill in remaining groups as having 0 collects (for scenarios with < 4 groups)
                        while (len(data) < 4):
                            data.append([0 for i in range(len(scenarios_))])
    
                    fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_wdg_" + str(paramLegendLabels_[val]) + "_t" + str(startTime) + ".png";     
                    crGraphs.createStackedBar(data, barLabels_=scenarioLabels_,fileName_=fileName,xLabel_=xLabel_,yLabel_="Waggle dance time", yLimMin_=0);

    if (DO_LOAD_EVENT_GROUPS_OVER_TIME):
        doWilcoxon = True;

        if (timeInterval_==300):
            doWilcoxon = False;

        YLIMMAX = 20;
        if (timeInterval_ == 3600):
            YLIMMAX = 100;
        elif (timeInterval_ == 7200):
            YLIMMAX = 250;

        size = getGraphSize(timeInterval_,False);

        for val in range(len(paramVals_)):
            for sc in range(len(scenarios[0])):
                data = [];
                graphLegendLabels = [];
                timeLabels = [];

                rawData = helpers.getLoadEventsGroups(paramName_,[paramVals_[val]], [scenarios[0][sc]], experimentDir_, startTime_=startTime_,endTime_=constants.MAX_TIME,sortByQuality_=False,afterParamNameStr_=afterParamNameStr_);

                #-- each raw data[2][0][0][G] contains number of loadings from group G in a particular time step. Sort these into bins based on time interval
                numOfGroups = len(rawData[2][0][0]);
                numOfIntervals = int(constants.MAX_TIME / timeInterval_);
                #print("Num of intervals: " + str(numOfIntervals));
                binData = [ [ [ 0 for r in range(constants.NUM_RUNS)] for i in range(numOfIntervals)] for b in range(numOfGroups)];
                intervalCounter = 0;
                for x in range(startTime_,constants.MAX_TIME,timeInterval_):
                    startTime = x;
                    endTime = x+timeInterval_;

                    for group in range(numOfGroups):
                        for t in range(endTime-startTime):
                            for runNo in range(constants.NUM_RUNS):
                                tIndex = startTime + t;

                                #print(str(tIndex) + " -> " + str(timeInterval_) + " val " + str(rawData[2][0][0][group][tIndex]));
                                binData[group][intervalCounter][runNo] += rawData[2][0][0][group][tIndex][runNo];
                                #if (group == 0):
                                    #print(str(tIndex) + " -> " + str(intervalCounter) + ":" + str(rawData[2][0][0][group][tIndex][runNo]));




                    if (endTime % 3600 == 0):
                        timeLabels.append(str(endTime/3600));
                    else:
                        timeLabels.append('');


                    #-- determine graph markers based on how many groups
                    lineStyles = [];
                    if (numOfGroups == 2):
                        graphMarkers = ['yd','ks'];
                        lineStyles = ['-','--'];
                    else:
                        graphMarkers = ['cx','yo','rd','ks'];
                        lineStyles = ['--','--','-','-'];

                    for group in range(numOfGroups):
                         if (len(data) <= group):
                            #-- not enough space in data structure based on the examined model groups - add empty list and a legend label for this group
                            graphLegendLabels.append("Examined G" + str(group+1));

                    intervalCounter += 1;

                #print(binData);

                #-- plot
                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_comparisonGroupsOverTime_"  + str(paramLegendLabels_[val]) + "_ITVL" + str(timeInterval_) + "_" + scenarios[0][sc] + "_exam.png";
                crGraphs.createPlot(range(len(binData[0])), binData, "Time [hours]", "Group resource collections",markers_=graphMarkers,lineStyles_=lineStyles,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=0,yLimMax_=YLIMMAX, markerSize_=12, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);


    if (DO_UNLOAD_TIME):
        for nr in range(len(NRVals_)):
            data = helpers.getUnloadTime(paramName_,paramVals_,scenarios[nr],experimentDir_);        
            #-- graph
            helpers.plotScenarioByParam(data[0],"Average unload time",-999999,paramVals_,paramLegendLabels_,scenarioLabels_,"tU",imageOutputDir_ + "_NR" + str(NRVals_[nr]),plotAverages_=True,size_=size_);

    if (DO_TRANSFER_ENTROPY):

        if (timeInterval_==300):
            doWilcoxon = False;

        YLIMMAX = 20;
        if (timeInterval_ == 3600):
            YLIMMAX = 100;
        elif (timeInterval_ == 7200):
            YLIMMAX = 250;

        size = getGraphSize(timeInterval_,True);
        for sc in range(len(scenarios_)):
            for val in range(len(paramVals_)):
                data = helpers.getInfoTransferForScenario(experimentDir_+"/" + scenarios_[sc] +"_" +  paramName_ + str(paramVals_[val]) + afterParamNameStr_,timeInterval_, NRVals_[0]);

                #-- determine graph markers based on how many groups
                graphMarkers = ['ro-', 'co-','ks-'];
                #graphLegendLabels = ['ITE value', 'loading value','information transfer events'];
                graphLegendLabels = ['ITE value', 'ITE value B'];

                 #-- create time labels
                timeLabels = [];
                for x in range(startTime_,startTime_+constants.MAX_TIME,timeInterval_):
                    startTime = x;
                    endTime = x+timeInterval_;
                    if (endTime % 3600 == 0):
                        timeLabels.append(str(endTime/3600));
                    else:
                        timeLabels.append('');

                fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "__infoTransf_fQ" + str(str(paramLegendLabels_[val])) + afterParamNameStr_ + "_" + scenarios_[sc] +  ".png";
                print(" Region A integrations median: " + str(crData.getMedian(data[4])) + "  average " + str(crData.getAverage(data[4])));
                print(" Region B lengths median: " + str(crData.getMedian(data[5])) + "  average " + str(crData.getAverage(data[5])));
                print(" Region C integrations median: " + str(crData.getMedian(data[6])) + "  average " + str(crData.getAverage(data[6])));
                #crGraphs.createPlot(range(len(data[0])), [data[1], data[2], data[0]], "Time [hours]", "Information transfer",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=-YLIMMAX,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);

                crGraphs.createPlot(range(len(data[0])), [data[2]], "Time [hours]", "Communication value",markers_=graphMarkers,boxPlots_=True,xTickLabels_=timeLabels, legendLabels_=graphLegendLabels, fileName_=fileName,yLimMin_=-YLIMMAX,yLimMax_=YLIMMAX, markerSize_=8, boxPlotWidth_=0.2, doWilcoxon_=doWilcoxon, size_=size);

    if (DO_INFO_TRANSFER_REGIONS_GRID):
        matrixDataRegionA = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        matrixDataRegionB = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        matrixDataRegionC = [[0 for sc in range(len(scenarioTypes_))] for d in range(len(distances_))];
        for d in range(len(distances_)):
            for sc in range(len(scenarioTypes_)):
                scIndex = d*len(scenarioTypes_) + sc;
                data = helpers.getInfoTransferForScenario(experimentDir_+"/" + scenarios_[scIndex] +"_" +  paramName_ + str(paramVals_[0]) + afterParamNameStr_,timeInterval_);
                matrixDataRegionA[d][sc] = crData.getAverage(data[4]);
                matrixDataRegionB[d][sc] = crData.getAverage(data[5]);
                matrixDataRegionC[d][sc] = crData.getAverage(data[6]);

        #-- create custom color map
        levs = range(100)
        cmap = mcolors.LinearSegmentedColormap.from_list(name='red_white_blue',
                    colors =[(0.3, 0.3, 1),
                        (0.3, 1, 0.5),
                        (1, 1., 1),
                        (1, 0.7, 0.3),
                        (1, 0.3, 0.3),],
                    N=len(levs)-1,
                )


        fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_infoTransf_regionA_" + str(timeInterval_) + afterParamNameStr_ + ".png";
        crGraphs.createMatrixPlot(matrixDataRegionA,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-25,vmax_=25,fileName_=fileName,annotateValues_=True);
        fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_infoTransf_regionB_" + str(timeInterval_) + afterParamNameStr_ + ".png";
        crGraphs.createMatrixPlot(matrixDataRegionB,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-25,vmax_=25,fileName_=fileName,annotateValues_=True);
        fileName = constants.BASE_FILE_PATH+"/" + imageOutputDir_ + "_infoTransf_regionC_" + str(timeInterval_) + afterParamNameStr_ + ".png";
        crGraphs.createMatrixPlot(matrixDataRegionC,"Scenario type","Deposit distance",xTickLabels_=scenarioTypes_,yTickLabels_=distances_,colorMap_=cmap,vmin_=-25,vmax_=25,fileName_=fileName,annotateValues_=True);

def getGraphSize(timeInterval_, hasNegativeVals_=False):
    height = 6;
    if (hasNegativeVals_):
        height = 6;
    size=(12,height);
    if (timeInterval_ <= 600 and constants.MAX_TIME > 14400):
        size=(24,height);

    if (constants.MAX_TIME == 61200):
        size=(14,height);

    if (timeInterval_ <= 600 and constants.MAX_TIME >= 61200):
        size=(45,height);

    if (timeInterval_ <= 600 and constants.MAX_TIME >= 93600):
        size=(60,height);

    return size;

       
 
                
        
            