"""
crData - library for python that lets you read data from files and manipulate data, mainly for use by crGraphs

Author: Lenka Pitonakova: contact@lenkaspace.net

"""

import os;
import scipy.stats;

SHOW_OUTPUT = False;

#
def fileToArray(filePath_, separator_=",", ignoreFirstRow_=False, containsNumbers_=True,endRow_=-1,maxTime_=-1, timeColumn_=0, startRow_=1):
    """
    Take a file that has rows and columns of values and convert it into a 2d array 
    in format array[rows][columns]
    Set the containsNumbers_ to False if e.g. there are strings int the file
    """
    data = []
    fileOk = False;
    if (SHOW_OUTPUT == True):
        print("Reading " + filePath_ + " ...");  
    try:
        f = open(filePath_,'r')
        #-- read data into a list of strings
        lines = f.readlines()
        f.close()
        fileOk = True
    except Exception:
        raise Exception("The file " + filePath_ + " doesn't exist."); 
    
    if (fileOk):
        counter=0;
        isFirstLine = True   
        #-- process the lines
        for line in lines:
            #print("LINE %d" % (counter))

            #-- ignore first row
            if (ignoreFirstRow_ and isFirstLine):
                isFirstLine = False;
                continue;

            counter+=1;
            #print(str(counter) + "  " + str(startRow_) + "  " + str(endRow_));
            #-- process to a certain row
            if (endRow_> 0 and counter > endRow_):
                continue;
            #-- start at a certain row
            if (counter < startRow_):
                continue;
           
            isFirstLine = False;
            #-- split the line into individual string numbers by comma
            dataStrings = line.split(separator_)
            #print(dataStrings);
            #-- convert the strings to ints
            dataInts = []
            for dataString in dataStrings:
                #-- clear the data string of encompassing double quotes
                dataString = dataString.replace('"','');
                if (dataString != "\n"):
                    if (containsNumbers_):
                        dataInts.append(float(dataString))
                    else:
                        dataInts.append(dataString.replace("\n",""))
            #-- add to main data structure
            if (len(dataInts) > 0):
                
                #-- process to a certain time of simulation, if time is given in column timeColumn_
                if (maxTime_ >= 0 and dataInts[timeColumn_] > maxTime_ ):
                    continue
  
                data.append(dataInts)
            

    
   
   
    return data

    
#
def getAverage(valuesList_,nullValue_=0):
    """
    Get average value of a list of values. If no values, return nullValue_.
    """
    if (len(valuesList_) > 0):
        return sum(valuesList_) / len(valuesList_);
    return nullValue_;
#
def getMedian(valuesList_):
    """
    Get median value of a list of values
    """
    theValues = sorted(valuesList_);
    if len(theValues) % 2 == 1:
        return theValues[(len(theValues)+1)/2-1]
    else:
        lower = theValues[len(theValues)/2-1]
        upper = theValues[len(theValues)/2]
        return (float(lower + upper)) / 2 

def getInterquartileRange(valuesList_):
    """
    Get interquartile range of a list, which is a range
    between 1st and 3rd quartile. Used usually with reporting
    median
    """
    theValues = sorted(valuesList_);
    upperQuartile = scipy.stats.scoreatpercentile(theValues, 75);
    lowerQuartile = scipy.stats.scoreatpercentile(theValues, 25);
    return upperQuartile - lowerQuartile;
#
def getListDifference(list1_,list2_):
    """
    Return a list where elements are difference between list1_ - list2_.
    If lists are 2d lists, the medians on 2nd dimensions are subtracted.
    """
    returnList = [];
    for i in range(len(list1_)):
        if (type(list1_[i]) == list and type(list2_[i]) == list):
            returnList.append(getMedian(list1_[i]) - getMedian(list2_[i]));
        else:
            returnList.append(list1_[i] - list2_[i]);
    return returnList;

#
def getListAddition(list1_,list2_):
    """
    Return a list where elements are additions between list1_ + list2_.
    If one list is shorter than another, it is understood as having 0s on the missing spaces.
    """
    returnList = [];
    length = len(list1_);
    if (len(list2_) > length):
        length = len(list2_);
    for i in range(length):
        val1 = 0;
        val2 = 0;
        if (i < len(list1_)):
            val1 = list1_[i];
        if (i < len(list2_)):
            val2 = list2_[i];
        returnList.append(val1 + val2);
    return returnList;

def getListMultiplication(list1_,list2_):
    """
    Return a list where elements are multiplications of elements from list1_ * elements from list2_.
    If one list is shorter than another, error is returned.
    """
    returnList = [];
    length = len(list1_);
    if (len(list2_) != length):
        raise Exception("crData: getListMultiplication : lists must be of the same length.")
    for i in range(length):
        returnList.append(list1_[i] * list2_[i]);
    return returnList;

def getListDivision(list1_,list2_):
    """
    Return a list where elements are divisons of elements from list1_ / elements from list2_.
    If one list is shorter than another, error is returned.
    """
    returnList = [];
    length = len(list1_);
    if (len(list2_) != length):
        raise Exception("crData: getListMultiplication : lists must be of the same length.")
    for i in range(length):
        if (list2_[i] != 0):
            returnList.append(list1_[i] / float(list2_[i]));
        else:
            returnList.append(0);
    return returnList;

    
#
def extractColumns(array_, columns_):
    """
    Returns a 2d list with only specific columns of the array_.
    Clumn numbers are specified in the columns_ array
    """
    numOfRows = len(array_);
    numOfNewCols = len(columns_);
    retArray = [[0.0 for i in range(numOfNewCols)] for j in range(numOfRows)];
    currentCol = 0;
    for i in range(numOfRows):
        currentCol = 0;
        for j in range(len(array_[0])):
            if (j in columns_):
                retArray[i][currentCol] = array_[i][j];
                currentCol+=1;
    return retArray;

#
def columnToArray(array_, columnId_, valueMultiplier_=1):
    """
    Returns a 1d list filled with values of a column of a specified array.
    Also multiplies each value by valueMultiplier_.
    """
    retArray = [];
    numOfRows = len(array_);
    for i in range(numOfRows):
        retArray.append(array_[i][columnId_]*valueMultiplier_);
    return retArray;

#
def columnsToRows(array_):
    """
    Return array that has rows with columns swapped
    """
    numOfRows = len(array_);
    numOfCols = len(array_[0]);
    retArray = [[0.0 for i in range(numOfRows)] for j in range(numOfCols)];
    for i in range(numOfRows):
        for j in range(numOfCols):
            retArray[j][i] = array_[i][j];
    return retArray;

#
def removeValues(array_, valueToRemove_=0):
    """
    Returns a 1D list from a list array_, that does not contain valueToRemove_, i.e. is shorter
    """
    retArray = [];
    for i in range(len(array_)):
        if (array_[i] != valueToRemove_):
            retArray.append(array_[i]);
    return retArray;
    
       
#
def print2DArray(array_):
    for i in range(len(array_)):
        print(array_[i]);
            