import constants;

constants.MAX_TIME=14400
START_TIME = 0;
TIME_INTERVAL = 14400;

import crGraphs;
import crData;

import helpers;
import numpy;

import matplotlib;
import analysis;
from copy import deepcopy;
import math;


def getExtraParamString(directory_):
    if ('localRec_relEE_persist' in directory_):
        return '_sigD60_TOmin1020_pS0.1';
    elif ('localRec' in directory_):
        return '_sigD60_TOmin0_pS0.001';
    else:
        return '_sigD1000_TOmin0_pS0.001';

def getModelLabel(directory_):
    str = "";
    if ('PEL_basicModel' in directory_):
        str = 'basic model';
    elif ('PEL' in directory_):
        str = 'self-regulating model';

    return str;

def getMaxMinCollectedResurce(scenarioType_,fP_):
    if (fP_ == 100):
        return [300,400];
        #
        # if (scenarioType_ == "group2"):
        #     return [300,400];
        # elif (scenarioType_ == "group4"):
        #     return [300,400]
    elif (fP_ == 200):
        return [150,250];

def getMaxMinEnergy(scenarioType_,fP_):
    return [10000,15000];

def getMaxMinResourceEnergyCost(scenarioType_,fP_):
    if (fP_ == 100):
        return [30,45];
    elif(fP_ == 200):
        return [60,75]



crGraphs.DPI = 100;
constants.NUM_RUNS = 50;


DO_ENERGY_CAPPED_COMPARISON_MINIMAL = True;


if __name__ == "__main__":

    experimentDirModelA = "PEL_basicModel";
    modelALabel = getModelLabel(experimentDirModelA);
    extraParamNameStrModelA = '';

    energyCapVals = [15000, 8000];
    energyCapLegend = [];
    for ec in range(len(energyCapVals)):
        if (energyCapVals[ec] < 14400):
            energyCapLegend.append(str(energyCapVals[ec]));
        else:
            energyCapLegend.append("unlimited");


    experimentDirSocial = "PEL";
    labelSocial = getModelLabel(experimentDirSocial);
    extraParamStrSocial = "pW0.0001_tDsigD90_TU800";

    experimentDirNonSocial = 'PELNONSOC';
    LabelNonSocial = getModelLabel(experimentDirNonSocial);
    extraParamStrNonSocial = "pW0.0001_tDsigD90_TU600";


    #--
    IMAGE_OUTPUT_DIR = "images_conferencePaper/";

    markers = ['go-', 'rs-'];
    lineStyles = ['-', '-'];

    #params = [(25,50,('Heap1', 9)), (50,200, ('Scatter25',5)), (25,50,('Heap1', 5)), (50,200, ('Scatter25',9))]
    params = [(25,50,('Heap1', 5)), (50,200, ('Scatter25',5))]
    params = [(50,200,('Scatter25', 5)), (25,50,('Scatter25', 9))]
    #params = [(25,50,('Scatter25', 5))]
    params = [(25,50,('Heap1', 5)), (50,200,('Heap1', 5)), (25,50,('Scatter25', 5)), (50,200,('Scatter25', 5))]

    for i in range(len(params)):
        NR = params[i][0]
        fP = params[i][1]
        scenarioInfo = helpers.getScenariosBasedOnTypes([params[i][2][0]], [params[i][2][1]]);
        scenarioLegend = scenarioInfo[0][0];
        scenario = scenarioInfo[1][0];

        fileName = "resECap_NR" + str(NR) + "_fP" + str(fP) + "_" + scenario
        controllerLegend = ["non-social", "social"];


        graphDataByECap_perc = [[[] for c in range(len(energyCapVals))] for i in range(2)]
        graphDataByECap_delta = [[[] for c in range(len(energyCapVals))] for i in range(2)]


        for c in range(len(energyCapVals)):

            dataSocial = helpers.getResourceCollectedForEnergy("fP" + str(fP) + "_NR" + str(NR) + "_" + extraParamStrSocial,[""], [scenario], experimentDirSocial, energyCapVals[c]);
            dataNonSocial = helpers.getResourceCollectedForEnergy("fP" + str(fP) + "_NR" + str(NR) + "_" + extraParamStrNonSocial,[""], [scenario], experimentDirNonSocial, energyCapVals[c]);
            dataModelA = helpers.getResourceCollectedForEnergy("fP" + str(fP) + "_NR" + str(NR) + extraParamNameStrModelA, [""], [scenario], experimentDirModelA, energyCapVals[c]);

            #-- for each data point of examined model, compare
            graphDataPartial = [[0 for r in range(constants.NUM_RUNS)] for i in range(2)]

            for run in range(len(dataModelA[0][0][0])):

                graphDataByECap_perc[0][c].append(((dataNonSocial[0][0][0][run]/dataModelA[0][0][0][run]) - 1.0)*100) ; # percentage improvement of resource collected
                graphDataByECap_perc[1][c].append(((dataSocial[0][0][0][run]/dataModelA[0][0][0][run]) - 1.0)*100); # percentage improvement of resource collected

                graphDataByECap_delta[0][c].append(dataNonSocial[0][0][0][run] - dataModelA[0][0][0][run]) ; # percentage improvement of resource collected
                graphDataByECap_delta[1][c].append(dataSocial[0][0][0][run] - dataModelA[0][0][0][run]); # percentage improvement of resource collected



        graphWidth = 6;

        filePath = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + fileName + "_perc.png";
        crGraphs.createPlot(range(len(energyCapLegend)), graphDataByECap_perc, "Total swarm energy limitation", "% improvement of res. collected", controllerLegend, xTickLabels_=energyCapLegend, confidenceIntervals_=True, markers_=markers, markerSize_=15, lineWidth_=4, lineStyles_=lineStyles, fileName_=filePath,size_=(graphWidth,6),yLimMin_=-80,yLimMax_=80);

        filePath = constants.BASE_FILE_PATH+"/" + IMAGE_OUTPUT_DIR + fileName + "_delta.png";
        #crGraphs.createPlot(range(len(energyCapLegend)), graphDataByECap_delta, "Total swarm energy limitation", "Improvement of res. collected", controllerLegend, xTickLabels_=energyCapLegend, confidenceIntervals_=True, markers_=markers, markerSize_=15, lineWidth_=4, lineStyles_=lineStyles, fileName_=filePath,size_=(graphWidth,6));


