
import crGraphs;
import constants;
import numpy;
import crData;
import math;
from jpype import *
import random
import matplotlib.pyplot as plt

def getScenariosBasedOnTypes(scenarioTypes_ = [], distances_ = []):
    scenarioLabels = [];
    scenarios = [];
    for i in range(len(distances_)):
        scenarioLabels.extend(scenarioTypes_);
        for scType in scenarioTypes_:
            if scType == 'H1' or scType == "Heap1":
                scenarios.extend(["group1-" + str(distances_[i]+3) + "E"]);
            elif scType == 'H2' or scType == "Heap2":
                scenarios.extend(["group2-" + str(distances_[i]+3) + "E"]);
            elif scType == 'H4' or scType == "Heap4":
                scenarios.extend(["group4-" + str(distances_[i]+3) + "E"]);
            elif scType == 'S10' or scType == "Scatter10":
                scenarios.extend(["rand10-" + str(distances_[i]+3)]);
            elif scType == 'S25' or scType == "Scatter25":
                scenarios.extend(["rand25-" + str(distances_[i]+3)]);
            elif scType == 'S100' or scType == "Scatter100":
                scenarios.extend(["rand100-" + str(distances_[i]+3)]);

            elif scType == 'H2w' or scType == 'Heap2w':
                scenarios.extend(["group2_05|15-" + str(distances_[i]+3) + "E"]);
            elif scType == 'H2s' or scType == 'Heap2s':
                scenarios.extend(["group2_01|19-" + str(distances_[i]+3) + "E"]);
            elif scType == 'H4s' or scType == 'Heap4s' or scType == 'Heap4B':
                scenarios.extend(["group4_05|15|01|19-" + str(distances_[i]+3) + "E"]);
            elif scType == 'H4w' or scType == 'Heap4w':
                scenarios.extend(["group4_05|05|05|25-" + str(distances_[i]+3) + "E"]);

    return [scenarioLabels, scenarios];

def getInfoTransferForScenario(scenarioFolder_, timeInterval_, NR_):
    """
    Get a 3D array:

    0th element is a T - long array (T=num of time intervals) containing NUM_RUNS long array of how many recruitment
    events happened.

    1st element is also a TxNUM_RUNS array, containing values (i.e. change in loading qualities) of those events

    1nd element is a TxNUM_RUNS array, containg values (change of loading qualities) of all load events
    """
    #-- prepare return vals
    numOfTimeBins = constants.MAX_TIME / timeInterval_;
    informationTransferEvents = [[0 for r in range(constants.NUM_RUNS)] for t in range(numOfTimeBins) ];
    informationTransferEventValues = [[0 for r in range(constants.NUM_RUNS)] for t in range(numOfTimeBins) ];
    informationTransferEventValueAverages = [0 for t in range(numOfTimeBins) ];
    informationTransferEventValuesB = [[0 for r in range(constants.NUM_RUNS)] for t in range(numOfTimeBins) ];
    regionAintegrations = [];
    regionBlengths = [];
    regionCintegrations = [];

    S=0.05 #robot speed in m/s
    #-- adjusted distance, based on swarm intelligence review, recruitment events will count N seconds before the loading event (i.e. when robots were recruited)
    D=0
    if ('-10' in scenarioFolder_):
        D=7
    elif ('-12' in scenarioFolder_):
        D=9
    elif ('-14' in scenarioFolder_):
        D=11
    elif ('-16' in scenarioFolder_):
        D=13
    travelTime = 1/S * (D+2); #allow time for 2 more meters, could be anywhere on the dance floor, might need to avoid stuff..
    print("!! adjusting for D=" + str(D) + " travel time " + str(travelTime));

    #-- define constants for computation
    danceFloorArea = math.pi * math.pow(2,2); #dance floor area, in metres
    if ('_sigD60' in scenarioFolder_):
        robotArea = math.pi * math.pow(0.6,2); #robot size, in metres
    elif ('_sigD1000' in scenarioFolder_ ):
        robotArea = math.pi * math.pow(10,2);
    if ('TOmin1020' in scenarioFolder_):
        observerTime = 1020;
    else:
        if ('pS0.1' in scenarioFolder_ ):
            observerTime = 8;
        else:
            observerTime = 1020;
    robotAreaOverDanceFloorArea = robotArea/danceFloorArea;
    if (robotAreaOverDanceFloorArea > 1):
        robotAreaOverDanceFloorArea = 1;
    informationTransferProb = 1 - math.pow(1-robotAreaOverDanceFloorArea, observerTime);

    timeBinsPerChangeInterval = 12;
    if ('fQ72000' in scenarioFolder_):
        timeBinsPerChangeInterval = 24;

    print(">>> get info val for " + scenarioFolder_ + "  NR= " + str(NR_) + " Ad=" + str(danceFloorArea) + " Ar=" + str(robotArea) + " TO=" + str(observerTime) + " ITprob=" + str(informationTransferProb));


    #-- prepare array that will index group id by quality, based on qualities from 1st 3 runs
    qualities = [];
    for runNo in range(3):
        data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_+ "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=constants.MAX_TIME);
        for row in range(len(data)):
            q = data[row][1];
            if not (q in qualities):
                #-- quality not added yet - add it
                qualities.append(q);
    #-- order list so that the lower qualities are at the beginning
    qualities = sorted(qualities, key=float);
    #print("Qualities found: " + str(qualities));

    for runNo in range(constants.NUM_RUNS):
        data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=constants.MAX_TIME);
        scoutingData = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/Run" + str(runNo) + "_scoutingEvents.txt", "\t", True, True,maxTime_=constants.MAX_TIME);
        waggleData = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/Run" + str(runNo) + "_wdEvents.txt", "\t", True, True,maxTime_=constants.MAX_TIME);
        depositRenewEventsData = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/Run" + str(runNo) + "_depositRenewEvents.txt", "\t", True, True,maxTime_=constants.MAX_TIME);
        for row in range(len(data)):
            foundBySelf = int(data[row][7]);
            if (True):
            #if (foundBySelf != 1): #only consider load events that resulted from recruitment
                loadEvtTime = data[row][0];

                #estimate adjusted information transfer time based on distace from the base
                infoTime = loadEvtTime;
                if (foundBySelf == 0):
                    infoTime -= travelTime;
                timeBin = int(math.floor(infoTime / timeInterval_));
                depoId = data[row][11];


                if (timeBin >=  infoTime/timeInterval_):
                    timeBin = timeBin - 1; #event of the very last second of the run - just put it to the last time bin

                #-- get quality not from the loading event but from the quality of deposit at the time of the information transfer
                quality = data[row][1];

                for x in range(len(depositRenewEventsData)):
                    if (depositRenewEventsData[x][0] <= infoTime and depositRenewEventsData[x][1] == depoId):
                        quality = depositRenewEventsData[x][2];
                        #print("!found at " + str(depositRenewEventsData[x][0]));
                #print("t=" + str(infoTime) + " id=" + str(depoId) + "  q=" + str(quality));
                #--
                loaderId = data[row][8];
                prevSourceQuality = quality; #what quality the recruiter foraged from when it transfered info
                prevDestinationQuality = 0; #what quality this loader foraged from before it was recruited
                #groupId = qualities.index(quality);

                #loadingsInGroup[timeBin][groupId] += 1;
                prevDestQualityFoundAtTime = 0;
                prevDestinationDepoId = -1;
                sourceRobotId = data[row][12];
                prevSourceRobotId = -1;
                prevDestinationGroupId = -1;
                for r in range(row-1,0,-1):
                    if (data[r][8] == loaderId):
                        if (prevDestinationQuality == 0):
                            prevDestinationQuality = data[r][1];
                            prevDestinationDepoId = data[r][11];
                            prevDestQualityFoundAtTime = data[r][0];
                            prevDestinationGroupId = qualities.index(prevDestinationQuality);
                            prevSourceRobotId = data[r][12];
                            #print("!! prev dest quality found at " + str(data[r][0]) + "  group " + str(prevDestinationDepoId));

                #-- note down the value before it's adjusted by adandonment
                #newInformationTransferEventValues[timeBin][runNo] += quality - prevDestinationQuality;

                #-- check if robot previously abandoned - i.e. gave up its information between the recorded loadings
                foundUnsuccessfulScoutingEvent = False;
                for r in range(len(scoutingData)):
                    if (scoutingData[r][0] < loadEvtTime):
                        if (scoutingData[r][1] == loaderId and scoutingData[r][2] == 0 and scoutingData[r][0] > prevDestQualityFoundAtTime):
                                #print( "  >> UNSUC SCOUTING EVENT FOUND at " + str(scoutingData[r][0]));
                                foundUnsuccessfulScoutingEvent = True;
                    else:
                        break;
                if (foundUnsuccessfulScoutingEvent):
                    prevDestinationQuality = 0;
                    prevDestinationDepoId = -1;
                    prevDestinationGroupId = -1;

                #-- take into account all abandonment as loss of information
                # foundAbandonmentEvent = False;
                # for r in range(len(waggleData)):
                #     if (waggleData[r][0] < loadEventTime):
                #         if (waggleData[r][1] == loaderId and waggleData[r][2] <= 0 and waggleData[r][0] > prevDestQualityFoundAtTime):
                #                 #print( "  >> ABANDONMENT EVENT FOUND at " + str(waggleData[r][0]));
                #                 foundAbandonmentEvent = True;
                #     else:
                #         break;
                #
                # if (foundAbandonmentEvent):
                #     prevDestinationQuality = 0;
                #     prevDestinationDepoId = -1;
                #     prevDestinationGroupId = -1;

                # if (sourceRobotId != prevSourceRobotId):
                #     prevDestinationDepoId = -1;
                #     prevDestinationGroupId = -1;
                #     prevDestinationQuality = 0;

                sourceEffect = math.fabs(prevDestinationQuality - prevSourceQuality);
                destState = quality - prevDestinationQuality;
                changeEffect = quality - prevDestinationQuality;
                #print("t=" + str(data[row][0]) + "->" + str(timeBin) + "  prevSourceQ=" + str(prevSourceQuality) + " prevDestQ=" + str(prevDestinationQuality) + " (at t=" + str(prevDestQualityFoundAtTime) + ") sourceEffect=" + str(sourceEffect));
                #if (loaderId == 3):
                #print("t=" + str(data[row][0]) + " [adj " + str(infoTime) + "] self? " + str(foundBySelf) + " robot " + str(loaderId) + "  prevDepoId=" + str(prevDestinationDepoId) + " nowDepoId=" + str(depoId) + " (at t=" + str(prevDestQualityFoundAtTime) + ") changeEffect=" + str(changeEffect) + "  recruiter id " + str(sourceRobotId) + "  prev recruiter id " + str(prevSourceRobotId));

                #-- note down the event
                if (depoId != prevDestinationDepoId):
                    informationTransferEvents[timeBin][runNo] += 1;
                    informationTransferEventValues[timeBin][runNo] += changeEffect;

                #-- take into account all abandonment as loss of information
                foundAbandonmentEvent = False;
                for r in range(len(waggleData)):
                    if (waggleData[r][0] < loadEvtTime):
                        if (waggleData[r][1] == loaderId and waggleData[r][2] <= 0 and waggleData[r][0] > prevDestQualityFoundAtTime):
                                #print( "  >> ABANDONMENT EVENT FOUND at " + str(waggleData[r][0]));
                                foundAbandonmentEvent = True;
                    else:
                        break;

                if (foundAbandonmentEvent):
                    prevDestinationDepoId = -1;

                if (sourceRobotId != prevSourceRobotId):
                    prevDestinationDepoId = -1;

                if (foundUnsuccessfulScoutingEvent):
                    prevDestinationQuality = 0;
                    prevDestinationDepoId = -1;

                changeEffect = quality - prevDestinationQuality;
                # if (changeEffect > 0):
                #     changeEffect = 1;
                # elif (changeEffect < 0):
                #     changeEffect = -1;
                if (depoId != prevDestinationDepoId):
                    #print(NR_)
                    #print("     Writing down")
                    informationTransferEventValuesB[timeBin][runNo] += changeEffect * 25.0/NR_; #noralise over 25 robots


    #-- evaluate averages
    for t in range(len(informationTransferEventValues)):
         informationTransferEventValueAverages[t] = [crData.getAverage(informationTransferEventValues[t])];

    #-- evaluate regions of the graph for information transfer event values B
    for runNo in range(constants.NUM_RUNS):
        changeIntervalBegunWith = 0;
        changeFoundInThisInterval = False;
        regionAintegration = 0;
        regionCintegration = 0;
        for t in range(len(informationTransferEventValuesB)):
            if (t % timeBinsPerChangeInterval == 0):
                #print("-------- " + str(t*timeInterval_/3600) + " : " + str(informationTransferEventValuesB[t][runNo]));
                changeIntervalBegunWith = t;
                changeFoundInThisInterval = False;

            ticksSinceIntervalBegun = t-changeIntervalBegunWith + 1; #add 1 because e.g. 12th time bin is the 1st 300 seconds from hour 1. Use this number *300 to get num of seconds
            if (t >= timeBinsPerChangeInterval*3): #take into account only 2nd half of the simulations - after the system has stabilised
                #-- capture events in regions A and C

                if (informationTransferEventValuesB[t][runNo] < 0):
                    regionAintegration += informationTransferEventValuesB[t][runNo];
                    #print(informationTransferEventValues[t][runNo]);
                elif (informationTransferEventValuesB[t][runNo] > 0):
                    #print(informationTransferEventValues[t][runNo]);
                    regionCintegration += informationTransferEventValuesB[t][runNo];

                #-- determine when C started
                if (informationTransferEventValuesB[t][runNo] > 0.1 and (not changeFoundInThisInterval)):
                    #print(" CHANGE EFFECT " + str(t) +  "    since " + str(changeIntervalBegunWith) + "=" + str(ticksSinceIntervalBegun) + ": " + str(informationTransferEventValuesB[t][runNo]));
                    changeFoundInThisInterval = True;
                    regionBlengths.append(ticksSinceIntervalBegun);

                #-- end of the interval, write down the intergrations
                if (ticksSinceIntervalBegun == timeBinsPerChangeInterval):
                    #print("INTERVAL EDNED at " + str(t) + "  reg A: " + str(regionAintegration) + "  reg C: " + str(regionCintegration));
                    regionAintegrations.append(regionAintegration);
                    regionCintegrations.append(regionCintegration);
                    regionAintegration = 0;
                    regionCintegration = 0;
                    #-- check if found any region B in this interval - if not, add the full interval length
                    if (not changeFoundInThisInterval):
                        regionBlengths.append(timeBinsPerChangeInterval);
                        #print("  ADDING WHOLE INTERVAL AT " + str(t));

            #print();






    return [informationTransferEvents, informationTransferEventValues, informationTransferEventValuesB, informationTransferEventValueAverages,regionAintegrations, regionBlengths, regionCintegrations];

def getResourceCollectedForParameter(paramName_, paramValues_, scenarios_, directory_,endRow_=constants.MAX_TIME,valueMultipliers_=[], startTime_=1, afterParamNameStr_=""):
    """
    Get a 2-D list where:
    
    0th element is a is a NxM list of resource collected for a changing parameter
    where N=num of scenarios, M = num of parameter values.
    paramName_ is the parameter name as it appears in the path.
    Each element is a list with total resource collected in each run.
    
    1st element is a is a NxM list of resource collected for a changing parameter
    where N=num of scenarios, M = num of parameter values.
    paramName_ is the parameter name as it appears in the path.
    Each element is a list with resource collected during each second.
    
    Value multipliers: M-D list of values that each data point gets multiplied by.
    E.g pass list with 1/NUM_ROBOTS values for per robot collected resource
    """
    print(">>> Get resource collected for " + directory_ + " " + paramName_ + " " + afterParamNameStr_ + " t=" + str(startTime_) + " - " + str(endRow_));
    resourceOverTimeArray = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
    finalResourceArray = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
   
    if (len(valueMultipliers_)==0):
        valueMultipliers_ = [1.0 for i in range(len(paramValues_))];

    for sc in range(len(scenarios_)):
        #print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_global.txt", "\t", True, True,endRow_, startRow_=startTime_);
                #-- if intersted in resource collected between t1 and t2, subtract amount collected at t1.
                toSubtract = data[0][1];
                if (startTime_ > 1):
                    for i in range(len(data)):
                        data[i][1] -= toSubtract;
                resourceOverTimeArray[sc][val] = crData.getListAddition(resourceOverTimeArray[sc][val], crData.columnToArray(data,1,(1.0/constants.NUM_RUNS)*valueMultipliers_[val]));
                #-- append the final collected resource value
                finalResourceArray[sc][val].append(data[len(data)-1][1]*valueMultipliers_[val]);
            
    return [finalResourceArray, resourceOverTimeArray];



def getPelletsForParameter(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME):
    """
    Get a NxM list of pellets on the ground where N = num of scenarios,
    M = num of parameter values.
    Each element is a list with number of pellets during each second.   
    """
    print(">>> Get pellets number for " + paramName_);
    retArrayOverTime = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_global.txt", "\t", True, True,maxRows_);
                retArrayOverTime[sc][val] = crData.getListAddition(retArrayOverTime[sc][val], crData.columnToArray(data,2,1.0/constants.NUM_RUNS));
    return retArrayOverTime;

def getRobotStatesForParameter(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get a 2D list, where each element is a NxM list of resource collected for a changing parameter
    where N is the number of scenarios, M is the number of paramValues_.
    paramName_ is the parameter name as it appears in the path.
    
    0th index: Each element is a list with a sublist of percentages of robots in different states during each second
    1st index: each element is a 16xR list % (0-100) of robots for each state in R runs.
    """
    print(">>> Get robot states for " + paramName_ + afterParamNameStr_);
    MAX_STATES = 16;
    retArrayNumsOverTme = [[[[] for j in range(MAX_STATES-3)] for i in range(len(paramValues_))] for k in range(len(scenarios_))];
    retArrayNums = [[[[] for j in range(MAX_STATES-3)] for i in range(len(paramValues_))] for k in range(len(scenarios_))];

    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_robots.txt", "\t", True, True,maxRows_);
                stateIndexCounter = 0;
                for state in range(MAX_STATES):
                    if (state != 7 and state != 8 and state!= 10):
                        #print(str(state) + "  " + str(stateIndexCounter) + "  " + str(len(retArrayNumsOverTme[sc][val])));
                        retArrayNumsOverTme[sc][val][stateIndexCounter] = crData.getListAddition(retArrayNumsOverTme[sc][val][stateIndexCounter], crData.columnToArray(data[0:constants.MAX_TIME],state+1,1.0/constants.NUM_RUNS));
                        retArrayNums[sc][val][stateIndexCounter].append(sum(crData.columnToArray(data[0:constants.MAX_TIME],state+1,100.0/(constants.NUM_RUNS))));
                        stateIndexCounter += 1;
                    #print(state);
                    #if (state == 0):
                        #print(retArray[index][state]);
    return [retArrayNumsOverTme, retArrayNums];


def getEnergySpent(paramName_, paramValues_, scenarios_, directory_, numRobots_,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get a NxM list of energy spent by robots PER ROBOT
    where N is the number of scenarios, M is the number of paramValues_.
    paramName_ is the parameter name as it appears in the path.
    Each element is a NUM_RUNS-D list with energy spent by all robots during the runs
    """
    print(">>> Get energy spent for " + paramName_);
    retArray = [[[0 for r in range(constants.NUM_RUNS)] for i in range(len(paramValues_))] for k in range(len(scenarios_))];
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            numLaden = 0;
            for runNo in range(constants.NUM_RUNS):
                #restersInRun = 0;
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ +"/Run" + str(runNo) + "_robots.txt", "\t", True, True,maxRows_);
                for row in range(len(data)):
                    #-- add up number of energy units per job done
                    retArray[sc][val][runNo] += 1*data[row][1]; #scouts
                    retArray[sc][val][runNo] += 1*data[row][2]; #foragers
                    retArray[sc][val][runNo] += 1*data[row][3]; #wg dancers
                    retArray[sc][val][runNo] += 1*data[row][4]; #observers 
                    retArray[sc][val][runNo] += 0*data[row][5]; #resters
                    retArray[sc][val][runNo] += 1*data[row][6]; #unloaders
                    retArray[sc][val][runNo] += 1*data[row][7]; #td dancers
                    retArray[sc][val][runNo] += 1*data[row][8]; #encounter samplers
                    retArray[sc][val][runNo] += 1*data[row][9]; #wakers
                    retArray[sc][val][runNo] += 1*data[row][10]; #deposit samplers (beggars)
                    retArray[sc][val][runNo] += 1*data[row][11]; #inspectors
                    if (len(data[row]) > 12):
                        retArray[sc][val][runNo] += 1*data[row][12]; #loaders foragers
                        retArray[sc][val][runNo] += 1*data[row][13]; #laden foragers
                        retArray[sc][val][runNo] += 1*data[row][14]; #loaders scouts
                        retArray[sc][val][runNo] += 1*data[row][15]; #laden scouts
                        retArray[sc][val][runNo] += 1*data[row][16]; #unsuccessful foragers / scouts returning
                    numLaden += data[row][13] + data[row][15];
            #print("laden: " + str(numLaden));
               
    return retArray;


def getResourceCollectedForEnergy(paramName_, paramValues_, scenarios_, directory_, energyCapPerRobot_, maxRows_=constants.MAX_TIME):
    """
    Get a 1-D list where:
    
    0th element is a is a NxM list of resource collected for a changing parameter
    where N=num of scenarios, M = num of parameter values.
    paramName_ is the parameter name as it appears in the path.
    Each element is a list with total resource collected in each run.
    
    Value multipliers: M-D list of values that each data point gets multiplied by.
    E.g pass list with 1/NUM_ROBOTS values for per robot collected resource
    """
    print(">>> Get resource collected for " + paramName_ + ", energy cap " + str(energyCapPerRobot_));
    finalResourceArray = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                energySpentInRun = 0;
                timeEnergyRanOut = maxRows_;
                #-- get energy data and find out when it ran out
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_robots.txt", "\t", True, True,maxRows_);
                for row in range(len(data)):
                    #-- imagine all robots just spent basic energy 1
                    energySpentInRun += 1;
                    #-- deduct energy for robots that were sleeping
                    energySpentInRun -= data[row][5];
                    if (energySpentInRun > energyCapPerRobot_):
                        timeEnergyRanOut = row-1;
                        break;
                #-- get how much resource was collected at the time of running out
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_global.txt", "\t", True, True,timeEnergyRanOut);
                
                #-- append the final collected resource value
                finalResourceArray[sc][val].append(data[len(data)-1][1]);
                
           # print("E ran out at t=" + str(timeEnergyRanOut) + "   res collected " + str(finalResourceArray[sc][val]));
                
               
    return [finalResourceArray];

def getLoadEventsGroupsB(scenarios_, directory_,maxRows_=constants.MAX_TIME):
    """
    Get a 3D list where:
    
    1st dimension is N-D a list containing a G-D list where N is number of scenarios, G is number of groups,
    averaged over number of runs
    
    2nd dimension  is a NxG-D list where each index is a 2D list containing
    [time,groupId]
    
    3rd dimension is a NxG-D list where each element is a 35-D list
    containing numbers of load events of group G in each 100-second step.
    """
    
    retArrayNums = [[] for k in range(len(scenarios_))];
    retArrayScatter = [[] for k in range(len(scenarios_))];
    retArrayBins = [[] for k in range(len(scenarios_))];
    
    for sc in range(len(scenarios_)):
        print(">>> Get load events groups for " + scenarios_[sc]);
        for runNo in range(constants.NUM_RUNS):
            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
            for row in range(len(data)):
                
                #print(str(data[row][0]) + ": " + str(data[row][1]));
                #-- calculate time bin number
                timeBin = int(min([math.floor(data[row][0]/100),(constants.MAX_TIME/100)-1]));
                groupId = data[row][11];
                #-- make sure there are arrays for groupId
                if (len(retArrayNums[sc]) < groupId):
                    retArrayNums[sc].append([]);
                    retArrayScatter[sc].append([[],[]]);
                    retArrayBins[sc].append([0 for k in range(constants.MAX_TIME/100)]);               
                    
                #print(str(data[row][0]) + ": " + str(timeBin));
                #-- sort the event to a bin
                retArrayNums[sc][groupId] += 1.0/constants.NUM_RUNS;
                retArrayScatter[sc][groupId][0].append(data[row][0]); #-- time
                retArrayScatter[sc][groupId][1].append(data[row][1]); #-- value
                retArrayBins[sc][groupId][timeBin] += 1.0/constants.NUM_RUNS;                        
          
    return [retArrayNums,retArrayScatter, retArrayBins]; 

def getLoadEvents(paramName_, paramValues_, scenarios_, directory_, NR_, fD_,maxRows_=constants.MAX_TIME, afterParamNameStr_=""):
    """
    Get a 7D array where each element is a
    Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    
    The 0th 2D array containts a list containing times how long it took a robot to reach a deposit it previously gathered from. 
    
    The 1st 2D array contains a NUM_RUNS-D listcontaining how many times subsequent laods from the same group / deposit were made.
    
    The 2d 2D array contains a list of times how long it took a robot to start gathering from a new deposit
    
    the 3rd 2D array contains a NUM_RUNS-D list containing how many times a robot started gathering from a new deposit.
    
    The 4th is F-D array where F=maxTime/fD_. Each element contains a list of times of the first load in a fD_ interval
    
    The 5th is a NUM-RUNS-D array containing total number of loads in a run
    
    The 6th is a list of Ms, where M is number of times a single robot loaded in a run.
    """
    print(">>> Get load events for " + directory_ + " " + paramName_ + afterParamNameStr_ );
    retArraySubseqTimes = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArraySubseqNums = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayReactivateTimes = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayReactivateNums = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayNumLoads = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayNumLoadsPerRobot = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    
    #-- adjust fD_ to seconds rather than ticks
    if (type(fD_) is str):
        fD_=0;
    fD_ /= 10;
    numOfFDIntervals = 1;
    if (fD_ > 0):
        numOfFDIntervals = constants.MAX_TIME/fD_;
    #print("  FD intervals: " + str(numOfFDIntervals));
    retArrayFirstLoadTimes = [[[[] for f in range(numOfFDIntervals)] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                
                numOfSubsequentLoadingsInARun = 0;
                numOfReactivatedLoadingsInARun = 0;
                numOfLoadsInARun = 0;
                robotLoadsInARun = [0 for nr in range(NR_)];
                #--- robots last loads element: [time, groupId]
                robotsLastLoads = [[0,-1] for nr in range(NR_)];
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                depositChangeData = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_depositRenewEvents.txt", "\t", True, True,maxTime_=maxRows_);
                outputStatus = "";
                lastFDInterval = -1;
               
                
                for row in range(len(data)):
                    numOfLoadsInARun += 1;
                    robotId = int(data[row][8]); 
                    fDInterval = 0;
                    if (fD_ > 0):
                        fDInterval = int(math.floor(data[row][0]/fD_));
                    groupId = data[row][11];
                    if (fDInterval > numOfFDIntervals-1):
                        fDInterval = numOfFDIntervals-1;
                        
                    if (robotsLastLoads[robotId][0] == 0):
                        #-- if last run was at dummy t=0, this is a first gathering, don't cout it but remember the time and deposit id
                        outputStatus = "IGNORE"
                        #numOfReactivatedLoadingsInARun += 1;
                    elif((data[row][11] != robotsLastLoads[robotId][1]) or (fD_>0 and(math.floor(robotsLastLoads[robotId][0]/fD_) != fDInterval))):
                        #-- if another group or if the same group that moved since last load by this robot, count this as reactivation to another group.
                        if (data[row][7] == 1.0):
                            retArrayReactivateTimes[sc][val].append(data[row][0] - robotsLastLoads[robotId][0]);
                            numOfReactivatedLoadingsInARun += 1;
                        
                        if (fD_>0):
                            outputStatus = "REACTIVATION t=" + str(data[row][0] - robotsLastLoads[robotId][0]) + ": groupid now " + str(data[row][11]) + "  last groupid " + str(robotsLastLoads[robotId][1]) + "   time bin now " + str( math.floor(data[row][0]/fD_)) + " last time bin " + str(math.floor(robotsLastLoads[robotId][0]/fD_));
                        else:
                            outputStatus = "REACTIVATION t=" + str(data[row][0] - robotsLastLoads[robotId][0]) + ": groupid now " + str(data[row][11]) + "  last groupid " + str(robotsLastLoads[robotId][1]);
                        
                    else:
                        #-- add to subseq loads data
                        retArraySubseqTimes[sc][val].append(data[row][0] - robotsLastLoads[robotId][0]);
                        outputStatus = "SUBSEQ LOOAD " + str( data[row][0] - robotsLastLoads[robotId][0] );
                        numOfSubsequentLoadingsInARun +=1;
                        
                    #-- remember this load
                    robotsLastLoads[robotId][0] = data[row][0];
                    robotsLastLoads[robotId][1] = groupId;
                    #print(str(robotId) + "   t " + str(robotsLastLoads[robotId][0]) + "   group " + str(robotsLastLoads[robotId][1]) + " >>> " + outputStatus);  
                    robotLoadsInARun[robotId] += 1;
                    
                    #-- find out if this is the first load of this fD interval
                    if (fDInterval != lastFDInterval):
                        #-- find out if this is load from the group that was moved
                        loadFromRenewedGroup = False;
                        if (fDInterval == 0):
                            loadFromRenewedGroup = True;
                        elif (groupId == depositChangeData[fDInterval-1][1]):
                            loadFromRenewedGroup = True;
                        
                        if (loadFromRenewedGroup): 
                            #-- new FD interval, remember the time it took to discover a new deposit
                            retArrayFirstLoadTimes[sc][val][fDInterval].append(data[row][0] - fDInterval*fD_);
                            #print("RUN" + str(runNo) + " t=" + str(data[row][0]) + "  fD interval " + str(fDInterval) + " at " + str(fDInterval*fD_) + "   time took to discover " + str(data[row][0] - fDInterval*fD_));
                            #-- fill in max time (interval length) for the previous intervals if nothing was registered in them
                            for k in range(fDInterval-lastFDInterval-1):
                                #print("FILLING MAX LENGTH FOR INTERVAL " + str(lastFDInterval+k+1));
                                retArrayFirstLoadTimes[sc][val][lastFDInterval+k+1].append(fD_);
                            lastFDInterval = fDInterval;
                        
                retArraySubseqNums[sc][val].append(numOfSubsequentLoadingsInARun);
                retArrayReactivateNums[sc][val].append(numOfReactivatedLoadingsInARun);
                retArrayNumLoads[sc][val].append(numOfLoadsInARun);
                for robotId in range(NR_):
                    retArrayNumLoadsPerRobot[sc][val].append(robotLoadsInARun[robotId]);
            #if (len(retArrayTimes[sc][va]) == 0):  
    return [retArraySubseqTimes,retArraySubseqNums,retArrayReactivateTimes,retArrayReactivateNums,retArrayFirstLoadTimes,retArrayNumLoads,retArrayNumLoadsPerRobot];


def getInfoBetweenLoadUnload(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get times between unload start time and last load. 
    """
    print(">>> Get time between unload and load " + paramName_);
    retArrayTimes = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
        
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                
                #--- robots last loads element: [time, groupId]
                #robotsLastLoads = [[0,-1] for nr in range(NR_)];
                dataUnloads = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_unloadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);

                for row in range(len(data)):
                    robotId = int(data[row][8]); 
                    loadTime = data[row][0];
                    #-- find the nearest unload event
                    #print(row);
                    for unloadRow in range(len(dataUnloads)):
                        #print("  " + str(unloadRow));
                        unloadStarted = dataUnloads[unloadRow][0] - dataUnloads[unloadRow][2]/10; #the duration is in ticks, the time is in seconds
                        if (unloadStarted > loadTime and int(dataUnloads[unloadRow][1]) == robotId):
                            #-- note down the event
                            if (unloadStarted - loadTime > 100):
                                retArrayTimes[sc][val].append(unloadStarted - loadTime);
                            #print("  >>> Robot " + str(robotId) + "  load at " + str(loadTime) + "  unl at " + str(unloadStarted) + "   T=" + str(unloadStarted - loadTime));
                            break;
                   
    return [retArrayTimes];



def getLoadEventsRecruitment(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a list with NUM_RUNS length containing percentages 
    of load events done due to recruitment per run.
    """
    print(">>> Get load events recruitment for " + paramName_ + " " + afterParamNameStr_);
    retArrayNums = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                recruitmentLoadEventsInRun = 0;
                for row in range(len(data)):
                    #-- make sure only evens till t=5400 taken into account
                    if (data[row][0] <= constants.MAX_TIME):
                        #print(str(data[row][0]) + "  " + str(data[row][7]))
                        if (data[row][7] == 0.0):
                            recruitmentLoadEventsInRun += 1.0/len(data);
                #print(str(val) + "  " + str(recruitmentLoadEventsInRun))
                retArrayNums[sc][val].append(recruitmentLoadEventsInRun);           
                           
                    
    return retArrayNums;

def getLoadEventsGroups(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME,startTime_=0, endTime_=constants.MAX_TIME,sortByQuality_=False,afterParamNameStr_=""):
    """
    Get a 2D list.
    The 0th index, Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a list with NUM_RUNS length containing percentages 
    of number of collections from different groups in that run.
    
    The 1st index, get an NxM matrix as well, where each element contains a list of std 
    of how the percentages differed in each run.

    The 2nd index, get a NxMxGxtxNUM_RUNS matrix, where G is number of groups and t is time. Each element
    contains NUM_RUNS-long list of loadings from a particular group.

    The 3rd index, get an NxM matrix, with G=num of groups elements containing NUM_RUNS
    records of actual number of loadings per run, from groups G.
    """
    print(">>> Get load events groups for " + directory_ + " / " + paramName_ + " " + afterParamNameStr_ + "(t=" + str(startTime_) + " - " + str(endTime_) + ")" );
    retArrayPercentages = [[[0] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayNums =        [[[0] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayStds = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayNumsOverTime = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];

    for sc in range(len(scenarios_)):
        for val in range(len(paramValues_)):
            qualities= [];
            if (sortByQuality_):
                #-- prepare array that will index group id by quality, based on qualities from 1st 3 runs
                for runNo in range(3):
                    data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                    for row in range(len(data)):
                        q = data[row][1];
                        if not (q in qualities):
                            #-- quality not added yet - add it
                            qualities.append(q);
                #-- order list so that the lower qualities are at the beginning
                qualities = sorted(qualities, key=float);
                #print("Qualities found: " + str(qualities));
            else:
                groupIds = [];
                #-- prepare array that will index group id by quality, based on qualities from 1st 3 runs
                for runNo in range(3):
                    data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                    for row in range(len(data)):
                        id = data[row][11];
                        if not (id in groupIds):
                            #-- quality not added yet - add it
                            groupIds.append(id);
                #-- order list so that the lower qualities are at the beginning
                groupIds = sorted(groupIds, key=float);
                #print("Group IDS found: " + str(groupIds));
            outp = "";
            runsWithRecords = 0;

            for runNo in range(constants.NUM_RUNS):
                #print("---- run " + str(runNo));
                groupNumsInRun = [];
                if (sortByQuality_):
                    groupNumsInRun = [0.00001 for i in range(len(qualities))]; #begin with a small value, so that groups show up on the graph as empty spaces if no records
                else:
                    groupNumsInRun = [0.00001 for i in range(len(groupIds))]; #begin with a small value, so that groups show up on the graph as empty spaces if no records
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                numOfRecords = 0;
                for row in range(len(data)):
                    time = data[row][0];
                    if (time >= startTime_ and time < endTime_):
                        numOfRecords += 1;
                        #-- group id is either the actual group id or quality group id
                        groupId = int(data[row][11]);
                        if (sortByQuality_):
                            oldGId = groupId + 0;
                            groupId = qualities.index(data[row][1]);
                            if (groupId != oldGId):
                                #print("t=" + str(time) + " Q " + str(data[row][1]) + "  id " + str(groupId) + "  old " + str(oldGId));
                                outp += "!!"

                        #-- find out if the group can be registered
                        while (len(groupNumsInRun) <= groupId):
                            groupNumsInRun.append(0);
                        while (len(retArrayNumsOverTime[sc][val]) <= groupId):
                            #print("! new group " + str(groupId) + " at RUN " + str(runNo) + "  T " + str(time));
                            retArrayNumsOverTime[sc][val].append([[0 for r in range(constants.NUM_RUNS)] for t in range(maxRows_)]); #append txNUM_RUNS list
                            
                        #-- register one more collection from this group
                        groupNumsInRun[groupId] += 1;

                        #-- register +1 loading for this time t, for this run
                        retArrayNumsOverTime[sc][val][groupId][int(time)][runNo] += 1;
                        #print(retArrayNumsOverTime[sc][val][groupId][int(time)][runNo]);

                #-- normalise group nums
                groupPercentagesInRun = []
                recordsCheck = 0;
                for i in range(len(groupNumsInRun)):
                    recordsCheck += groupNumsInRun[i];
                    if (numOfRecords > 0):
                        groupPercentagesInRun.append(groupNumsInRun[i] / float(numOfRecords) );



                #-- get the std of how the percentages differed in this particular run
                retArrayStds[sc][val].append(numpy.std(groupPercentagesInRun))
              
                if (numOfRecords > 0):
                    runsWithRecords += 1;

                #-- just add to the meta list - normalisation will be performed later 
                retArrayPercentages[sc][val] = crData.getListAddition(retArrayPercentages[sc][val], groupPercentagesInRun);
                retArrayNums[sc][val] = crData.getListAddition(retArrayNums[sc][val], groupNumsInRun);

                #retArrayNums[sc][val].append(groupNumsInRun);
            #print("num of runs with records " + str(runsWithRecords));

            #-- normalise percentages based on how many records with non-zero values, so that each record for a certain
            #   deposit has average number of loadings per N runs, not total
            for i in range(len(retArrayPercentages[sc][val])):
                if (runsWithRecords > 0):
                    retArrayPercentages[sc][val][i] /= float(runsWithRecords);
                    retArrayNums[sc][val][i] /= float(runsWithRecords);
                #print(str(val) + "  " + str(retArrayNums[sc][val])); 
            #print(outp);


            #-- swap rows and columns of the retArrayNums[sc][val] so that the records are ordered by group, not by runs
            #retArrayNums[sc][val] = crData.columnsToRows(retArrayNums[sc][val]);

    return [retArrayPercentages, retArrayStds, retArrayNumsOverTime,retArrayNums];


def getWaggleDanceGroups(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME, startTime_=0, endTime_=constants.MAX_TIME,sortByQuality_=False):
    """
    Get a 2D list.
    The 0th index, Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a G-D list containing times of waggle dances for groups G, averaged
    for number of runs.
    
    The 1st index, get an NxM matrix as well, where each element contains a list of std 
    of how the times differed in each run.
    """
    print(">>> Get waggle dance groups for " + paramName_);
    retArrayNums = [[[0] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayStds = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            qualities= [];
            if (sortByQuality_):
                #-- prepare array that will index group id by quality, based on qualities from 1st 3 runs
                for runNo in range(3):
                    data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                    for row in range(len(data)):
                        q = data[row][1];
                        if not (q in qualities):
                            #-- quality not added yet - add it
                            qualities.append(q);
                #-- order list so that the lower qualities are at the beginning
                qualities = sorted(qualities, key=float);
                print("Qualities found: " + str(qualities));
            outp = "";   
            for runNo in range(constants.NUM_RUNS):
                groupNumsInRun = [];
                dataLoadEvents = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_loadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_wdEvents.txt", "\t", True, True,maxTime_=maxRows_);
                for row in range(len(data)):
                    durationOfWD = data[row][2];
                    timeOfWD = data[row][0];
                    if (durationOfWD > -1 and timeOfWD >= startTime_ and timeOfWD < endTime_):
                        #-- figure out what the robot's group id was when it last time loaded:
                        
                        
                        loadEventGroupId = -1;
                        loadEventTime = -1;
                        for rowB in range(len(dataLoadEvents)):
                            if (dataLoadEvents[rowB][0] < timeOfWD):
                                #-- compare robot ids:
                                if (dataLoadEvents[rowB][8] == data[row][1]):   
                                    loadEventGroupId = int(dataLoadEvents[rowB][11]);
                                    loadEventTime = dataLoadEvents[rowB][0];
                                    if (sortByQuality_):
                                        oldGId = loadEventGroupId + 0;
                                        loadEventGroupId = qualities.index(dataLoadEvents[rowB][1]);
                                        if (loadEventGroupId != oldGId):
                                            #print("Q " + str(dataLoadEvents[rowB][1]) + "  id " + str(loadEventGroupId) + "  old " + str(oldGId));
                                            outp += "!!"
                            else:
                                continue;
                        #print(" waggle dance time " + str(timeOfWD) + " loaded at " + str(loadEventTime) + "  from " + str(loadEventGroupId));
                      
                        
                        #-- find out if the group can be registered
                        while (len(groupNumsInRun) <= loadEventGroupId):
                            groupNumsInRun.append(0);
                       
                        
                        #-- register one more waggle dance for this group
                        groupNumsInRun[loadEventGroupId] += durationOfWD / constants.NUM_RUNS;  
                           
                    
                #-- get the std of how the percentages differed in this particular run
                #print (numpy.std(groupNumsInRun));
                retArrayStds[sc][val].append(numpy.std(groupNumsInRun))
                #print(retArrayStds[sc][val]);
                #-- normalise the percentages by group Id for num runs
                retArrayNums[sc][val] = crData.getListAddition(retArrayNums[sc][val], [x/constants.NUM_RUNS for x in groupNumsInRun]);
                #print(str(val) + "  " + str(retArrayNums[sc][val])); 
            #print(outp);                         
    return [retArrayNums, retArrayStds]; 

def getScoutingEvents(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME, afterParamNameStr_=""):
    """
    Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a list with NUM_RUNS length containing percentages 
    of scoutings resulting in finding a deposit.
    """
    print(">>> Get scouting events for " + paramName_ + " " + afterParamNameStr_);
    retArrayNums = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_scoutingEvents.txt", "\t", True, True,maxTime_=maxRows_);
                successfullScoutsInRun = 0;
                for row in range(len(data)):
                    #-- make sure only evens till t=5400 taken into account
                    if (data[row][0] <= constants.MAX_TIME):
                        #print(str(data[row][0]) + "  " + str(data[row][2]))
                        if (data[row][2] == 1.0):
                            successfullScoutsInRun += 1.0/len(data);
                #print(str(val) + "  " + str(recruitmentLoadEventsInRun))
                retArrayNums[sc][val].append(successfullScoutsInRun);           
                           
                    
    return retArrayNums;

def getNeighbSearchEvents(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get a 2D list.
    0th element:
    Get a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a list with NUM_RUNS length containing percentages 
    of successful neighbourhood searches.
    
    1st element:
    Get a M list where matrix where M = num of parameter values.
    Each element is a 2D list containing N list where N is number of scenarios.
    In the 0th index of the 2D list the numbers represent number of successful
    searches, the 1st index unsuccessful searches. This data structure fits crGraphs.createStackedBar
    """
    print(">>> Get neighb search events for " + paramName_ + afterParamNameStr_);
    retArrayNums = [[[0 for i in range(len(scenarios_))],[0 for i in range(len(scenarios_))]] for j in range(len(paramValues_))];
    retArrayPercentages = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    for val in range(len(paramValues_)):
        print(paramValues_[val]);
        for sc in range(len(scenarios_)):
            for runNo in range(constants.NUM_RUNS):
                successfulInRun = 0;
                unsuccessfulInRun = 0;
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_neighbSearchEvents.txt", "\t", True, True,maxTime_=maxRows_);
                for row in range(len(data)):
                    #-- increase a bin count based on whetheer it was successful or not
                    if (data[row][2] == 1.0):
                        successfulInRun += 1;
                    else:
                        unsuccessfulInRun += 1;
                #-- save in common array
                retArrayNums[val][0][sc] += successfulInRun;
                retArrayNums[val][1][sc] += unsuccessfulInRun;
                #-- get percentage of successful searches
                totalSearches = successfulInRun + unsuccessfulInRun;
                if (totalSearches > 0):
                    retArrayPercentages[sc][val].append(successfulInRun / float(totalSearches));
                else:
                    retArrayPercentages[sc][val].append(0);
                
    return [retArrayPercentages, retArrayNums];


def getUnloadTime(paramName_, paramValues_, scenarios_, directory_, onlyAboveValue_=0,maxRows_=constants.MAX_TIME,afterParamNameStr_=""):
    """
    Get a 2D list.
    
    1st element is a NxM matrix where N = num of scenarios, M = num of parameter values.
    Each element is a list containing unload times in all runs.
    
    2nd element is a NxMxT matrix where T = num of seconds a run lasted. Each element is average unload time at 
    that second.
    """
    print(">>> Get unload time for " + paramName_);
    retArrayNums = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_))];
    retArrayOverTime = [[[0 for t in range(constants.MAX_TIME+1)] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
    tempArrayOverTime = [[[[] for t in range(constants.MAX_TIME+1)] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + afterParamNameStr_ + "/Run" + str(runNo) + "_unloadEvents.txt", "\t", True, True,maxTime_=maxRows_);
                for row in range(len(data)):
                    if (data[row][2] != 0): #ignore 0 unloading time, these are just unsuccessful scouts / foragers returning
                        if (data[row][2] > onlyAboveValue_): 
                            retArrayNums[sc][val].append(data[row][2]);
                            tempArrayOverTime[sc][val][int(data[row][0])].append(data[row][2]); # write into a list in temp array
    
            #-- convert temp array into averages, based on how many times unload events were noted down for each second
            for t in range(constants.MAX_TIME):
                retArrayOverTime[sc][val][t] = crData.getAverage(tempArrayOverTime[sc][val][t]);
            
    return [retArrayNums,retArrayOverTime];

def getUnloadTimeOverTime(paramName_, paramValues_, scenarios_, directory_,maxRows_=constants.MAX_TIME):
    """
    Get a NxM list of pellets on the ground where N = num of scenarios,
    M = num of parameter values.
    Each element is a list with number of pellets during each second.   
    """
    print(">>> Get pellets number for " + paramName_);
    retArrayOverTime = [[[] for i in range(len(paramValues_))] for j in range(len(scenarios_)) ];
    
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for val in range(len(paramValues_)):
            for runNo in range(constants.NUM_RUNS):
                data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+directory_+"/" + scenarios_[sc] +"_" + paramName_ + str(paramValues_[val]) + "/Run" + str(runNo) + "_global.txt", "\t", True, True,maxRows_);
                retArrayOverTime[sc][val] = crData.getListAddition(retArrayOverTime[sc][val], crData.columnToArray(data,2,1.0/constants.NUM_RUNS));
    return retArrayOverTime;

def plotCollectedResource(data_,fileName_,experimentDir_, legendLabels_, scenarios_,
                          markers_,
                          extraMarkers_,
                          boxPlotMarkers_,
                          separateScenarios_=True):
    xLabel = "Time";
    yLabel = "Resource collected"
    time = numpy.linspace(0, constants.MAX_TIME, constants.MAX_TIME);
    numOfValues = len(data_[1][0]);
    totalArrayTimeLine = [[] for i in range(len(scenarios_) * numOfValues)];
    totalArrayBoxPlots = [[] for i in range(len(scenarios_) * numOfValues)];
    index = 0;
    for sc in range(len(scenarios_)):
        
        if (separateScenarios_):
            #-- create time line plot
            fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_+"_" + scenarios_[sc] + ".png";
            crGraphs.createPlot(time, data_[1][sc], xLabel_=xLabel, yLabel_ = yLabel,legendLabels_=legendLabels_, markers_=markers_,extraMarkers_=extraMarkers_,extraMarkersStep_=500,legendCols_=3,fileName_=fileName,xLimMin_=0,xLimMax_=constants.MAX_TIME,yLimMin_=0,yLimMax_=100);
        
            #-- create box plot
            fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_+"_" + scenarios_[sc] + "_box.png";
            #crGraphs.createPlot(range(len(legendLabels_)),[data_[0][sc]],xLabel,"",xTickLabels_=legendLabels_,boxPlots_=True,markers_=boxPlotMarkers_,legendCols_=3,fileName_=fileName,yLimMin_=0,yLimMax_=100);
        else:
            for val in range(numOfValues):
                totalArrayTimeLine[index+val] = data_[1][sc][val];
                totalArrayBoxPlots[index+val] = data_[0][sc][val];
            index+=numOfValues;
            
    
    if (separateScenarios_ == False):
        #-- create time line plot
        fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_ + ".png";
        crGraphs.createPlot(time, totalArrayTimeLine, xLabel_=xLabel, yLabel_ = yLabel,legendLabels_=legendLabels_, markers_=markers_,extraMarkers_=extraMarkers_,extraMarkersStep_=500,legendCols_=3,fileName_=fileName,xLimMin_=0,xLimMax_=constants.MAX_TIME,yLimMin_=0,yLimMax_=100);
    
        #-- create box plot
        fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_+ "_box.png";
        #crGraphs.createPlot(range(len(legendLabels_)),[totalArrayBoxPlots],xLabel,"",xTickLabels_=legendLabels_,boxPlots_=True,markers_=boxPlotMarkers_,legendCols_=3,fileName_=fileName,yLimMin_=0,yLimMax_=100);
        
      
def plotCollectedResourceMatrix(data_,fileName_,xAxisName_,xAxisVals_, yAxisName_, yAxisVals_, experimentDir_):
    
    matrixPlotData = [[] for j in range(len(data_[0]))];
    for i in range(len(data_[0])):
        for j in range(len(data_[0][i])):
            matrixPlotData[i].append(crData.getMedian(data_[0][i][j]));
           
    #print(matrixPlotData);
    fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_ + "_matrix.png"; 
    crGraphs.createMatrixPlot(matrixPlotData, xAxisName_, yAxisName_, xAxisVals_, yAxisVals_, fileName_=fileName,vmax_=100);
   
        
def plotLoadEventQuality(data_, fileName_, experimentDir_):
    """
    Plot scatter plot of quality, plotting > 0.5 first, then < 0.5
    """
    xLabel = "Time";    
    yLabel = "Load event quality"
    markers = ['b.','r.'];
    
    fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_;
    figure = crGraphs.createPlot(data_[1][0][0],data_[1][0][1],xLabel,yLabel,markers_=[markers[0]],legendCols_=3,fileName_=fileName,yLimMin_=0,yLimMax_=2,xLimMin_=0,xLimMax_=constants.MAX_TIME,holdFigure_=True);
    crGraphs.createPlot(data_[1][1][0],data_[1][1][1],xLabel,yLabel,markers_=[markers[1]],legendCols_=3,fileName_=fileName,yLimMin_=0,yLimMax_=2,xLimMin_=0,xLimMax_=constants.MAX_TIME,figure_=figure);
    
def plotLoadEventQualityTimeBins(data_, fileName_, experimentDir_):
    """
    Plot numbers of load events in each time bin based on quality
    """
    print(data_[0][1]);
    print(data_[0][0]);
    print(len(data_[1][0]));
    goodEventsPercentage = round(100 * data_[0][0] / (data_[0][0] + data_[0][1]));
    xLabel = "Time";    
    yLabel = "# of load events (blue = " + str(goodEventsPercentage) + "%)"
    markers = ['b-','r-'];
    fileName = constants.BASE_FILE_PATH+"/"+experimentDir_+fileName_;
    figure = crGraphs.createPlot(range((constants.MAX_TIME/100)),data_[2][0],xLabel,yLabel,markers_=[markers[0]],legendCols_=3,fileName_=fileName,xLimMin_=0,xLimMax_=(constants.MAX_TIME/100),holdFigure_=False);
    crGraphs.createPlot(range((constants.MAX_TIME/100)),data_[2][1],xLabel,yLabel,markers_=[markers[1]],legendCols_=3,fileName_=fileName,xLimMin_=0,xLimMax_=(constants.MAX_TIME/100),figure_=figure);
    
def plotScenarioByParam(data_,yLabel_,yMax_,paramVals_,legendLabels_,scenarios_,fileName_, experimentDir_,
                        markers_=['gs-','rs-','bs-','ms-','ks-','cs-','ys-'],
                        boxPlots_=True,legendCols_=4,plotStds_=False,plotAverages_=False,xLabel_="",
                        size_=(14,6), doWilcoxon_=False,
                        yMin_=0):
    """
    Accepts data in form of NxM matrix where N is number of scenarios,
    M is number of param values. Each element should contain a list of numbers
    that represent some measure and should be NUM_RUNS long.
    
    plotStds_ - set to true if should plot std of the lists rather than box plots
    """
    if (plotStds_ or plotAverages_):
        boxPlots_=False;
        
    fileName = constants.BASE_FILE_PATH+"/" + experimentDir_ + "_" + fileName_ +".png";        
    colors = [];
    xTickLabels = scenarios_;
    groups = range(len(xTickLabels));
    data = [];
    for val in range(len(paramVals_)):
        temp = [];
        for sc in range(len(scenarios_)):
            if (plotStds_):
                temp.append(numpy.std(data_[sc][val]));
            elif (plotAverages_):
                temp.append(numpy.mean(data_[sc][val]));
            else:
                temp.append(data_[sc][val]);
        data.append(temp);
                 
    crGraphs.createPlot(groups, data, xLabel_, yLabel_, legendLabels_, markers_, colors, xTickLabels, boxPlots_, fileName_=fileName,yLimMin_=yMin_,yLimMax_=yMax_,legendCols_=legendCols_,size_=size_, doWilcoxon_=doWilcoxon_);

             
    