/* Author: Matt modified by tw08r
% Email: tw08r@ecs.soton.ac.uk
% Created on: May 20, 2015
% Last Modified: May. 28, 2015 V1.41
This version add FLC decoder*/
#include "mex.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
/* 1.1 this version include viterbi decoder for EGM,and all 10 URC
/* 1.2 this version add state 4 and 8 CC and CC viterbi decoder
 * 1.3 this version add 3 more URC start above (0,0) point 4 states URC 11 and 8 state URC 12 and URC 13 see notebook P190
 * 1.4 add FLC decoder
 * 1.41 a small bug has been detected. Matlab only allow c to use space up to double *[2^20] 
/* note, the second half of the table must only be the second transition to each state */
/* last column is transition probablity */
static int urcstates[13] = {2, 4, 4, 4, 4, 8, 8, 8, 8, 8, 4, 8, 8};
static int transurcR[10][16][6] = {{
    {0,          0,          0,          0,          0,          0},
    {1,          1,          0,          1,          0,          0},
    {0,          1,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0}
},
/*static int transurc2[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {1,          2,          0,          0,          0,          0},
    {2,          1,          0,          1,          0,          0},
    {3,          3,          0,          1,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          0,          1,          1,          0,          0},
    {2,          3,          1,          0,          0,          0},
    {3,          1,          1,          0,          0,          0}
},
/*static int transurc3[8][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {1,          0,          0,          1,          0,          0},
    {2,          3,          0,          0,          0,          0},
    {3,          3,          0,          1,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          2,          1,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          1,          1,          0,          0,          0}
},
/*static int transurc4[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {2,          3,          0,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          3,          1,          1,          0,          0}
},
/*static int transurc5[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {2,          3,          0,          0,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          3,          1,          0,          0,          0}
},
/*static int transurc6[16][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {2,          5,          0,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {4,          2,          0,          0,          0,          0},
    {5,          6,          0,          1,          0,          0},
    {6,          7,          0,          1,          0,          0},
    {7,          3,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          6,          1,          1,          0,          0},
    {5,          2,          1,          0,          0,          0},
    {6,          3,          1,          0,          0,          0},
    {7,          7,          1,          1,          0,          0}
},
/*static int transurc7[16][6] = {*/
{
    {0,          0,          0,          0,          0,          0},
    {1,          0,          0,          1,          0,          0},
    {2,          1,          0,          0,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {4,          6,          0,          0,          0,          0},
    {5,          6,          0,          1,          0,          0},
    {6,          7,          0,          0,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          1,          0,          0,          0},
    {2,          5,          1,          1,          0,          0},
    {3,          5,          1,          0,          0,          0},
    {4,          2,          1,          1,          0,          0},
    {5,          2,          1,          0,          0,          0},
    {6,          3,          1,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc8[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {2,          5,          0,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {5,          2,          0,          0,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          6,          1,          1,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc9[16][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {1,          4,          0,          0,          0,          0},
    {2,          5,          0,          0,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {5,          2,          0,          1,          0,          0},
    {6,          3,          0,          1,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          1,          1,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          6,          1,          0,          0,          0},
    {6,          7,          1,          0,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc10[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {2,          5,          0,          0,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {4,          6,          0,          0,          0,          0},
    {5,          2,          0,          1,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          5,          1,          0,          0,          0},
    {4,          2,          1,          1,          0,          0},
    {5,          6,          1,          0,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
}};
static int translte8[16][6] =  
{
    {1,          1,          0,          0,          0,          0},
    {2,          5,          0,          0,          0,          0},
    {3,          6,          0,          1,          0,          0},
    {4,          2,          0,          1,          0,          0},
    {5,          3,          0,          1,          0,          0},
    {6,          7,          0,          1,          0,          0},
    {7,          8,          0,          0,          0,          0},
    {8,          4,          0,          0,          0,          0},
    {1,          5,          1,          1,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          2,          1,          0,          0,          0},
    {4,          6,          1,          0,          0,          0},
    {5,          7,          1,          0,          0,          0},
    {6,          3,          1,          0,          0,          0},
    {7,          4,          1,          1,          0,          0},
    {8,          8,          1,          1,          0,          0}
};
static int transCC[1][8][6] = 
{{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          1,          0},
    {1,          0,          0,          0,          1,          0},
    {1,          2,          1,          1,          0,          0},
    {2,          3,          0,          1,          0,          0},
    {2,          1,          1,          0,          1,          0},
    {3,          3,          0,          1,          1,          0},
    {3,          1,          1,          0,          0,          0}
}};
static int transurc4[8][6] = 
{
    {0,          0,          0,          0,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {2,          3,          0,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          3,          1,          1,          0,          0}
};
static int transurc8[16][6] = 
{
    {0,          0,          0,          0,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {2,          5,          0,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {5,          2,          0,          0,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          6,          1,          1,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
};
static int transurc[13][16][6] = {{
    {0,          0,          0,          0,          0,          0},
    {0,          1,          1,          1,          0,          0},
    {1,          1,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0}
},
/*static int transurc2[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          2,          0,          0,          0,          0},
    {1,          0,          1,          1,          0,          0},
    {2,          1,          0,          1,          0,          0},
    {2,          3,          1,          0,          0,          0},
    {3,          3,          0,          1,          0,          0},
    {3,          1,          1,          0,          0,          0}
},
/*static int transurc3[8][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          0,          0,          1,          0,          0},
    {1,          2,          1,          0,          0,          0},
    {2,          3,          0,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          3,          0,          1,          0,          0},
    {3,          1,          1,          0,          0,          0}
},
/*static int transurc4[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          3,          0,          1,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {3,          3,          1,          1,          0,          0}
},
/*static int transurc5[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          3,          0,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {3,          3,          1,          0,          0,          0}
},
/*static int transurc6[16][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          5,          0,          1,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          2,          0,          0,          0,          0},
    {4,          6,          1,          1,          0,          0},
    {5,          6,          0,          1,          0,          0},
    {5,          2,          1,          0,          0,          0},
    {6,          7,          0,          1,          0,          0},
    {6,          3,          1,          0,          0,          0},
    {7,          3,          0,          0,          0,          0},
    {7,          7,          1,          1,          0,          0}
},
/*static int transurc7[16][6] = {*/
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          0,          0,          1,          0,          0},
    {1,          4,          1,          0,          0,          0},
    {2,          1,          0,          0,          0,          0},
    {2,          5,          1,          1,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {3,          5,          1,          0,          0,          0},
    {4,          6,          0,          0,          0,          0},
    {4,          2,          1,          1,          0,          0},
    {5,          6,          0,          1,          0,          0},
    {5,          2,          1,          0,          0,          0},
    {6,          7,          0,          0,          0,          0},
    {6,          3,          1,          1,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc8[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          5,          0,          1,          0,          0},
    {2,          1,          1,          0,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          2,          0,          0,          0,          0},
    {5,          6,          1,          1,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc9[16][6] =*/
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          0,          0,          0},
    {1,          0,          1,          1,          0,          0},
    {2,          5,          0,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          1,          0,          0,          0,          0},
    {3,          5,          1,          1,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          2,          0,          1,          0,          0},
    {5,          6,          1,          0,          0,          0},
    {6,          3,          0,          1,          0,          0},
    {6,          7,          1,          0,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc10[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          5,          0,          0,          0,          0},
    {2,          1,          1,          1,          0,          0},
    {3,          1,          0,          1,          0,          0},
    {3,          5,          1,          0,          0,          0},
    {4,          6,          0,          0,          0,          0},
    {4,          2,          1,          1,          0,          0},
    {5,          2,          0,          1,          0,          0},
    {5,          6,          1,          0,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
  /*static int transurc11[8][6] =*/ 
{
    {0,          0,          0,          0,          0,          0},
    {0,          2,          1,          1,          0,          0},
    {1,          2,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          0,          0,          0,          0},
    {2,          3,          1,          1,          0,          0},
    {3,          3,          0,          1,          0,          0},
    {3,          1,          1,          0,          0,          0}
},
/*static int transurc12[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          0,          0,          0,          0},
    {2,          5,          1,          1,          0,          0},
    {3,          5,          0,          1,          0,          0},
    {3,          1,          1,          0,          0,          0},
    {4,          2,          0,          0,          0,          0},
    {4,          6,          1,          1,          0,          0},
    {5,          6,          0,          1,          0,          0},
    {5,          2,          1,          0,          0,          0},
    {6,          3,          0,          0,          0,          0},
    {6,          7,          1,          1,          0,          0},
    {7,          7,          0,          1,          0,          0},
    {7,          3,          1,          0,          0,          0}
},
/*static int transurc13[16][6] = */
{
    {0,          0,          0,          0,          0,          0},
    {0,          4,          1,          1,          0,          0},
    {1,          4,          0,          1,          0,          0},
    {1,          0,          1,          0,          0,          0},
    {2,          1,          0,          0,          0,          0},
    {2,          5,          1,          1,          0,          0},
    {3,          5,          0,          1,          0,          0},
    {3,          1,          1,          0,          0,          0},
    {4,          6,          0,          1,          0,          0},
    {4,          2,          1,          0,          0,          0},
    {5,          2,          0,          0,          0,          0},
    {5,          6,          1,          1,          0,          0},
    {6,          7,          0,          1,          0,          0},
    {6,          3,          1,          0,          0,          0},
    {7,          3,          0,          0,          0,          0},
    {7,          7,          1,          1,          0,          0}
}
};



#ifndef max
 #define max(a,b) \
   ({ __typeof__ (a) _a = (a); \
       __typeof__ (b) _b = (b); \
     _a > _b ? _a : _b; })
#endif

#ifndef min
 #define min(a,b) \
   ({ __typeof__ (a) _a = (a); \
       __typeof__ (b) _b = (b); \
     _a < _b ? _a : _b; })
#endif
__inline  double maxstar(double a, double b)
{    
    return  max(a,b) + log(1.0+exp(-fabs(a-b)));    
}




/* reg_trellis - does each state have 2 transitions ending there? */
void bcjr_decoder(double *uncoded_in, double *coded_in1, double *coded_in2, double *coded_in3,
        double *uncoded_out, double *coded_out1, double *coded_out2,double *coded_out3,
        int len, int trans[][6], int state_count, int trans_count, int codeword_count,
        int reg_trellis, double *trans_prob, int last_state)
{
    
    int i,j;
    int transc = trans_count;
    int set0,set1;
    double p1,p0;
    int a,b;
    double **gammas;
    double **alphas;
    double **betas;
    double temp[16];
    int states = state_count;

    /* calculate gammas */ 
    gammas = (double**) malloc (transc*sizeof(double *));
    for (i = 0; i < transc; i++)
        gammas[i] = (double*) malloc(len*sizeof(double));
    
    for (i = 0; i < transc; i++)
    {
        if (trans[i][2] && trans[i][3]){
            for (j = 0; j < len; j++){
                gammas[i][j] = uncoded_in[j] + coded_in1[j];
            }
        }
        else if (trans[i][2]){
            for (j = 0; j < len; j++)
                gammas[i][j] = uncoded_in[j];
        }
        else if (trans[i][3]){
            for (j = 0; j < len; j++)
                gammas[i][j] = coded_in1[j];
        }
        else{
            for (j = 0; j < len; j++)
                gammas[i][j] = 0;
        }
    }

	if (codeword_count >= 2)
	{
		for (i = 0; i < transc; i++)
		{
			if (trans[i][4]){
				for (j = 0; j < len; j++)
					gammas[i][j] += coded_in2[j];
			}
		}
	}
	if (codeword_count >= 3)
	{
		for (i = 0; i < transc; i++)
		{
			if (trans[i][5]){
				for (j = 0; j < len; j++)
					gammas[i][j] += coded_in3[j];
			}
		}
	}


    if (trans_prob != (double*)0)
    {
        for (i = 0; i < transc; i++)
        {
            for (j=0; j < len; j++)
                gammas[i][j] += trans_prob[i];
        }
    }
    
    
    
    /* set and initialise memory */
    alphas = (double**) malloc (states*sizeof(double *));
    for (i = 0; i < states; i++)
        alphas[i] = (double*) malloc(len*sizeof(double));
    betas = (double**) malloc (states*sizeof(double *));
    for (i = 0; i < states; i++)
        betas[i] = (double*) malloc(len*sizeof(double));
    
    if (reg_trellis == 0)
    {
        for (i = 0; i < states; i++) {
            for (j=0; j< len; j++)
                alphas[i][j] = -9000;
        }
        for (i = 0; i < states; i++){
            for (j=0; j< len; j++)
                betas[i][j] = -9000;
        }
    }
    
    
    
    /* forward recursion (alphas) */
    alphas[0][0] = 0;        /* first state */
    for (i = 1; i < states; i++)
        alphas[i][0] = -9000;
    if (reg_trellis == 0){
        for (i = 1; i < len; i++)
        {
            for (j = 0; j < transc; j++)
                alphas[trans[j][1]][i] = maxstar(  alphas[trans[j][1]][i],  alphas[trans[j][0]][i-1] + gammas[j][i-1]  );
        }
    }
    else
    {
        for (i = 1; i < len; i++)
        {
            for (j = 0; j < states; j++)
                temp[trans[j][1]] = alphas[trans[j][0]][i-1] + gammas[j][i-1];
            for (j = states; j < transc; j++)
                alphas[trans[j][1]][i] = maxstar( temp[trans[j][1]],  alphas[trans[j][0]][i-1] + gammas[j][i-1]  );
        }
    }
    
    
    /* backwards recursion (betas) */
    /* double betas[8][len]; */
    if (last_state < 1 || last_state > states){
        for (i = 0; i < states; i++)
            betas[i][len-1] = 0;     /* end state unknown */
    }
    else
    {
        for (i = 0; i < states; i++)
            betas[i][len-1] = -9000;
        betas[last_state-1][len-1] = 0;
    }
    
    if (reg_trellis == 0){
        for (i = len-2; i >= 0; i--)
        {
            for (j = 0; j < transc; j++)
                betas[trans[j][0]][i] = maxstar( betas[trans[j][0]][i],  betas[trans[j][1]][i+1] + gammas[j][i+1]  );
        }
    }
    else
    {
        for (i = len-2; i >= 0; i--)
        {
            for (j = 0; j < states; j++)
                temp[trans[j][0]] = betas[trans[j][1]][i+1] + gammas[j][i+1];
            for (j = states; j < transc; j++)
                betas[trans[j][0]][i] = maxstar( temp[trans[j][0]],  betas[trans[j][1]][i+1] + gammas[j][i+1]  );
        }
    }
    
    /*
     * if (trans_prob != (double*)0)
     * {
     * mexPrintf("trans probs\n");
     * for (i=0;i<transc;i++)
     * {
     * mexPrintf("%f ",trans_prob[i]);
     *
     *
     * }
     * }
     * mexPrintf("GAMMAS\n");
     * for (i=0;i<transc;i++)
     * {
     * for (j=0;j<len;j++)
     * mexPrintf("%f ",gammas[i][j]);
     * mexPrintf("\n");
     *
     * }
     * mexPrintf("ALPHAS\n");
     * for (i=0;i<states;i++)
     * {
     * for (j=0;j<len;j++)
     * mexPrintf("%f ",alphas[i][j]);
     * mexPrintf("\n");
     *
     * }
     * mexPrintf("\n");
     * mexPrintf("\n");
     * mexPrintf("BETAS\n");
     * for (i=0;i<states;i++)
     * {
     * for (j=0;j<len;j++)
     * mexPrintf("%f ",betas[i][j]);
     * mexPrintf("\n");
     *
     * }
     * mexPrintf("\n");
     */
	 
    /* deltas */
    /* reuse gammas memory */
    for (i = 0; i < transc; i++)
    {
        a = trans[i][0];
        b = trans[i][1];
        for (j = 0; j < len; j++)
            gammas[i][j] += alphas[a][j] + betas[b][j];
    }
    
    
    /* extrinisic uncoded llr */
    for (j = 0; j < len; j++)
    {
        set0 = 0;
        set1 = 0;
        
        for (i = 0; i < transc; i++)
        {
            if (trans[i][2]){
                if (set1)
                    p1 = maxstar(p1,gammas[i][j]);
                else
                {
                    set1 = 1;
                    p1 = gammas[i][j];
                }
            }
            else{
                if (set0)
                    p0 = maxstar(p0,gammas[i][j]);
                else
                {
                    set0 = 1;
                    p0 = gammas[i][j];
                }
            }
        }
        uncoded_out[j] = p1 - p0 - uncoded_in[j];
    }
    
    
    /* coded llr out */
    for (j = 0; j < len; j++)
    {
        set0 = 0;
        set1 = 0;
        
        for (i = 0; i < transc; i++)
        {
            if (trans[i][3]){
                if (set1)
                    p1 = maxstar(p1,gammas[i][j]);
                else
                {
                    set1 = 1;
                    p1 = gammas[i][j];
                }
            }
            else{
                if (set0)
                    p0 = maxstar(p0,gammas[i][j]);
                else
                {
                    set0 = 1;
                    p0 = gammas[i][j];
                }
            }
        }
        coded_out1[j] = p1 - p0 - coded_in1[j];
    }

	/* coded llr out2 */
	if (codeword_count >= 2)
	{
		for (j = 0; j < len; j++)
		{
			set0 = 0;
			set1 = 0;

			for (i = 0; i < transc; i++)
			{
				if (trans[i][4]){
					if (set1)
						p1 = maxstar(p1,gammas[i][j]);
					else
					{
						set1 = 1;
						p1 = gammas[i][j];
					}
				}
				else{
					if (set0)
						p0 = maxstar(p0,gammas[i][j]);
					else
					{
						set0 = 1;
						p0 = gammas[i][j];
					}
				}
			}
			coded_out2[j] = p1 - p0 - coded_in2[j];
		}
	}

	/* coded llr out3 */
	if (codeword_count >= 3)
	{
		for (j = 0; j < len; j++)
		{
			set0 = 0;
			set1 = 0;

			for (i = 0; i < transc; i++)
			{
				if (trans[i][5]){
					if (set1)
						p1 = maxstar(p1,gammas[i][j]);
					else
					{
						set1 = 1;
						p1 = gammas[i][j];
					}
				}
				else{
					if (set0)
						p0 = maxstar(p0,gammas[i][j]);
					else
					{
						set0 = 1;
						p0 = gammas[i][j];
					}
				}
			}
			coded_out3[j] = p1 - p0 - coded_in3[j];
		}
	}
    
    for (i = 0; i < transc; i++){
        free(gammas[i]);
    }
    free(gammas);
    for (i = 0; i < states; i++){
        free(alphas[i]);
    }
    free(alphas);
    for (i = 0; i < states; i++){
        free(betas[i]);
    }
    free(betas);
    
    
}


/* Add viterbi decoder in this decoder and out put decoded_out*/
/*mode:  EGM M1 1, EGM M0 0, URC -1, CC viterbi 2 tw08r*/
void bcjr_decoder_v(double *uncoded_in, double *coded_in1, double *coded_in2, double *coded_in3,
        double *uncoded_out, double *coded_out1, double *coded_out2,double *coded_out3,double *decoded_out,/*viterbi output tw08r*/
        int len, int mode, int trans[][6], int state_count, int trans_count, int codeword_count,
        int reg_trellis, double *trans_prob, int last_state)
{
    
    int i,j;
    int transc = trans_count;
    int set0,set1,state,best_state;
    double p1,p0,best_alpha;
    int a,b;
    double **gammas;
    double **alphas;
    double **betas;
    double *alphas_last;/*this is for the last state and viterbi tw08r*/
    double temp[16];
    int states = state_count;

    /* calculate gammas */ 
    gammas = (double**) malloc (transc*sizeof(double *));
    for (i = 0; i < transc; i++)
        gammas[i] = (double*) malloc(len*sizeof(double));
    
    for (i = 0; i < transc; i++)
    {
        if (trans[i][2] && trans[i][3]){
            for (j = 0; j < len; j++){
                gammas[i][j] = uncoded_in[j] + coded_in1[j];
            }
        }
        else if (trans[i][2]){
            for (j = 0; j < len; j++)
                gammas[i][j] = uncoded_in[j];
        }
        else if (trans[i][3]){
            for (j = 0; j < len; j++)
                gammas[i][j] = coded_in1[j];
        }
        else{
            for (j = 0; j < len; j++)
                gammas[i][j] = 0;
        }
    }
	    
	if (codeword_count >= 2)
	{
		for (i = 0; i < transc; i++)
		{
			if (trans[i][4]){
				for (j = 0; j < len; j++)
					gammas[i][j] += coded_in2[j];
			}
		}
	}
	if (codeword_count >= 3)
	{
		for (i = 0; i < transc; i++)
		{
			if (trans[i][5]){
				for (j = 0; j < len; j++)
					gammas[i][j] += coded_in3[j];
			}
		}
	}


    if (trans_prob != (double*)0)
    {
        for (i = 0; i < transc; i++)
        {
            for (j=0; j < len; j++)
                gammas[i][j] += trans_prob[i];
        }
    }

   
    
    /* set and initialise memory */
    alphas = (double**) malloc (states*sizeof(double *));
    alphas_last = (double*) malloc (states*sizeof(double));/*tw08r*/
    for (i = 0; i < states; i++)
        alphas[i] = (double*) malloc(len*sizeof(double));
    betas = (double**) malloc (states*sizeof(double *));
    for (i = 0; i < states; i++)
        betas[i] = (double*) malloc(len*sizeof(double));
    

        for (i = 0; i < states; i++) {
            for (j=0; j< len; j++)
                alphas[i][j] = -9000;
        }
        for (i = 0; i < states; i++){
            for (j=0; j< len; j++)
                betas[i][j] = -9000;
        }

 

    
    /* forward recursion (alphas) */
    alphas[0][0] = 0;        /* first state */
    for (i = 1; i < states; i++)
        alphas[i][0] = -9000;
        for (i = 1; i < len; i++)
        {
            for (j = 0; j < transc; j++)
                alphas[trans[j][1]][i] = maxstar(  alphas[trans[j][1]][i],  alphas[trans[j][0]][i-1] + gammas[j][i-1]  );
        }
         if (mode == 1 || mode == 2)
	 {
	  for (j = 0; j < transc; j++)
	  alphas_last[trans[j][1]] = maxstar(  alphas_last[trans[j][1]],  alphas[trans[j][0]][len-1] + gammas[j][len-1]  );
	 }


    
    
    /* backwards recursion (betas) */
    /* double betas[8][len]; */
    if ((last_state < 1 || last_state > states)){
        for (i = 0; i < states; i++)
            betas[i][len-1] = 0;     /* end state unknown */
    }
    else if (mode == 1)
    {
        betas[0][len-1] = 0;
	betas[1][len-1] = 0;
    }
    else /*if (mode == 0 || mode == -1)*/
    {
        for (i = 0; i < states; i++)
            betas[i][len-1] = -9000;
        betas[last_state-1][len-1] = 0;
    }



        for (i = len-2; i >= 0; i--)
        {
            for (j = 0; j < transc; j++)
                betas[trans[j][0]][i] = maxstar( betas[trans[j][0]][i],  betas[trans[j][1]][i+1] + gammas[j][i+1]  );
        }

 
    /* deltas */
    /* reuse gammas memory */
    for (i = 0; i < transc; i++)
    {
        a = trans[i][0];
        b = trans[i][1];
        for (j = 0; j < len; j++)
            gammas[i][j] += alphas[a][j] + betas[b][j];
    }
    
    
    /* extrinisic uncoded llr */
    for (j = 0; j < len; j++)
    {
        set0 = 0;
        set1 = 0;
        
        for (i = 0; i < transc; i++)
        {
            if (trans[i][2]){
                if (set1)
                    p1 = maxstar(p1,gammas[i][j]);
                else
                {
                    set1 = 1;
                    p1 = gammas[i][j];
                }
            }
            else{
                if (set0)
                    p0 = maxstar(p0,gammas[i][j]);
                else
                {
                    set0 = 1;
                    p0 = gammas[i][j];
                }
            }
        }
        uncoded_out[j] = p1 - p0 - uncoded_in[j];
    }
    

    /* coded llr out */
    for (j = 0; j < len; j++)
    {
        set0 = 0;
        set1 = 0;
        
        for (i = 0; i < transc; i++)
        {
            if (trans[i][3]){
                if (set1)
                    p1 = maxstar(p1,gammas[i][j]);
                else
                {
                    set1 = 1;
                    p1 = gammas[i][j];
                }
            }
            else{
                if (set0)
                    p0 = maxstar(p0,gammas[i][j]);
                else
                {
                    set0 = 1;
                    p0 = gammas[i][j];
                }
            }
        }
        coded_out1[j] = p1 - p0 - coded_in1[j];
    }

	/* coded llr out2 */
	if (codeword_count >= 2)
	{
		for (j = 0; j < len; j++)
		{
			set0 = 0;
			set1 = 0;

			for (i = 0; i < transc; i++)
			{
				if (trans[i][4]){
					if (set1)
						p1 = maxstar(p1,gammas[i][j]);
					else
					{
						set1 = 1;
						p1 = gammas[i][j];
					}
				}
				else{
					if (set0)
						p0 = maxstar(p0,gammas[i][j]);
					else
					{
						set0 = 1;
						p0 = gammas[i][j];
					}
				}
			}
			coded_out2[j] = p1 - p0 - coded_in2[j];
		}
	}

	/* coded llr out3 */
	if (codeword_count >= 3)
	{
		for (j = 0; j < len; j++)
		{
			set0 = 0;
			set1 = 0;

			for (i = 0; i < transc; i++)
			{
				if (trans[i][5]){
					if (set1)
						p1 = maxstar(p1,gammas[i][j]);
					else
					{
						set1 = 1;
						p1 = gammas[i][j];
					}
				}
				else{
					if (set0)
						p0 = maxstar(p0,gammas[i][j]);
					else
					{
						set0 = 1;
						p0 = gammas[i][j];
					}
				}
			}
			coded_out3[j] = p1 - p0 - coded_in3[j];
		}
	}


    /*Viterbi decoder tw08r */
    
    if (mode == 1)
    {


     	state = (alphas_last[0] > alphas_last[1]) ? 0 : 1; 
        for (i = len-1; i >= 0; i--)
        {
	  best_alpha = -9000;
            for (j = 0; j < transc; j++)
	    {
                if( trans[j][1] == state && alphas[trans[j][0]][i] > best_alpha )
		   {
		     best_alpha = alphas[trans[j][0]][i];
		     decoded_out[i] = trans[j][2];
		     best_state = trans[j][0];
		     	  
		   }
	     }
	  state = best_state;

        }

    }
    else if (mode == 0)
    {
      	state = last_state;
        for (i = len-1; i >= 0; i--)
        {
	  best_alpha = -9000;
            for (j = 0; j < transc; j++)
	    {
                if( trans[j][1] == state && alphas[trans[j][0]][i] > best_alpha )
		   {
		     best_alpha = alphas[trans[j][0]][i];
		     if (state == states || state == (state-1))
		       decoded_out[i] = (uncoded_out > 0 ? 1:0);
		     else
		       decoded_out[i] = trans[j][2];
		     best_state = trans[j][0];
		   }
	     }
	  state = best_state;   
        }
      
    }
    else if (mode == 2)
    {
      /*for (i=0;i<states;i++)
     {
     for (j=0;j<len;j++)
     mexPrintf("%f ",alphas_last[i]);
     
    
     }
	mexPrintf("\n");*/
	state = 0;
     	for (i = 1; i < states; i++)
        {
	  if ((alphas_last[i] > alphas_last[state]) ? 1 : 0)
            state = i;
        }
        for (i = len-1; i >= 0; i--)
        {
	  best_alpha = -9000;
            for (j = 0; j < transc; j++)
	    {
                if( trans[j][1] == state && alphas[trans[j][0]][i] > best_alpha )
		   {
		     best_alpha = alphas[trans[j][0]][i];
		     decoded_out[i] = trans[j][2];
		     best_state = trans[j][0];
		     	  
		   }
	     }
	  state = best_state;

        }

    }


    for (i = 0; i < transc; i++){
        free(gammas[i]);
    }
    free(gammas);
    for (i = 0; i < states; i++){
        free(alphas[i]);
    }
    free(alphas);
    for (i = 0; i < states; i++){
        free(betas[i]);
    }
    free(alphas_last);
    free(betas);
    
    		        
}

/* Add viterbi decoder in this decoder and out put decoded_out*/
/*mode:  EGM M1 1, EGM M0 0, URC -1, CC viterbi 2 tw08r*/
void bcjr_decoder_flc(double *uncoded_in, double *coded_in1, double *coded_in2, double *coded_in3,
        double *uncoded_out, double *coded_out1, double *coded_out2,double *coded_out3,double *decoded_out,/*viterbi output tw08r*/
        int len, int lenS, int lenP,  int codeword_count, double *trans_prob)
{
    
    int i,j,sym_index,codeword_bit,dbase,d_len,bit_shift;
    double log1_temp,log0_temp;
    double sum_in=0;
    double max_in=0;
    double sum_Pro=0;/* sum(symbol_probabilities))*/
    int SymP_len = 0;
    int bit_index = 0;
    
    for (i=0;i<lenS;i++)
    {
      sum_in += uncoded_in[i];
      max_in = max(max_in,uncoded_in[i]);
      uncoded_out[i] = 0;/*initialize t_hat*/
    }
    if (len != sum_in-lenS)
      mexErrMsgIdAndTxt("MyToolbox:inputError","length(utildea) should equal sum(x_hat) - length(x_hat)");
    
    if (max_in > 18)
      mexErrMsgIdAndTxt("MyToolbox:inputError","The input uncoded value must be less then 18 or the matlab will crash ");
    
    
    int max_codeword_length = (int)max_in+1;
    
    int d_len_max = pow(2,(int)max_in);
    int d[d_len_max];
    double apriori_llrs[max_codeword_length];
    double log_0[max_codeword_length];
    double log_1[max_codeword_length];
    double SymP[d_len_max];
    double Symp_max, Symp_min, LogSymp_max;
    double LogSymP[d_len_max];  
    int LogSymp_max_Idx;

    
    for (i=0;i<len;i++)/*initialize utildee*/
    {
      coded_out1[i] = 0;
      if (codeword_count >= 2)
	coded_out2[i] = 0;
      if (codeword_count >= 3)
	coded_out3[i] = 0;
    }
    
    /* allocate codeword space
    codeword = (double**) malloc (d_len_max*sizeof(double *));
    for (i = 0; i < d_len_max; i++)
        codeword[i] = (double*) malloc(max_in*sizeof(double));*/
      
          
    for (sym_index=0;sym_index<lenS;sym_index++)
    {
      if(uncoded_in[sym_index] != 1)
      {
      	d_len = pow(2,uncoded_in[sym_index])-pow(2,(uncoded_in[sym_index]-1));/*initialize d */
      	dbase = pow(2,(uncoded_in[sym_index]-1));
	SymP_len = 0;

      	for (i=0;i<d_len;i++)
	{
	    d[i]=dbase +i;
	    if(d[i] <= lenP)
	    {
	      SymP[i]=trans_prob[d[i]-1];
	      sum_Pro += trans_prob[d[i]-1];
	      SymP_len++;
	    }
	    else
	    {
	      SymP[i]=(1-sum_Pro)/(d_len-SymP_len);	      
	    }

	}


	for (i=0;i<=uncoded_in[sym_index]-2;i++)
	{
	  apriori_llrs[i] = coded_in1[i+bit_index];
	  log_0[i] = 0;
	  log_1[i] = 0;
	}

	for (i=0;i<d_len;i++)
	{
	    LogSymP[i] = log(SymP[i]);/*log_symbol_probabilities = log(symbol_probabilities);*/
	    for (j = 0; j <=uncoded_in[sym_index]-2; j++)
                    {
		        bit_shift = (int)uncoded_in[sym_index]-2-j;
                        codeword_bit = i >> bit_shift;

			if (codeword_bit & 1)
			  LogSymP[i] += apriori_llrs[(j)];
                        /*codeword[i][j] = codeword_bit;/*build codeword*/
                    }

	}
	Symp_max = -9000;
    	Symp_min = 9000;
	LogSymp_max = -9000;


	for (i=0;i<d_len;i++)
	{
	  if(LogSymP[i] > LogSymp_max)
	  {
	    LogSymp_max = LogSymP[i];
	    LogSymp_max_Idx = i;
	  }
	  if(SymP[i] > Symp_max)
	  {
	    Symp_max = SymP[i];
	  }
	  Symp_min = min(Symp_min,SymP[i]);
	  

	}
	uncoded_out[sym_index] = (double)LogSymp_max_Idx;

	if (Symp_max != Symp_min)
	{
	    for (j = 0; j <=uncoded_in[sym_index]-2; j++)
                {
		  log0_temp = -9000;
		  log1_temp = -9000;
                    for (i=0;i<d_len;i++)
                    {
			bit_shift = (int)uncoded_in[sym_index]-2-j;
                        codeword_bit = i >> bit_shift;
				/*mexPrintf("%s ","log_SymP=");
				mexPrintf("%d ",i);
				mexPrintf("%d ",codeword_bit);
				mexPrintf("%d ",bit_shift);
				mexPrintf("%f ",log1_temp);
				mexPrintf("%f ",log0_temp);
				mexPrintf("%f ",LogSymP[i]);
				mexPrintf("\n");
				if (codeword_bit & 1)
				  mexPrintf("1 ");
				else
				  mexPrintf("0 ");
				mexPrintf("\n");*/
                        if (codeword_bit & 1)
                            log1_temp = maxstar(log1_temp,LogSymP[i]);
                        else
                            log0_temp = maxstar(log0_temp,LogSymP[i]);


                        /*codeword[i][j] = codeword_bit;/*build codeword*/
                    }
                    coded_out1[bit_index + j] = log1_temp - log0_temp - apriori_llrs[j];
                }  
	}
	bit_index += (uncoded_in[sym_index]-1);
      

      }
      else
      {
	uncoded_out[sym_index] = 0;
      }

    }


    
    		        
}




/* The gateway function */
void mexFunction( int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[])
{
    
    double *uncoded_in;
    double *coded_in1;
	double *coded_in2;
	double *coded_in3;
    double *uncoded_out;/*extrinsic uncoded bits*/
    double *coded_out1;/*posteriori LLRs*/
    double *coded_out2;
    double *decoded_out;/*viterbi decoded bits tw08r*/
	double *coded_out3;
    int len,i,j,states,last_state,mode,lenS,lenP;/*lenS is length for input symbol*/
    char *input_buf;
    int blank_transitions[6000][6];
    double *trans_probs;
    double *p;
	int codeword_count = 1;

    last_state = -1;

        /*output the build-in trellis. Notice this is the different order as it used in new URC version*/
    if (mxIsChar(prhs[0])){

      input_buf = mxArrayToString(prhs[0]);

    if  (strncmp(input_buf,"urc ",4)==0){
      int test_urc;
      sscanf (input_buf,"%*s %d",&test_urc);
      if (test_urc > 14)
	mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Only 13 URC available");
      printf ("urc %d - tellise\n",test_urc);
      for (i=0;i<urcstates[test_urc-1]*2;i++){
	for(j=0;j<6;j++){
	mexPrintf("%d ",transurc[test_urc-1][i][j]);
	}
	mexPrintf("\n");
      }
     return;
    }
    }

    
    /* check for proper number of arguments */
    if(nrhs<3 ) {
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:nrhs",">=Three inputs required. [uncoded_out, coded_out,decoded_out] = bcjr_decoder_v(uncoded_in, coded_in, {'urc8','urc4','lte8','uec'})\n One input bcjr_decoder_v('uec *')");
    }

    
    if(nlhs!=2 && nlhs!=3) {
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:nlhs","Two or three outputs required. [uncoded_out, coded_out,decoded_out] = bcjr_decoder_v(uncoded_in, coded_in, {'urc8','urc4','lte8','uec'})");
    }
    
    
    /* make sure the 1st input argument is type double */
    if( !mxIsDouble(prhs[0]) ||
            mxIsComplex(prhs[0])) {
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Input matrix must be type double.");
    }
    /* make sure the 2nd input argument is type double */
    if( !mxIsDouble(prhs[1]) ||
            mxIsComplex(prhs[1])) {
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Input matrix must be type double.");
    }
   
    
    /* check that number of rows in 1st input argument is 1 */
    
    if(mxGetM(prhs[0])!=1) {
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be a row vector.");
    }
    
    len = mxGetN(prhs[1]);
    if (mxIsChar(prhs[2])){
    input_buf = mxArrayToString(prhs[2]);
    }
    else
      mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Third Input must be a string for urc *, uec, new ,EGM0 and EGM1.");
    
    if (len < 3)
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be a row vector.");
    if (mxGetN(prhs[0]) < 3)
        mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be a row vector.");
    if ((strncmp(input_buf,"FLC",5)!=0))
    {    
      if (mxGetN(prhs[0]) != mxGetN(prhs[1]))
            mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be same dimentions.");
    }



    if ((strncmp(input_buf,"uec",5)==0) || (strncmp(input_buf,"new",5)==0) || (strncmp(input_buf,"EGM1",5)==0) || (strncmp(input_buf,"EGM0",5)==0)) 
    {
        
        if(nrhs!=5 && nrhs!=4)
            mexErrMsgIdAndTxt("MyToolbox:arrayProduct:nrhs","Four inputs required. [uncoded_out, coded_out,decoded_out] = bcjr_decoder(uncoded_in, coded_in, 'uec', transitions{, last_state}). States start at 1, set last_state < 0 for unknown");
        if( !mxIsDouble(prhs[3]) ||
                mxIsComplex(prhs[3])) {
            mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Input matrix must be type double.");
        }
        
        if(mxGetM(prhs[3])==1 || mxGetM(prhs[3])>5999) {
            mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notMatrix","transitions must be Tx5 (one codeword), Tx6 (two codewords) or Tx7 (two codewords).  Max transitions = 6000");
        }
        if(mxGetN(prhs[3])!=5 && mxGetN(prhs[3])!=6 && mxGetN(prhs[3])!=7) {
            mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notMatrix","transitions must be Tx5 (one codeword), Tx6 (two codewords) or Tx7 (two codewords).  Max transitions = 6000");
        }
		if(mxGetN(prhs[3])==6){
			codeword_count = 2;
		}
		if(mxGetN(prhs[3])==7){
			codeword_count = 3;
		}
		if (codeword_count == 2)
		{
			if(mxGetM(prhs[1])!=2) {
				mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notMatrix","Input coded LLRs needs two rows.");
			}
		}
		else if (codeword_count == 3)
		{
			if(mxGetM(prhs[1])!=3) {
				mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notMatrix","Input coded LLRs needs threee rows.");
			}
		}
		else
		{
			if(mxGetM(prhs[1])!=1) {
				mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be a row vector.");
			}
		}
        
        if(nrhs==5){
            if( !mxIsDouble(prhs[4]) ||
                    mxIsComplex(prhs[4])) {
                mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Input last_state must be type double.");
            }
            last_state = mxGetScalar(prhs[4]);
        }
        
        trans_probs = malloc(mxGetM(prhs[3])*sizeof(double *));
        p = mxGetPr(prhs[3]);
         
        for (i=0; i < 2; i++){
            for (j=0; j <  mxGetM(prhs[3]); j++)
                blank_transitions[j][i] = ((int)*p++)-1;
        }
        for (i=2; i < 4; i++){
            for (j=0; j <  mxGetM(prhs[3]); j++)
                blank_transitions[j][i] = (int)*p++;
        }
		if (codeword_count >= 2){
			for (i=4; i < 5; i++){
				for (j=0; j <  mxGetM(prhs[3]); j++)
					blank_transitions[j][i] = (int)*p++;
			}
		}
		if (codeword_count >= 3){
			for (i=5; i < 6; i++){
				for (j=0; j <  mxGetM(prhs[3]); j++)
					blank_transitions[j][i] = (int)*p++;
			}
		}
        for (i=0; i < mxGetM(prhs[3]); i++)
            trans_probs[i] = *p++;
        
    }
    else if ((strncmp(input_buf,"CCVit",5)==0))
    {
      codeword_count =mxGetM(prhs[1]);;      
    }
    else if ((strncmp(input_buf,"FLC",5)==0))
    {
      codeword_count =mxGetM(prhs[1]);
      lenP = mxGetN(prhs[3]);
      trans_probs = malloc(lenP*sizeof(double *));/*P_t_given_x_vector*/
      lenS = mxGetN(prhs[0]);
      p = mxGetPr(prhs[3]);
      for (i=0; i < mxGetN(prhs[3]); i++)
            trans_probs[i] = *p++;
    }
	else
	{
		if(mxGetM(prhs[1])!=1) {
			mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notRowVector","Input must be a row vector.");
		}
	}
    

    /* get pointers */
	uncoded_in = mxGetPr(prhs[0]);
	if (codeword_count == 1)
		coded_in1 = mxGetPr(prhs[1]);
	else if (codeword_count == 2)
	{
		coded_in1 = malloc(sizeof(double) * len);
		coded_in2 = malloc(sizeof(double) * len);
		p = mxGetPr(prhs[1]);
		for (i=0; i < len; i++){
			coded_in1[i] = *p++;
			coded_in2[i] = *p++;
		}
	}
	else if (codeword_count == 3)
	{
		coded_in1 = malloc(sizeof(double) * len);
		coded_in2 = malloc(sizeof(double) * len);
		coded_in3 = malloc(sizeof(double) * len);
		p = mxGetPr(prhs[1]);
		for (i=0; i < len; i++){
			coded_in1[i] = *p++;
			coded_in2[i] = *p++;
			coded_in3[i] = *p++;
		}
	}
	else
		mexErrMsgIdAndTxt("Error","Error code: 48573869730");

    
    
    
    /* create the output matrixs */
    if ((strncmp(input_buf,"FLC",5)==0) )
      plhs[0] = mxCreateDoubleMatrix(1,(mwSize)lenS,mxREAL);
    else
      plhs[0] = mxCreateDoubleMatrix(1,(mwSize)len,mxREAL);
    
    /* get a pointer to the real data in the output matrix */
    uncoded_out = mxGetPr(plhs[0]);  
    	/*For EGM system there are 3 outputs, the third one is Viterbi decoded bits tw08r   */
    	if ((strncmp(input_buf,"EGM0",5)==0) || (strncmp(input_buf,"EGM1",5)==0) || (strncmp(input_buf,"CCVit",5)==0))
	{
	  plhs[2] = mxCreateDoubleMatrix(1,(mwSize)len,mxREAL);
	  decoded_out = mxGetPr(plhs[2]);	  
	}/*tw08r end*/
	  
	if (codeword_count == 1){
		plhs[1] = mxCreateDoubleMatrix(1,(mwSize)len,mxREAL);
		coded_out1 = mxGetPr(plhs[1]);
	}
	else if (codeword_count == 2)
	{
		plhs[1] = mxCreateDoubleMatrix(2,(mwSize)len,mxREAL);
		coded_out1 = malloc(sizeof(double) * len);
		coded_out2 = malloc(sizeof(double) * len);
	}
	else if (codeword_count == 3)
	{
		plhs[1] = mxCreateDoubleMatrix(3,(mwSize)len,mxREAL);
		coded_out1 = malloc(sizeof(double) * len);
		coded_out2 = malloc(sizeof(double) * len);
		coded_out3 = malloc(sizeof(double) * len);
	}
	else
		mexErrMsgIdAndTxt("Error","Error code: 5812645");


    
    /* call the computational routine */
    /*change here for all 10 URCs tw08r*/
    if (strncmp(input_buf,"urc ",4)==0)
    {
      int test_urc;
      mode = -1;
      sscanf (input_buf,"%*s %d",&test_urc);
      if (test_urc > 14)
	mexErrMsgIdAndTxt("MyToolbox:arrayProduct:notDouble","Only 13 URC available");

        bcjr_decoder_v(uncoded_in, coded_in1, 0, 0, uncoded_out, coded_out1, 0, 0, 0, 
		       len,mode,transurc[test_urc-1],urcstates[test_urc-1],urcstates[test_urc-1]*2,1,1,(double*)0 , last_state);

    }
    else if (strncmp(input_buf,"lte8",5)==0)
    {
        bcjr_decoder(uncoded_in, coded_in1, 0, 0,
                uncoded_out, coded_out1, 0, 0, len,translte8,8,16,1,1,(double*)0 , last_state);
    }
    else if ((strncmp(input_buf,"uec",5)==0)  || (strncmp(input_buf,"new",5)==0))
    {
        states = 0;
        for (i=0;i<mxGetM(prhs[3]);i++)
        {
            states = max(states, blank_transitions[i][0]);
            states = max(states, blank_transitions[i][1]);
        }
        
        bcjr_decoder(uncoded_in, coded_in1, coded_in2, coded_in3,
                uncoded_out, coded_out1, coded_out2, coded_out3, len,blank_transitions,
                states+1,mxGetM(prhs[3]),codeword_count,0,trans_probs, last_state);
        
        free(trans_probs);
        
        
    }
    else if ((strncmp(input_buf,"EGM0",5)==0) )/*add 2 more options for decoder EGM M0 and M1 tw08r*/
    {
        states = 0;
	mode = 0;
        for (i=0;i<mxGetM(prhs[3]);i++)
        {
            states = max(states, blank_transitions[i][0]);
            states = max(states, blank_transitions[i][1]);
        }
        
        bcjr_decoder_v(uncoded_in, coded_in1, coded_in2, coded_in3,
                uncoded_out, coded_out1, coded_out2, coded_out3,decoded_out, len,mode
                ,blank_transitions,states+1,mxGetM(prhs[3]),codeword_count,0,
		 trans_probs, last_state);
        
        free(trans_probs);
        
        
    }
    else if ((strncmp(input_buf,"EGM1",5)==0) )
    {
        states = 0;
	mode = 1;
	last_state = 1;
        for (i=0;i<mxGetM(prhs[3]);i++)
        {
            states = max(states, blank_transitions[i][0]);
            states = max(states, blank_transitions[i][1]);
        }
        
        bcjr_decoder_v(uncoded_in, coded_in1, coded_in2, coded_in3,
                uncoded_out, coded_out1, coded_out2, coded_out3,decoded_out, len,mode
                ,blank_transitions,states+1,mxGetM(prhs[3]),codeword_count,0,
		 trans_probs, last_state);
        
        free(trans_probs);
        
        
    }/*tw08r*/
    else if ((strncmp(input_buf,"CCVit",5)==0) )
    {


      mode = 2;/*mode 2 for CC viterbi decoder*/
	/*more state cc viterbi decoder add later tw08r*/
        bcjr_decoder_v(uncoded_in, coded_in1, coded_in2, coded_in3, uncoded_out, coded_out1, coded_out2, coded_out3, decoded_out, 
	    len,mode,transCC[0],4,8,2,1,(double*)0 , last_state);

        
        
    }/*tw08r*/
    else if ((strncmp(input_buf,"FLC",5)==0) )
    {


      mode = 2;/*mode 2 for CC viterbi decoder*/
	/*more state cc viterbi decoder add later tw08r*/

        bcjr_decoder_flc(uncoded_in, coded_in1, coded_in2, coded_in3, uncoded_out, coded_out1, coded_out2, coded_out3, decoded_out, 
	    len, lenS, lenP,codeword_count,trans_probs);
		 
        free(trans_probs);
        
    }/*tw08r*/
    else
    {
        mexErrMsgIdAndTxt("MyToolbox:inputError","Select from 'urc 1-10','EGM0','EGM1','FLC', or 'lte8'");
    }
    


	if (codeword_count == 2)
	{
		p = mxGetPr(plhs[1]);
		for (i=0; i < len; i++){
			*p++ = coded_out1[i];
			*p++ = coded_out2[i];
		}
		free(coded_in1);
		free(coded_in2);
		free(coded_out1);
		free(coded_out2);
	}
	if (codeword_count == 3)
	{
		p = mxGetPr(plhs[1]);
		for (i=0; i < len; i++){
			*p++ = coded_out1[i];
			*p++ = coded_out2[i];
			*p++ = coded_out3[i];
		}
		free(coded_in1);
		free(coded_in2);
		free(coded_in3);
		free(coded_out1);
		free(coded_out2);
		free(coded_out3);
	}

	mxFree(input_buf);

    /* mexPrintf("%f %f %f %f %f",maxstar(2.4,2.4),maxstar(6.7,8.1), maxstar(3,200), maxstar(-5,-8999), maxstar(-6.7,8.1));*/ 
}


