% EXIT function for a UEC used as an outer code
% Copyright (C) 2008  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.


% dist                 % distribution of the source bits
% s                    % parameter in the distribution
% codewords            % codewords of the trellis
% frame_count          % number of iterations for every point
% IA_count             % number of points in EXIT chart
% new_maxstar_mode
% bec                  % bec = 1:generate_bec_llrs; bec = 0:generate_llrs

% imperfect probability at both transmitter and receiver
% the probability is initialized to a uniform distributaion, for example:
% p(1) = 1/1001; p(2) = 1/1001; ... ; p(1001) = 1001.
% any symbol value that is bigger than 1001 is set to 1001.
% at receiver, the probability is updated after every frame

function results = main_adptarith_ser_zeta_perfect_v3(snr_start, job_index, rngNum, memory_len)


global acs
global maxstar_mode
new_maxstar_mode = 0;
acs = 0;
maxstar_mode = new_maxstar_mode;

snr_start  = str2double(snr_start);
job_index  = str2double(job_index);
memory_len = str2double(memory_len);

if job_index == 1
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 20;
    standard_deviation_normaliser = 0.3097;
    doping = 1;
    doping_rate = 1/0.7385;
    
elseif job_index == 2
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    doping_rate = 1/0.6970;
    
elseif job_index == 4
    desired_p1 = 0.85;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    doping_rate = 1/0.6655;
    
elseif job_index == 5
    desired_p1 = 0.75;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    doping_rate = 1/0.7083;
    
elseif job_index == 7
    desired_p1 = 0.8;
    sigma      = 0.05;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    doping_rate = 1/0.7238;
    
elseif job_index == 8
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 160;
    standard_deviation_normaliser = 0.1097;
    doping = 1;
    doping_rate = 1/0.7090;
    
elseif job_index == 10
    desired_p1 = 0.8;
    sigma      = 0.01667;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    doping_rate = 1/0.7529;
    
else
    
end

old = digits;
dig_num = 2000;
digits(dig_num);
%
m  = 1000;
% =====================================
% target simulations parameters
target_frame_errors = 1000000;
% iteration_count = 100;
if job_index == 1
    iteration_count = 31;    
elseif job_index == 2
    iteration_count = 31;    
elseif job_index == 4
    iteration_count = 27;    
elseif job_index == 5
    iteration_count = 30;    
elseif job_index == 7
    iteration_count = 30;    
elseif job_index == 8
    iteration_count = 31;    
elseif job_index == 10
    iteration_count = 31;    
else
    
end
chances = 3;
%==============================================
% probability table initialization for a new snr, having a fixed size
% prob_tab_en structure: column 1: symbol value; column 2: symbol occurancies; column 3: symbol value probability;
symbol_max = 1001;
prob_tab_en = zeros(symbol_max, 3);
prob_tab_en(:, 1) = (1:symbol_max)';
prob_tab_en(:, 2) = ones(size(prob_tab_en(:, 1)));
prob_tab_en(:, 3) = prob_tab_en(:, 2) ./ sum(prob_tab_en(:, 2));

prob_tab_de = prob_tab_en;

prob_tab_en_init = zeros(symbol_max, 3);
prob_tab_en_init(:, 1) = (1:symbol_max)';
prob_tab_en_init(:, 2) = ones(size(prob_tab_en_init(:, 1)));
prob_tab_en_init(:, 3) = prob_tab_en_init(:, 2) ./ sum(prob_tab_en_init(:, 2));

rngNum = str2double(rngNum);
pause(rngNum);
rng('shuffle');

% loop over the Eb/N0 values
for snr_index = 1%1:length(snrs)
    
    % Current snr
    snr = snr_start;
    % Convert from SNR (in dB) to noise power spectral density
    N0 = 1/(10^(snr/10));
    
    %     % Create a figure to plot the results.
    %     figure
    %     axes1 = axes('YScale','log');
    %     ylabel('SER');
    %     xlabel('SNR (in dB)');
    %     xlim([snrs(1), snrs(end)]);
    %     ylim([1e-6,1]);
    %     hold on
    %     plots = plot(nan,'Parent',axes1);
    
    datestamp = datestr(now, '_yymmddHHMMSS_');
    randstamp = num2str(floor(rand(1)*10000));
    filename = ['/home/wz4g11/matlab/UEC/4th_adap_arithmatic/adapArith/v11_memory_stationary_p1s_urc1_complexity_memorylen/Results/results_arithv3_job', num2str(job_index), '_snr_', num2str(snr_start), datestamp, randstamp, '.mat'];
    
    % initialization
    frame_index = 1;
    % Counters to store the number of bits and errors simulated so far
    symbol_error_counts = zeros(1, iteration_count);
    
    frame_errors = 0;
    frame_count  = 0;
    symbol_errors = 0;
    symbol_count  = 0;
    error_counts_acslimit = 0;
    
    % filter
    filter_order = 10*frames_per_cycle;
    B = fir1(filter_order, 2/frames_per_cycle); %
    hd = dfilt.dffir(B);
    hd.persistentmemory = true;
    hd.state = randn(1,filter_order);
    %
    
    symbol_mac_en = zeros(memory_len, m);
    symbol_mac_de = zeros(memory_len, m);
    
    % Continue the simulation until enough frame errors or bits have been simulated
    while frame_errors < target_frame_errors
        
        % desired_standard_deviation = 1/30
        % standard_deviation_normaliser = 0.4379
        % desired_mean = 0.797
        bool_corret_p1 = 0;
        while (~bool_corret_p1)
            
            new_data = randn;
            new_data = sigma/standard_deviation_normaliser*filter(hd, new_data) + desired_p1;
            
            if new_data <= desired_p1+3*sigma && new_data >= desired_p1-3*sigma
                
                p1 = new_data;
                s = zeta_p1_to_s(p1);
                bool_corret_p1 = 1;
            end
        end
        
        % check whether the length of p is an even number
        w_even = 0;
        % Generate some random bits
        x = generate_symbols(m, s);
        x(x > symbol_max) = symbol_max;
        % =============================== Arithmetic coding starts
        % Generate some random bits
        symbols = x;
        
        % Determine the cumulative symbol probabilities
        cumulative_probabilities_en = [0;cumsum(prob_tab_en(:, 3))]';
        % ===============================
        prob_tab_temp = zeros(symbol_max, 2);
        prob_tab_temp(:, 1) = (1:symbol_max)';
        
        row_cur = mod(frame_index, memory_len) + 1;
        symbol_mac_en(row_cur, :) = x;
        for row_index = 1:1:memory_len
            for number_index = 1:1:symbol_max
                prob_tab_temp(number_index, 2) = prob_tab_temp(number_index, 2) + sum(symbol_mac_en(row_index, :) == prob_tab_temp(number_index, 1));
            end
        end
        %
        prob_tab_en(:, 2) = prob_tab_en_init(:, 2) + prob_tab_temp(:, 2);
        prob_tab_en(:, 3) = prob_tab_en(:, 2) ./ sum(prob_tab_en(:, 2));
        % ===============================
        
        % Initialise the range of values to 0-1
        lower = 0;
        upper = 1;
        % For each symbol...
        for symbol_index = 1:length(symbols)
            % ...narrow down the range depending on the symbol values
            difference = vpa(upper - lower);
            
            % Display the ranges that are associated with each symbol value
            %     lower + difference*cumulative_probabilities;
            
            % Choose the range that corresponds to the next symbol value
            upper = lower + difference*cumulative_probabilities_en(symbols(symbol_index)+1);
            lower = lower + difference*cumulative_probabilities_en(symbols(symbol_index));
        end
        
        % Look for a value within the identified range, starting from a value of 0
        value = vpa(0);
        % Power of 0.5 to consider
        power = 1;
        temp = vpa(0.5)^power;
        % Initialise an empty bit sequence
        bits = [];
        % Keep going until the shortest binary number that represents a fraction within the identified range has been found
        while value < lower
            % If the next power of 0.5 keeps the value below upper...
            if value + temp <= upper
                % ...add this to our value
                value = value + temp;
                % Concatenate a 1 onto our bit sequence
                bits = [bits,1];
            else
                % Concatenate a 0 onto our bit sequence
                bits = [bits,0];
            end
            % Increase the power of 0.5
            power = power + 1;
            temp = temp/vpa(2);
        end
        % =============================== Arithmetic coding ends
        
        % Unary encoder
        y = bits;
        % CC encoder
        z = CC_encoder_4state(y);
        % Re-shape
        z_vec = reshape(z, 1, []);
        
        % interleaver1
        interleaver1 = randperm(length(z_vec));
        u = z_vec(interleaver1);
        
        % URC encoder
        v = URC1_encoder(u);
        
        % interleaver2
        interleaver2 = randperm(length(v));
        w = v(interleaver2);
        
        if doping
            doping_length = 2*round((doping_rate-1)*length(interleaver2)/2);
            w_doping = w((end-doping_length+1):end);
            w = [w w_doping];
        end
        
        % check whether the length of p is an even number
        if mod(length(w),2) == 1
            w = [w 0];
            w_even = 1;
        end
        
        % modulation
        p = reshape(w, 2, []);
        q = modulate(p);
        
        % Rayleigh channel
        channel = sqrt(1/2) * (randn(size(q)) + 1i*randn(size(q)));
        % Received symbols with noise
        q_rx = channel.*q + sqrt(N0/2) * (randn(size(q)) + 1i*randn(size(q)));
        
        % QPSK Demodulate
        p_tilde = soft_demodulate(q_rx, channel, N0);
        % Re-shape
        w_tilde = reshape(p_tilde, 1, []);
        
        % check whether the length of p is an even number
        if 1 == w_even
            w_tilde(end) = [];
        end
        
        % de-doping or de-puncturing
        if doping
            w_tilde_doping = w_tilde((end-doping_length+1):end);
            w_tilde = w_tilde(1:(length(w) - doping_length));
            w_tilde((end-doping_length+1):end) = w_tilde((end-doping_length+1):end) + w_tilde_doping;
        end
        
        % deinterleaver2
        v_tilde = zeros(size(v));
        v_tilde(interleaver2) = w_tilde;
        
        z_vec_tilde_e = zeros(size(z_vec));
        z_vec_tilde_a = zeros(size(z_vec));
        
        %
        error_counts = zeros(1, iteration_count);
        best_IE_UEC = -1;
        chance  = 0;
        iteration_index = 1;
        
        % iterations start
        while (iteration_index < iteration_count && chance < chances) || (iteration_index < 31)
            
            % interleaver1
            u_tilde_a = z_vec_tilde_e(interleaver1);
            
            % URC decoder
            %             u_tilde_e = URC8_decoder(v_tilde, u_tilde_a);
            %             [u_tilde_e,~]=bcjr_decoder(u_tilde_a,v_tilde,'urc8');
            trans2 = [1,          1,          0,          0, 0;
                1,          2,          1,          1, 0;
                2,          2,          0,          1, 0;
                2,          1,          1,          0, 0];
            [u_tilde_e, ytildep] = bcjr_decoder(u_tilde_a, v_tilde, 'uec', trans2);
            
            % deinterleaver1
            z_vec_tilde_a(interleaver1) = u_tilde_e;
            
            % Re-shape
            z_tilde_a = reshape(z_vec_tilde_a, size(z));
            
            % Calculate llr, % the number of 1 and 0
            y_tilde_a = zeros(size(y));
            
            % Do the CC deocder
            %             [z_tilde_e, ytildep] = CC_decoder_4state_bcjr(z_tilde_a, y_tilde_a);
            trans2 =  [1,          1,          0,          0,          0,  0;
                1,          3,          1,          1,          1,  0;
                2,          1,          0,          0,          1,  0;
                2,          3,          1,          1,          0,  0;
                3,          4,          0,          1,          0,  0;
                3,          2,          1,          0,          1,  0;
                4,          4,          0,          1,          1,  0;
                4,          2,          1,          0,          0,  0];
            [ytildep, z_tilde_e]  = bcjr_decoder(y_tilde_a,z_tilde_a,'uec',trans2);
            
            % Re-shape
            z_vec_tilde_e = reshape(z_tilde_e, 1, []);
            
            % Soft unary decoder
            % Last iteration
            [uncoded_p_tt, coded_e_tt, y_hat] = bcjr_decoder_v(y_tilde_a,z_tilde_a,'CCVit',trans2);
            
            % count the errors
            errors = sum(y_hat ~= y);
            
            if errors == 0
                % No need to carry on if all the errors have been removed.
                chance = chances;
            else
                IE_UEC = measure_mutual_information_averaging(z_tilde_e);
                % Have we seen an improvement in this iteration?
                if IE_UEC >  best_IE_UEC
                    best_IE_UEC = IE_UEC;
                else
                    chance = chance + 1;
                end
            end
            
            if errors > 0
                % Accumulate the number of errors that have been simulated so far
                error_counts(iteration_index:end) = errors;
            end
            
            if iteration_index == 30
                % =============================== Arithmetic decoding starts
                % Convert the binary number into a fraction
                value = sum(vpa(y_hat).*vpa(0.5).^(1:length(y_hat)));
                
                % Create some storage for the recovered symbols. The number of symbols is assumed to be known to the decoder.
                recovered_symbols = zeros(1,length(symbols));
                
                % Update the probability table
                cumulative_probabilities_de = [0;cumsum(prob_tab_de(:, 3))]';
                
                % Initialise the ranges for each symbol to the cumulative probabilities
                ranges = vpa(cumulative_probabilities_de);
                
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                lower=0;
                ranges_mask = ones(size(ranges));
                % For each symbol...
                for symbol_index = 1:length(recovered_symbols)
                    
                    % Find the symbol value which corresponds to the range in which our value falls
                    recovered_symbols(symbol_index) = 1;
                    keepgoing = 1;
                    while keepgoing
                        j = recovered_symbols(symbol_index)+1;
                        if ranges_mask(j) == 0
                            ranges_mask(j) = 1;
                            ranges(j) = difference*cumulative_probabilities_de(j)+lower;
                        end
                        if (value > ranges(j))
                            recovered_symbols(symbol_index) = recovered_symbols(symbol_index)+1;
                        else
                            keepgoing = 0;
                        end
                    end
                    %while value-lower > ranges(recovered_symbols(symbol_index)+1)
                    %    recovered_symbols(symbol_index) = recovered_symbols(symbol_index)+1;
                    %end
                    
                    % Update the ranges that correspond to each symbol value
                    if ranges_mask(recovered_symbols(symbol_index)) == 0
                        j = recovered_symbols(symbol_index);
                        ranges_mask(j) = 1;
                        ranges(j) = difference*cumulative_probabilities_de(j)+lower;
                    end
                    lower = ranges(recovered_symbols(symbol_index));
                    upper =  ranges(recovered_symbols(symbol_index)+1);
                    difference = upper-lower;
                    %ranges = difference*cumulative_probabilities_de;
                    ranges_mask = zeros(size(ranges));
                    %ranges = ranges + lower;
                end
                % =============================== Arithmetic decoding ends
                error_counts_acslimit = error_counts_acslimit + sum(recovered_symbols ~= symbols);
            end
            
            % Ready for next iteration
            iteration_index = iteration_index + 1;
        end
        
        % =============================== Arithmetic decoding starts
        % Convert the binary number into a fraction
        value = sum(vpa(y_hat).*vpa(0.5).^(1:length(y_hat)));
        
        % Create some storage for the recovered symbols. The number of symbols is assumed to be known to the decoder.
        recovered_symbols = zeros(1,length(symbols));
        
        % Update the probability table
        cumulative_probabilities_de = [0;cumsum(prob_tab_de(:, 3))]';
        %         prob_tab_de = prob_tab_en;
        
        % Initialise the ranges for each symbol to the cumulative probabilities
        ranges = vpa(cumulative_probabilities_de);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        lower=0;
        ranges_mask = ones(size(ranges));
        % For each symbol...
        for symbol_index = 1:length(recovered_symbols)
            % Find the symbol value which corresponds to the range in which our value falls
            recovered_symbols(symbol_index) = 1;
            keepgoing = 1;
            while keepgoing
                j = recovered_symbols(symbol_index)+1;
                if ranges_mask(j) == 0
                    ranges_mask(j) = 1;
                    ranges(j) = difference*cumulative_probabilities_de(j)+lower;
                end
                if (value > ranges(j))
                    recovered_symbols(symbol_index) = recovered_symbols(symbol_index)+1;
                else
                    keepgoing = 0;
                end
            end
            %while value-lower > ranges(recovered_symbols(symbol_index)+1)
            %    recovered_symbols(symbol_index) = recovered_symbols(symbol_index)+1;
            %end
            
            % Update the ranges that correspond to each symbol value
            if ranges_mask(recovered_symbols(symbol_index)) == 0
                j = recovered_symbols(symbol_index);
                ranges_mask(j) = 1;
                ranges(j) = difference*cumulative_probabilities_de(j)+lower;
            end
            lower = ranges(recovered_symbols(symbol_index));
            upper =  ranges(recovered_symbols(symbol_index)+1);
            difference = upper-lower;
            %ranges = difference*cumulative_probabilities_de;
            ranges_mask = zeros(size(ranges));
            %ranges = ranges + lower;
        end
        % =============================== Arithmetic decoding ends
        % Display the recovered symbols
        best_errors = sum(recovered_symbols ~= symbols);
        
        if best_errors > 0
            error_counts(iteration_index:end) = error_counts(iteration_index:end) + best_errors;
            
            % total number of errors for this frame
            symbol_errors = symbol_errors + best_errors;
            % number of frames
            frame_errors = frame_errors + 1;
            
        elseif best_errors == 0
            error_counts(iteration_index:end) = error_counts(iteration_index:end) + 0;
        end
        
        % total length of source x
        symbol_count = symbol_count + m;
        frame_count  = frame_count + 1;
        symbol_error_counts = symbol_error_counts + error_counts;
        
        % Store the SNR and BERs in a matrix and display it.
        results(snr_index,1) = snr;
        results(snr_index,2) = symbol_count;
        results(snr_index,3) = symbol_errors;
        results(snr_index,4) = frame_count;
        results(snr_index,5) = frame_errors;
        results(snr_index,6) = error_counts_acslimit;
        results(snr_index,(1:iteration_count)+6) = symbol_error_counts;
        
        % Save the results in a file
        save(filename, 'results', '-MAT');
        % ===============================
        prob_tab_temp = zeros(symbol_max, 2);
        prob_tab_temp(:, 1) = (1:symbol_max)';
        
        row_cur = mod(frame_index, memory_len) + 1;
        symbol_mac_de(row_cur, :) = recovered_symbols;
        for row_index = 1:1:memory_len
            for number_index = 1:1:symbol_max
                prob_tab_temp(number_index, 2) = prob_tab_temp(number_index, 2) + sum(symbol_mac_de(row_index, :) == prob_tab_temp(number_index, 1));
            end
        end
        %
        prob_tab_de(:, 2) = prob_tab_en_init(:, 2) + prob_tab_temp(:, 2);
        prob_tab_de(:, 3) = prob_tab_de(:, 2) ./ sum(prob_tab_de(:, 2));
        % ===============================
        
        % for next frame
        frame_index = frame_index + 1;
        
        %         % Plot the BER vs Eb/N0 results
        %         set(plots,'XData',snrs);
        %         set(plots,'YData',symbol_error_counts./symbol_counts);
        %         drawnow
    end
end
end


