function w = average_exp_golomb_weight(dist, s, threshold, k)
    
    symbol_count = 1000000;
    w = 0;
    keepgoing = 1;
    symbol_indices = 1:symbol_count;
    
    zeta_s = zeta(s);
    
    while keepgoing
       
        length = feval(dist, symbol_indices, s, zeta_s).*double(exp_golomb_weight(symbol_indices, k));
        
        w = w + sum(length);
        
        if(length(end) < threshold)
            keepgoing = 0;
        else
            symbol_indices = symbol_indices + symbol_count;
        end
    end
end
