% codewords is a matrix in which row s' gives the codeword from state s' to
% state -1. The codeword from state s' to state min(r,s'+1) and the
% codeword from state -s' to state 1 are assumed to be the compliment of
% the codeword from state s' to state -1.

% codewords = [1 1];
% codewords = [0 1; 1 1];
function c = trellis_encoder(b,codewords)

c = zeros(size(codewords,2),length(b));
state = 1;
even = 0;

%count = zeros(size(codewords,1),2,2);


for bit_index = 1:length(b)
%    count(state,2-b(bit_index),even+1) = count(state,2-b(bit_index),even+1) + 1;
   
    if b(bit_index)
        c(:,bit_index) = xor(even,codewords(state,:));
        state = 1;
        even = ~even;
    else
        c(:,bit_index) = xor(~even,codewords(state,:));
        state = min(size(codewords,1),state+1);                
    end
end
      
%mean(count/sum(sum(sum(count))),3)

%mean(log(count./repmat(sum(count,2),1,2)),3)
