function l = average_exp_golomb_length(dist, s, threshold, k)
    
    symbol_count = 1000000;
    l = 0;
    keepgoing = 1;
    symbol_indices = 1:symbol_count;
    
    zeta_s = zeta(s);
    
    while keepgoing
       
        length = feval(dist, symbol_indices, s, zeta_s).*exp_golomb_length(symbol_indices, k);
        
        l = l + sum(length);
        
        if(length(end) < threshold)
            keepgoing = 0;
        else
            symbol_indices = symbol_indices + symbol_count;
        end
    end
end
