% Jacobian logarithm
% If A = log(a) and B = log(b), then log(a+b) = max(A,B) + log(1+exp(-abs(A-B)))
% Copyright (C) 2008  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.


function C = add(varargin)


    global acs;

    if(nargin == 1)
        varargin = num2cell(reshape(varargin{1},1,numel(varargin{1})));
    end    
    
    C = varargin{1};  
    for arg_index = 2:length(varargin)
        C = C + varargin{arg_index};
    end    
    
    acs = acs+(length(varargin)-1)*sum(sum(sum(~(isinf(C)))));

end


% function C = add(A,B)
% 
%     global acs;
%    
%     % Perform the addition
%     C = A+B;
%     
%     % Count the ACS operations, ignoring any that have an infinite operand
%     acs = acs+sum(sum(~(isinf(A)|isinf(B))));
% end

