% EXIT function for a UEC used as an outer code
% Copyright (C) 2008  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.


% dist                 % distribution of the source bits
% s                    % parameter in the distribution
% codewords            % codewords of the trellis
% frame_count          % number of iterations for every point
% IA_count             % number of points in EXIT chart
% new_maxstar_mode
% bec                  % bec = 1:generate_bec_llrs; bec = 0:generate_llrs

% main_adptegcc_ser_zeta_memo_zero_non: the source symbol distribution is zeta distribution
% the memory length is zero, which means that the CC decoder neither
% estimate p1/l from current frame nor has no knowledge of p1/l at all.

% In this function, we assume that the EG-CC decoder will estimate a priori
% information y_tilde_a for every frame, with a fixed memory length.

function results = main_adptegcc_ser_zeta_memos_zero(snr_start, memory_len, job_index, rngNum)

global acs
global maxstar_mode
new_maxstar_mode = 0;
acs = 0;
maxstar_mode = new_maxstar_mode;

%
memory_len = str2double(memory_len); % 0: No priori information; 1,2,...,30: Actual memory length; inf: Perfect knowledge.
snr_start  = str2double(snr_start);
job_index  = str2double(job_index);
m = 1000;

if job_index == 1
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 20;
    standard_deviation_normaliser = 0.3097;
    doping = 1;
    puncturing = 0;
    doping_rate = 1/0.9845;
    
elseif job_index == 2
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    puncturing = 0;
    doping_rate = 1/0.9897;
    
elseif job_index == 4
    desired_p1 = 0.85;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 0;
    puncturing = 1;
    puncturing_rate = 1/1.0401;
    
elseif job_index == 5
    desired_p1 = 0.75;
    sigma      = 0.0333;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    puncturing = 0;
    doping_rate = 1/0.8638;
    
elseif job_index == 7
    desired_p1 = 0.8;
    sigma      = 0.05;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 1;
    puncturing = 0;
    doping_rate = 1/0.9626;
    
elseif job_index == 8
    desired_p1 = 0.8;
    sigma      = 0.0333;
    frames_per_cycle              = 160;
    standard_deviation_normaliser = 0.1097;
    doping = 1;
    puncturing = 0;
    doping_rate = 1/0.9962;
    
elseif job_index == 10
    desired_p1 = 0.8;
    sigma      = 0.01667;
    frames_per_cycle              = 40;
    standard_deviation_normaliser = 0.2186;
    doping = 0;
    puncturing = 1;
    puncturing_rate = 1/1.0020;
    
else
    
end
% ===============================
% s = zeta_p1_to_s(p1);
% =====================================
% target simulations parameters
target_frame_errors = 1000000;
% iteration_count = 100;
if job_index == 1
    iteration_count = 41;    
elseif job_index == 2
    iteration_count = 41;    
elseif job_index == 4
    iteration_count = 43;    
elseif job_index == 5
    iteration_count = 36;    
elseif job_index == 7
    iteration_count = 40;    
elseif job_index == 8
    iteration_count = 41;    
elseif job_index == 10
    iteration_count = 41;    
else
    
end
chances = 3;
% =====================================

% Choose parameters for the SER simulation

rngNum = str2double(rngNum);
pause(rngNum);
rng('shuffle');

% loop over the Eb/N0 values
for snr_index = 1%1:length(snrs)
    
    % Current snr
    snr = snr_start;
    % Convert from SNR (in dB) to noise power spectral density
    N0 = 1/(10^(snr/10));
    
    %     % Create a figure to plot the results.
    %     figure
    %     axes1 = axes('YScale','log');
    %     ylabel('SER');
    %     xlabel('SNR (in dB)');
    %     xlim([snrs(1), snrs(end)]);
    %     ylim([1e-6,1]);
    %     hold on
    %     plots = plot(nan,'Parent',axes1);
    
    datestamp = datestr(now, '_yymmddHHMMSS_');
    randstamp = num2str(floor(rand(1)*10000));
    filename = ['/home/wz4g11/matlab/UEC/4th_adap_arithmatic/adapEGCC/v11_memory_nonstationary_p1s_urc1_complexity_memorylen/Results/job', num2str(job_index), '/results_adptegcc_ser_job', num2str(job_index), '_', num2str(m), '_memos_', num2str(memory_len), '_snr_', num2str(snr_start), datestamp, randstamp, '.mat'];
    
    % initialization
    frame_index = 1;
    % Counters to store the number of bits and errors simulated so far
    symbol_counts = 0;
    symbol_errors = 0;
    frame_error_counts = 0;
    symbol_error_counts = zeros(1, iteration_count);
    
    %     % memory of storing symbols recoverred
    %     symbol_mac = cell(1, memory_len);
    
    % filter
    filter_order = 10*frames_per_cycle;
    B = fir1(filter_order, 2/frames_per_cycle); %
    hd = dfilt.dffir(B);
    hd.persistentmemory = true;
    hd.state = randn(1,filter_order);
    %
    
    % Continue the simulation until enough frame errors or bits have been simulated
    while frame_error_counts < target_frame_errors
        
        bool_corret_p1 = 0;
        while (~bool_corret_p1)
            
            new_data = randn;
            new_data = sigma/standard_deviation_normaliser*filter(hd, new_data) + desired_p1;
            
            if new_data <= desired_p1+3*sigma && new_data >= desired_p1-3*sigma
                
                p1 = new_data;
                s = zeta_p1_to_s(p1);
                bool_corret_p1 = 1;
            end
        end
        %
        
        % check whether the length of p is an even number
        w_even = 0;
        % Generate some random bits
        x = generate_symbols(m, s);
        
        % Exp_golomb encoder
        y = exp_golomb(x, 0);
        
        % CC encoder
        z = CC_encoder_4state(y);
        % Re-shape
        z_vec = reshape(z, 1, []);
        
        % interleaver1
        interleaver1 = randperm(length(z_vec));
        u = z_vec(interleaver1);
        
        % URC encoder
        v = URC1_encoder(u);
        
        % interleaver2
        interleaver2 = randperm(length(v));
        w = v(interleaver2);
        
        % doping or puncturing
        if doping
            doping_length = 2*round((doping_rate-1)*length(interleaver2)/2);
            w_doping = w((end-doping_length+1):end);
            w = [w w_doping];
        else
            puncturing_length = 2*round(puncturing_rate*length(interleaver2)/2);
            w = w(1: puncturing_length);
        end
        
        % check whether the length of p is an even number
        if mod(length(w),2) == 1
            w = [w 0];
            w_even = 1;
        end
        
        % modulation
        p = reshape(w, 2, []);
        q = modulate(p);
        
        % Rayleigh channel
        channel = sqrt(1/2) * (randn(size(q)) + 1i*randn(size(q)));
        % Received symbols with noise
        q_rx = channel.*q + sqrt(N0/2) * (randn(size(q)) + 1i*randn(size(q)));
        
        % QPSK Demodulate
        p_tilde = soft_demodulate(q_rx, channel, N0);
        % Re-shape
        w_tilde = reshape(p_tilde, 1, []);
        
        % check whether the length of p is an even number
        if 1 == w_even
            w_tilde(end) = [];
        end
        
        % de-doping or de-puncturing
        if doping
            w_tilde_doping = w_tilde((end-doping_length+1):end);
            w_tilde = w_tilde(1:(length(w) - doping_length));
            w_tilde((end-doping_length+1):end) = w_tilde((end-doping_length+1):end) + w_tilde_doping;
        else
            w_tilde = [w_tilde zeros(1, (length(interleaver2) - puncturing_length))];
        end
        
        % deinterleaver2
        v_tilde = zeros(size(v));
        v_tilde(interleaver2) = w_tilde;
        
        z_vec_tilde_e = zeros(size(z_vec));
        z_vec_tilde_a = zeros(size(z_vec));
        
        %         % update y_tilde_a
        %         if 1 == frame_index
        %             % no a priori information
        %             y_tilde_a = zeros(size(y));
        %         else
        %             % llr
        %             % length of y_tilde_a
        %             total_l = 0;
        %             % weight of y_tilde_a
        %             total_w = 0;
        %             for i = 1:1:memory_len
        %                 total_l = total_l + numel(symbol_mac{i});
        %                 total_w = total_w + sum(symbol_mac{i});
        %             end
        %             llr = log(total_w/(total_l - total_w));
        %             % see if the memory is already filled or not
        %             y_tilde_a = ones(size(y))*llr;
        %         end
        
        %
        best_IE = 0;
        chance  = 0;
        iteration_index = 1;
        
        % iterations start
        while iteration_index < iteration_count && chance < chances
            
            % interleaver1
            u_tilde_a = z_vec_tilde_e(interleaver1);
            
            %
            u_tilde_a(u_tilde_a == inf)  = 9000;
            u_tilde_a(u_tilde_a == -inf) = -9000;
            
            % URC decoder
            %             u_tilde_e = URC8_decoder(v_tilde, u_tilde_a);
            %             [u_tilde_e,~]=bcjr_decoder(u_tilde_a,v_tilde,'urc8');
            
            trans2 = [1,          1,          0,          0, 0;
                1,          2,          1,          1, 0;
                2,          2,          0,          1, 0;
                2,          1,          1,          0, 0];
            [u_tilde_e, ytildep] = bcjr_decoder(u_tilde_a, v_tilde, 'uec', trans2);
            
            % deinterleaver1
            z_vec_tilde_a(interleaver1) = u_tilde_e;
            % Re-shape
            z_tilde_a = reshape(z_vec_tilde_a, size(z));
            
            % no a priori information
            y_tilde_a = zeros(size(y));
            
            %             % Do the CC deocder
            %             [z_tilde_e, ytildep] = CC_decoder_4state_bcjr(z_tilde_a, y_tilde_a);
            trans2 =  [1,          1,          0,          0,          0,  0;
                1,          3,          1,          1,          1,  0;
                2,          1,          0,          0,          1,  0;
                2,          3,          1,          1,          0,  0;
                3,          4,          0,          1,          0,  0;
                3,          2,          1,          0,          1,  0;
                4,          4,          0,          1,          1,  0;
                4,          2,          1,          0,          0,  0];
            [ytildep, z_tilde_e]  = bcjr_decoder(y_tilde_a,z_tilde_a,'uec',trans2);
            
            % viterbi
            [uncoded_p_tt, coded_e_tt, y_hat] = bcjr_decoder_v(y_tilde_a,z_tilde_a,'CCVit',trans2);
            
            % Re-shape
            z_vec_tilde_e = reshape(z_tilde_e, 1, []);
            
            % Soft unary decoder
            x_hat = exp_golomb_decoder1(y_hat, m);
            
            % count the errors
            errors = sum(x_hat ~= x);
            
            % determine to stop decoding or not
            if errors == 0
                % stop iteration once get the 0 errors
                best_errors = 0;
                chance = chances;
            else
                % Have we seen an improvement in this iteration?
                IE_temp = measure_mutual_information_averaging(z_tilde_e);
                if IE_temp >  best_IE
                    best_IE = IE_temp;
                    best_errors = errors;
                else
                    chance = chance + 1;
                end
            end
            
            % only collect the data from the steaty state, say after 2*memory_len number of frames
            if frame_index > 10*memory_len
                % errors remaining after each iteration
                symbol_error_counts(iteration_index) = symbol_error_counts(iteration_index) + errors;
            end
            
            % Ready for next iteration
            iteration_index = iteration_index + 1;
        end
        
        % only collect the data from the steaty state, say after 2*memory_len number of frames
        if frame_index > 10*memory_len
            % If iterative decoding was stopped early, assume that the same BER would have been obtained for all subsequent decoding iterations
            while iteration_index <= iteration_count
                symbol_error_counts(iteration_index) = symbol_error_counts(iteration_index) + best_errors;
                iteration_index = iteration_index + 1;
            end
            
            % if cannot correctly decoding within iterations
            if best_errors ~= 0
                % total number of errors for this frame
                symbol_errors = symbol_errors + best_errors;
                % Accumulate the number of errors that have been simulated so far
                frame_error_counts = frame_error_counts + 1;
            end
            
            % all symbols are simulated so far
            symbol_counts = symbol_counts + m;
            
            % Store the SNR and BERs in a matrix and display it.
            results(snr_index,1) = snr;
            results(snr_index,2) = symbol_counts;
            results(snr_index,3) = symbol_errors;
            results(snr_index,4) = frame_index;
            results(snr_index,5) = frame_error_counts;
            results(snr_index,(1:iteration_count)+5) = symbol_error_counts;
            
            % Save the results in a file
            save(filename, 'results', '-MAT');
        end
        
        %         % update the corresponding row of symbol_mac and p_vec
        %         row_cur = mod(frame_index, memory_len) + 1;
        %         symbol_mac{row_cur} = y_hat;
        
        % for next frame
        frame_index = frame_index + 1;
        
        %         % Plot the BER vs Eb/N0 results
        %         set(plots,'XData',snrs);
        %         set(plots,'YData',symbol_error_counts./symbol_counts);
        %         drawnow
    end
end
end

