% Generate Gaussian distributed a priori LLRs
% Copyright (C) 2010  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% bits is a 1xK vector of bits
% mutual_information is a scalar in the range 0 to 1
% llrs is a 1xK vector of LLRs
function llrs = generate_bec_llrs(bits, mutual_information)

        

    if mutual_information < 0
        error('mutual information is too low!');
    elseif mutual_information > 1;
        error('mutual information is too high!');        
    elseif mutual_information == 0
        llrs = zeros(size(bits)); % Output a vector of c valued LLRs when the requested MI is 0
    elseif mutual_information == 1;
       llrs = 2*(bits-0.5)*inf; % Output a vector of infinite valued LLRs when the requested MI is H
    else
        
        pe = 1-mutual_information;
        
        llrs = 2*(bits-0.5)*inf;
        erasures = rand(size(llrs))<pe;
        llrs(erasures) = 0;
        
    end
        
end

