set term pslatex
set output '1job1_results.tex' 
set size square 1,1

set xlabel "$E_b/N_0~$[dB]" 
set ylabel "SER"  offset 0,0

set xrange [-0.5:8] 
set yrange [1e-6:1e-0] 

set format y '$10^{%T}$'
set log y
set key top left spacing 2 noautotitles nobox

set multiplot
################################### job1 in paper
set origin 0.75,2
set label 1 '(a)' at screen 0.88, screen 3
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7673,0.00008 to 0.7673,0.8 nohead
set label 2 "Capacity bound" at 0.44,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job2.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job2.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job2.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job2.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job2.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job2.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job2.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job2.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job2.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job2.txt' using 1:2 with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2

################################### job2 in paper
set origin 1.55,2
set label 1 '(b)' at screen 1.68, screen 3
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.4853,0.00008 to 0.4853,0.8 nohead
set label 2 "Capacity bound" at 0.16,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job4.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job4.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job4.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job4.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job4.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job4.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job4.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job4.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job4.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job4.txt' using 1:2 with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2

################################### job3 in paper
set origin 0.75,1
set label 1 '(c)' at screen 0.88, screen 2
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7252,0.00008 to 0.7252,0.8 nohead
set label 2 "Capacity bound" at 0.40,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job5.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job5.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job5.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job5.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job5.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job5.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job5.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job5.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job5.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job5.txt' using 1:2 with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2


################################### job4 in paper
set origin 1.55,1
set label 1 '(d)' at screen 1.68, screen 2
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7761,0.00008 to 0.7761,0.8 nohead
set label 2 "Capacity bound" at 0.45,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job1.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job1.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job1.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job1.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job1.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job1.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job1.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job1.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job1.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job1.txt' using 1:2 with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2

################################### job5 in paper
set origin 0.75,0
set label 1 '(e)' at screen 0.88, screen 1
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7436,0.00008 to 0.7436,0.8 nohead
set label 2 "Capacity bound" at 0.42,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job8.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job8.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job8.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job8.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job8.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job8.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job8.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job8.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job8.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job8.txt' using 1:2 with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2


################################### job6 in paper
set origin 1.55,0
set label 1 '(f)' at screen 1.68, screen 1
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7534,0.00008 to 0.7534,0.8 nohead
set label 2 "Capacity bound" at 0.43,0.00105 rotate left

plot 'gp_results_adptegcc_memo_0_job10.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job10.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job10.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job10.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job10.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job10.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job10.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job10.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job10.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job10.txt' using 1:2 with lp lt 1 pt 12 ps 1.2


unset arrow 5
unset label 1
unset label 2

################################### job7 in paper
set origin 0.75,-1
set label 1 '(g)' at screen 0.88, screen 0
#set label 2 '$a=100$' at screen 0.53, screen 1 center

set arrow 5 from 0.7242,0.00008 to 0.7242,0.8 nohead
set label 2 "Capacity bound" at 0.40,0.00105 rotate left
set key right spacing 1.7 width 0.1 noautotitles box 
set key at 16,0.7 right

plot 'gp_results_adptegcc_memo_0_job7.txt' using 1:2 with lp lt 1 pt 1 ps 1.2,\
'gp_results_adptegcc_memo_1_job7.txt' using 1:2 with lp lt 1 pt 2 ps 1.2,\
'gp_results_adptegcc_perfect_job7.txt' using 1:2 with lp lt 3 pt 9 ps 1.2,\
'gp_results_adptuec_memo_0_job7.txt' using 1:2 with lp lt 1 pt 6 ps 1.2,\
'gp_results_adptuec_memo_1_job7.txt' using 1:2 with lp lt 1 pt 8 ps 1.2,\
'gp_results_adptuec_memo_best_job7.txt' using 1:2 with lp lt 1 pt 4 ps 1.2,\
'gp_results_adptuec_perfect_job7.txt' using 1:2 with lp lt 3 pt 5 ps 1.2,\
'gp_results_arithv1_job7.txt' using 1:2 with lp lt 3 pt 7 ps 1.2,\
'gp_results_arithv2_job7.txt' using 1:2 with lp lt 3 pt 11 ps 1.2,\
'gp_results_arithv3_job7.txt' using 1:2 with lp lt 1 pt 12 ps 1.2,\
'dummy.txt' using 1:2 title 'UEC $M=0$' with lp lt 1 pt 6 ps 1.2,\
'dummy.txt' using 1:2 title 'UEC $M=1$' with lp lt 1 pt 8 ps 1.2,\
'dummy.txt' using 1:2 title 'UEC $M=T$' with lp lt 1 pt 4 ps 1.2,\
'dummy.txt' using 1:2 title '  UEC idealized' with lp lt 3 pt 5 ps 1.2,\
'dummy.txt' using 1:2 title '  EG-CC $M=0$' with lp lt 1 pt 1 ps 1.2,\
'dummy.txt' using 1:2 title '  EG-CC $M=1$' with lp lt 1 pt 2 ps 1.2,\
'dummy.txt' using 1:2 title 'EG-CC idealized' with lp lt 3 pt 9 ps 1.2,\
'dummy.txt' using 1:2 title 'Arithmetic-CC v1' with lp lt 3 pt 7 ps 1.2,\
'dummy.txt' using 1:2 title 'Arithmetic-CC v2' with lp lt 3 pt 11 ps 1.2,\
'dummy.txt' using 1:2 title 'Arithmetic-CC v3' with lp lt 1 pt 12 ps 1.2

unset arrow 5
unset label 1
unset label 2

unset xlabel
unset ylabel
unset xrange
unset yrange
unset log y





