% Jacobian logarithm
% If A = log(a) and B = log(b), then log(a+b) = max(A,B) + log(1+exp(-abs(A-B)))
% Copyright (C) 2008  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.



function C = maxstar(varargin)

    global maxstar_mode; % 0 for exact, 1 for LUT, 2 for approx
    global acs;
   
    if(nargin == 1)
        varargin = num2cell(reshape(varargin{1},1,numel(varargin{1})));
    end
    
    
    operations1 = 0;
    operations2 = varargin{1} < inf;
    
    
    C = varargin{1};    
    for arg_index = 2:length(varargin)

        operations1 = operations1 + (C>-inf & varargin{arg_index}>-inf);
        
        operations2 = operations2 & varargin{arg_index}<inf;
        
        
        % Depending on the mode, perform the correction
        if maxstar_mode == 2
%            acs = acs+sum(sum(~(isinf(C)|isinf(varargin{arg_index}))));
            
            % Perform the max operation
            C = max(C,varargin{arg_index});
        else 
%            acs = acs+5*sum(sum(~(isinf(C)|isinf(varargin{arg_index}))));
            
            % Calculate the difference
            difference = abs(C-varargin{arg_index});

            % Replace Inf-Inf=NaN with Inf-Inf=0 
            difference(isnan(difference)) = 0;

            if maxstar_mode == 1            
                % Use the LUT to approximate the correction
                correction = 0.65*ones(size(difference));
                correction(difference>=0.196) = 0.55;
                correction(difference>=0.433) = 0.45;
                correction(difference>=0.710) = 0.35;
                correction(difference>=1.050) = 0.25;
                correction(difference>=1.508) = 0.15;
                correction(difference>=2.252) = 0.05;
                correction(difference>=4.500) = 0;
            else
                % Use the exact correction
                correction = log(1+exp(-difference));
            end

            % Apply the correction
            C = max(C,varargin{arg_index}) + correction;
        end       
    end
    
    if maxstar_mode == 2
        acs = acs + sum(sum(sum(operations2.*operations1)));
    else
        acs = acs + 5*sum(sum(sum(operations2.*operations1)));
    end
    
    
end
    
    
% function C = maxstar(varargin)
%     global maxstar_mode; % 0 for exact, 1 for LUT, 2 for approx
% 
%     global acs;
% 
%     % Perform the max operation
%     C = max(A,B);
%     
%     % Depending on the mode, perform the correction
%     if maxstar_mode == 2
%         % Used to count ACS operations
%         multiplier = 1;
%     else 
%         % Calculate the difference
%         difference = abs(A-B);
%         
%         % Replace Inf-Inf=NaN with Inf-Inf=0 
%         difference(isnan(difference)) = 0;
%         
%         if maxstar_mode == 1            
%             % Use the LUT to approximate the correction
%             correction = 0.65*ones(size(difference));
%             correction(difference>=0.196) = 0.55;
%             correction(difference>=0.433) = 0.45;
%             correction(difference>=0.710) = 0.35;
%             correction(difference>=1.050) = 0.25;
%             correction(difference>=1.508) = 0.15;
%             correction(difference>=2.252) = 0.05;
%             correction(difference>=4.500) = 0;
%         else
%             % Use the exact correction
%             correction = log(1+exp(-difference));
%         end
%         
%         % Apply the correction
%         C = C + correction;
%             
%         % Used to count ACS operations
%         multiplier = 5;
%     end
%     
%    % Count the ACS operations, ignoring any that have an infinite operand
%    acs = acs+multiplier*sum(sum(~(isinf(A)|isinf(B))));
%     
% end
% 
