classdef MeasurementTlbx
    %UNTITLED3 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
    end
    
    methods (Static)
        
        %%
        function RepeatFlag = AcceptOrRepeatMeasurement_Prompt
            %
            
            AcceptString = input('Do you want to [A]ccept the measurements or [R]epeat them? [A/R] ', 's');

            while ~(strcmp(AcceptString, 'A') || strcmp(AcceptString, 'R'))
                display('Please input A or R.')
                AcceptString = input('Do you want to [A]ccept the measurements or [R]epeat them? [A/R] ', 's');
            end
            
            switch AcceptString
                case 'A', RepeatFlag = 0;
                case 'R', RepeatFlag = 1;
            end
            
%             switch AcceptFlag % It is the old RepeatFlag
%                 case 1
%                     AcceptFlag = 0;
%                 case 0
%                     AcceptFlag = 1;
%             end
            
            
        end%%%
        
        %%
        function  TestHardware(MaxGain_INIT, TotalNumOutputChan, MicIdxs)
            
            
            [y, fs] = audioread('whitenoise_6s_48kHz.wav');
            
            % Testing output audio (if needed)
            % Play all the outputs - one at a time (to test speakers)
            display('Testing all the speakers, one at a time')
            MultiChAudioTlbx.TestOutputChannels(y(1:2*fs), 1, TotalNumOutputChan, fs, MaxGain_INIT, 'AllOutputs-OneAtATime');
            %
            % Testing output audi: Play Some Channels
            ChannelsToPlay = [1:3];
            display(['Playing channels' num2str(ChannelsToPlay)])
            MultiChAudioTlbx.TestOutputChannels(y, ChannelsToPlay, TotalNumOutputChan, fs, MaxGain_INIT);
            
            % Testing the inputs
            if MicIdxs ~= 0
                % Record (To test microphones)
                
                display('Testing microphones')
                q = zeros(length(y), TotalNumOutputChan);
                q(:, 1) = y; % TO record noise level comment this line
                OutputSignal = MultiChAudioTlbx.PlayRecord(q, 1, TotalNumOutputChan, fs, MicIdxs, MaxGain_INIT);
                
                figure;
                subplot(1,2,1); plot(y);
                title('Signal reproduced by the speakers.')
                subplot(1,2,2); plot(OutputSignal);
                title('Signal recorded by the microphones')
                
                fffff = fft(OutputSignal);
                aaa = CreateFrequencyVector(fs, length(OutputSignal));
                fffff = fffff(1:length(OutputSignal)/2 +1);
                figure;
                semilogx(aaa, LogDB(abs(fffff)));
                
                pwelch(OutputSignal, [], [], [], fs, 'twosided'); % Uses default window, overlap & NFFT.
            end
            
            
            
        end
        
        %%
        function Plots( TimeDomainWave, Estimated_IR, Estimated_FRF, Coherence, MicNumb, fs, N_fft, FilterTitleStr)
            %UNTITLED2 Summary of this function goes here
            %   Detailed explanation goes here
            
            ffreq = CreateFrequencyVector(fs, N_fft);
            
            % Plotting results
            numbrow = 2;
            numbcol = 3;
            
            freqlimits = [50, 10000];
            
            
            FigureTlbx.New(['Measurements from Microphone Num ' num2str(MicNumb) ' Filter ' FilterTitleStr], 0);
            
            %             subplot(numbrow,numbcol,[1 2]);
            %             plot(TimeDomainWave); title('Time Domain Recorded Data');
            
            subplot(numbrow,numbcol, 1);
            plot(Estimated_IR); title('Estimated IR pressure');
            
            subplot(numbrow,numbcol, 2);
            semilogx(ffreq, LogDB(abs(Estimated_FRF)));
            title('Magnitude FRFs'); xlim(freqlimits); xlabel(labels.FreqInHertz)
            
            subplot(numbrow,numbcol, 3);
            semilogx(ffreq, angle(Estimated_FRF));
            title('Phase FRFs'); xlim(freqlimits); xlabel(labels.FreqInHertz)
            
            subplot(numbrow,numbcol, 4);
            semilogx(ffreq, Coherence);
            title('Coherence'); ylim([0, 1.1]);
            xlim(freqlimits); xlabel(labels.FreqInHertz)
            
            subplot(numbrow,numbcol, 5);
             plot(TimeDomainWave); title('Time domain recording');
            
        end
        
        %%
        function SaveVariables(TitleSession, curr_timedomain_file)
            % Saving into big matrices for later usage
            %TimeDomainRecordings = curr_timedomain_file;
            
            NameFile = [TitleSession];
            save(NameFile,'curr_timedomain_file');     % 'IR_estimated','FRF_estimated','COH_estimated',
        end
        
        %%
        
    end
    
end

