classdef SineSweepTlbx
    % Collection of Methods (Functions) for measuring the response (Impulse Response and the
    % Transfer function) of a LTI system
    
    properties
        
    end
    
    %%
    methods(Static)
        
        % Using a sine sweep measurement
        %[h, H] = SineSweep(SineSweepInputSignalWAV, OutputSignalRecorded, InverseFilterWAV, N_fft, fs);
        function [h_IR, H_fft] = ApplyInverseFilter(RecordedSineSweep, InverseFilter, NormalizationFactor)
            %APPYINVERSEFILTER Summary of this function goes here
            %   Detailed explanation goes here
            % If RecordedSineSweep is a matrix, it must be
            % NUMFILTER*TIMEDURATION
            
            if nargin < 3
                NormalizationFactor = 1;
            end
            
            %NumDimsMatrixSineSweep = ndims(RecordedSineSweep);
            [NumFilter, TimeDuration] = size(RecordedSineSweep); % it is assumed to be the minimum
            
            lengthConvolution = TimeDuration; % Because of the frequency domain convolution
            h_IR = zeros(NumFilter, lengthConvolution);
            H_fft = zeros(NumFilter, lengthConvolution);
            for idx = 1:NumFilter
                
                curr_rec = squeeze(RecordedSineSweep(idx, :));
                %curr_rec = curr_rec(:);
                temph = FilterTlbx.fconv(curr_rec, InverseFilter);
                %temph = conv(curr_rec, InverseFilter);
                
                temph = temph/NormalizationFactor;
                tempH = fft(temph);
                
               
                h_IR(idx, :) = temph; % Normalising by the sampling frequency
                H_fft(idx, :) = tempH;
                
            end
            
        end
        
        function Plots(h, H, fs, FigureNameTextStr)
            
            %PLOTS Summary of this function goes here
            %   Detailed explanation goes here
            if nargin < 4
            else
                figure('Name', [FigureNameTextStr ' WhiteNoise']);
            end
            
            N_fft = length(h);
            
            samplevect = (0:(N_fft - 1));
            timevect = samplevect/fs;
            freqvect = linspace(0, fs, N_fft);
            
            subplot(3,1,1); plot(timevect, h); title('Estimated IR'); xlabel('Samples'); ylabel('Amplitude'); grid on;
            xlim([timevect(1), timevect(end)]);
            
            Ax1 = gca;
            Ax2 = axes('Position', get(Ax1,'Position'), 'XAxisLocation','top');
            plot(samplevect, h, 'color','k','parent', Ax2);
            xlim([samplevect(1), samplevect(end)]);
            
            subplot(3,1,2); semilogx(freqvect, LogDB(abs(H))); title('Estimated Magnitude FRF'); xlabel('Freq, Hz'); ylabel('dB');
            grid on; xlim([50, fs/2]);
            
            subplot(3,1,3); semilogx(freqvect, unwrap(angle((H)))); title('PHase'); xlabel('Freq, Hz');xlim([50, fs/2]);  grid on;
            
            
        end
        
    end
    
    
end%Static Methods
