import matplotlib.pyplot as plt
import os


def prov_aggregator_statements(bindings_output, templates_output, expansions_output, info, location):

    template_names = {"template_1409":"orch_negotiation_reject",
                      "template_1408":"orch_negotiation_final",
                      "template_1407":"orch_negotiation_accept",
                      "template_4916":"ui_submit_request",
                      "template_4917":"ui_receive_ride_request",
                      "template_4":"ui_view_derivation",
                      "template_1410":"orch_composition",
                      "template_5":"orch_submit_request",
                      "template_25878":"reputation_api_call",
                      "template_3":"ui_change_view",
                      "template_2":"ui_login",
                      "total_average":"total_average"
                      }

    csv = '{0}outputs/normalised_stats.csv'.format(location)
    csv2 = '{0}outputs/totals_stats.csv'.format(location)

    try:
        os.remove(csv)
        os.remove(csv2)
    except:
        print ""

    dic = {}

    with open(csv, 'a') as stat_file:
        headers = "template name, size, binding, size, expansion, size\n"
        stat_file.write(headers)

    with open(info) as info_file:

        for info_line in info_file:

            template_name = info_line.split()[0].split('/')[2]

            template_size = 0
            binding_size = 0
            expansion_size = 0

            with open(templates_output) as template_file:
                for template_line in template_file:
                    if "{0}.ttl".format(template_name) in template_line:
                        #template_size = template_line.split(', ')[1].strip()
                        template_size = template_line.split(' ')[-1]
                        print "template size: "+template_line, " --- ", template_size

            binding_name = info_line.split()[1].split('/')[2]
            with open(bindings_output) as binding_file:
                for binding_line in binding_file:
                    if "{0}.ttl".format(binding_name) in binding_line:
                        #binding_size = binding_line.split(', ')[1].strip()
                        binding_size = binding_line.split(' ')[-1]
                        print "binding size: "+binding_line, " --- ", binding_size

            expansion_name = info_line.split()[2].split('/')[2]
            with open(expansions_output) as expansion_file:
                for expansions_line in expansion_file:
                    if "{0}.ttl".format(expansion_name) in expansions_line:
                        #expansion_size = expansions_line.split(', ')[1].strip()
                        expansion_size = expansions_line.split(' ')[-1]
                        print "expansion line: "+expansions_line, " --- ", expansion_size

            stat = "{0}, {1}, {2}, {3}, {4}, {5}\n".format(template_name,
                                                           template_size,
                                                           binding_name,
                                                           binding_size,
                                                           expansion_name,
                                                           expansion_size)

            print "stat: --",stat

            if template_name in dic.keys():
                dic[template_name]['binding_size'].append(int(binding_size))
                dic[template_name]['expansion_size'].append(int(expansion_size))
            else:
                dic[template_name] = {'binding_size':[int(binding_size)],
                                      'expansion_size': [int(expansion_size)],
                                      'template_size': int(template_size)}
            with open(csv, 'a') as stat_file:
                stat_file.write(stat)

        averages = {}

        for temp_name, sizes in dic.iteritems():
            for s in sizes.iteritems():
                if 'binding_size' is s[0]:
                    averages[temp_name+'_average_binding_size'] = sum(s[1])/len(s[1])
                    if 'b_sizes' in averages.keys():
                        averages['b_sizes'].extend(s[1])
                    else:
                        averages['b_sizes'] = s[1]
                if 'expansion_size' is s[0]:
                    averages[temp_name+'_average_expansion_size'] = sum(s[1])/len(s[1])
                    if 'e_sizes' in averages.keys():
                        averages['e_sizes'].extend(s[1])
                    else:
                        averages['e_sizes'] = s[1]
                if 'template_size' is s[0]:
                    averages[temp_name+'_size'] = s[1]
                    if 't_sizes' in averages.keys():
                        averages['t_sizes'].extend([s[1]])
                    else:
                        averages['t_sizes'] = [s[1]]

        averages['total_average_b_size'] = sum(averages['b_sizes'])/len(averages['b_sizes'])
        averages['total_average_t_size'] = sum(averages['t_sizes'])/len(averages['t_sizes'])
        averages['total_average_e_size'] = sum(averages['e_sizes'])/len(averages['e_sizes'])

        headers = 'template, template_size, average_binding_size, average_expansion_size\n'
        record = '{0}, {1}, {2}, {3}\n'.format('total_average',
                                             averages['total_average_t_size'],
                                             averages['total_average_b_size'],
                                             averages['total_average_e_size'])
        with open(csv2, 'a') as stat2_file:
            stat2_file.write(headers)
            stat2_file.write(record)

        abs = 0
        aes = 0
        ats = 0

        for temp_name, sizes in dic.iteritems():
            for k,v in averages.iteritems():
                #print "{0}{1}".format(temp_name,'_average_binding_size'),' ', k, "{0}{1}".format(temp_name,'_average_binding_size') == str(k),  type("{0}{1}".format(temp_name,'_average_binding_size')), type(str(k)), v
                if "{0}{1}".format(temp_name,'_average_binding_size') == str(k):
                    abs = v
                if "{0}{1}".format(temp_name,'_average_expansion_size') == str(k):
                    aes = v
                if "{0}{1}".format(temp_name,'_size') == str(k):
                    ats = v
                record2 = '{0}, {1}, {2}, {3}\n'.format(temp_name, ats, abs, aes)
            with open(csv2, 'a') as stat2_file:
                stat2_file.write(record2)

    read_file = open(csv2,'r')
    sep_file = read_file.read().split('\n')
    count = 0
    count2 = 0
    colours = ['#550000',
               '#801515',
               '#D46A6A',
               '#042037',
               '#123652',
               '#496D89',
               '#405100',
               '#647A14',
               '#B6CB66',
               '#1C053A',
               '#321456',
               '#6B4E90',
               '#3F002E',
               '#5F1049',
               '#9F4F89',
               '#eee999',
               '#aaa888',
               ]
    for d in sep_file:
        #print d, type(d), len(d)
        if count != 0 and len(d) is not 0:

            values = d.split(',')
            print values
            print float(values[1]), float(values[2]), float(values[3]), count, count+len(sep_file), count+len(sep_file)*2, colours[count2]
            #plt.bar([float(values[1]), float(values[2]), float(values[3])], [count, count+len(sep_file), count+len(sep_file)*2], color=colours[count-1])
            #plt.bar([count, count+len(sep_file), count+len(sep_file)*2],[float(values[1]), float(values[2]), float(values[3])], color=colours[count-1])
            plt.bar([count, count+1, count+2],
                    [float(values[1]), float(values[2]), float(values[3])],
                    color=colours[count2],
                    label=template_names[values[0]])
            count2 += 1
        count += 3


    plt.title('Average Number of Triples for Templates, Bindings and their Expansion Normalised in ttl')
    plt.xlabel('Provenance (Template, Binding, Expansion)')
    plt.ylabel('Size in Bytes')
    plt.legend()
    plt.show()

def prov_aggregator_bytes(bindings_output, templates_output, expansions_output, info, location, format, format_b, pdffile):

    template_names = {"template_1409":"orch_negotiation_reject",
                      "template_1408":"orch_negotiation_final",
                      "template_1407":"orch_negotiation_accept",
                      "template_4916":"ui_submit_request",
                      "template_4917":"ui_receive_ride_request",
                      "template_4":"ui_view_derivation",
                      "template_1410":"orch_composition",
                      "template_5":"orch_submit_request",
                      "template_25878":"reputation_api_call",
                      "template_3":"ui_change_view",
                      "template_2":"ui_login",
                      "total_average":"total_average"
                      }

    csv = '{0}/outputs/normalised_stats.csv'.format(location)
    csv2 = '{0}/outputs/totals_stats.csv'.format(location)

    try:
        os.remove(csv)
        os.remove(csv2)
    except:
        print ""

    dic = {}

    with open(csv, 'a') as stat_file:
        headers = "template name, size, binding, size, expansion, size\n"
        stat_file.write(headers)

    with open(info) as info_file:

        for info_line in info_file:

            template_name = info_line.split()[0].split('/')[2]

            template_size = 0
            binding_size = 0
            expansion_size = 0

            with open(templates_output) as template_file:
                for template_line in template_file:
                    if "{0}.{1}".format(template_name, format) in template_line:
                        template_size = template_line.split(', ')[1].strip()
                        #template_size = template_line.split(' ')[-1]
                        print "template size: "+template_line, " --- ", template_size

            binding_name = info_line.split()[1].split('/')[2]
            with open(bindings_output) as binding_file:
                for binding_line in binding_file:
                    if "{0}.{1}".format(binding_name, format_b) in binding_line:
                        binding_size = binding_line.split(', ')[1].strip()
                        #binding_size = binding_line.split(' ')[-1]
                        print "binding size: "+binding_line, " --- ", binding_size

            expansion_name = info_line.split()[2].split('/')[2]
            with open(expansions_output) as expansion_file:
                for expansions_line in expansion_file:
                    if "{0}.{1}".format(expansion_name, format) in expansions_line:
                        expansion_size = expansions_line.split(', ')[1].strip()
                        #expansion_size = expansions_line.split(' ')[-1]
                        print "expansion line: "+expansions_line, " --- ", expansion_size

            stat = "{0}, {1}, {2}, {3}, {4}, {5}\n".format(template_name,
                                                           template_size,
                                                           binding_name,
                                                           binding_size,
                                                           expansion_name,
                                                           expansion_size)

            print "stat: --",stat

            if template_name in dic.keys():
                dic[template_name]['binding_size'].append(int(binding_size))
                dic[template_name]['expansion_size'].append(int(expansion_size))
            else:
                dic[template_name] = {'binding_size':[int(binding_size)],
                                      'expansion_size': [int(expansion_size)],
                                      'template_size': int(template_size)}
            with open(csv, 'a') as stat_file:
                stat_file.write(stat)

        averages = {}

        for temp_name, sizes in dic.iteritems():
            for s in sizes.iteritems():
                if 'binding_size' is s[0]:
                    averages[temp_name+'_average_binding_size'] = sum(s[1])/len(s[1])
                    if 'b_sizes' in averages.keys():
                        averages['b_sizes'].extend(s[1])
                    else:
                        averages['b_sizes'] = s[1]
                if 'expansion_size' is s[0]:
                    averages[temp_name+'_average_expansion_size'] = sum(s[1])/len(s[1])
                    if 'e_sizes' in averages.keys():
                        averages['e_sizes'].extend(s[1])
                    else:
                        averages['e_sizes'] = s[1]
                if 'template_size' is s[0]:
                    averages[temp_name+'_size'] = s[1]
                    if 't_sizes' in averages.keys():
                        averages['t_sizes'].extend([s[1]])
                    else:
                        averages['t_sizes'] = [s[1]]

        averages['total_average_b_size'] = sum(averages['b_sizes'])/len(averages['b_sizes'])
        averages['total_average_t_size'] = sum(averages['t_sizes'])/len(averages['t_sizes'])
        averages['total_average_e_size'] = sum(averages['e_sizes'])/len(averages['e_sizes'])

        headers = 'template, template_size, average_binding_size, average_expansion_size\n'
        record = '{0}, {1}, {2}, {3}\n'.format('total_average',
                                             averages['total_average_t_size'],
                                             averages['total_average_b_size'],
                                             averages['total_average_e_size'])
        with open(csv2, 'a') as stat2_file:
            stat2_file.write(headers)
            stat2_file.write(record)

        abs = 0
        aes = 0
        ats = 0

        for temp_name, sizes in dic.iteritems():
            for k,v in averages.iteritems():
                #print "{0}{1}".format(temp_name,'_average_binding_size'),' ', k, "{0}{1}".format(temp_name,'_average_binding_size') == str(k),  type("{0}{1}".format(temp_name,'_average_binding_size')), type(str(k)), v
                if "{0}{1}".format(temp_name,'_average_binding_size') == str(k):
                    abs = v
                if "{0}{1}".format(temp_name,'_average_expansion_size') == str(k):
                    aes = v
                if "{0}{1}".format(temp_name,'_size') == str(k):
                    ats = v
                record2 = '{0}, {1}, {2}, {3}\n'.format(temp_name, ats, abs, aes)
            with open(csv2, 'a') as stat2_file:
                stat2_file.write(record2)

    read_file = open(csv2,'r')
    sep_file = read_file.read().split('\n')
    count = 0
    count2 = 0
    colours = ['#550000',
               '#801515',
               '#D46A6A',
               '#042037',
               '#123652',
               '#496D89',
               '#405100',
               '#647A14',
               '#B6CB66',
               '#1C053A',
               '#321456',
               '#6B4E90',
               '#3F002E',
               '#5F1049',
               '#9F4F89',
               '#eee999',
               '#aaa888',
               ]
    for d in sep_file:
        #print d, type(d), len(d)
        if count != 0 and len(d) is not 0:

            values = d.split(',')
            print values
            print float(values[1]), float(values[2]), float(values[3]), count, count+len(sep_file), count+len(sep_file)*2, colours[count2]
            #plt.bar([float(values[1]), float(values[2]), float(values[3])], [count, count+len(sep_file), count+len(sep_file)*2], color=colours[count-1])
            #plt.bar([count, count+len(sep_file), count+len(sep_file)*2],[float(values[1]), float(values[2]), float(values[3])], color=colours[count-1])
            plt.bar([count, count+1, count+2],
                    [float(values[1]), float(values[2]), float(values[3])],
                    color=colours[count2],
                    label=template_names[values[0]])
            count2 += 1
        count += 3


    plt.title('Average Size of Templates, Bindings and their Expansion Normalised in ttl in bytes')
    plt.xlabel('Provenance (Template, Binding, Expansion)')
    plt.ylabel('Size in Bytes')
    plt.legend()
    #plt.show()
    plt.savefig(pdffile)



#prov_aggregator_statements('../smartshare/archive_34644/bindings_output_2.txt',
#                '../smartshare/archive_34644/templates_output_2.txt',
#                '../smartshare/archive_34644/expansions_output_2.txt',
#                '../smartshare/archive_34644/info2.txt',
#                '../smartshare/archive_34644/')

prov_aggregator_bytes('outputs/bindings_output.txt',
                      'outputs/templates_output.txt',
                      'outputs/expansions_output.txt',
                      'outputs/info2.txt',
                      '.', 'provn', 'provn',
                      'outputs/plot_bytes.pdf')

### recomputing with new bindings
prov_aggregator_bytes('outputs/bindings2_output.txt',
                      'outputs/templates_output.txt',
                      'outputs/expansions_output.txt',
                      'outputs/info2_v2.txt',
                      '.', 'provn', 'json',
                      'outputs/plot_bytes2.pdf')
