FontSize=18;
fig=figure;
axes('YScale','log');
xlim([0, 3]);
ylim([1e-7, 1]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',FontSize-2);
xlabel('$E_b/N_0$ (dB)','fontsize',FontSize,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
set(gca,'XTick',[0:0.5:3]);
ylabel('BER','fontsize',FontSize,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
hold on


% Plot Benchmarker
I_BCJR = 5;
BER_N256=[1e-1 6e-2 4e-2 2e-2 8e-3 3e-3 9e-4 1.8e-4 3.5e-5 5.5e-6];
EbN0_N256=[0:0.25:2.25];
BER_N512=[1e-1 5.5e-2 3e-2 1e-2 3e-3 5.5e-4 6.5e-5 7.5e-6 3e-7];
EbN0_N512=[0:0.25:2];
BER_N1024=[1e-1 4.5e-2 2.5e-2 5.5e-3 9e-4 6e-5 4e-6 5e-7];
EbN0_N1024=[0:0.25:1.75];
fig_BM_(1)=semilogy(EbN0_N256,BER_N256,'-r','LineWidth',2,'MarkerSize',8);
fig_BM_(2)=semilogy(EbN0_N512,BER_N512,'-r','LineWidth',2,'MarkerSize',8);
fig_BM_(3)=semilogy(EbN0_N1024,BER_N1024,'-r','LineWidth',2,'MarkerSize',8);


% Plot FPTD_Int
load('Data_IFPTD_2.mat');
I_FPTD = 28;
fig_FPTD_Int(1)=semilogy(Results_BER_N256(:,1),Results_BER_N256(:,I_FPTD+2)./Results_BER_N256(:,2),'-b','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(2)=semilogy(Results_BER_N512(:,1),Results_BER_N512(:,I_FPTD+2)./Results_BER_N512(:,2),'-b','LineWidth',2,'MarkerSize',10);
fig_FPTD_Int(3)=semilogy(Results_BER_N1024(:,1),Results_BER_N1024(:,I_FPTD+2)./Results_BER_N1024(:,2),'-b','LineWidth',2,'MarkerSize',10);


% Create textbox
annotation(fig,'textbox',[0.346526826775675 0.162489023929854 0.171881681416638 0.0611111120193724],...
    'String','$N=1024$','LineStyle','none','Interpreter','latex','FontSize',18);
% Create arrow
annotation(fig,'arrow',[0.427184466019417 0.5],[0.221530434782609 0.27779641943734]);
% Create ellipse
annotation(fig,'ellipse',[0.503666666666665 0.2704 0.0403333333333344 0.0272000000000012]);
% Create textbox
annotation(fig,'textbox',[0.722401805484584 0.431268108897173 0.156256630909543 0.0611111120193724],...
    'String','$N=256$','LineStyle','none','Interpreter','latex','FontSize',18);
% Create arrow
annotation(fig,'arrow',[0.734210526315789 0.68657860671095],[0.446031746031746 0.406013436220463]);
% Create ellipse
annotation(fig,'ellipse',[0.637543859649123 0.378450793650794 0.0443333333333337 0.0288000000000002]);
% Create arrow
annotation(fig,'arrow',[0.728947368421053 0.638162493612671],[0.338095238095238 0.263377736237739]);
% Create ellipse
annotation(fig,'ellipse',[0.595438596491228 0.234006349206349 0.0443333333333336 0.0288000000000004]);
% Create textbox
annotation(fig,'textbox',[0.724080054505196 0.324370662382335 0.156256630909543 0.0611111120193724],...
    'String','$N=512$','LineStyle','none','Interpreter','latex','FontSize',18);

% Legend
leg=legend([fig_FPTD_Int(1) fig_BM_(1)],'FPTD, approx max*, $I\leq 28$','Benchmarker, exact max*, $I=5$');
set(legend,'Location','NorthEast','color','none','Box','off','interpreter','latex','FontSize',FontSize);
leg.Position(4) = leg.Position(4)+0.05; 
leg.Position(2) = leg.Position(2)-0.05; 

