FrameLength = [40 64 128 256 512 720];
I_FPTD = 28;
Threshold=1e-5;

FontSize=18;
fig=figure;
axes('YScale','log');
xlim([0, 6]);
ylim([1e-7, 1]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',FontSize-2);
xlabel('$E_b/N_0$ (dB)','fontsize',FontSize,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
set(gca,'XTick',[0:0.5:6]);
ylabel('BER','fontsize',FontSize,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
hold on

XPos=[0.715 0.62 0.51 0.424 0.36 0.27];

%Plot FPTD_Int
load('Data_IFPTD_2.mat');
for Frame_idx=1:length(FrameLength)
    Results_BER=eval(['Results_BER_N' num2str(FrameLength(Frame_idx))]);
    I_counter=eval(['I_counter_N' num2str(FrameLength(Frame_idx))]);
    BERs=Results_BER(:,I_FPTD+2)./Results_BER(:,2);
    fig_FPTD_Int(Frame_idx)=semilogy(Results_BER(:,1),BERs,'-b','LineWidth',2,'MarkerSize',10);
    [temp, EbN0_meet]=min(abs(BERs-Threshold));
    I_av=[1:I_FPTD]*I_counter(EbN0_meet,3:2+I_FPTD)'/sum(I_counter(EbN0_meet,3:2+I_FPTD));
    [x, y]=polyxpoly([0 6],[Threshold Threshold],Results_BER(:,1),BERs);
    plot(x-0.02,y,'x','Color',[0.3 0.3 0.3],'LineWidth',2,'MarkerSize',10);
    annotation(fig,'textbox',[XPos(Frame_idx) 0.28 0.11 0.064],...
    'String',num2str(round(I_av,1)),'LineStyle','none','FontSize',FontSize,'FitBoxToText','on','interpreter','latex');
end

% Annotation
plot([0 6],[Threshold Threshold],'--','Color',[0.3 0.3 0.3],'LineWidth',2,'MarkerSize',10);
annotation(fig,'textbox',[0.19 0.28 0.11 0.064],...
    'String','$I_\mathrm{av}=$','LineStyle','none','FontSize',FontSize,'FitBoxToText','on','interpreter','latex');
annotation(fig,'textarrow',[0.456873315363881 0.26010781671159],[0.707846410684474 0.535893155258765],...
    'String','$N\in\{40, 64, 128 ,256,512,720\}$','LineWidth',1.5,'FontSize',FontSize,'interpreter','latex');
