MarkerSize=12;
FontSize=18;

load('P1e-3_bounds.mat');
load('P1e-3_LTE.mat');

fig = figure;
axes('XScale','log');
xlim([10 1e4]);
set(fig,'Position',[100,100,750,600]);
set(gca,'FontSize',FontSize);
xlabel('Frame length $N$','fontsize',FontSize,'interpreter','latex');
ylhand = get(gca,'ylabel');
ylabel('$E_b/N_0$ (dB)','fontsize',FontSize,'interpreter','latex');
grid
hold on

% Plot bounds
h_bounds(1) = plot([Ns(1), Ns(end)]./3, [-0.55 -0.55],':k','LineWidth',2,'MarkerSize',MarkerSize);
h_bounds(2) = plot([Ns(1), Ns(end)]./3, [-0.49 -0.49],'--k','LineWidth',2,'MarkerSize',MarkerSize);
h_bounds(3) = plot(Ns./3, EbN0s_converse,'-.b','LineWidth',2,'MarkerSize',MarkerSize);
h_bounds(4) = plot(Ns./3, EbN0s_kappa,':b','LineWidth',2,'MarkerSize',MarkerSize);
h_bounds(5) = plot(Ns./3, EbN0s_gallager,'--b','LineWidth',2,'MarkerSize',MarkerSize);

% Plot simulated data
% LTE
h_LTE = plot([40 48 64 96 128 256 512 1024 2048 4096 6144],EbN0s_FPTD_I128,'-k','LineWidth',2,'MarkerSize',MarkerSize);

% Results from papers
h_ARA_LDPC_R1_3=plot([20 25 50:50:250],[5.8 5 3.9 2.95 2.4 2.15 1.9],'-r','LineWidth',2,'MarkerSize',MarkerSize);
h_PEG_LDPC_R1_2=plot([25:25:100 150:50:500],[5 3.9 3.45 3.2 2.85 2.58 2.4 2.3 2.19 2.08 2.04 2],'-g','LineWidth',2,'MarkerSize',MarkerSize);

legend([h_bounds h_LTE h_ARA_LDPC_R1_3 h_PEG_LDPC_R1_2],'Shannon capacity ($R=\frac{1}{3}$)','DCMC capacity ($R=\frac{1}{3}$)','Converse bound ($R=\frac{1}{3}$)','Kappa-beta bound ($R=\frac{1}{3}$)','Gallager bound ($R=\frac{1}{3}$)','LTE turbo code ($R=\frac{1}{3}$)','ARA-LDPC ($R=\frac{1}{3}$)','PEG-LDPC ($R=\frac{1}{2}$)'); 
set(legend,'Location','NorthEast','color','none','Box','off','interpreter','latex','FontSize',FontSize);